/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.thin;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jp.terasoluna.fw.web.RequestUtil;
import jp.terasoluna.fw.web.thin.AbstractControlFilter;
import jp.terasoluna.fw.web.thin.AuthorizationController;
import jp.terasoluna.fw.web.thin.UnauthorizedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationControlFilter
extends AbstractControlFilter<AuthorizationController> {
    public static final String AUTHORIZATION_THRU_KEY = "AUTHORIZATION_THRU_KEY";
    public static final String DEFAULT_AUTHORIZATION_BEAN_ID = "authorizationController";
    private static final String AUTHORIZATION_CONTROLLER_ERROR = "errors.authorization.controller";
    private static final Class AUTHORIZATION_CONTROLLER_CLASS = AuthorizationController.class;
    private static Log log = LogFactory.getLog(AuthorizationControlFilter.class);
    protected static AuthorizationController controller = null;

    public static AuthorizationController getAuthorizationController() {
        return controller;
    }

    @Override
    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        if (controller == null) {
            controller = (AuthorizationController)this.getController();
        }
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req.getAttribute(AUTHORIZATION_THRU_KEY) == null) {
            req.setAttribute(AUTHORIZATION_THRU_KEY, (Object)"true");
            if (controller.isCheckRequired(req) && !controller.isAuthorized(RequestUtil.getPathInfo(req), req)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"isAuthorized() failed.");
                }
                throw new UnauthorizedException();
            }
        }
        chain.doFilter(req, res);
    }

    @Override
    protected Class getControllerClass() {
        return AUTHORIZATION_CONTROLLER_CLASS;
    }

    @Override
    protected String getErrorCode() {
        return AUTHORIZATION_CONTROLLER_ERROR;
    }

    @Override
    public String getDefaultControllerBeanId() {
        return DEFAULT_AUTHORIZATION_BEAN_ID;
    }
}

