/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.codelist;

import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import jp.terasoluna.fw.web.codelist.CodeBean;
import jp.terasoluna.fw.web.codelist.DBCodeListQuery;
import jp.terasoluna.fw.web.codelist.ReloadableCodeListLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBCodeListLoader
implements ReloadableCodeListLoader {
    private Log log = LogFactory.getLog(DBCodeListLoader.class);
    private List<CodeBean> codeLists = null;
    private String sql = null;
    private DataSource dataSource = null;
    private final Object lockObject = new Object();

    public void load() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"load() called.");
        }
        if (this.codeLists != null) {
            return;
        }
        this.loadCodeList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"reload() called.");
        }
        if (this.codeLists == null) {
            this.loadCodeList();
        } else {
            Object object = this.lockObject;
            synchronized (object) {
                this.loadCodeList();
            }
        }
    }

    protected void loadCodeList() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"loadCodeList() called.");
        }
        DBCodeListQuery query = new DBCodeListQuery(this.dataSource, this.sql);
        query.compile();
        List resultList = query.execute();
        this.codeLists = Collections.unmodifiableList(resultList);
    }

    public CodeBean[] getCodeBeans() {
        if (this.codeLists == null) {
            return new CodeBean[0];
        }
        CodeBean[] cb = new CodeBean[this.codeLists.size()];
        for (int i = 0; i < this.codeLists.size(); ++i) {
            cb[i] = new CodeBean();
            cb[i].setId(this.codeLists.get(i).getId());
            cb[i].setName(this.codeLists.get(i).getName());
        }
        return cb;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }
}

