/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.util.ClassLoadException;
import jp.terasoluna.fw.web.struts.MessageFormatCloneReturnIfUseDateFormatMap;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.PropertyTestCase;
import jp.terasoluna.utlib.UTUtil;

/**
 * {@link jp.terasoluna.fw.web.struts.action.DBMessageResources} 
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * bZ[W\[XNXB<br>
 * ̃NXgp邱ƂɂāAbZ[W\[X`t@C
 * iʏStrutsŎgvpeBt@C`̃bZ[W\[Xj
 * łȂANX[hDBQƂADB̃bZ[W\[X
 * gp邱Ƃ\łB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.action.DBMessageResources
 */
public class DBMessageResourcesTest extends PropertyTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DBMessageResourcesTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
        UTUtil.setPrivateField(DBMessageResources.class, "dbMessages", null);
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
        UTUtil.setPrivateField(DBMessageResources.class, "dbMessages", null);
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public DBMessageResourcesTest(String name) {
        super(name);
    }

    /**
     * testDbInit01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() messages.sql:"messages.sql"݂Ȃ<br>
     *         () messages.dao:"messages.dao"݂Ȃ<br>
     *         
     * <br>
     * ҒlF(ԕω) dbMessages:Map<br>
     *         
     * <br>
     * bZ[W\[X`t@CɃL["messages.sql""messages.dao"
     * `ȂꍇAdbMessagesɋMapݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDbInit01() throws Exception {
        // O
        deleteProperty("messages.sql");
        deleteProperty("messages.dao");
        
        // eXg{
        DBMessageResources.dbInit();

        // 
        Map map = (Map) UTUtil.getPrivateField(DBMessageResources.class,
                                               "dbMessages");
        assertTrue(map.isEmpty());
    }

    /**
     * testDbInit02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() messages.sql:"messages.sql"݂Ȃ<br>
     *         () messages.dao:"jp.terasoluna.fw.web.action.MessageResources_MessageResourcesDAOStub01"<br>
     *         
     * <br>
     * ҒlF(ԕω) O:yxOz<br>
     *                    bZ[W<br>
     *                    "defined only one of the pair - messages.dao and messages.sql."<br>
     *         (ԕω) dbMessages:Map<br>
     *         
     * <br>
     * bZ[W\[X`t@CɃL["messages.sql"݂ȂꍇA
     * xOoAdbMessagesɋMapݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDbInit02() throws Exception {
        // O
        deleteProperty("messages.sql");
        addProperty("messages.dao", 
                    DBMessageResources_MessageResourcesDAOStub01.class.getName());        
        // eXg{
        DBMessageResources.dbInit();

        // 
        assertTrue(LogUTUtil.checkWarn(
            "defined only one of the pair - messages.dao and messages.sql."));
        Map map = (Map) UTUtil.getPrivateField(DBMessageResources.class,
                                               "dbMessages");
        assertTrue(map.isEmpty());
    }

    /**
     * testDbInit03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() messages.sql:"SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE"<br>
     *         () messages.dao:"messages.dao"݂Ȃ<br>
     *         
     * <br>
     * ҒlF(ԕω) O:yxOz<br>
     *                    bZ[W<br>
     *                    "defined only one of the pair - messages.dao and messages.sql."<br>
     *         (ԕω) dbMessages:Map<br>
     *         
     * <br>
     * bZ[W\[X`t@CɃL["messages.dao"݂ȂꍇA
     * xOoAdbMessagesɋMapݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDbInit03() throws Exception {
        // O
        addProperty("messages.sql",
                    "SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE");
        deleteProperty("messages.dao");
        
        // eXg{
        DBMessageResources.dbInit();

        // 
        assertTrue(LogUTUtil.checkWarn(
            "defined only one of the pair - messages.dao and messages.sql."));
        Map map = (Map) UTUtil.getPrivateField(DBMessageResources.class,
                                               "dbMessages");
        assertTrue(map.isEmpty());
    }

    /**
     * testDbInit04()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() messages.sql:"SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE"<br>
     *         () messages.dao:""<br>
     *         
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    G[R[hF"errors.db.message.resources.init"<br>
     *                    bvOFClassLoadException<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "" cannot loaded."<br>
     *                    O<br>
     *                    ClassLoadException<br>
     *         (ԕω) dbMessages:Map<br>
     *         
     * <br>
     * bZ[W\[X`t@CɃL["messages.dao"œo^Ăl
     * ̏ꍇAdbmessagesɂ͋Mapݒ肳AG[Oo͂A
     * OX[邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDbInit04() throws Exception {
        // O
        addProperty("messages.sql",
                    "SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE");
        addProperty("messages.dao", "");
        
        // eXg{
        try {
            DBMessageResources.dbInit();
            fail();
        } catch (SystemException e) {
            // 
            assertTrue(e.getCause() instanceof ClassLoadException);
            assertEquals("errors.db.message.resources.init",
                         e.getErrorCode());
            assertTrue(LogUTUtil.checkError("\"\" cannot loaded.", e.getCause()));
            Map map = (Map) UTUtil.getPrivateField(DBMessageResources.class,
                                                   "dbMessages");
            assertTrue(map.isEmpty());
        }
        
    }

    /**
     * testDbInit05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() messages.sql:"SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE"<br>
     *         () messages.dao:"aaaaa"<br>
     *         
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    G[R[hF"errors.db.message.resources.init"<br>
     *                    bvOFClassLoadException<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    ""aaaaa" cannot loaded."<br>
     *                    O<br>
     *                    ClassLoadException<br>
     *         (ԕω) dbMessages:Map<br>
     *         
     * <br>
     * bZ[W\[X`t@CɃL["messages.dao"œo^Ăl
     * ݂ȂNX̏ꍇAdbmessagesɂ͋Mapݒ肳AG[O
     * o͂AOX[邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDbInit05() throws Exception {
        // O
        addProperty("messages.sql",
                    "SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE");
        addProperty("messages.dao",
                    "aaaaa");
        
        // eXg{
        try {
            DBMessageResources.dbInit();
            fail();
        } catch (SystemException e) {
            // 
            assertTrue(e.getCause() instanceof ClassLoadException);
            assertEquals("errors.db.message.resources.init",
                         e.getErrorCode());
            assertTrue(LogUTUtil.checkError("\"aaaaa\" cannot loaded.", e.getCause()));
            Map map = (Map) UTUtil.getPrivateField(DBMessageResources.class,
                                                   "dbMessages");
            assertTrue(map.isEmpty());
        }
        
    }

    /**
     * testDbInit06()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() messages.sql:"SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE"<br>
     *         () messages.dao:"java.lang.Object"<br>
     *         
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    G[R[hF"errors.db.message.resources.init"<br>
     *                    bvOFClassCastException<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    ""java.lang.Object" not implemented MessageResourcesDAO"<br>
     *                    O<br>
     *                    ClassCastException<br>
     *         (ԕω) dbMessages:Map<br>
     *         
     * <br>
     * bZ[W\[X`t@CɃL["messages.dao"œo^Ă
     * NXMessageResourcesDAOĂȂꍇAdbmessagesɂ
     * Mapݒ肳AG[Oo͂AOX[邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDbInit06() throws Exception {
        // O
        addProperty("messages.sql",
                    "SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE");
        addProperty("messages.dao", "java.lang.Object");
        UTUtil.setPrivateField(DBMessageResources.class, 
                               "dbMessages",
                               new HashMap<String, String>());
        
        // eXg{
        try {
            DBMessageResources.dbInit();
            fail();
        } catch (SystemException e) {
            // 
            assertEquals(ClassCastException.class.getName(),
                         e.getCause().getClass().getName());
            assertEquals("errors.db.message.resources.init",
                         e.getErrorCode());
            assertTrue(LogUTUtil.checkError(
                "\"java.lang.Object\" not implemented MessageResourcesDAO", 
                e.getCause()));
            Map map = (Map) UTUtil.getPrivateField(DBMessageResources.class,
                                                   "dbMessages");
            assertTrue(map.isEmpty());
        }
    }

    /**
     * testDbInit07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() messages.sql:"SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE"<br>
     *         () messages.dao:"jp.terasoluna.fw.web.struts.action.DBMessageResources_MessageResourcesDAOStub01"<br>
     *         () queryMessageMap:["TEST01"->"eXg߂[OP"]<br>
     *                ["TEST01"->"testMESSAGE02"]<br>
     *                ["TEST01"->"IO"]<br>
     *         
     * <br>
     * ҒlF(ԕω) dbMessages:["TEST01"->"eXg߂[OP"]<br>
     *                    ["TEST02"->"testMESSAGE02"]<br>
     *                    ["TEST03"->"IO"]<br>
     *         
     * <br>
     * bZ[W\[X`t@C"messages.dao""messages.sql"
     * `ĂꍇADB擾bZ[WL[ƃbZ[W
     * ݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDbInit07() throws Exception {
        // O
        addProperty("messages.sql",
                    "SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE");
        addProperty("messages.dao", 
                    DBMessageResources_MessageResourcesDAOStub01.class.getName());

        // eXg{
        DBMessageResources.dbInit();
        
        // 
        Map map = (Map) UTUtil.getPrivateField(DBMessageResources.class,
                                               "dbMessages");
        assertEquals(3, map.size());
        assertEquals("eXg߂[OP", map.get("TEST01"));
        assertEquals("testMESSAGE02", map.get("TEST02"));
        assertEquals("IO", map.get("TEST03"));
    }

    /**
     * testPropertyInit01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() propertyFile:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "Message resources file "null" is illegal."<br>
     *         (ԕω) messages:Map<br>
     *         
     * <br>
     * bZ[W\[X`t@Cnull̂ƂAbZ[W擾
     * G[Oo͂ďI邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testPropertyInit01() throws Exception {
        // OAeXg{
        DBMessageResources resources 
            = new DBMessageResources(null, null);

        // 
        assertTrue(LogUTUtil.checkError(
                "Message resources file \"null\" is illegal."));
        Map map = (Map) UTUtil.getPrivateField(resources, "messages");
        assertTrue(map.isEmpty());
    }

    /**
     * testPropertyInit02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() propertyFile:""<br>
     *         
     * <br>
     * ҒlF(ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "Message resources file "" is illegal."<br>
     *         (ԕω) messages:Map<br>
     *         
     * <br>
     * bZ[W\[X`t@C󕶎̂ƂAbZ[W
     * 擾ɃG[Oo͂ďI邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testPropertyInit02() throws Exception {
        // O
        DBMessageResources resources 
            = new DBMessageResources(null, "");
        
        // 
        assertTrue(LogUTUtil.checkError("Message resources file \"\" is illegal."));
        Map map = (Map) UTUtil.getPrivateField(resources, "messages");
        assertTrue(map.isEmpty());
    }

    /**
     * testPropertyInit03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() propertyFile:"aaaaa"<br>
     *         
     * <br>
     * ҒlF(ԕω) O:yG[Oz<br>
     *                    "Message resources file "aaaaa" is illegal."<br>
     *         (ԕω) messages:Map<br>
     *         
     * <br>
     * bZ[W\[X`t@C݂ȂƂAbZ[W擾
     * G[Oo͂ďI邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testPropertyInit03() throws Exception {
        // O
        DBMessageResources resources 
            = new DBMessageResources(null, "aaaaa");
        
        // 
        assertTrue(LogUTUtil.checkError(
                "Message resources file \"aaaaa\" is illegal."));
        Map map = (Map) UTUtil.getPrivateField(resources, "messages");
        assertTrue(map.isEmpty());
    }

    /**
     * testPropertyInit04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() propertyFile:"DBMessageResources_MessageResources01"<br>
     *                ĩt@Cj<br>
     *         
     * <br>
     * ҒlF(ԕω) messages:Map<br>
     *         
     * <br>
     * bZ[W\[X`t@C̒g̏ꍇAbZ[W擾
     * I邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testPropertyInit04() throws Exception {
        // O
        DBMessageResources resources 
            = new DBMessageResources(
                null, this.getClass().getPackage().getName().replace('.', '/')
                + "/DBMessageResources_MessageResources01");
        
        // 
        Map map = (Map) UTUtil.getPrivateField(resources, "messages");
        assertTrue(map.isEmpty());
    }

    /**
     * testPropertyInit05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() propertyFile:"DBMessageResources_MessageResources02"<br>
     *                yt@C̓ez<br>
     *                message.error.required=<br>
     *         
     * <br>
     * ҒlF(ԕω) messages:["message.error.required"->""]<br>
     *         
     * <br>
     * bZ[W\[X`t@C擾L[ɑ΂l󕶎
     * ꍇAbZ[W󕶎Őݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testPropertyInit05() throws Exception {
        // O
        DBMessageResources resources 
        = new DBMessageResources(
                null, this.getClass().getPackage().getName().replace('.', '/')
                + "/DBMessageResources_MessageResources02");
        // 
        Map map = (Map) UTUtil.getPrivateField(resources, "messages");
        assertEquals(1, map.size());
        assertEquals("", map.get("message.error.required"));
    }

    /**
     * testPropertyInit06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() propertyFile:"DBMessageResources_MessageResources03"<br>
     *                yt@C̓ez<br>
     *                message.error.required={0}͂ĂB<br>
     *         
     * <br>
     * ҒlF(ԕω) messages:["message.error.required"->"{0}͂ĂB"]<br>
     *         
     * <br>
     * bZ[W\[X`t@C擾ʂ1̏ꍇA
     * ݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testPropertyInit06() throws Exception {
        // O
        DBMessageResources resources 
        = new DBMessageResources(
                null, this.getClass().getPackage().getName().replace('.', '/')
                + "/DBMessageResources_MessageResources03");
        
        // 
        Map map = (Map) UTUtil.getPrivateField(resources, "messages");
        assertEquals(1, map.size());
        assertEquals("{0}͂ĂB", map.get("message.error.required"));
    }

    /**
     * testPropertyInit07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() propertyFile:"DBMessageResources_MessageResources04"<br>
     *                yt@C̓ez<br>
     *                error.date.format={0}̓{1}`œ͂ĂB<br>
     *                message.error.required={0}͂ĂB<br>
     *                error.prohibited={0}ɓ͋֎~"{1}"܂܂Ă܂B<br>
     *         
     * <br>
     * ҒlF(ԕω) messages:["error.date.format"->"{0}̓{1}`œ͂ĂB"]<br>
     *                    ["message.error.required"->"{0}͂ĂB"]<br>
     *                    ["error.prohibited"->"{0}ɓ͋֎~"{1}"܂܂Ă܂B"]<br>
     *         
     * <br>
     * bZ[W\[X`t@C擾ʂ̏ꍇA
     * ݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testPropertyInit07() throws Exception {
        // O
        DBMessageResources resources 
        = new DBMessageResources(
                null, this.getClass().getPackage().getName().replace('.', '/')
                + "/DBMessageResources_MessageResources04");
        
        // 
        Map map = (Map) UTUtil.getPrivateField(resources, "messages");
        assertEquals(3, map.size());
        assertEquals("{0}̓{1}`œ͂ĂB", 
                     map.get("error.date.format"));
        assertEquals("{0}͂ĂB", 
                     map.get("message.error.required"));
        assertEquals("{0}ɓ͋֎~\"{1}\"܂܂Ă܂B", 
                     map.get("error.prohibited"));
    }

    /**
     * testGetMessageLocaleString01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() locale:locale.JAPAN<br>
     *         () key:""<br>
     *         () messages:[""->"eXgbZ[WOP"]<br>
     *         () returnNull:true<br>
     *         
     * <br>
     * ҒlF(߂l) String:"eXgbZ[WOP"<br>
     *         (ԕω) O:SystemExceptionF<br>
     *                         G[R[hF"errors.db.message.resources"<br>
     *                         bvOFnull<br>
     *         (ԕω) O:yG[Oz<br>
     *                         bZ[W<br>
     *                         "Message key 'null' or empty not allowed."<br>
     *         
     * <br>
     * key󕶎̏ꍇAG[Oo͂AOX[邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessageLocaleString01() throws Exception {
        // O
        DBMessageResources resources 
            = new DBMessageResources(null, null);
        Map<String, String> map = new HashMap<String, String>(1);
        map.put("", "eXgbZ[WOP");
        UTUtil.setPrivateField(resources, "messages", map);
        UTUtil.setPrivateField(resources, "returnNull", Boolean.TRUE);
        
        // eXg{
        try {
            resources.getMessage(Locale.JAPAN, "");
            fail();
        } catch (SystemException e) {
            // 
            assertNull(e.getCause());
            assertEquals("errors.db.message.resources",
                         e.getErrorCode());
            assertTrue(LogUTUtil.checkError(
                "Message key 'null' or empty not allowed."));
        }
        
    }

    /**
     * testGetMessageLocaleString02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() locale:locale.JAPAN<br>
     *         () key:""<br>
     *         () messages:Map<br>
     *         () dbMessages:[""->"caeXgbZ[WOP"]<br>
     *         () returnNull:true<br>
     *         
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                         G[R[hF"errors.db.message.resources"<br>
     *                         bvOFnull<br>
     *         (ԕω) O:yG[Oz<br>
     *                         bZ[W<br>
     *                         "Message key 'null' or empty not allowed."<br>
     *         
     * <br>
     * key󕶎̏ꍇAG[Oo͂AOX[邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessageLocaleString02() throws Exception {
        // O
        DBMessageResources resources 
            = new DBMessageResources(null, null);
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("", "caeXgbZ[WOP");
        UTUtil.setPrivateField(resources, "dbMessages", map);
        UTUtil.setPrivateField(resources, "returnNull", Boolean.TRUE);
        
        // eXg{
        try {
            resources.getMessage(Locale.JAPAN, "");
            fail();
        } catch (SystemException e) {
            // 
            assertNull(e.getCause());
            assertEquals("errors.db.message.resources",
                         e.getErrorCode());
            assertTrue(LogUTUtil.checkError(
                "Message key 'null' or empty not allowed."));
        }
    }

    /**
     * testGetMessageLocaleString03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() locale:locale.JAPAN<br>
     *         () key:"TEST01"<br>
     *         () messages:["TEST01"->""]<br>
     *         () returnNull:true<br>
     *         
     * <br>
     * ҒlF(߂l) String:""<br>
     *         
     * <br>
     * messagesɓo^ĂL[ƃbZ[WL[vbZ[W
     * 󕶎̏ꍇA󕶎񂪕ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessageLocaleString03() throws Exception {
        // O
        DBMessageResources resources 
            = new DBMessageResources(null, null);
        Map<String, String> map = new HashMap<String, String>(1);
        map.put("TEST01", "");
        UTUtil.setPrivateField(resources, "messages", map);
        UTUtil.setPrivateField(resources, "returnNull", Boolean.TRUE);
        
        // eXg{
        String actual = resources.getMessage(Locale.JAPAN, "TEST01");

        // 
        assertEquals("", actual);
    }

    /**
     * testGetMessageLocaleString04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() locale:locale.JAPAN<br>
     *         () key:"TEST01"<br>
     *         () messages:["TEST01"->"eXgbZ[WOP"]<br>
     *         () returnNull:true<br>
     *         
     * <br>
     * ҒlF(߂l) String:"eXgbZ[WOP"<br>
     *         
     * <br>
     * messagesɂ̓bZ[W1o^ĂāAbZ[WL[vꍇA
     * bZ[W擾ĕԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessageLocaleString04() throws Exception {
        // O
        DBMessageResources resources 
            = new DBMessageResources(null, null);
        Map<String, String> map = new HashMap<String, String>(1);
        map.put("TEST01", "eXgbZ[WOP");
        UTUtil.setPrivateField(resources, "messages", map);
        UTUtil.setPrivateField(resources, "returnNull", Boolean.TRUE);
        
        // eXg{
        String actual = resources.getMessage(Locale.JAPAN, "TEST01");

        // 
        assertEquals("eXgbZ[WOP", actual);
    }

    /**
     * testGetMessageLocaleString05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() locale:locale.JAPAN<br>
     *         () key:"TEST02"<br>
     *         () messages:["TEST01"->"eXgbZ[WOP"]<br>
     *                ["TEST02"->"eXgbZ[WOQ"]<br>
     *                ["TEST03"->"eXgbZ[WOR"]<br>
     *         () returnNull:true<br>
     *         
     * <br>
     * ҒlF(߂l) String:"eXgbZ[WOQ"<br>
     *         
     * <br>
     * messagesɂ̓bZ[Wo^ꂢăbZ[WL[̓1
     * vꍇAbZ[W擾ĕԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessageLocaleString05() throws Exception {
        // O
        DBMessageResources resources 
            = new DBMessageResources(null, null);
        Map<String, String> map = new HashMap<String, String>(1);
        map.put("TEST01", "eXgbZ[WOP");
        map.put("TEST02", "eXgbZ[WOQ");
        map.put("TEST03", "eXgbZ[WOR");
        UTUtil.setPrivateField(resources, "messages", map);
        UTUtil.setPrivateField(resources, "returnNull", Boolean.TRUE);
        
        // eXg{
        String actual = resources.getMessage(Locale.JAPAN, "TEST02");

        // 
        assertEquals("eXgbZ[WOQ", actual);
    }

    /**
     * testGetMessageLocaleString06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() locale:locale.JAPAN<br>
     *         () key:"TEST01"<br>
     *         () messages:Map<br>
     *         () dbMessages:["TEST01"->""]<br>
     *         () returnNull:true<br>
     *         
     * <br>
     * ҒlF(߂l) String:""<br>
     *         
     * <br>
     * messagesɉo^Ă炸AdbMessagesɓo^ĂL[
     * bZ[WL[vbZ[W󕶎̏ꍇA󕶎
     * ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessageLocaleString06() throws Exception {
        // O
        DBMessageResources resources 
            = new DBMessageResources(null, null);
        Map<String, String> map = new HashMap<String, String>();
        Map<String, String> dbmap = new HashMap<String, String>(1);
        dbmap.put("TEST01", "");
        UTUtil.setPrivateField(resources, "messages", map);
        UTUtil.setPrivateField(resources, "dbMessages", dbmap);
        UTUtil.setPrivateField(resources, "returnNull", Boolean.TRUE);
        
        // eXg{
        String actual = resources.getMessage(Locale.JAPAN, "TEST01");

        // 
        assertEquals("", actual);
    }

    /**
     * testGetMessageLocaleString07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() locale:locale.JAPAN<br>
     *         () key:"TEST01"<br>
     *         () messages:Map<br>
     *         () dbMessages:["TEST01"->"caeXgbZ[WOP"]<br>
     *         () returnNull:true<br>
     *         
     * <br>
     * ҒlF(߂l) String:"caeXgbZ[WOP"<br>
     *         
     * <br>
     * messageso^Ă炸AdbMessagesɃbZ[W
     * 1o^ꂢăbZ[WL[vꍇAbZ[W
     * 擾ĕԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessageLocaleString07() throws Exception {
        // O
        DBMessageResources resources 
            = new DBMessageResources(null, null);
        Map<String, String> map = new HashMap<String, String>();
        Map<String, String> dbmap = new HashMap<String, String>(1);
        dbmap.put("TEST01", "caeXgbZ[WOP");
        UTUtil.setPrivateField(resources, "messages", map);
        UTUtil.setPrivateField(resources, "dbMessages", dbmap);
        UTUtil.setPrivateField(resources, "returnNull", Boolean.TRUE);
        
        // eXg{
        String actual = resources.getMessage(Locale.JAPAN, "TEST01");

        // 
        assertEquals("caeXgbZ[WOP", actual);
    }

    /**
     * testGetMessageLocaleString08()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() locale:locale.JAPAN<br>
     *         () key:"TEST02"<br>
     *         () messages:Map<br>
     *         () dbMessages:["TEST01"->"caeXgbZ[WOP"]<br>
     *                ["TEST02"->"caeXgbZ[WOQ"]<br>
     *                ["TEST03"->"caeXgbZ[WOR"]<br>
     *         () returnNull:true<br>
     *         
     * <br>
     * ҒlF(߂l) String:"caeXgbZ[WOQ"<br>
     *         
     * <br>
     * messageso^Ă炸AdbMessagesɃbZ[W
     * o^ꂢăbZ[WL[̓1ƈvꍇA
     * bZ[W擾ĕԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessageLocaleString08() throws Exception {
        // O
        DBMessageResources resources 
            = new DBMessageResources(null, null);
        Map<String, String> map = new HashMap<String, String>();
        Map<String, String> dbmap = new HashMap<String, String>(1);
        dbmap.put("TEST01", "caeXgbZ[WOP");
        dbmap.put("TEST02", "caeXgbZ[WOQ");
        dbmap.put("TEST03", "caeXgbZ[WOR");
        UTUtil.setPrivateField(resources, "messages", map);
        UTUtil.setPrivateField(resources, "dbMessages", dbmap);
        UTUtil.setPrivateField(resources, "returnNull", Boolean.TRUE);
        
        // eXg{
        String actual = resources.getMessage(Locale.JAPAN, "TEST02");

        // 
        assertEquals("caeXgbZ[WOQ", actual);
    }

    /**
     * testGetMessageLocaleString09()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() locale:locale.JAPAN<br>
     *         () key:"TEST01"<br>
     *         () messages:["TEST01"->"eXgbZ[WOP"]<br>
     *         () dbMessages:["TEST01"->"caeXgbZ[WOP"]<br>
     *         () returnNull:true<br>
     *         
     * <br>
     * ҒlF(߂l) String:"eXgbZ[WOP"<br>
     *         
     * <br>
     * bZ[WL[dbMessagesmessagesɑ݂ꍇAmessages
     * bZ[W擾ĕԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessageLocaleString09() throws Exception {
        // O
        DBMessageResources resources 
            = new DBMessageResources(null, null);
        Map<String, String> map = new HashMap<String, String>();
        map.put("TEST01", "eXgbZ[WOP");
        Map<String, String> dbmap = new HashMap<String, String>(1);
        dbmap.put("TEST01", "caeXgbZ[WOP");
        UTUtil.setPrivateField(resources, "messages", map);
        UTUtil.setPrivateField(resources, "dbMessages", dbmap);
        UTUtil.setPrivateField(resources, "returnNull", Boolean.TRUE);
        
        // eXg{
        String actual = resources.getMessage(Locale.JAPAN, "TEST01");

        // 
        assertEquals("eXgbZ[WOP", actual);
    }

    /**
     * testGetMessageLocaleString10()
     * <br><br>
     * 
     * T(ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() locale:locale.JAPAN<br>
     *         () key:null<br>
     *         () messages:Map<br>
     *         () dbMessages:Map<br>
     *         () returnNull:true<br>
     *         
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    G[R[hF"errors.db.message.resources"<br>
     *                    bvOFnull<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "Message key 'null' or empty not allowed."<br>
     *         
     * <br>
     * keynull̏ꍇAG[Oo͂AOX[邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessageLocaleString10() throws Exception {
        // O
        DBMessageResources resources 
            = new DBMessageResources(null, null);
        Map<String, String> map = new HashMap<String, String>();
        Map<String, String> dbmap = new HashMap<String, String>();
        UTUtil.setPrivateField(resources, "messages", map);
        UTUtil.setPrivateField(resources, "dbMessages", dbmap);
        UTUtil.setPrivateField(resources, "returnNull", Boolean.TRUE);
        
        // eXg{
        try {
            resources.getMessage(Locale.JAPAN, null);
            fail();
        } catch (SystemException e) {
            // 
            assertNull(e.getCause());
            assertEquals("errors.db.message.resources",
                         e.getErrorCode());
            assertTrue(LogUTUtil.checkError(
                "Message key 'null' or empty not allowed."));
        }
    }

    /**
     * testGetMessageLocaleString11()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() locale:locale.JAPAN<br>
     *         () key:"TEST01"<br>
     *         () messages:["TEST01"->null]<br>
     *         () dbMessages:["TEST01"->null]<br>
     *         () fwMessage(GlobalMessageResources):["TEST01"->"eveXgbZ[WOP"]<br>
     *         () returnNull:true<br>
     *         
     * <br>
     * ҒlF(߂l) String:"eveXgbZ[WOP"<br>
     *         
     * <br>
     * messagesAdbMessagesɊY郁bZ[WL[o^Ă炸A
     * t[[ÑbZ[W\[X̃bZ[WL[ƈvꍇA
     * t[[ÑbZ[W擾ł邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessageLocaleString11() throws Exception {
        // O
        DBMessageResources resources 
            = new DBMessageResources(null, null);
        Map<String, String> map = new HashMap<String, String>();
        map.put("TEST01", null);
        Map<String, String> dbmap = new HashMap<String, String>(1);
        dbmap.put("TEST01", null);
        UTUtil.setPrivateField(resources, "messages", map);
        UTUtil.setPrivateField(resources, "dbMessages", dbmap);
        UTUtil.setPrivateField(resources, "returnNull", Boolean.TRUE);
        
        // GlobalMessageResources̃bZ[W\[XobNAbvpɑޔ
        Object tempFwMap 
            = UTUtil.getPrivateField(GlobalMessageResources.getInstance(), 
                                     "fwMessages");
        Map<String, String> newFwMap
            = new HashMap<String, String>();
        newFwMap.put("TEST01", "eveXgbZ[WOP");
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(), 
                               "fwMessages", 
                               newFwMap);
        
        Object tempGlobalMap 
            = UTUtil.getPrivateField(GlobalMessageResources.getInstance(), 
                                     "globalMessages");
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(), 
                               "globalMessages", 
                               new HashMap());

        // eXg{
        String actual = resources.getMessage(Locale.JAPAN, "TEST01");

        // 
        assertEquals("eveXgbZ[WOP", actual);
        
        // ɖ߂
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(), 
                               "fwMessages", 
                               tempFwMap);
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(), 
                               "globalMessages", 
                               tempGlobalMap);
    }

    /**
     * testGetMessageLocaleString12()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() locale:locale.JAPAN<br>
     *         () key:"TEST01"<br>
     *         () messages:Map<br>
     *         () dbMessages:null<br>
     *         () fwMessage(GlobalMessageResources):TEST01L[ƂGg͂Ȃ<br>
     *         () returnNull:true<br>
     *         
     * <br>
     * ҒlF(߂l) String:null<br>
     *         
     * <br>
     * dbMessagesnullŁAmessagesMapŁAɃVXẽbZ[W\[Xɂo^ĂȂꍇAnullԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessageLocaleString12() throws Exception {
        // O
        DBMessageResources resources 
            = new DBMessageResources(null, null);
        Map<String, String> map = new HashMap<String, String>();
        UTUtil.setPrivateField(resources, "messages", map);
        UTUtil.setPrivateField(resources, "dbMessages", null);
        UTUtil.setPrivateField(resources, "returnNull", Boolean.TRUE);
        
        // GlobalMessageResources̃bZ[W\[XobNAbvpɑޔ
        Object tempFwMap 
            = UTUtil.getPrivateField(GlobalMessageResources.getInstance(), 
                                     "fwMessages");        
        Object tempGlobalMap 
            = UTUtil.getPrivateField(GlobalMessageResources.getInstance(), 
                                     "globalMessages");
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(), 
                               "fwMessages",
                               new HashMap());
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(), 
                               "globalMessages", 
                               new HashMap());

        // eXg{
        String actual = resources.getMessage(Locale.JAPAN, "TEST01");

        // 
        assertNull(actual);
        
        // ɖ߂
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(), 
                               "fwMessages",
                               tempFwMap);
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(), 
                               "globalMessages", 
                               tempGlobalMap);

    }

    /**
     * testGetMessageLocaleString13()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() locale:locale.JAPAN<br>
     *         () key:"TEST01"<br>
     *         () messages:null<br>
     *         () dbMessages:null<br>
     *         () fwMessage(GlobalMessageResources):TEST01L[ƂGg͂Ȃ<br>
     *         () returnNull:false<br>
     *         
     * <br>
     * ҒlF(߂l) String:"???ja_JP.TEST01???"<br>
     *         
     * <br>
     * dbMessagesnullŁAmessagesnullŁAɃVXẽbZ[W\[Xɂo^ĂȂꍇAreturnNullfalseȂ???Locale.key???`ŕԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessageLocaleString13() throws Exception {
        // O
        DBMessageResources resources 
            = new DBMessageResources(null, null);
        UTUtil.setPrivateField(resources, "messages", null);
        UTUtil.setPrivateField(resources, "dbMessages", null);
        UTUtil.setPrivateField(resources, "returnNull", Boolean.FALSE);
        
        // GlobalMessageResources̃bZ[W\[XobNAbvpɑޔ
        Object tempFwMap 
            = UTUtil.getPrivateField(GlobalMessageResources.getInstance(), 
                                     "fwMessages");        
        Object tempGlobalMap 
            = UTUtil.getPrivateField(GlobalMessageResources.getInstance(), 
                                     "globalMessages");
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(), 
                               "fwMessages", 
                               new HashMap());
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(), 
                               "globalMessages", 
                               new HashMap());

        // eXg{
        String actual = resources.getMessage(Locale.JAPAN, "TEST01");

        // 
        assertEquals("???ja_JP.TEST01???", actual);
        
        // ɖ߂
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(), 
                               "fwMessages", 
                               tempFwMap);
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(), 
                               "globalMessages", 
                               tempGlobalMap);

    }

    /**
     * testGetMessageLocaleString14()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() locale:null<br>
     *         () key:"TEST01"<br>
     *         () messages:Map<br>
     *         () dbMessages:null<br>
     *         () fwMessage(GlobalMessageResources):TEST01L[ƂGg͂Ȃ<br>
     *         () returnNull:false<br>
     *         
     * <br>
     * ҒlF(߂l) String:"???.TEST01???"<br>
     *         
     * <br>
     * dbMessagesnullŁAmessagesMapŁAɃVXe
     * bZ[W\[Xɂo^ĂȂꍇAreturnNullfalseȂ
     * P[null̂Ƃ???.key???`ŕԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessageLocaleString14() throws Exception {
        // O
        DBMessageResources resources 
            = new DBMessageResources(null, null);
        Map<String, String> map = new HashMap<String, String>();
        UTUtil.setPrivateField(resources, "messages", map);
        UTUtil.setPrivateField(resources, "dbMessages", null);
        UTUtil.setPrivateField(resources, "returnNull", Boolean.FALSE);
        
        // GlobalMessageResources̃bZ[W\[XobNAbvpɑޔ
        Object tempFwMap 
            = UTUtil.getPrivateField(GlobalMessageResources.getInstance(), 
                                     "fwMessages");        
        Object tempGlobalMap 
            = UTUtil.getPrivateField(GlobalMessageResources.getInstance(), 
                                     "globalMessages");
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(), 
                               "fwMessages", 
                               new HashMap());
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(), 
                               "globalMessages",
                               new HashMap());

        // eXg{
        Locale locale = null;
        String actual = resources.getMessage(locale, "TEST01");

        // 
        assertEquals("???.TEST01???", actual);
        
        // ɖ߂
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(), 
                               "fwMessages", 
                               tempFwMap);
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(), 
                               "globalMessages", 
                               tempGlobalMap);

    }

    /**
     * testGetMessageString01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"TEST01"<br>
     *         () messages:["TEST01"->"eXgbZ[WOP"]<br>
     *         
     * <br>
     * ҒlF(߂l) String:"eXgbZ[WOP"<br>
     *         
     * <br>
     * getMessage(Locale, String)ĂяoĂ邩mFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessageString01() throws Exception {
        // O
        DBMessageResources resources 
            = new DBMessageResources(null, null);
        Map<String, String> map = new HashMap<String, String>();
        map.put("TEST01", "eXgbZ[WOP");
        UTUtil.setPrivateField(resources, "messages", map);
        
        // eXg{
        String actual = resources.getMessage("TEST01");

        // 
        assertEquals("eXgbZ[WOP", actual);
    }

    /**
     * testDBMessageResourcesMessageResourcesFactoryString01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() factory:DBMessageResourcesFactoryCX^X<br>
     *         () config:"DBMessageResources_MessageResources05"<br>
     *                       yt@C̓ez<br>
     *                       error.date.format={0}̓{1}`œ͂ĂB<br>
     *         () dbMessages:null<br>
     *         () messageResources.messageFormatClone:"disable"<br>
     *         
     * <br>
     * ҒlF(߂l) DBMessageResources:factory->OŐݒ肵CX^X<br>
     *                  config->"DBMessageResources_MessageResources05"<br>
     *                  formats->HashMapCX^X<br>
     *         (ԕω) dbInit()̌Ăяo:Ăяo<br>
     *         (ԕω) propertyInit()̌Ăяo:configƓŌĂяo<br>
     *         
     * <br>
     * dbInitĂ΂ApropertyInitĂ΂Ă邱ƂmFB<br>
     * MessageFormatCacheMapFactory#getInstance̖߂lnull̂ƂA
     * formats͍ւȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDBMessageResourcesMessageResourcesFactoryString01() throws Exception {
        // O
        DBMessageResourcesFactory factory
            = new DBMessageResourcesFactory();
        addProperty("messageResources.messageFormatClone", "disable");
        
        // eXg{
        DBMessageResources resources
            = new DBMessageResources(factory, 
                DBMessageResources.class.getPackage().getName()
                .replace('.', '/') + "/DBMessageResources_MessageResources05");     
        
        // 
        assertSame(factory, UTUtil.getPrivateField(resources, "factory"));
        assertEquals(DBMessageResources.class.getPackage().getName()
            .replace('.', '/') + "/DBMessageResources_MessageResources05",
            UTUtil.getPrivateField(resources, "config"));
        
        Map actualDbMap 
            = (Map) UTUtil.getPrivateField(DBMessageResources.class, 
                                           "dbMessages");
        assertTrue(actualDbMap.isEmpty());
        
        Map actualMap = (Map) UTUtil.getPrivateField(resources, "messages");
        assertEquals(1, actualMap.size());
        assertEquals("{0}̓{1}`œ͂ĂB",
                     actualMap.get("error.date.format"));
        assertEquals(UTUtil.getPrivateField(resources, "formats").getClass(), HashMap.class);
    }

    /**
     * testDBMessageResourcesMessageResourcesFactoryString02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() factory:DBMessageResourcesFactoryCX^X<br>
     *         () config:"DBMessageResources_MessageResources05"<br>
     *                       yt@C̓ez<br>
     *                       error.date.format={0}̓{1}`œ͂ĂB<br>
     *         () dbMessages:["TEST01"->"eXgbZ[WOP"]<br>
     *         () messageResources.messageFormatClone:"dateFormatOnly"<br>
     *         
     * <br>
     * ҒlF(߂l) DBMessageResources:factory->OŐݒ肵CX^X<br>
     *                  config->"DBMessageResources_MessageResources05"<br>
     *                  formats->MessageFormatCloneReturnIfUseDateFormatMapCX^X<br>
     *         (ԕω) dbInit()̌Ăяo:ĂяoȂ<br>
     *         (ԕω) propertyInit()̌Ăяo:configƓŌĂяo<br>
     *         
     * <br>
     * dbInitĂ΂ꂸApropertyInitĂ΂Ă邱ƂmFB
     * MessageFormatCacheMapFactory#getInstance̖߂lnullȊÔƂA
     * formats̖߂lɍւ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDBMessageResourcesMessageResourcesFactoryString02() throws Exception {
        // O        
        // dbInitĂ΂Ȃ悤mapݒ肷
        Map<String, String> dbMap
            = new HashMap<String, String>();
        dbMap.put("TEST01", "eXgbZ[WOP");
        UTUtil.setPrivateField(
            DBMessageResources.class,
            "dbMessages",
            dbMap);
        DBMessageResourcesFactory factory
            = new DBMessageResourcesFactory();
        addProperty("messageResources.messageFormatClone", "dateFormatOnly");
        
        // eXg{
        DBMessageResources resources
            = new DBMessageResources(factory, 
                DBMessageResources.class.getPackage().getName()
                .replace('.', '/') + "/DBMessageResources_MessageResources05");  
        
        // 
        assertSame(factory, UTUtil.getPrivateField(resources, "factory"));
        assertEquals(
            DBMessageResources.class.getPackage().getName()
            .replace('.', '/') + "/DBMessageResources_MessageResources05",
            UTUtil.getPrivateField(resources, "config"));
        
        Map actualDbMap = (Map) UTUtil.getPrivateField(resources, "dbMessages");
        assertSame(dbMap, actualDbMap);
        assertEquals(1, actualDbMap.size());
        assertEquals("eXgbZ[WOP", actualDbMap.get("TEST01"));
        
        Map actualMap = (Map) UTUtil.getPrivateField(resources, "messages");
        assertEquals(1, actualMap.size());
        assertEquals("{0}̓{1}`œ͂ĂB",
                     actualMap.get("error.date.format"));
        assertEquals(UTUtil.getPrivateField(resources, "formats").getClass(), MessageFormatCloneReturnIfUseDateFormatMap.class);
    }

    /**
     * testDBMessageResourcesMessageResourcesFactoryString03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() factory:null<br>
     *         () config:"DBMessageResources_MessageResources05"<br>
     *                       yt@C̓ez<br>
     *                       error.date.format={0}̓{1}`œ͂ĂB<br>
     *         () dbMessages:["TEST01"->"eXgbZ[WOP"]<br>
     *         
     * <br>
     * ҒlF(߂l) DBMessageResources:factory->null<br>
     *                  config->"DBMessageResources_MessageResources05"<br>
     *         (ԕω) dbInit()̌Ăяo:ĂяoȂ<br>
     *         (ԕω) propertyInit()̌Ăяo:configƓŌĂяo<br>
     *         
     * <br>
     * dbInitĂ΂ꂸApropertyInitĂ΂Ă邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDBMessageResourcesMessageResourcesFactoryString03() throws Exception {
        // O        
        // dbInitĂ΂Ȃ悤mapݒ肷
        Map<String, String> dbMap
            = new HashMap<String, String>();
        dbMap.put("TEST01", "eXgbZ[WOP");
        UTUtil.setPrivateField(
                DBMessageResources.class,
                "dbMessages",
                dbMap);
        
        // eXg{
        DBMessageResources resources 
            = new DBMessageResources(null, 
                DBMessageResources.class.getPackage().getName()
                .replace('.', '/') + "/DBMessageResources_MessageResources05");

        // 
        assertNull(UTUtil.getPrivateField(resources, "factory"));
        assertEquals(
                DBMessageResources.class.getPackage().getName()
                .replace('.', '/') + "/DBMessageResources_MessageResources05",
                UTUtil.getPrivateField(resources, "config"));
        
        Map actualDbMap = (Map) UTUtil.getPrivateField(resources, "dbMessages");
        assertSame(dbMap, actualDbMap);
        assertEquals(1, actualDbMap.size());
        assertEquals("eXgbZ[WOP", actualDbMap.get("TEST01"));
        
        Map actualMap = (Map) UTUtil.getPrivateField(resources, "messages");
        assertEquals(1, actualMap.size());
        assertEquals("{0}̓{1}`œ͂ĂB",
                     actualMap.get("error.date.format"));
    }

    /**
     * testDBMessageResourcesMessageResourcesFactoryString04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() factory:DBMessageResourcesFactoryCX^X<br>
     *         () config:null<br>
     *         () dbMessages:["TEST01"->"eXgbZ[WOP"]<br>
     *         
     * <br>
     * ҒlF(߂l) DBMessageResources:factory->OŐݒ肵CX^X<br>
     *                  config->null<br>
     *         (ԕω) dbInit()̌Ăяo:ĂяoȂ<br>
     *         (ԕω) propertyInit()̌Ăяo:nullŌĂяo<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "Message resources file "null" is illegal."<br>
     *         
     * <br>
     * confignull̏ꍇAdbInitĂ΂ꂸApropertyInitĂ΂AG[Oo͂ACX^Xԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDBMessageResourcesMessageResourcesFactoryString04() throws Exception {
        // O
        
        // dbInitĂ΂Ȃ悤mapݒ肷
        Map<String, String> dbMap
            = new HashMap<String, String>();
        dbMap.put("TEST01", "eXgbZ[WOP");
        UTUtil.setPrivateField(
            DBMessageResources.class,
            "dbMessages",
            dbMap);
        DBMessageResourcesFactory factory
            = new DBMessageResourcesFactory();
        
        // eXg{
        DBMessageResources resources
            = new DBMessageResources(factory, null);

        // 
        assertSame(factory, UTUtil.getPrivateField(resources, "factory"));
        assertNull(UTUtil.getPrivateField(resources, "config"));
        
        Map actualDbMap = (Map) UTUtil.getPrivateField(resources, "dbMessages");
        assertSame(dbMap, actualDbMap);
        assertEquals(1, actualDbMap.size());
        assertEquals("eXgbZ[WOP", actualDbMap.get("TEST01"));
       
        Map actualMap = (Map) UTUtil.getPrivateField(resources, "messages");
        assertTrue(actualMap.isEmpty());

        assertTrue(LogUTUtil.checkError(
            "Message resources file \"null\" is illegal."));
        
    }

    /**
     * testDBMessageResourcesMessageResourcesFactoryString05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() factory:DBMessageResourcesFactoryCX^X<br>
     *         () config:""<br>
     *         () dbMessages:["TEST01"->"eXgbZ[WOP"]<br>
     *         
     * <br>
     * ҒlF(߂l) DBMessageResources:factory->OŐݒ肵CX^X<br>
     *                  config->""<br>
     *         (ԕω) dbInit()̌Ăяo:ĂяoȂ<br>
     *         (ԕω) propertyInit()̌Ăяo:configƓŌĂяo<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "Message resources file "" is illegal."<br>
     *         
     * <br>
     * confignull̏ꍇAdbInitĂ΂ꂸApropertyInitĂ΂A
     * G[Oo͂ACX^Xԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDBMessageResourcesMessageResourcesFactoryString05() throws Exception {
        // O        
        // dbInitĂ΂Ȃ悤mapݒ肷
        Map<String, String> dbMap
            = new HashMap<String, String>();
        dbMap.put("TEST01", "eXgbZ[WOP");
        UTUtil.setPrivateField(
            DBMessageResources.class,
            "dbMessages",
            dbMap);
        DBMessageResourcesFactory factory
            = new DBMessageResourcesFactory();
        
        // eXg{
        DBMessageResources resources
            = new DBMessageResources(factory, "");

        // 
        assertSame(factory, UTUtil.getPrivateField(resources, "factory"));
        assertEquals("", UTUtil.getPrivateField(resources, "config"));
        
        Map actualDbMap = (Map) UTUtil.getPrivateField(resources, "dbMessages");
        assertSame(dbMap, actualDbMap);
        assertEquals(1, actualDbMap.size());
        assertEquals("eXgbZ[WOP", actualDbMap.get("TEST01"));
        
        Map actualMap = (Map) UTUtil.getPrivateField(resources, "messages");
        assertTrue(actualMap.isEmpty());
        assertTrue(LogUTUtil.checkError(
            "Message resources file \"\" is illegal."));
        
    }

    /**
     * testDBMessageResourcesMessageResourcesFactoryStringboolean01()
     * <br><br>
     * 
     *  (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() factory:DBMessageResourcesFactoryCX^X<br>
     *         () config:"DBMessageResources_MessageResources05"<br>
     *                       yt@C̓ez<br>
     *                       error.date.format={0}̓{1}`œ͂ĂB<br>
     *         () returnNull:true<br>
     *         () dbMessages:null<br>
     *         () messageResources.messageFormatClone:"disable"<br>
     *         
     * <br>
     * ҒlF(߂l) DBMessageResources:factory->OŐݒ肵CX^X<br>
     *                  config->"DBMessageResources_MessageResources05"<br>
     *                  returnNull->true<br>
     *                  formats->HashMapCX^X<br>
     *         (ԕω) dbInit()̌Ăяo:Ăяo<br>
     *         (ԕω) propertyInit()̌Ăяo:configƓŌĂяo<br>
     *         
     * <br>
     * dbInitĂ΂ApropertyInitĂ΂Ă邱ƂmFB
     * MessageFormatCacheMapFactory#getInstance̖߂lnull̂ƂA
     * formats͍ւȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDBMessageResourcesMessageResourcesFactoryStringboolean01() throws Exception {
        // O
        UTUtil.setPrivateField(
                DBMessageResources.class,
                "dbMessages",
                null);
        DBMessageResourcesFactory factory
            = new DBMessageResourcesFactory();
        addProperty("messageResources.messageFormatClone", "disable");
        
        // eXg{
        DBMessageResources resources
        = new DBMessageResources(factory, 
            DBMessageResources.class.getPackage().getName()
            .replace('.', '/') + "/DBMessageResources_MessageResources05",
            true);    
        
        // 
        assertSame(factory, UTUtil.getPrivateField(resources, "factory"));
        assertEquals(DBMessageResources.class.getPackage().getName()
                .replace('.', '/') + "/DBMessageResources_MessageResources05",
                UTUtil.getPrivateField(resources, "config"));
        assertEquals(true, UTUtil.getPrivateField(resources, "returnNull"));
        
        Map actualDbMap 
            = (Map) UTUtil.getPrivateField(DBMessageResources.class, 
            "dbMessages");
        assertTrue(actualDbMap.isEmpty());
        
        Map actualMap = (Map) UTUtil.getPrivateField(resources, "messages");
        assertEquals(1, actualMap.size());
        assertEquals("{0}̓{1}`œ͂ĂB",
                     actualMap.get("error.date.format"));
        assertEquals(UTUtil.getPrivateField(resources, "formats").getClass(), HashMap.class);
    }

    /**
     * testDBMessageResourcesMessageResourcesFactoryStringboolean02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() factory:DBMessageResourcesFactoryCX^X<br>
     *         () config:"DBMessageResources_MessageResources05"<br>
     *                       yt@C̓ez<br>
     *                       error.date.format={0}̓{1}`œ͂ĂB<br>
     *         () returnNull:true<br>
     *         () dbMessages:["TEST01"->"eXgbZ[WOP"]<br>
     *         () messageResources.messageFormatClone:"dateFormatOnly"<br>
     *         
     * <br>
     * ҒlF(߂l) DBMessageResources:factory->OŐݒ肵CX^X<br>
     *                  config->"DBMessageResources_MessageResources05"<br>
     *                  returnNull->true<br>
     *                  formats->MessageFormatCloneReturnIfUseDateFormatMapCX^X<br>
     *         (ԕω) dbInit()̌Ăяo:ĂяoȂ<br>
     *         (ԕω) propertyInit()̌Ăяo:configƓŌĂяo<br>
     *         
     * <br>
     * dbInitĂ΂ꂸApropertyInitĂ΂Ă邱ƂmFB
     * MessageFormatCacheMapFactory#getInstance̖߂lnullȊÔƂA
     * formats̖߂lɍւ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDBMessageResourcesMessageResourcesFactoryStringboolean02() throws Exception {
        // O
        // dbInitĂ΂Ȃ悤mapݒ肷
        Map<String, String> dbMap
            = new HashMap<String, String>();
        dbMap.put("TEST01", "eXgbZ[WOP");
        UTUtil.setPrivateField(
                DBMessageResources.class,
                "dbMessages",
                dbMap);
        DBMessageResourcesFactory factory
            = new DBMessageResourcesFactory();
        addProperty("messageResources.messageFormatClone", "dateFormatOnly");
        
        // eXg{
        DBMessageResources resources
        = new DBMessageResources(factory, 
            DBMessageResources.class.getPackage().getName()
            .replace('.', '/') + "/DBMessageResources_MessageResources05",
            true);     
        
        // 
        assertSame(factory, UTUtil.getPrivateField(resources, "factory"));
        assertEquals(
                DBMessageResources.class.getPackage().getName()
                .replace('.', '/') + "/DBMessageResources_MessageResources05",
                UTUtil.getPrivateField(resources, "config"));
        assertEquals(true, UTUtil.getPrivateField(resources, "returnNull"));
        
        Map actualDbMap = (Map) UTUtil.getPrivateField(resources, "dbMessages");
        assertSame(dbMap, actualDbMap);
        assertEquals(1, actualDbMap.size());
        assertEquals("eXgbZ[WOP", actualDbMap.get("TEST01"));
        
        Map actualMap = (Map) UTUtil.getPrivateField(resources, "messages");
        assertEquals(1, actualMap.size());
        assertEquals("{0}̓{1}`œ͂ĂB",
                     actualMap.get("error.date.format"));
        assertEquals(UTUtil.getPrivateField(resources, "formats").getClass(), MessageFormatCloneReturnIfUseDateFormatMap.class);
    }

    /**
     * testDBMessageResourcesMessageResourcesFactoryStringboolean03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() factory:null<br>
     *         () config:"DBMessageResources_MessageResources05"<br>
     *                       yt@C̓ez<br>
     *                       error.date.format={0}̓{1}`œ͂ĂB<br>
     *         () returnNull:true<br>
     *         () dbMessages:["TEST01"->"eXgbZ[WOP"]<br>
     *         
     * <br>
     * ҒlF(߂l) DBMessageResources:factory->null<br>
     *                  config->"DBMessageResources_MessageResources05"<br>
     *                  returnNull->true<br>
     *         (ԕω) dbInit()̌Ăяo:ĂяoȂ<br>
     *         (ԕω) propertyInit()̌Ăяo:configƓŌĂяo<br>
     *         
     * <br>
     * dbInitĂ΂ꂸApropertyInitĂ΂Ă邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDBMessageResourcesMessageResourcesFactoryStringboolean03() throws Exception {
        // O        
        // dbInitĂ΂Ȃ悤mapݒ肷
        Map<String, String> dbMap
            = new HashMap<String, String>();
        dbMap.put("TEST01", "eXgbZ[WOP");
        UTUtil.setPrivateField(
                DBMessageResources.class,
                "dbMessages",
                dbMap);
        
        // eXg{
        DBMessageResources resources 
        = new DBMessageResources(null, 
            DBMessageResources.class.getPackage().getName()
            .replace('.', '/') + "/DBMessageResources_MessageResources05",
            true);   
        
        // 
        assertNull(UTUtil.getPrivateField(resources, "factory"));
        assertEquals(
                DBMessageResources.class.getPackage().getName()
                .replace('.', '/') + "/DBMessageResources_MessageResources05",
                UTUtil.getPrivateField(resources, "config"));
        assertEquals(true, UTUtil.getPrivateField(resources, "returnNull"));
        
        Map actualDbMap = (Map) UTUtil.getPrivateField(resources, "dbMessages");
        assertSame(dbMap, actualDbMap);
        assertEquals(1, actualDbMap.size());
        assertEquals("eXgbZ[WOP", actualDbMap.get("TEST01"));
        
        Map actualMap = (Map) UTUtil.getPrivateField(resources, "messages");
        assertEquals(1, actualMap.size());
        assertEquals("{0}̓{1}`œ͂ĂB",
                     actualMap.get("error.date.format"));
        
    }

    /**
     * testDBMessageResourcesMessageResourcesFactoryStringboolean04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() factory:DBMessageResourcesFactoryCX^X<br>
     *         () config:null<br>
     *         () returnNull:true<br>
     *         () dbMessages:["TEST01"->"eXgbZ[WOP"]<br>
     *         
     * <br>
     * ҒlF(߂l) DBMessageResources:factory->OŐݒ肵CX^X<br>
     *                  config->null<br>
     *                  returnNull->true<br>
     *         (ԕω) dbInit()̌Ăяo:ĂяoȂ<br>
     *         (ԕω) propertyInit()̌Ăяo:configƓŌĂяo<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "Message resources file "null" is illegal."<br>
     *         
     * <br>
     * confignull̏ꍇAdbInitĂ΂ꂸApropertyInitĂ΂A
     * G[Oo͂ACX^Xԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDBMessageResourcesMessageResourcesFactoryStringboolean04() throws Exception {
        // O        
        // dbInitĂ΂Ȃ悤mapݒ肷
        Map<String, String> dbMap
            = new HashMap<String, String>();
        dbMap.put("TEST01", "eXgbZ[WOP");
        UTUtil.setPrivateField(
                DBMessageResources.class,
                "dbMessages",
                dbMap);
        DBMessageResourcesFactory factory
            = new DBMessageResourcesFactory();
        
        // eXg{
        DBMessageResources resources
            = new DBMessageResources(factory, null, true);

        // 
        assertSame(factory, UTUtil.getPrivateField(resources, "factory"));
        assertNull(UTUtil.getPrivateField(resources, "config"));
        assertEquals(true, UTUtil.getPrivateField(resources, "returnNull"));

        Map actualDbMap = (Map) UTUtil.getPrivateField(resources, "dbMessages");
        assertSame(dbMap, actualDbMap);
        assertEquals(1, actualDbMap.size());
        assertEquals("eXgbZ[WOP", actualDbMap.get("TEST01"));
        
        Map actualMap = (Map) UTUtil.getPrivateField(resources, "messages");
        assertTrue(actualMap.isEmpty());

        assertTrue(LogUTUtil.checkError(
                "Message resources file \"null\" is illegal."));
        
    }

    /**
     * testDBMessageResourcesMessageResourcesFactoryStringboolean05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() factory:DBMessageResourcesFactoryCX^X<br>
     *         () config:""<br>
     *         () returnNull:true<br>
     *         () dbMessages:["TEST01"->"eXgbZ[WOP"]<br>
     *         
     * <br>
     * ҒlF(߂l) DBMessageResources:factory->OŐݒ肵CX^X<br>
     *                  config->""<br>
     *                  returnNull->true<br>
     *         (ԕω) dbInit()̌Ăяo:ĂяoȂ<br>
     *         (ԕω) propertyInit()̌Ăяo:configƓŌĂяo<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "Message resources file "" is illegal."<br>
     *         
     * <br>
     * confignull̏ꍇAdbInitĂ΂ꂸApropertyInitĂ΂A
     * G[Oo͂ACX^Xԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDBMessageResourcesMessageResourcesFactoryStringboolean05() throws Exception {
        // O        
        // dbInitĂ΂Ȃ悤mapݒ肷
        Map<String, String> dbMap
            = new HashMap<String, String>();
        dbMap.put("TEST01", "eXgbZ[WOP");
        UTUtil.setPrivateField(
                DBMessageResources.class,
                "dbMessages",
                dbMap);
        DBMessageResourcesFactory factory
            = new DBMessageResourcesFactory();
        
        // eXg{
        DBMessageResources resources
            = new DBMessageResources(factory, "", true);

        // 
        assertSame(factory, UTUtil.getPrivateField(resources, "factory"));
        assertEquals("", UTUtil.getPrivateField(resources, "config"));
        assertEquals(true, UTUtil.getPrivateField(resources, "returnNull"));
        
        Map actualDbMap = (Map) UTUtil.getPrivateField(resources, "dbMessages");
        assertSame(dbMap, actualDbMap);
        assertEquals(1, actualDbMap.size());
        assertEquals("eXgbZ[WOP", actualDbMap.get("TEST01"));
        
        Map actualMap = (Map) UTUtil.getPrivateField(resources, "messages");
        assertTrue(actualMap.isEmpty());
        assertTrue(LogUTUtil.checkError(
                "Message resources file \"\" is illegal."));
    }

    /**
     * testDBMessageResourcesMessageResourcesFactoryStringboolean06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() factory:DBMessageResourcesFactoryCX^X<br>
     *         () config:"DBMessageResources_MessageResources05"<br>
     *                       yt@C̓ez<br>
     *                       error.date.format={0}̓{1}`œ͂ĂB<br>
     *         () returnNull:false<br>
     *         () dbMessages:["TEST01"->"eXgbZ[WOP"]<br>
     *         
     * <br>
     * ҒlF(߂l) DBMessageResources:factory->OŐݒ肵CX^X<br>
     *                  config->"DBMessageResources_MessageResources05"<br>
     *                  returnNull->false<br>
     *         (ԕω) dbInit()̌Ăяo:ĂяoȂ<br>
     *         (ԕω) propertyInit()̌Ăяo:configƓŌĂяo<br>
     *         
     * <br>
     * dbInitĂ΂ꂸApropertyInitĂ΂Ă邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDBMessageResourcesMessageResourcesFactoryStringboolean06() throws Exception {
        // O        
        // dbInitĂ΂Ȃ悤mapݒ肷
        Map<String, String> dbMap
            = new HashMap<String, String>();
        dbMap.put("TEST01", "eXgbZ[WOP");
        UTUtil.setPrivateField(
                DBMessageResources.class,
                "dbMessages",
                dbMap);
        DBMessageResourcesFactory factory
            = new DBMessageResourcesFactory();
        
        // eXg{

        DBMessageResources resources
            = new DBMessageResources(factory, 
                DBMessageResources.class.getPackage().getName()
                .replace('.', '/') + "/DBMessageResources_MessageResources05",
                false);   
        
        // 
        assertSame(factory, UTUtil.getPrivateField(resources, "factory"));
        assertEquals(
                DBMessageResources.class.getPackage().getName()
                .replace('.', '/') + "/DBMessageResources_MessageResources05",
                UTUtil.getPrivateField(resources, "config"));
        assertEquals(false, UTUtil.getPrivateField(resources, "returnNull"));
        
        Map actualDbMap = (Map) UTUtil.getPrivateField(resources, "dbMessages");
        assertSame(dbMap, actualDbMap);
        assertEquals(1, actualDbMap.size());
        assertEquals("eXgbZ[WOP", actualDbMap.get("TEST01"));
        
        Map actualMap = (Map) UTUtil.getPrivateField(resources, "messages");
        assertEquals(1, actualMap.size());
        assertEquals("{0}̓{1}`œ͂ĂB",
                     actualMap.get("error.date.format"));
    }

}
