/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.beans.jxpath;

import java.util.HashMap;

import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.beans.jxpath.HashMapForJXPathIntrospector} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * commons-JXPath̃oO(JXPATH-152)pHashMapB<br>
 * <p>
 * 
 * @see jp.terasoluna.fw.beans.jxpath.HashMapForJXPathIntrospector
 */
public class HashMapForJXPathIntrospectorTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(HashMapForJXPathIntrospectorTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testHashMapForJXPathIntrospector01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() HashMap<br>
     *                {
     *                  "aaa"="xxx",
     *                  "bbb"="yyy"
     *                }<br>
     *         
     * <br>
     * ҒlF(߂l) HashMapForJXPathIntrospector<br>
     *                {
     *                  "aaa"="xxx",
     *                  "bbb"="yyy"
     *                }<br>
     *         
     * <br>
     * RXgN^ɗ^Map̃Gg[ׂĊ܂ރCX^X邱Ƃ̊mFB
     * (X[p[NXւ̈ϏmFB)
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testHashMapForJXPathIntrospector01() throws Exception {
        // O
        HashMap<String, String> srcMap = new HashMap<String, String>();
        srcMap.put("aaa", "xxx");
        srcMap.put("bbb", "yyy");

        // eXg{
        HashMapForJXPathIntrospector<String, String> map = new HashMapForJXPathIntrospector<String, String>(srcMap);

        // 
        assertEquals(2, map.size());
        assertEquals("xxx", map.get("aaa"));
        assertEquals("yyy", map.get("bbb"));
    }

    /**
     * testGet01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() "aaa"<br>
     *         () {
     *                  "aaa"="xxx"
     *                }<br>
     *         () put2bL[IuWFNgput<br>
     *         
     * <br>
     * ҒlF(߂l) "xxx"<br>
     *         (ԕω) getɂ͏IȂ<br>
     *         
     * <br>
     * putget҂邱Ƃ̊mFB
     * (߂ĺAX[p[NXւ̈ϏmFB)
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGet01() throws Exception {
        // O
        final HashMapForJXPathIntrospector<Object, String> map = new HashMapForJXPathIntrospector<Object, String>(new HashMap<Object, String>());
        map.put("aaa", "xxx");
        new Thread() {

            @Override
            public void run() {
                map.put(new WaitHashObject(2000), "wait");
            }
            
        }.start();
        Thread.sleep(500);

        // eXg{
        long start = System.currentTimeMillis();
        String ret = map.get("aaa");
        long time = System.currentTimeMillis() - start;

        // 
        assertTrue(time > 1000); // 1500~b
        assertEquals("xxx", ret);
    }

    /**
     * testGet02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() "aaa"<br>
     *         () {
     *                  "aaa"="xxx"
     *                  get2bL[IuWFNg="wait"
     *                }<br>
     *         () get2bL[IuWFNgget<br>
     *         
     * <br>
     * ҒlF(߂l) "xxx"<br>
     *         (ԕω) get͑ɏI<br>
     *         
     * <br>
     * putłȂget͓ɕXbhŎgp\ł邱Ƃ̊mFB
     * (߂ĺAX[p[NXւ̈ϏmFB)
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGet02() throws Exception {
        // O
        final HashMapForJXPathIntrospector<Object, String> map = new HashMapForJXPathIntrospector<Object, String>(new HashMap<Object, String>());
        map.put("aaa", "xxx");
        final WaitHashObject waitKey = new WaitHashObject(2000);
        map.put(waitKey, "wait");
        new Thread() {

            @Override
            public void run() {
                map.get(waitKey);
            }

        }.start();
        Thread.sleep(500);

        // eXg{
        long start = System.currentTimeMillis();
        String ret = map.get("aaa");
        long time = System.currentTimeMillis() - start;

        // 
        assertTrue(time < 500); // ق0~b
        assertEquals("xxx", ret);
    }

    /**
     * testPut01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"aaa"<br>
     *         () value:"xxx"<br>
     *         () {
     *                  ()
     *                }<br>
     *         () put2bL[IuWFNgput<br>
     *         
     * <br>
     * ҒlF(ԕω) Gg["aaa"="xxx"ǉ<br>
     *         (ԕω) putɂ͏IȂ<br>
     *         
     * <br>
     * putput҂邱Ƃ̊mFB
     * (Gg[ǉ́AX[p[NXւ̈ϏmFB)
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testPut01() throws Exception {
        // O
        final HashMapForJXPathIntrospector<Object, String> map = new HashMapForJXPathIntrospector<Object, String>(new HashMap<Object, String>());
        new Thread() {

            @Override
            public void run() {
                map.put(new WaitHashObject(2000), "wait");
            }
            
        }.start();
        Thread.sleep(500);

        // eXg{
        long start = System.currentTimeMillis();
        map.put("aaa", "xxx");
        long time = System.currentTimeMillis() - start;

        // 
        assertTrue(time > 1000); // 1500~b
        assertEquals("xxx", map.get("aaa"));
    }

    /**
     * testPut01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"aaa"<br>
     *         () value:"xxx"<br>
     *         () {
     *                  get2bL[IuWFNg="wait"
     *                }<br>
     *         () get2bL[IuWFNgget<br>
     *         
     * <br>
     * ҒlF(ԕω) Gg["aaa"="xxx"ǉ<br>
     *         (ԕω) putɂ͏IȂ<br>
     *         
     * <br>
     * getput҂邱Ƃ̊mFB
     * (Gg[ǉ́AX[p[NXւ̈ϏmFB)
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testPut02() throws Exception {
        // O
        final HashMapForJXPathIntrospector<Object, String> map = new HashMapForJXPathIntrospector<Object, String>(new HashMap<Object, String>());
        final WaitHashObject waitKey = new WaitHashObject(2000);
        map.put(waitKey, "wait");
        new Thread() {

            @Override
            public void run() {
                map.get(waitKey);
            }

        }.start();
        Thread.sleep(500);

        // eXg{
        long start = System.currentTimeMillis();
        map.put("aaa", "xxx");
        long time = System.currentTimeMillis() - start;

        // 
        assertTrue(time > 1000); // 1500~b
        assertEquals("xxx", map.get("aaa"));
    }

    /**
     * HashMapւputgetɎԂL[IuWFNgB
     * putget̍ۂɗphashCode\bhɁAX[vĂB
     * X[vԂ̓RXgN^Ŏw肷B
     */
    private static class WaitHashObject {
        private long sleepMillis;
        public WaitHashObject(long sleepMillis) {
            this.sleepMillis = sleepMillis;
            
        }
        @Override
        public int hashCode() {
            try {
                Thread.sleep(sleepMillis);
            } catch (InterruptedException e) {
            }
            return super.hashCode();
        }
        
    }
}
