/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.thin;

import static org.mockito.Mockito.*;

import com.mockrunner.mock.web.MockFilterChain;
import com.mockrunner.mock.web.MockHttpServletRequest;

import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;

import jp.co.nttdata.terasoluna.ractes.GeneratedByRactes;
import jp.co.nttdata.terasoluna.ractes.utlib.JUnit3TestCase;
import jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest;
import jp.terasoluna.utlib.MockServletRequest;
import jp.terasoluna.utlib.MockServletResponse;
import jp.terasoluna.utlib.UTUtil;

import org.springframework.beans.factory.annotation.Autowired;

/**
 * {@link jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter}̃eXgNX.
 * <p>
 * <dl>
 * <dt><b>eXgΏۃNXTv</b></dt>
 * <dd>
 * <p>
 * w肳ꂽK\p^[ɊÂāANCAg̃NGXgp[^gB
 * <p>
 * 
 * <p>
 * NCAgM͒lIɃg~OB rWlXWbNɂ́Ag~OꂽԂœ͒l󂯓nB
 * ̂߁Aʂ̃rWlXWbNŉ߂ăg~OsKv͂ȂB
 * <p>
 * 
 * NGXgp[^g@\
 * <p>
 * NCAgM͒lIɃg~OT[ubgtB^񋟂B
 * <p>
 * gp@
 * <p>
 * NCAg̓͒lIɃg~OꍇA
 * WebAvP[Vݒt@Ciweb.xmljŐp̃T[ubgtB^iTrimRequestParameterFilterjo^B
 * ̍ہAp[^ƂāANGXgp[^̃gɎgp鐳K\p^[itrimPatternjw肷B<br>
 * ȉ́ANGXgp[^ȎSpEpXy[XIɏꍇtrimPattern̎włB<br>
 * <br>
 * WebAvP[Vݒt@Ciweb.xmlj<br>
 * <code>
 * &lt;filter&gt;<br>
 * &nbsp;&lt;filter-name&gt;trimRequestParameterFilter&lt;filter-name&gt;<br>
 * &nbsp;&lt;filter-class&gt;jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter&lt;filter-class&gt;<br>
 * &nbsp;&lt;init-param&gt;<br>
 * &nbsp;&nbsp;&lt;param-name&gt;trimPattern&lt;param-name&gt;<br>
 * &nbsp;&nbsp;&lt;param-value&gt;^[@\s]|[@\s]$&lt;param-value&gt;<br>
 * &nbsp;&lt;init-param&gt;<br>
 * &lt;filter&gt;<br>
 * <br>
 * &lt;filter-mapping&gt;<br>
 * &nbsp;&lt;filter-name&gt; trimRequestParameterFilter &lt;filter-name&gt;<br>
 * &nbsp;&lt;url-pattern&gt;&lt;url-pattern&gt;<br>
 * &lt;filter-mapping&gt;<br>
 * <code></dd>
 * <dt><b>eXgΏۃo[W</b></dt>
 * <dd></dd>
 * </dl>
 * </p>
 * 
 * @author btkaneokah
 * @version $Id: TrimRequestParameterFilterTest.java 5156 2012-03-06 02:36:07Z bthashidumets $
 * @see jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter
 * @ractes.javadocgen
 */
@GeneratedByRactes(ver = "1.1.0", testObjects = {"jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter"})
public class TrimRequestParameterFilterTest extends JUnit3TestCase {

	/**
	 * eXgΏۃIuWFNg
	 * 
	 * @ractes.javadocgen
	 */
	@Autowired
	@GeneratedByRactes
	private TrimRequestParameterFilter testObject;

	/**
	 * eXg\bhsOɌĂяo.
	 * 
	 * @throws java.lang.Exception
	 * @ractes.javadocgen
	 */
	@Override
	@GeneratedByRactes
	public void setUpBeforeTestMethod() throws Exception {

	}

	/**
	 * eXg\bhsɌĂяo.
	 * 
	 * @throws java.lang.Exception
	 * @ractes.javadocgen
	 */
	@Override
	@GeneratedByRactes
	public void tearDownAfterTestMethod() throws Exception {

	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#init(FilterConfig)}
	 *  eXg:
	 * <ul>
	 * <li>gp^[p[^̒lgp^[ɐݒ肳</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>NGXgp[^̃gɎgp鐳K\p^[w肵āÃT[ubgtB^܂B</dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#init(FilterConfig)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testInitFilterConfig001() throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new TrimRequestParameterFilter();
		}

		// ͒l̏
		// config̏
		FilterConfig mockConfigA = mock(FilterConfig.class);
		String paramA = "trimPattern";
		// l
		String returnA = "^[@\\s]*|[@\\s]*$";
		when(mockConfigA.getInitParameter(paramA)).thenReturn(returnA);

		// eXg\bh̎s
		this.testObject.init(mockConfigA);

		// Ҍʂ̊mF
		// tB[htrimPattern̊mF
		// l
		String trimPatternA = (String) UTUtil.getPrivateField(this.testObject,
				"trimPattern");
		assertEquals("^[@\\s]*|[@\\s]*$", trimPatternA);

		// tB[hignoreFlag̊mF
		// tB^L
		boolean ignoreFlagA = ((Boolean) UTUtil.getPrivateField(
				this.testObject, "ignoreFlag")).booleanValue();
		assertEquals(false, ignoreFlagA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#init(FilterConfig)}
	 *  eXg:
	 * <ul>
	 * <li>gp^[p[^̒lُl̏ꍇAtOtrueɐݒ肷B</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>NGXgp[^̃gɎgp鐳K\p^[w肵āÃT[ubgtB^܂B</dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#init(FilterConfig)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testInitFilterConfig005() throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new TrimRequestParameterFilter();
		}

		// ͒l̏
		// config̏
		FilterConfig mockConfigA = mock(FilterConfig.class);
		String paramA = "trimPattern";
		// ُl
		String returnA = "\\";
		when(mockConfigA.getInitParameter(paramA)).thenReturn(returnA);

		// eXg\bh̎s
		this.testObject.init(mockConfigA);

		// Ҍʂ̊mF
		// tB[hignoreFlag̊mF
		// tB^
		boolean ignoreFlagA = ((Boolean) UTUtil.getPrivateField(
				this.testObject, "ignoreFlag")).booleanValue();
		assertEquals(true, ignoreFlagA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#init(FilterConfig)}
	 *  eXg:
	 * <ul>
	 * <li>gp^[p[^null̏ꍇAtOtrueɐݒ肷B</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; ȕɂU镑̐</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>NGXgp[^̃gɎgp鐳K\p^[w肵āÃT[ubgtB^܂B</dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#init(FilterConfig)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testInitFilterConfig006() throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new TrimRequestParameterFilter();
		}

		// ͒l̏
		// config̏
		FilterConfig mockConfigA = mock(FilterConfig.class);
		String paramA = "trimPattern";
		// null
		String returnA = null;
		when(mockConfigA.getInitParameter(paramA)).thenReturn(returnA);

		// eXg\bh̎s
		this.testObject.init(mockConfigA);

		// Ҍʂ̊mF
		// tB[hignoreFlag̊mF
		// tB^
		boolean ignoreFlagA = ((Boolean) UTUtil.getPrivateField(
				this.testObject, "ignoreFlag")).booleanValue();
		assertEquals(true, ignoreFlagA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#init(FilterConfig)}
	 *  eXg:
	 * <ul>
	 * <li>gp^[p[^󕶎̏ꍇAgp[^̒lgp^[ɃZbgB</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; ȕɂU镑̐</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>NGXgp[^̃gɎgp鐳K\p^[w肵āÃT[ubgtB^܂B</dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#init(FilterConfig)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testInitFilterConfig007() throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new TrimRequestParameterFilter();
		}

		// ͒l̏
		// config̏
		FilterConfig mockConfigA = mock(FilterConfig.class);
		String paramA = "trimPattern";
		// 󕶎
		String returnA = "";
		when(mockConfigA.getInitParameter(paramA)).thenReturn(returnA);

		// eXg\bh̎s
		this.testObject.init(mockConfigA);

		// Ҍʂ̊mF
		// tB[hignoreFlag̊mF
		// tB^L
		boolean ignoreFlagA = ((Boolean) UTUtil.getPrivateField(
				this.testObject, "ignoreFlag")).booleanValue();
		assertEquals(false, ignoreFlagA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#doFilter(ServletRequest, ServletResponse, FilterChain)}
	 *  eXg:
	 * <ul>
	 * <li>gp̃NGXgCX^X𐶐Ȃ</li>
	 * <li>Rec^Cvmultipart/form-dataŎn܂ꍇACX^X͍sȂ</li>
	 * <li>gp̃NGXgCX^X𐶐Ȃ</li>
	 * <li>Rec^Cvmultipart/form-dataŎn܂ꍇACX^X͍sȂ</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; ԗ</dd>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>̃T[ubgtB^s܂B
	 * 
	 * contentType<code>multipartform-data<code>łȂꍇA
 * HttpServletRequestParameterTrimmedHttpServletRequestɒu܂B
	 * </dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#doFilter(ServletRequest,
	 *      ServletResponse, FilterChain)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testDoFilterServletRequestServletResponseFilterChain001()
			throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new TrimRequestParameterFilter();
		}

		// Ȍ
		// OtrimPatterntB[h̏
		// l
		String trimPatternA = "^[@\\s]*|[@\\s]*$";
		UTUtil.setPrivateField(this.testObject, "trimPattern", trimPatternA);

		// ͒l̏
		// request̏
		HttpServletRequest mockRequestA = mock(HttpServletRequest.class);
		String returnA = "multipart/form-data";
		when(mockRequestA.getContentType()).thenReturn(returnA);

		// responsȅ
		MockServletResponse responseA = new MockServletResponse();

		// chain̏
		MockFilterChain chainA = new MockFilterChain();

		// eXg\bh̎s
		this.testObject.doFilter(mockRequestA, responseA, chainA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#doFilter(ServletRequest, ServletResponse, FilterChain)}
	 *  eXg:
	 * <ul>
	 * <li>gp̃NGXgCX^X𐶐</li>
	 * <li>Rec^Cvmultipart/form-dataŎnȂ</li>
	 * <li>̃NGXǧ^HttpServletRequest^̏ꍇACX^X͍s</li>
	 * <li>gp̃NGXgCX^X𐶐</li>
	 * <li>Rec^Cvmultipart/form-dataŎnȂ</li>
	 * <li>̃NGXǧ^HttpServletRequest^̏ꍇACX^X͍s</li>
	 * <li>gp̃NGXgCX^X𐶐</li>
	 * <li>Rec^Cvmultipart/form-dataŎnȂ</li>
	 * <li>̃NGXǧ^HttpServletRequest^̏ꍇACX^X͍s</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; ԗ</dd>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>̃T[ubgtB^s܂B
	 * 
	 * contentType<code>multipartform-data<code>łȂꍇA
 * HttpServletRequestParameterTrimmedHttpServletRequestɒu܂B
	 * </dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#doFilter(ServletRequest,
	 *      ServletResponse, FilterChain)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testDoFilterServletRequestServletResponseFilterChain002()
			throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new TrimRequestParameterFilter();
		}

		// Ȍ
		// OtrimPatterntB[h̏
		// l
		String trimPatternA = "^[@\\s]*|[@\\s]*$";
		UTUtil.setPrivateField(this.testObject, "trimPattern", trimPatternA);

		// ͒l̏
		// request̏
		HttpServletRequest mockRequestA = mock(HttpServletRequest.class);
		String returnA = "test";
		when(mockRequestA.getContentType()).thenReturn(returnA);

		// responsȅ
		MockServletResponse responseA = new MockServletResponse();

		// chain̏
		MockFilterChain chainA = new MockFilterChain();

		// eXg\bh̎s
		this.testObject.doFilter(mockRequestA, responseA, chainA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#doFilter(ServletRequest, ServletResponse, FilterChain)}
	 *  eXg:
	 * <ul>
	 * <li>gp̃NGXgCX^X𐶐</li>
	 * <li>Rec^Cvnull̏ꍇAp^[ZbgꂽNGXgCX^X</li>
	 * <li>̃NGXǧ^HttpServletRequest^̏ꍇACX^X͍s</li>
	 * <li>gp̃NGXgCX^X𐶐</li>
	 * <li>Rec^Cvnull̏ꍇAp^[ZbgꂽNGXgCX^X</li>
	 * <li>̃NGXǧ^HttpServletRequest^̏ꍇACX^X͍s</li>
	 * <li>gp̃NGXgCX^X𐶐</li>
	 * <li>Rec^Cvnull̏ꍇAp^[ZbgꂽNGXgCX^X</li>
	 * <li>̃NGXǧ^HttpServletRequest^̏ꍇACX^X͍s</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; ԗ</dd>
	 * <dd>@\ &gt; U镑 &gt; ȕɂU镑̐</dd>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>̃T[ubgtB^s܂B
	 * 
	 * contentType<code>multipartform-data<code>łȂꍇA
 * HttpServletRequestParameterTrimmedHttpServletRequestɒu܂B
	 * </dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#doFilter(ServletRequest,
	 *      ServletResponse, FilterChain)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testDoFilterServletRequestServletResponseFilterChain003()
			throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new TrimRequestParameterFilter();
		}

		// Ȍ
		// OtrimPatterntB[h̏
		// l
		String trimPatternA = "^[@\\s]*|[@\\s]*$";
		UTUtil.setPrivateField(this.testObject, "trimPattern", trimPatternA);

		// ͒l̏
		// request̏
		HttpServletRequest mockRequestA = mock(HttpServletRequest.class);
		// null
		String returnA = null;
		when(mockRequestA.getContentType()).thenReturn(returnA);

		// responsȅ
		MockServletResponse responseA = new MockServletResponse();

		// chain̏
		MockFilterChain chainA = new MockFilterChain();

		// eXg\bh̎s
		this.testObject.doFilter(mockRequestA, responseA, chainA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#doFilter(ServletRequest, ServletResponse, FilterChain)}
	 *  eXg:
	 * <ul>
	 * <li>gp̃NGXgCX^X𐶐</li>
	 * <li>Rec^Cv󕶎̏ꍇAgp^[ZbgꂽNGXgCX^X</li>
	 * <li>̃NGXǧ^HttpServletRequest^̏ꍇACX^X͍s</li>
	 * <li>gp̃NGXgCX^X𐶐</li>
	 * <li>Rec^Cv󕶎̏ꍇAgp^[ZbgꂽNGXgCX^X</li>
	 * <li>̃NGXǧ^HttpServletRequest^̏ꍇACX^X͍s</li>
	 * <li>gp̃NGXgCX^X𐶐</li>
	 * <li>Rec^Cv󕶎̏ꍇAgp^[ZbgꂽNGXgCX^X</li>
	 * <li>̃NGXǧ^HttpServletRequest^̏ꍇACX^X͍s</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; ԗ</dd>
	 * <dd>@\ &gt; U镑 &gt; ȕɂU镑̐</dd>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>̃T[ubgtB^s܂B
	 * 
	 * contentType<code>multipartform-data<code>łȂꍇA
 * HttpServletRequestParameterTrimmedHttpServletRequestɒu܂B
	 * </dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#doFilter(ServletRequest,
	 *      ServletResponse, FilterChain)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testDoFilterServletRequestServletResponseFilterChain004()
			throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new TrimRequestParameterFilter();
		}

		// Ȍ
		// OtrimPatterntB[h̏
		// l
		String trimPatternA = "^[@\\s]*|[@\\s]*$";
		UTUtil.setPrivateField(this.testObject, "trimPattern", trimPatternA);

		// ͒l̏
		// request̏
		HttpServletRequest mockRequestA = mock(HttpServletRequest.class);
		// 󕶎
		String returnA = "";
		when(mockRequestA.getContentType()).thenReturn(returnA);

		// responsȅ
		MockServletResponse responseA = new MockServletResponse();

		// chain̏
		MockFilterChain chainA = new MockFilterChain();

		// eXg\bh̎s
		this.testObject.doFilter(mockRequestA, responseA, chainA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#doFilter(ServletRequest, ServletResponse, FilterChain)}
	 *  eXg:
	 * <ul>
	 * <li>gp̃NGXgCX^X𐶐Ȃ</li>
	 * <li>Rec^Cvmultipart/form-dataŎnȂ</li>
	 * <li>̃NGXǧ^HttpServletRequest^ȊȌꍇACX^X͍sȂ</li>
	 * <li>gp̃NGXgCX^X𐶐Ȃ</li>
	 * <li>Rec^Cvmultipart/form-dataŎnȂ</li>
	 * <li>̃NGXǧ^HttpServletRequest^ȊȌꍇACX^X͍sȂ</li>
	 * <li>gp̃NGXgCX^X𐶐Ȃ</li>
	 * <li>Rec^Cvmultipart/form-dataŎnȂ</li>
	 * <li>̃NGXǧ^HttpServletRequest^ȊȌꍇACX^X͍sȂ</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; ԗ</dd>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>̃T[ubgtB^s܂B
	 * 
	 * contentType<code>multipartform-data<code>łȂꍇA
 * HttpServletRequestParameterTrimmedHttpServletRequestɒu܂B
	 * </dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#doFilter(ServletRequest,
	 *      ServletResponse, FilterChain)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testDoFilterServletRequestServletResponseFilterChain005()
			throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new TrimRequestParameterFilter();
		}

		// Ȍ
		// OtrimPatterntB[h̏
		// l
		String trimPatternA = "^[@\\s]*|[@\\s]*$";
		UTUtil.setPrivateField(this.testObject, "trimPattern", trimPatternA);

		// ͒l̏
		// request̏
		// HttpServletRequest^ȊO
		MockServletRequest requestA = new MockServletRequest();

		// responsȅ
		MockServletResponse responseA = new MockServletResponse();

		// chain̏
		MockFilterChain chainA = new MockFilterChain();

		// eXg\bh̎s
		this.testObject.doFilter(requestA, responseA, chainA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#doFilter(ServletRequest, ServletResponse, FilterChain)}
	 *  eXg:
	 * <ul>
	 * <li>tOTRUÊƂNGXgCX^X𐶐Ȃ</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>̃T[ubgtB^s܂B
	 * 
	 * contentType<code>multipartform-data<code>łȂꍇA
 * HttpServletRequestParameterTrimmedHttpServletRequestɒu܂B
	 * </dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#doFilter(ServletRequest,
	 *      ServletResponse, FilterChain)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testDoFilterServletRequestServletResponseFilterChain006()
			throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new TrimRequestParameterFilter();
		}

		// Ȍ
		// OtrimPatterntB[h̏
		// l
		String trimPatternA = "^[@\\s]*|[@\\s]*$";
		UTUtil.setPrivateField(this.testObject, "trimPattern", trimPatternA);

		// OignoreFlagtB[h̏
		// tB^
		boolean ignoreFlagA = true;
		UTUtil.setPrivateField(this.testObject, "ignoreFlag", Boolean
				.valueOf(ignoreFlagA));

		// ͒l̏
		// request̏
		HttpServletRequest mockRequestA = mock(HttpServletRequest.class);
		String returnA = "test";
		when(mockRequestA.getContentType()).thenReturn(returnA);

		// responsȅ
		MockServletResponse responseA = new MockServletResponse();

		// chain̏
		MockFilterChain chainA = new MockFilterChain();

		// eXg\bh̎s
		this.testObject.doFilter(mockRequestA, responseA, chainA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#doFilter(ServletRequest, ServletResponse, FilterChain)}
	 *  eXg:
	 * <ul>
	 * <li>tOFALSÊƂNGXgCX^X𐶐</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>̃T[ubgtB^s܂B
	 * 
	 * contentType<code>multipartform-data<code>łȂꍇA
 * HttpServletRequestParameterTrimmedHttpServletRequestɒu܂B
	 * </dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#doFilter(ServletRequest,
	 *      ServletResponse, FilterChain)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testDoFilterServletRequestServletResponseFilterChain007()
			throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new TrimRequestParameterFilter();
		}

		// Ȍ
		// OtrimPatterntB[h̏
		// l
		String trimPatternA = "^[@\\s]*|[@\\s]*$";
		UTUtil.setPrivateField(this.testObject, "trimPattern", trimPatternA);

		// OignoreFlagtB[h̏
		// tB^L
		boolean ignoreFlagA = false;
		UTUtil.setPrivateField(this.testObject, "ignoreFlag", Boolean
				.valueOf(ignoreFlagA));

		// ͒l̏
		// request̏
		HttpServletRequest mockRequestA = mock(HttpServletRequest.class);
		String returnA = "test";
		when(mockRequestA.getContentType()).thenReturn(returnA);

		// responsȅ
		MockServletResponse responseA = new MockServletResponse();

		// chain̏
		MockFilterChain chainA = new MockFilterChain();

		// eXg\bh̎s
		this.testObject.doFilter(mockRequestA, responseA, chainA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#destroy()}
	 *  eXg:
	 * <ul>
	 * <li>gp^[nullɐݒ肷</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>̃T[ubgtB^j܂B</dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#destroy()
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testDestroy001() throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new TrimRequestParameterFilter();
		}

		// Ȍ
		// OtrimPatterntB[h̏
		String trimPatternA = null;
		UTUtil.setPrivateField(this.testObject, "trimPattern", trimPatternA);

		// eXg\bh̎s
		this.testObject.destroy();

		// Ҍʂ̊mF
		// tB[htrimPattern̊mF
		String trimPatternB = (String) UTUtil.getPrivateField(this.testObject,
				"trimPattern");
		assertEquals(null, trimPatternB);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#destroy()}
	 *  eXg:
	 * <ul>
	 * <li>gp^[nullɐݒ肷</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>̃T[ubgtB^j܂B</dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#destroy()
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testDestroy002() throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new TrimRequestParameterFilter();
		}

		// Ȍ
		// OtrimPatterntB[h̏
		String trimPatternA = "";
		UTUtil.setPrivateField(this.testObject, "trimPattern", trimPatternA);

		// eXg\bh̎s
		this.testObject.destroy();

		// Ҍʂ̊mF
		// tB[htrimPattern̊mF
		String trimPatternB = (String) UTUtil.getPrivateField(this.testObject,
				"trimPattern");
		assertEquals(null, trimPatternB);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#destroy()}
	 *  eXg:
	 * <ul>
	 * <li>gp^[nullɐݒ肷</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>̃T[ubgtB^j܂B</dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#destroy()
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testDestroy003() throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new TrimRequestParameterFilter();
		}

		// Ȍ
		// OtrimPatterntB[h̏
		String trimPatternA = "^[@\\s]*|[@\\s]*$";
		UTUtil.setPrivateField(this.testObject, "trimPattern", trimPatternA);

		// eXg\bh̎s
		this.testObject.destroy();

		// Ҍʂ̊mF
		// tB[htrimPattern̊mF
		String trimPatternB = (String) UTUtil.getPrivateField(this.testObject,
				"trimPattern");
		assertEquals(null, trimPatternB);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#getParameterTrimmedHttpServletRequest(HttpServletRequest)}
	 *  eXg:
	 * <ul>
	 * <li>gp^[l̏ꍇA
	 * gp^[ZbgꂽParameterTrimmedHttpServletRequestCX^X</li>
	 * <li>߂lRequestCX^XtrimPatterntB[h͎OtB[h̃gp^[Ɉv</li>
	 * <li>gp^[l̏ꍇA
	 * gp^[ZbgꂽParameterTrimmedHttpServletRequestCX^X</li>
	 * <li>߂lRequestCX^XtrimPatterntB[h͎OtB[h̃gp^[Ɉv</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>HttpServletRequestParameterTrimmedHttpServletRequest\zĕԂ܂B</dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#getParameterTrimmedHttpServletRequest(HttpServletRequest)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testGetParameterTrimmedHttpServletRequestHttpServletRequest001()
			throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new TrimRequestParameterFilter();
		}

		// Ȍ
		// OtrimPatterntB[h̏
		// l
		String trimPatternA = "^[@\\s]*|[@\\s]*$";
		UTUtil.setPrivateField(this.testObject, "trimPattern", trimPatternA);

		// ͒l̏
		// request̏
		MockHttpServletRequest requestA = new MockHttpServletRequest();

		// eXg\bh̎s
		HttpServletRequest actual = this.testObject
				.getParameterTrimmedHttpServletRequest(requestA);

		// Ҍʂ̊mF
		// ߂l̊mF
		Class<?> returnA = actual.getClass();
		assertEquals(ParameterTrimmedHttpServletRequest.class, returnA);
		String trimPatternB = (String) UTUtil.getPrivateField(actual,
				"trimPattern");
		assertEquals("^[@\\s]*|[@\\s]*$", trimPatternB);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#getParameterTrimmedHttpServletRequest(HttpServletRequest)}
	 *  eXg:
	 * <ul>
	 * <li>gp^[ُl̏ꍇA
	 * gp^[ZbgꂽParameterTrimmedHttpServletRequestCX^X</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>HttpServletRequestParameterTrimmedHttpServletRequest\zĕԂ܂B</dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#getParameterTrimmedHttpServletRequest(HttpServletRequest)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testGetParameterTrimmedHttpServletRequestHttpServletRequest002()
			throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new TrimRequestParameterFilter();
		}

		// Ȍ
		// OtrimPatterntB[h̏
		// ُl
		String trimPatternA = "\\";
		UTUtil.setPrivateField(this.testObject, "trimPattern", trimPatternA);

		// ͒l̏
		// request̏
		MockHttpServletRequest requestA = new MockHttpServletRequest();

		// eXg\bh̎s
		HttpServletRequest actual = this.testObject
				.getParameterTrimmedHttpServletRequest(requestA);

		// Ҍʂ̊mF
		// ߂l̊mF
		Class<?> returnA = actual.getClass();
		assertEquals(ParameterTrimmedHttpServletRequest.class, returnA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#getParameterTrimmedHttpServletRequest(HttpServletRequest)}
	 *  eXg:
	 * <ul>
	 * <li>gp^[null̏ꍇA
	 * gp^[ZbgꂽParameterTrimmedHttpServletRequestCX^X</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; ȕɂU镑̐</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>HttpServletRequestParameterTrimmedHttpServletRequest\zĕԂ܂B</dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#getParameterTrimmedHttpServletRequest(HttpServletRequest)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testGetParameterTrimmedHttpServletRequestHttpServletRequest003()
			throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new TrimRequestParameterFilter();
		}

		// Ȍ
		// OtrimPatterntB[h̏
		// null
		String trimPatternA = null;
		UTUtil.setPrivateField(this.testObject, "trimPattern", trimPatternA);

		// ͒l̏
		// request̏
		MockHttpServletRequest requestA = new MockHttpServletRequest();

		// eXg\bh̎s
		HttpServletRequest actual = this.testObject
				.getParameterTrimmedHttpServletRequest(requestA);

		// Ҍʂ̊mF
		// ߂l̊mF
		Class<?> returnA = actual.getClass();
		assertEquals(ParameterTrimmedHttpServletRequest.class, returnA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#getParameterTrimmedHttpServletRequest(HttpServletRequest)}
	 *  eXg:
	 * <ul>
	 * <li>gp^[󕶎̏ꍇA
	 * gp^[ZbgꂽParameterTrimmedHttpServletRequestCX^X</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; ȕɂU镑̐</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>HttpServletRequestParameterTrimmedHttpServletRequest\zĕԂ܂B</dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#getParameterTrimmedHttpServletRequest(HttpServletRequest)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testGetParameterTrimmedHttpServletRequestHttpServletRequest004()
			throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new TrimRequestParameterFilter();
		}

		// Ȍ
		// OtrimPatterntB[h̏
		// ""
		String trimPatternA = "";
		UTUtil.setPrivateField(this.testObject, "trimPattern", trimPatternA);

		// ͒l̏
		// request̏
		MockHttpServletRequest requestA = new MockHttpServletRequest();

		// eXg\bh̎s
		HttpServletRequest actual = this.testObject
				.getParameterTrimmedHttpServletRequest(requestA);

		// Ҍʂ̊mF
		// ߂l̊mF
		Class<?> returnA = actual.getClass();
		assertEquals(ParameterTrimmedHttpServletRequest.class, returnA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#getParameterTrimmedHttpServletRequest(HttpServletRequest)}
	 *  eXg:
	 * <ul>
	 * <li>gp^[l̏ꍇA
	 * gp^[ZbgꂽParameterTrimmedHttpServletRequestCX^X</li>
	 * <li>߂lRequestCX^XtrimPatterntB[h͎OtB[h̃gp^[Ɉv</li>
	 * <li>gp^[l̏ꍇA
	 * gp^[ZbgꂽParameterTrimmedHttpServletRequestCX^X</li>
	 * <li>߂lRequestCX^XtrimPatterntB[h͎OtB[h̃gp^[Ɉv</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>HttpServletRequestParameterTrimmedHttpServletRequest\zĕԂ܂B</dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter#getParameterTrimmedHttpServletRequest(HttpServletRequest)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testGetParameterTrimmedHttpServletRequestHttpServletRequest005()
			throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new TrimRequestParameterFilter();
		}

		// Ȍ
		// OtrimPatterntB[h̏
		// l
		String trimPatternA = "test";
		UTUtil.setPrivateField(this.testObject, "trimPattern", trimPatternA);

		// ͒l̏
		// request̏
		MockHttpServletRequest requestA = new MockHttpServletRequest();

		// eXg\bh̎s
		HttpServletRequest actual = this.testObject
				.getParameterTrimmedHttpServletRequest(requestA);

		// Ҍʂ̊mF
		// ߂l̊mF
		String trimPatternB = (String) UTUtil.getPrivateField(actual,
				"trimPattern");
		assertEquals("test", trimPatternB);
	}

}
