/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.thin;

import static org.mockito.Mockito.*;

import jp.co.nttdata.terasoluna.ractes.GeneratedByRactes;
import jp.co.nttdata.terasoluna.ractes.utlib.JUnit3TestCase;
import jp.terasoluna.utlib.MockFilterChain;
import jp.terasoluna.utlib.MockFilterConfig;
import jp.terasoluna.utlib.MockServletRequest;
import jp.terasoluna.utlib.MockServletResponse;
import jp.terasoluna.utlib.UTUtil;

import org.springframework.beans.factory.annotation.Autowired;

/**
 * {@link jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter}̃eXgNX.
 * <p>
 * <dl>
 * <dt><b>eXgΏۃNXTv</b></dt>
 * <dd>
 * <p>
 * NGXgp[^̃GR[fBOݒsB
 * <p>
 * <p>
 * gp@
 * <p>
 * <p>
 * NCAg̃NGXgɎIɕGR[hwsꍇA WebAvP[Vݒt@Ciweb.xmlj
 * p̃T[ubgtB^iSetCharacterEncodingFilterjo^B<br>
 * ̍ہAp[^ƂāA NGXg̕GR[hʁEtB^̕񏈗tOEtB^[tOw肷B<br>
 * ȉ́ANGXgɎIɕGR[hwsꍇencoding̎włB<br>
 * <br>
 * WebAvP[Vݒt@Ciweb.xmlj<br>
 * <code>
 * &lt;filter&gt;<br>
 * &nbsp;&lt;filter-name&gt;encodingFilter&lt;filter-name&gt;<br>
 * &nbsp;&nbsp;&lt;filter-class&gt;<br>
 * &nbsp;&nbsp;&nbsp;jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter<br>
 * &nbsp;&nbsp;&lt;filter-class&gt;<br>
 * &nbsp;&nbsp;&lt;init-param&gt;<br>
 * &nbsp;&nbsp;&nbsp;&lt;param-name&gt;encoding&lt;param-name&gt;<br>
 * &nbsp;&nbsp;&nbsp;&lt;param-value&gt;Windows-31J&lt;param-value&gt;<br>
 * &nbsp;&nbsp;&lt;init-param&gt;<br>
 * &nbsp;&lt;init-param&gt;<br>
 * &nbsp;&nbsp;&lt;param-name&gt;more&lt;param-name&gt;<br>
 * &nbsp;&nbsp;&lt;param-value&gt;false&lt;param-value&gt;<br>
 * &nbsp;&lt;init-param&gt;<br>
 * &nbsp;&lt;init-param&gt;<br>
 * &nbsp;&nbsp;&lt;param-name&gt;ignore&lt;param-name&gt;<br>
 * &nbsp;&nbsp;&lt;param-value&gt;false&lt;param-value&gt;<br>
 * &nbsp;&lt;init-param&gt;<br>
 * &lt;filter&gt;<br>
 * <br>
 * &lt;filter-mapping&gt;<br>
 * &nbsp;&lt;filter-name&gt;encodingFilter&lt;filter-name&gt;<br>
 * &nbsp;&lt;url-pattern&gt;&lt;url-pattern&gt;<br>
 * &lt;filter-mapping&gt;<br>
 * <code></dd>
 * <dt><b>eXgΏۃo[W</b></dt>
 * <dd></dd>
 * </dl>
 * </p>
 * 
 * @author btkaneokah
 * @version $Id: SetCharacterEncodingFilterTest.java 5156 2012-03-06 02:36:07Z bthashidumets $
 * @see jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter
 * @ractes.javadocgen
 */
@GeneratedByRactes(ver = "1.1.0", testObjects = { "jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter" })
public class SetCharacterEncodingFilterTest extends JUnit3TestCase {

	/**
	 * eXgΏۃIuWFNg
	 * 
	 * @ractes.javadocgen
	 */
	@Autowired
	@GeneratedByRactes
	private SetCharacterEncodingFilter testObject;

	/**
	 * eXg\bhsOɌĂяo.
	 * 
	 * @throws java.lang.Exception
	 * @ractes.javadocgen
	 */
	@Override
	@GeneratedByRactes
	public void setUpBeforeTestMethod() throws Exception {

	}

	/**
	 * eXg\bhsɌĂяo.
	 * 
	 * @throws java.lang.Exception
	 * @ractes.javadocgen
	 */
	@Override
	@GeneratedByRactes
	public void tearDownAfterTestMethod() throws Exception {

	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#init(FilterConfig)}
	 *  eXg:
	 * <ul>
	 * <li>p[^Ȓl̏ꍇAtOtrueɐݒ肳B</li>
	 * <li>񏈗p[^Ȓl̏ꍇA񏈗tOtrueɐݒ肳B</li>
	 * <li>GR[fBOp[^̒ll̃GR[fBO̒lɐݒ肳</li>
	 * <li>p[^Ȓl̏ꍇAtOtrueɐݒ肳B</li>
	 * <li>񏈗p[^Ȓl̏ꍇA񏈗tOtrueɐݒ肳B</li>
	 * <li>GR[fBOp[^̒ll̃GR[fBO̒lɐݒ肳</li>
	 * <li>p[^Ȓl̏ꍇAtOtrueɐݒ肳B</li>
	 * <li>񏈗p[^Ȓl̏ꍇA񏈗tOtrueɐݒ肳B</li>
	 * <li>GR[fBOp[^̒ll̃GR[fBO̒lɐݒ肳</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>B</dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#init(FilterConfig)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testInitFilterConfig001() throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new SetCharacterEncodingFilter();
		}

		// ͒l̏
		// filterConfig̏
		MockFilterConfig mockFilterConfigA = mock(MockFilterConfig.class);
		String paramA_0 = "encoding";
		// l
		String returnA_0 = "Windows-31J";
		when(mockFilterConfigA.getInitParameter(paramA_0))
				.thenReturn(returnA_0);
		String paramA_1 = "ignore";
		// l
		String returnA_1 = "true";
		when(mockFilterConfigA.getInitParameter(paramA_1))
				.thenReturn(returnA_1);
		String paramA_2 = "more";
		// l
		String returnA_2 = "true";
		when(mockFilterConfigA.getInitParameter(paramA_2))
				.thenReturn(returnA_2);

		// eXg\bh̎s
		this.testObject.init(mockFilterConfigA);

		// Ҍʂ̊mF
		// tB[hencoding̊mF
		// l
		String encodingA = (String) UTUtil.getPrivateField(this.testObject,
				"encoding");
		assertEquals("Windows-31J", encodingA);

		// tB[hignoreFlag̊mF
		// true
		boolean ignoreFlagA = ((Boolean) UTUtil.getPrivateField(
				this.testObject, "ignoreFlag")).booleanValue();
		assertEquals(true, ignoreFlagA);

		// tB[hmoreFlag̊mF
		// true
		boolean moreFlagA = ((Boolean) UTUtil.getPrivateField(this.testObject,
				"moreFlag")).booleanValue();
		assertEquals(true, moreFlagA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#init(FilterConfig)}
	 *  eXg:
	 * <ul>
	 * <li>p[^ُȒl̏ꍇAtOfalseɐݒ肳B</li>
	 * <li>񏈗p[^ُȒl̏ꍇA񏈗tOfalseɐݒ肳B</li>
	 * <li>p[^ُȒl̏ꍇAtOfalseɐݒ肳B</li>
	 * <li>񏈗p[^ُȒl̏ꍇA񏈗tOfalseɐݒ肳B</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>B</dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#init(FilterConfig)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testInitFilterConfig005() throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new SetCharacterEncodingFilter();
		}

		// ͒l̏
		// filterConfig̏
		MockFilterConfig mockFilterConfigA = mock(MockFilterConfig.class);
		String paramA_0 = "encoding";
		// l
		String returnA_0 = "Windows-31J";
		when(mockFilterConfigA.getInitParameter(paramA_0))
				.thenReturn(returnA_0);
		String paramA_1 = "ignore";
		// ُl
		String returnA_1 = "test";
		when(mockFilterConfigA.getInitParameter(paramA_1))
				.thenReturn(returnA_1);
		String paramA_2 = "more";
		// ُl
		String returnA_2 = "test";
		when(mockFilterConfigA.getInitParameter(paramA_2))
				.thenReturn(returnA_2);

		// eXg\bh̎s
		this.testObject.init(mockFilterConfigA);

		// Ҍʂ̊mF
		// tB[hignoreFlag̊mF
		// false
		boolean ignoreFlagA = ((Boolean) UTUtil.getPrivateField(
				this.testObject, "ignoreFlag")).booleanValue();
		assertEquals(false, ignoreFlagA);

		// tB[hmoreFlag̊mF
		// false
		boolean moreFlagA = ((Boolean) UTUtil.getPrivateField(this.testObject,
				"moreFlag")).booleanValue();
		assertEquals(false, moreFlagA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#init(FilterConfig)}
	 *  eXg:
	 * <ul>
	 * <li>GR[fBOp[^󕶎̏ꍇAGR[fBOftHgGR[fBOɐݒ肳B</li>
	 * <li>p[^null̏ꍇAtOfalseɐݒ肳B</li>
	 * <li>񏈗p[^null̏ꍇA񏈗tOfalseɐݒ肳B</li>
	 * <li>GR[fBOp[^󕶎̏ꍇAGR[fBOftHgGR[fBOɐݒ肳B</li>
	 * <li>p[^null̏ꍇAtOfalseɐݒ肳B</li>
	 * <li>񏈗p[^null̏ꍇA񏈗tOfalseɐݒ肳B</li>
	 * <li>GR[fBOp[^󕶎̏ꍇAGR[fBOftHgGR[fBOɐݒ肳B</li>
	 * <li>p[^null̏ꍇAtOfalseɐݒ肳B</li>
	 * <li>񏈗p[^null̏ꍇA񏈗tOfalseɐݒ肳B</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; ȕɂU镑̐</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>B</dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#init(FilterConfig)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testInitFilterConfig006() throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new SetCharacterEncodingFilter();
		}

		// ͒l̏
		// filterConfig̏
		MockFilterConfig mockFilterConfigA = mock(MockFilterConfig.class);
		String paramA_0 = "encoding";
		// null
		String returnA_0 = null;
		when(mockFilterConfigA.getInitParameter(paramA_0))
				.thenReturn(returnA_0);
		String paramA_1 = "ignore";
		// null
		String returnA_1 = null;
		when(mockFilterConfigA.getInitParameter(paramA_1))
				.thenReturn(returnA_1);
		String paramA_2 = "more";
		// null
		String returnA_2 = null;
		when(mockFilterConfigA.getInitParameter(paramA_2))
				.thenReturn(returnA_2);

		// eXg\bh̎s
		this.testObject.init(mockFilterConfigA);

		// Ҍʂ̊mF
		// tB[hencoding̊mF
		// null
		String encodingA = (String) UTUtil.getPrivateField(this.testObject,
				"encoding");
		assertEquals(null, encodingA);

		// tB[hignoreFlag̊mF
		// false
		boolean ignoreFlagA = ((Boolean) UTUtil.getPrivateField(
				this.testObject, "ignoreFlag")).booleanValue();
		assertEquals(false, ignoreFlagA);

		// tB[hmoreFlag̊mF
		// false
		boolean moreFlagA = ((Boolean) UTUtil.getPrivateField(this.testObject,
				"moreFlag")).booleanValue();
		assertEquals(false, moreFlagA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#init(FilterConfig)}
	 *  eXg:
	 * <ul>
	 * <li>GR[fBOp[^󕶎̏ꍇAGR[fBOftHgGR[fBOɐݒ肳B</li>
	 * <li>p[^󕶎̏ꍇAtOfalseɐݒ肳B</li>
	 * <li>񏈗p[^󕶎̏ꍇA񏈗tOfalseɐݒ肳B</li>
	 * <li>GR[fBOp[^󕶎̏ꍇAGR[fBOftHgGR[fBOɐݒ肳B</li>
	 * <li>p[^󕶎̏ꍇAtOfalseɐݒ肳B</li>
	 * <li>񏈗p[^󕶎̏ꍇA񏈗tOfalseɐݒ肳B</li>
	 * <li>GR[fBOp[^󕶎̏ꍇAGR[fBOftHgGR[fBOɐݒ肳B</li>
	 * <li>p[^󕶎̏ꍇAtOfalseɐݒ肳B</li>
	 * <li>񏈗p[^󕶎̏ꍇA񏈗tOfalseɐݒ肳B</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; ȕɂU镑̐</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>B</dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#init(FilterConfig)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testInitFilterConfig007() throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new SetCharacterEncodingFilter();
		}

		// ͒l̏
		// filterConfig̏
		MockFilterConfig mockFilterConfigA = mock(MockFilterConfig.class);
		String paramA_0 = "encoding";
		// 󕶎
		String returnA_0 = "";
		when(mockFilterConfigA.getInitParameter(paramA_0))
				.thenReturn(returnA_0);
		String paramA_1 = "ignore";
		// 󕶎
		String returnA_1 = "";
		when(mockFilterConfigA.getInitParameter(paramA_1))
				.thenReturn(returnA_1);
		String paramA_2 = "more";
		// 󕶎
		String returnA_2 = "";
		when(mockFilterConfigA.getInitParameter(paramA_2))
				.thenReturn(returnA_2);

		// eXg\bh̎s
		this.testObject.init(mockFilterConfigA);

		// Ҍʂ̊mF
		// tB[hencoding̊mF
		// null
		String encodingA = (String) UTUtil.getPrivateField(this.testObject,
				"encoding");
		assertEquals(null, encodingA);

		// tB[hignoreFlag̊mF
		// false
		boolean ignoreFlagA = ((Boolean) UTUtil.getPrivateField(
				this.testObject, "ignoreFlag")).booleanValue();
		assertEquals(false, ignoreFlagA);

		// tB[hmoreFlag̊mF
		// false
		boolean moreFlagA = ((Boolean) UTUtil.getPrivateField(this.testObject,
				"moreFlag")).booleanValue();
		assertEquals(false, moreFlagA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#init(FilterConfig)}
	 *  eXg:
	 * <ul>
	 * <li>p[^Ȓl̏ꍇAtOtrueɐݒ肳B</li>
	 * <li>񏈗p[^Ȓl̏ꍇA񏈗tOtrueɐݒ肳B</li>
	 * <li>GR[fBOp[^̒lُl̏ꍇAnullɐݒ肳B</li>
	 * <li>p[^Ȓl̏ꍇAtOtrueɐݒ肳B</li>
	 * <li>񏈗p[^Ȓl̏ꍇA񏈗tOtrueɐݒ肳B</li>
	 * <li>GR[fBOp[^̒lُl̏ꍇAnullɐݒ肳B</li>
	 * <li>p[^Ȓl̏ꍇAtOtrueɐݒ肳B</li>
	 * <li>񏈗p[^Ȓl̏ꍇA񏈗tOtrueɐݒ肳B</li>
	 * <li>GR[fBOp[^̒lُl̏ꍇAnullɐݒ肳B</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>B</dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#init(FilterConfig)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testInitFilterConfig008() throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new SetCharacterEncodingFilter();
		}

		// ͒l̏
		// filterConfig̏
		MockFilterConfig mockFilterConfigA = mock(MockFilterConfig.class);
		String paramA_0 = "encoding";
		// 
		String returnA_0 = "test";
		when(mockFilterConfigA.getInitParameter(paramA_0))
				.thenReturn(returnA_0);
		String paramA_1 = "ignore";
		// l
		String returnA_1 = "yes";
		when(mockFilterConfigA.getInitParameter(paramA_1))
				.thenReturn(returnA_1);
		String paramA_2 = "more";
		// l
		String returnA_2 = "yes";
		when(mockFilterConfigA.getInitParameter(paramA_2))
				.thenReturn(returnA_2);

		// eXg\bh̎s
		this.testObject.init(mockFilterConfigA);

		// Ҍʂ̊mF
		// tB[hencoding̊mF
		// null
		String encodingA = (String) UTUtil.getPrivateField(this.testObject,
				"encoding");
		assertEquals(null, encodingA);

		// tB[hignoreFlag̊mF
		// true
		boolean ignoreFlagA = ((Boolean) UTUtil.getPrivateField(
				this.testObject, "ignoreFlag")).booleanValue();
		assertEquals(true, ignoreFlagA);

		// tB[hmoreFlag̊mF
		// true
		boolean moreFlagA = ((Boolean) UTUtil.getPrivateField(this.testObject,
				"moreFlag")).booleanValue();
		assertEquals(true, moreFlagA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#doFilter(ServletRequest, ServletResponse, FilterChain)}
	 *  eXg:
	 * <ul>
	 * <li>GR[hsȂݒ̏ꍇANGXg̃GR[hݒ肪sȂ</li>
	 * <li>񏈗tOfalse@and@tB^σtO̒l݂</li>
	 * <li>GR[hsȂݒ̏ꍇANGXg̃GR[hݒ肪sȂ</li>
	 * <li>񏈗tOfalse@and@tB^σtO̒l݂</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; ԗ</dd>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>tB^[B
	 * 
	 * <p>
	 * NGXgp[^w肳ꂽGR[fBOɐݒ肷B
	 * <p></dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#doFilter(ServletRequest,
	 *      ServletResponse, FilterChain)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testDoFilterServletRequestServletResponseFilterChain001()
			throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new SetCharacterEncodingFilter();
		}

		// Ȍ
		// OmoreFlagtB[h̏
		// 񏈗tOoff
		boolean moreFlagA = false;
		UTUtil.setPrivateField(this.testObject, "moreFlag", Boolean
				.valueOf(moreFlagA));

		// OencodingtB[h̏
		// l
		String encodingA = "Windows-31J";
		UTUtil.setPrivateField(this.testObject, "encoding", encodingA);

		// OignoreFlagtB[h̏
		// tOoff
		boolean ignoreFlagA = false;
		UTUtil.setPrivateField(this.testObject, "ignoreFlag", Boolean
				.valueOf(ignoreFlagA));

		// ͒l̏
		// request̏
		MockServletRequest requestA = new MockServletRequest();
		String param1A = "THRU_FILTER_ENCODING";
		// σtOon
		String param2A = "THRU_FILTER_ENCODING";
		requestA.setAttribute(param1A, param2A);

		// responsȅ
		MockServletResponse responseA = new MockServletResponse();

		// chain̏
		MockFilterChain chainA = new MockFilterChain();

		// eXg\bh̎s
		this.testObject.doFilter(requestA, responseA, chainA);

		// Ҍʂ̊mF
		// request̊mF
		String CharacterEncodingA = requestA.getCharacterEncoding();
		assertEquals(null, CharacterEncodingA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#doFilter(ServletRequest, ServletResponse, FilterChain)}
	 *  eXg:
	 * <ul>
	 * <li>GR[hsݒ̏ꍇANGXg̃GR[hݒ肪s</li>
	 * <li>񏈗tOtrue</li>
	 * <li>tOfalse and GR[fBOȒl</li>
	 * <li>GR[hsݒ̏ꍇANGXg̃GR[hݒ肪s</li>
	 * <li>񏈗tOtrue</li>
	 * <li>tOfalse and GR[fBOȒl</li>
	 * <li>GR[hsݒ̏ꍇANGXg̃GR[hݒ肪s</li>
	 * <li>񏈗tOtrue</li>
	 * <li>tOfalse and GR[fBOȒl</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; ԗ</dd>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>tB^[B
	 * 
	 * <p>
	 * NGXgp[^w肳ꂽGR[fBOɐݒ肷B
	 * <p></dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#doFilter(ServletRequest,
	 *      ServletResponse, FilterChain)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testDoFilterServletRequestServletResponseFilterChain002()
			throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new SetCharacterEncodingFilter();
		}

		// Ȍ
		// OmoreFlagtB[h̏
		// 񏈗tOon
		boolean moreFlagA = true;
		UTUtil.setPrivateField(this.testObject, "moreFlag", Boolean
				.valueOf(moreFlagA));

		// OencodingtB[h̏
		// l
		String encodingA = "Windows-31J";
		UTUtil.setPrivateField(this.testObject, "encoding", encodingA);

		// OignoreFlagtB[h̏
		// tOoff
		boolean ignoreFlagA = false;
		UTUtil.setPrivateField(this.testObject, "ignoreFlag", Boolean
				.valueOf(ignoreFlagA));

		// ͒l̏
		// request̏
		MockServletRequest requestA = new MockServletRequest();
		String param1A = "THRU_FILTER_ENCODING";
		// σtOon
		String param2A = "THRU_FILTER_ENCODING";
		requestA.setAttribute(param1A, param2A);

		// responsȅ
		MockServletResponse responseA = new MockServletResponse();

		// chain̏
		MockFilterChain chainA = new MockFilterChain();

		// eXg\bh̎s
		this.testObject.doFilter(requestA, responseA, chainA);

		// Ҍʂ̊mF
		// request̊mF
		String CharacterEncodingA = requestA.getCharacterEncoding();
		assertEquals("Windows-31J", CharacterEncodingA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#doFilter(ServletRequest, ServletResponse, FilterChain)}
	 *  eXg:
	 * <ul>
	 * <li>GR[hsݒ̏ꍇANGXg̃GR[hݒ肪s</li>
	 * <li>tB^σtO̒l݂Ȃ</li>
	 * <li>tOfalse and GR[fBOȒl</li>
	 * <li>GR[hsݒ̏ꍇANGXg̃GR[hݒ肪s</li>
	 * <li>tB^σtO̒l݂Ȃ</li>
	 * <li>tOfalse and GR[fBOȒl</li>
	 * <li>GR[hsݒ̏ꍇANGXg̃GR[hݒ肪s</li>
	 * <li>tB^σtO̒l݂Ȃ</li>
	 * <li>tOfalse and GR[fBOȒl</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; ԗ</dd>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>tB^[B
	 * 
	 * <p>
	 * NGXgp[^w肳ꂽGR[fBOɐݒ肷B
	 * <p></dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#doFilter(ServletRequest,
	 *      ServletResponse, FilterChain)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testDoFilterServletRequestServletResponseFilterChain003()
			throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new SetCharacterEncodingFilter();
		}

		// Ȍ
		// OmoreFlagtB[h̏
		// 񏈗tOoff
		boolean moreFlagA = false;
		UTUtil.setPrivateField(this.testObject, "moreFlag", Boolean
				.valueOf(moreFlagA));

		// OencodingtB[h̏
		// l
		String encodingA = "utf-8";
		UTUtil.setPrivateField(this.testObject, "encoding", encodingA);

		// OignoreFlagtB[h̏
		// tOoff
		boolean ignoreFlagA = false;
		UTUtil.setPrivateField(this.testObject, "ignoreFlag", Boolean
				.valueOf(ignoreFlagA));

		// ͒l̏
		// request̏
		MockServletRequest requestA = new MockServletRequest();
		String param1A = "THRU_FILTER_ENCODING";
		// σtOoff
		String param2A = null;
		requestA.setAttribute(param1A, param2A);

		// responsȅ
		MockServletResponse responseA = new MockServletResponse();

		// chain̏
		MockFilterChain chainA = new MockFilterChain();

		// eXg\bh̎s
		this.testObject.doFilter(requestA, responseA, chainA);

		// Ҍʂ̊mF
		// request̊mF
		String CharacterEncodingA = requestA.getCharacterEncoding();
		assertEquals("utf-8", CharacterEncodingA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#doFilter(ServletRequest, ServletResponse, FilterChain)}
	 *  eXg:
	 * <ul>
	 * <li>GR[hsȂݒ̏ꍇANGXg̃GR[hݒ肪sȂ</li>
	 * <li>񏈗tOtrue</li>
	 * <li>tOtrue</li>
	 * <li>GR[hsȂݒ̏ꍇANGXg̃GR[hݒ肪sȂ</li>
	 * <li>񏈗tOtrue</li>
	 * <li>tOtrue</li>
	 * <li>GR[hsȂݒ̏ꍇANGXg̃GR[hݒ肪sȂ</li>
	 * <li>񏈗tOtrue</li>
	 * <li>tOtrue</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; ԗ</dd>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>tB^[B
	 * 
	 * <p>
	 * NGXgp[^w肳ꂽGR[fBOɐݒ肷B
	 * <p></dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#doFilter(ServletRequest,
	 *      ServletResponse, FilterChain)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testDoFilterServletRequestServletResponseFilterChain004()
			throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new SetCharacterEncodingFilter();
		}

		// Ȍ
		// OmoreFlagtB[h̏
		// 񏈗tOon
		boolean moreFlagA = true;
		UTUtil.setPrivateField(this.testObject, "moreFlag", Boolean
				.valueOf(moreFlagA));

		// OencodingtB[h̏
		// l
		String encodingA = "utf-8";
		UTUtil.setPrivateField(this.testObject, "encoding", encodingA);

		// OignoreFlagtB[h̏
		// tOon
		boolean ignoreFlagA = true;
		UTUtil.setPrivateField(this.testObject, "ignoreFlag", Boolean
				.valueOf(ignoreFlagA));

		// ͒l̏
		// request̏
		MockServletRequest requestA = new MockServletRequest();
		String param1A = "THRU_FILTER_ENCODING";
		// σtOon
		String param2A = "THRU_FILTER_ENCODING";
		requestA.setAttribute(param1A, param2A);

		// responsȅ
		MockServletResponse responseA = new MockServletResponse();

		// chain̏
		MockFilterChain chainA = new MockFilterChain();

		// eXg\bh̎s
		this.testObject.doFilter(requestA, responseA, chainA);

		// Ҍʂ̊mF
		// request̊mF
		String CharacterEncodingA = requestA.getCharacterEncoding();
		assertEquals(null, CharacterEncodingA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#doFilter(ServletRequest, ServletResponse, FilterChain)}
	 *  eXg:
	 * <ul>
	 * <li>GR[hsȂݒ̏ꍇANGXg̃GR[hݒ肪sȂ</li>
	 * <li>tB^σtO̒l݂Ȃ</li>
	 * <li>GR[fBOُȒl</li>
	 * <li>GR[hsȂݒ̏ꍇANGXg̃GR[hݒ肪sȂ</li>
	 * <li>tB^σtO̒l݂Ȃ</li>
	 * <li>GR[fBOُȒl</li>
	 * <li>GR[hsȂݒ̏ꍇANGXg̃GR[hݒ肪sȂ</li>
	 * <li>tB^σtO̒l݂Ȃ</li>
	 * <li>GR[fBOُȒl</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; ԗ</dd>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>tB^[B
	 * 
	 * <p>
	 * NGXgp[^w肳ꂽGR[fBOɐݒ肷B
	 * <p></dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#doFilter(ServletRequest,
	 *      ServletResponse, FilterChain)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testDoFilterServletRequestServletResponseFilterChain005()
			throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new SetCharacterEncodingFilter();
		}

		// Ȍ
		// OmoreFlagtB[h̏
		// 񏈗tOoff
		boolean moreFlagA = false;
		UTUtil.setPrivateField(this.testObject, "moreFlag", Boolean
				.valueOf(moreFlagA));

		// OencodingtB[h̏
		// 
		String encodingA = null;
		UTUtil.setPrivateField(this.testObject, "encoding", encodingA);

		// OignoreFlagtB[h̏
		// tOoff
		boolean ignoreFlagA = false;
		UTUtil.setPrivateField(this.testObject, "ignoreFlag", Boolean
				.valueOf(ignoreFlagA));

		// ͒l̏
		// request̏
		MockServletRequest requestA = new MockServletRequest();
		String param1A = "THRU_FILTER_ENCODING";
		// σtOoff
		String param2A = null;
		requestA.setAttribute(param1A, param2A);

		// responsȅ
		MockServletResponse responseA = new MockServletResponse();

		// chain̏
		MockFilterChain chainA = new MockFilterChain();

		// eXg\bh̎s
		this.testObject.doFilter(requestA, responseA, chainA);

		// Ҍʂ̊mF
		// request̊mF
		String CharacterEncodingA = requestA.getCharacterEncoding();
		assertEquals(null, CharacterEncodingA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#doFilter(ServletRequest, ServletResponse, FilterChain)}
	 *  eXg:
	 * <ul>
	 * <li>GR[fBO̒lُȏꍇAG[s</li>
	 * <li>tB^σtO̒l݂Ȃ</li>
	 * <li>GR[fBOُȒl</li>
	 * <li>GR[fBO̒lُȏꍇAG[s</li>
	 * <li>tB^σtO̒l݂Ȃ</li>
	 * <li>GR[fBOُȒl</li>
	 * <li>GR[fBO̒lُȏꍇAG[s</li>
	 * <li>tB^σtO̒l݂Ȃ</li>
	 * <li>GR[fBOُȒl</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; ԗ</dd>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>tB^[B
	 * 
	 * <p>
	 * NGXgp[^w肳ꂽGR[fBOɐݒ肷B
	 * <p></dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#doFilter(ServletRequest,
	 *      ServletResponse, FilterChain)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testDoFilterServletRequestServletResponseFilterChain006()
			throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new SetCharacterEncodingFilter();
		}

		// Ȍ
		// OmoreFlagtB[h̏
		// 񏈗tOoff
		boolean moreFlagA = false;
		UTUtil.setPrivateField(this.testObject, "moreFlag", Boolean
				.valueOf(moreFlagA));

		// OencodingtB[h̏
		// 󕶎
		String encodingA = "";
		UTUtil.setPrivateField(this.testObject, "encoding", encodingA);

		// OignoreFlagtB[h̏
		// tOoff
		boolean ignoreFlagA = false;
		UTUtil.setPrivateField(this.testObject, "ignoreFlag", Boolean
				.valueOf(ignoreFlagA));

		// ͒l̏
		// request̏
		MockServletRequest requestA = new MockServletRequest();
		String param1A = "THRU_FILTER_ENCODING";
		// σtOoff
		String param2A = null;
		requestA.setAttribute(param1A, param2A);

		// responsȅ
		MockServletResponse responseA = new MockServletResponse();

		// chain̏
		MockFilterChain chainA = new MockFilterChain();

		// eXg\bh̎s
		this.testObject.doFilter(requestA, responseA, chainA);

		// Ҍʂ̊mF
		// request̊mF
		String CharacterEncodingA = requestA.getCharacterEncoding();
		assertEquals("", CharacterEncodingA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#doFilter(ServletRequest, ServletResponse, FilterChain)}
	 *  eXg:
	 * <ul>
	 * <li>GR[fBO̒lُȏꍇAG[s</li>
	 * <li>tB^σtO̒l݂Ȃ</li>
	 * <li>GR[fBOُȒl</li>
	 * <li>GR[fBO̒lُȏꍇAG[s</li>
	 * <li>tB^σtO̒l݂Ȃ</li>
	 * <li>GR[fBOُȒl</li>
	 * <li>GR[fBO̒lُȏꍇAG[s</li>
	 * <li>tB^σtO̒l݂Ȃ</li>
	 * <li>GR[fBOُȒl</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; ԗ</dd>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>tB^[B
	 * 
	 * <p>
	 * NGXgp[^w肳ꂽGR[fBOɐݒ肷B
	 * <p></dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#doFilter(ServletRequest,
	 *      ServletResponse, FilterChain)
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testDoFilterServletRequestServletResponseFilterChain007()
			throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new SetCharacterEncodingFilter();
		}

		// Ȍ
		// OmoreFlagtB[h̏
		// 񏈗tOoff
		boolean moreFlagA = false;
		UTUtil.setPrivateField(this.testObject, "moreFlag", Boolean
				.valueOf(moreFlagA));

		// OencodingtB[h̏
		// ُl
		String encodingA = "ARIMASEN";
		UTUtil.setPrivateField(this.testObject, "encoding", encodingA);

		// OignoreFlagtB[h̏
		// tOoff
		boolean ignoreFlagA = false;
		UTUtil.setPrivateField(this.testObject, "ignoreFlag", Boolean
				.valueOf(ignoreFlagA));

		// ͒l̏
		// request̏
		MockServletRequest requestA = new MockServletRequest();
		String param1A = "THRU_FILTER_ENCODING";
		// σtOoff
		String param2A = null;
		requestA.setAttribute(param1A, param2A);

		// responsȅ
		MockServletResponse responseA = new MockServletResponse();

		// chain̏
		MockFilterChain chainA = new MockFilterChain();

		// eXg\bh̎s
		this.testObject.doFilter(requestA, responseA, chainA);

		// Ҍʂ̊mF
		// request̊mF
		String CharacterEncodingA = requestA.getCharacterEncoding();
		assertEquals("ARIMASEN", CharacterEncodingA);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#destroy()}
	 *  eXg:
	 * <ul>
	 * <li>GR[fBOnullɐݒ肳</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>IB</dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#destroy()
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testDestroy001() throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new SetCharacterEncodingFilter();
		}

		// Ȍ
		// OencodingtB[h̏
		String encodingA = null;
		UTUtil.setPrivateField(this.testObject, "encoding", encodingA);

		// eXg\bh̎s
		this.testObject.destroy();

		// Ҍʂ̊mF
		// tB[hencoding̊mF
		String encodingB = (String) UTUtil.getPrivateField(this.testObject,
				"encoding");
		assertEquals(null, encodingB);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#destroy()}
	 *  eXg:
	 * <ul>
	 * <li>GR[fBOnullɐݒ肳</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>IB</dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#destroy()
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testDestroy002() throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new SetCharacterEncodingFilter();
		}

		// Ȍ
		// OencodingtB[h̏
		String encodingA = "";
		UTUtil.setPrivateField(this.testObject, "encoding", encodingA);

		// eXg\bh̎s
		this.testObject.destroy();

		// Ҍʂ̊mF
		// tB[hencoding̊mF
		String encodingB = (String) UTUtil.getPrivateField(this.testObject,
				"encoding");
		assertEquals(null, encodingB);
	}

	/**
	 * {@link jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#destroy()}
	 *  eXg:
	 * <ul>
	 * <li>GR[fBOnullɐݒ肳</li>
	 * </ul>
	 * mFeXg\bhB
	 * <p>
	 * <dl>
	 * <dt><b>i`FbN</b></dt>
	 * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
	 * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
	 * <dd>IB</dd>
	 * </dl>
	 * </p>
	 * 
	 * @throws java.lang.Exception
	 * @see jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter#destroy()
	 * @ractes.javadocgen
	 */
	@GeneratedByRactes
	public final void testDestroy003() throws Exception {
		// eXgΏۃCX^X̐
		if (null == this.testObject) {
			this.testObject = new SetCharacterEncodingFilter();
		}

		// Ȍ
		// OencodingtB[h̏
		String encodingA = "Windows-31J";
		UTUtil.setPrivateField(this.testObject, "encoding", encodingA);

		// eXg\bh̎s
		this.testObject.destroy();

		// Ҍʂ̊mF
		// tB[hencoding̊mF
		String encodingB = (String) UTUtil.getPrivateField(this.testObject,
				"encoding");
		assertEquals(null, encodingB);
	}

}
