/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.thin;

import static org.mockito.Mockito.*;

import java.util.Map;
import java.util.regex.PatternSyntaxException;

import jp.co.nttdata.terasoluna.ractes.GeneratedByRactes;
import jp.co.nttdata.terasoluna.ractes.utlib.JUnit3TestCase;
import jp.terasoluna.utlib.MockHttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;

/**
 * {@link jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest}
 * ̃eXgNX.
 * <p>
 * <dl>
 * <dt><b>eXgΏۃNXTv</b></dt>
 * <dd>
 * <p>
 * w肳ꂽK\p^[ɊÂăgꂽNGXgp[^ԂHttpServletRequest̎B
 * <p></dd>
 * <dt><b>eXgΏۃo[W</b></dt>
 * <dd></dd>
 * </dl>
 * </p>
 * 
 * @author btkaneokah
 * @version $Id: ParameterTrimmedHttpServletRequestTest.java 5156 2012-03-06 02:36:07Z bthashidumets $
 * @see jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest
 * @ractes.javadocgen
 */
@GeneratedByRactes(ver = "1.1.0", testObjects = { "jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest" })
public class ParameterTrimmedHttpServletRequestTest extends JUnit3TestCase {

    /**
     * eXgΏۃIuWFNg
     * 
     * @ractes.javadocgen
     */
    @Autowired
    @GeneratedByRactes
    private ParameterTrimmedHttpServletRequest testObject;

    /**
     * eXg\bhsOɌĂяo.
     * 
     * @throws java.lang.Exception
     * @ractes.javadocgen
     */
    @Override
    @GeneratedByRactes
    public void setUpBeforeTestMethod() throws Exception {

    }

    /**
     * eXg\bhsɌĂяo.
     * 
     * @throws java.lang.Exception
     * @ractes.javadocgen
     */
    @Override
    @GeneratedByRactes
    public void tearDownAfterTestMethod() throws Exception {

    }

    /**
     * {@link jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#getParameter(String)}
     *  eXg:
     * <ul>
     * <li>p[^ɑΉp[^݂ꍇAgꂽp[^ԋpB</li>
     * </ul>
     * mFeXg\bhB
     * <p>
     * <dl>
     * <dt><b>i`FbN</b></dt>
     * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
     * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
     * <dd>gꂽp[^擾܂B</dd>
     * </dl>
     * </p>
     * 
     * @throws java.lang.Exception
     * @see jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#getParameter(String)
     * @ractes.javadocgen
     */
    @GeneratedByRactes
    public final void testGetParameterString001() throws Exception {
        // eXgΏۃCX^X̐
        if (null == this.testObject) {
            MockHttpServletRequest param1A = new MockHttpServletRequest();
            // l
            String param2A = "^[@\\s]*|[@\\s]*$";
            this.testObject = new ParameterTrimmedHttpServletRequest(param1A,
                    param2A);
        }

        // Ȍ
        // OrequesttB[h̏
        MockHttpServletRequest requestA = new MockHttpServletRequest();
        String param1B = "key1";
        String param2B = " value1 ";
        requestA.setParameter(param1B, param2B);
        this.testObject.setRequest(requestA);

        // ͒l̏
        // namȅ
        // l
        String nameA = "key1";

        // eXg\bh̎s
        String actual = this.testObject.getParameter(nameA);

        // Ҍʂ̊mF
        // ߂l̊mF
        // l
        assertEquals("value1", actual);
    }

    /**
     * {@link jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#getParameter(String)}
     *  eXg:
     * <ul>
     * <li>p[^ɑΉp[^݂ȂꍇAnullԋpB</li>
     * </ul>
     * mFeXg\bhB
     * <p>
     * <dl>
     * <dt><b>i`FbN</b></dt>
     * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
     * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
     * <dd>gꂽp[^擾܂B</dd>
     * </dl>
     * </p>
     * 
     * @throws java.lang.Exception
     * @see jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#getParameter(String)
     * @ractes.javadocgen
     */
    @GeneratedByRactes
    public final void testGetParameterString002() throws Exception {
        // eXgΏۃCX^X̐
        if (null == this.testObject) {
            MockHttpServletRequest param1A = new MockHttpServletRequest();
            // l
            String param2A = "^[@\\s]*|[@\\s]*$";
            this.testObject = new ParameterTrimmedHttpServletRequest(param1A,
                    param2A);
        }

        // Ȍ
        // OrequesttB[h̏
        MockHttpServletRequest requestA = new MockHttpServletRequest();
        String param1B = "key1";
        String param2B = " value1 ";
        requestA.setParameter(param1B, param2B);
        this.testObject.setRequest(requestA);

        // ͒l̏
        // namȅ
        // l
        String nameA = "noValue";

        // eXg\bh̎s
        String actual = this.testObject.getParameter(nameA);

        // Ҍʂ̊mF
        // ߂l̊mF
        // null
        assertEquals(null, actual);
    }

    /**
     * {@link jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#getParameter(String)}
     *  eXg:
     * <ul>
     * <li>p[^null̏ꍇAnullԋpB</li>
     * </ul>
     * mFeXg\bhB
     * <p>
     * <dl>
     * <dt><b>i`FbN</b></dt>
     * <dd>@\ &gt; U镑 &gt; ȕɂU镑̐</dd>
     * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
     * <dd>gꂽp[^擾܂B</dd>
     * </dl>
     * </p>
     * 
     * @throws java.lang.Exception
     * @see jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#getParameter(String)
     * @ractes.javadocgen
     */
    @GeneratedByRactes
    public final void testGetParameterString003() throws Exception {
        // eXgΏۃCX^X̐
        if (null == this.testObject) {
            MockHttpServletRequest param1A = new MockHttpServletRequest();
            // l
            String param2A = "^[@\\s]*|[@\\s]*$";
            this.testObject = new ParameterTrimmedHttpServletRequest(param1A,
                    param2A);
        }

        // Ȍ
        // OrequesttB[h̏
        MockHttpServletRequest requestA = new MockHttpServletRequest();
        String param1B = "key1";
        String param2B = " value1 ";
        requestA.setParameter(param1B, param2B);
        this.testObject.setRequest(requestA);

        // ͒l̏
        // namȅ
        // null
        String nameA = null;

        // eXg\bh̎s
        String actual = this.testObject.getParameter(nameA);

        // Ҍʂ̊mF
        // ߂l̊mF
        // null
        assertEquals(null, actual);
    }

    /**
     * {@link jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#getParameterValues(String)}
     *  eXg:
     * <ul>
     * <li>z̗vfȏꍇAz̒lgp^[̐K\Ɉvӏgꂽz񂪕Ԃ</li>
     * </ul>
     * mFeXg\bhB
     * <p>
     * <dl>
     * <dt><b>i`FbN</b></dt>
     * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
     * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
     * <dd>gꂽp[^̔z擾܂B</dd>
     * </dl>
     * </p>
     * 
     * @throws java.lang.Exception
     * @see jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#getParameterValues(String)
     * @ractes.javadocgen
     */
    @GeneratedByRactes
    public final void testGetParameterValuesString001() throws Exception {
        // eXgΏۃCX^X̐
        if (null == this.testObject) {
            MockHttpServletRequest param1A = new MockHttpServletRequest();
            // l
            String param2A = "^[@\\s]*|[@\\s]*$";
            this.testObject = new ParameterTrimmedHttpServletRequest(param1A,
                    param2A);
        }

        // Ȍ
        // OrequesttB[h̏
        MockHttpServletRequest requestA = new MockHttpServletRequest();
        String param1B = "key1";
        String[] param2B = new String[1];
        param2B[0] = " value1 ";
        requestA.setParameter(param1B, param2B);
        this.testObject.setRequest(requestA);

        // ͒l̏
        // namȅ
        String nameA = "key1";

        // eXg\bh̎s
        String[] actual = this.testObject.getParameterValues(nameA);

        // Ҍʂ̊mF
        // ߂l̊mF
        assertEquals(1, actual.length);
        assertEquals("value1", actual[0]);
    }

    /**
     * {@link jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#getParameterValues(String)}
     *  eXg:
     * <ul>
     * <li>z̗vfȏꍇAz̒lgp^[̐K\Ɉvӏgꂽz񂪕Ԃ</li>
     * </ul>
     * mFeXg\bhB
     * <p>
     * <dl>
     * <dt><b>i`FbN</b></dt>
     * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
     * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
     * <dd>gꂽp[^̔z擾܂B</dd>
     * </dl>
     * </p>
     * 
     * @throws java.lang.Exception
     * @see jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#getParameterValues(String)
     * @ractes.javadocgen
     */
    @GeneratedByRactes
    public final void testGetParameterValuesString002() throws Exception {
        // eXgΏۃCX^X̐
        if (null == this.testObject) {
            MockHttpServletRequest param1A = new MockHttpServletRequest();
            // l
            String param2A = "^[@\\s]*|[@\\s]*$";
            this.testObject = new ParameterTrimmedHttpServletRequest(param1A,
                    param2A);
        }

        // Ȍ
        // OrequesttB[h̏
        MockHttpServletRequest requestA = new MockHttpServletRequest();
        String param1B = "key1";
        String[] param2B = new String[3];
        param2B[0] = " value1 ";
        param2B[1] = "value2 ";
        param2B[2] = "value3 ";
        requestA.setParameter(param1B, param2B);
        this.testObject.setRequest(requestA);

        // ͒l̏
        // namȅ
        String nameA = "key1";

        // eXg\bh̎s
        String[] actual = this.testObject.getParameterValues(nameA);

        // Ҍʂ̊mF
        // ߂l̊mF
        assertEquals(3, actual.length);
        assertEquals("value1", actual[0]);
        assertEquals("value2", actual[1]);
        assertEquals("value3", actual[2]);
    }

    /**
     * {@link jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#getParameterValues(String)}
     *  eXg:
     * <ul>
     * <li>p[^ɑΉp[^z񂪑݂ȂꍇAnullԋpB</li>
     * </ul>
     * mFeXg\bhB
     * <p>
     * <dl>
     * <dt><b>i`FbN</b></dt>
     * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
     * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
     * <dd>gꂽp[^̔z擾܂B</dd>
     * </dl>
     * </p>
     * 
     * @throws java.lang.Exception
     * @see jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#getParameterValues(String)
     * @ractes.javadocgen
     */
    @GeneratedByRactes
    public final void testGetParameterValuesString003() throws Exception {
        // eXgΏۃCX^X̐
        if (null == this.testObject) {
            MockHttpServletRequest param1A = new MockHttpServletRequest();
            // l
            String param2A = "^[@\\s]*|[@\\s]*$";
            this.testObject = new ParameterTrimmedHttpServletRequest(param1A,
                    param2A);
        }

        // Ȍ
        // OrequesttB[h̏
        MockHttpServletRequest requestA = new MockHttpServletRequest();
        String param1B = "key1";
        String[] param2B = new String[3];
        param2B[0] = " value1 ";
        param2B[1] = "value2 ";
        param2B[2] = "value3 ";
        requestA.setParameter(param1B, param2B);
        this.testObject.setRequest(requestA);

        // ͒l̏
        // namȅ
        String nameA = "noValue";

        // eXg\bh̎s
        String[] actual = this.testObject.getParameterValues(nameA);

        // Ҍʂ̊mF
        // ߂l̊mF
        assertEquals(null, actual);
    }

    /**
     * {@link jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#getParameterValues(String)}
     *  eXg:
     * <ul>
     * <li>z̗vfȏꍇAz̒lgp^[̐K\Ɉvӏgꂽz񂪕Ԃ</li>
     * </ul>
     * mFeXg\bhB
     * <p>
     * <dl>
     * <dt><b>i`FbN</b></dt>
     * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
     * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
     * <dd>gꂽp[^̔z擾܂B</dd>
     * </dl>
     * </p>
     * 
     * @throws java.lang.Exception
     * @see jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#getParameterValues(String)
     * @ractes.javadocgen
     */
    @GeneratedByRactes
    public final void testGetParameterValuesString004() throws Exception {
        // eXgΏۃCX^X̐
        if (null == this.testObject) {
            MockHttpServletRequest param1A = new MockHttpServletRequest();
            // l
            String param2A = "^[@\\s]*|[@\\s]*$";
            this.testObject = new ParameterTrimmedHttpServletRequest(param1A,
                    param2A);
        }

        // Ȍ
        // OrequesttB[h̏
        MockHttpServletRequest requestA = new MockHttpServletRequest();
        String param1B = "key1";
        String[] param2B = new String[0];
        requestA.setParameter(param1B, param2B);
        this.testObject.setRequest(requestA);

        // ͒l̏
        // namȅ
        String nameA = "key1";

        // eXg\bh̎s
        String[] actual = this.testObject.getParameterValues(nameA);

        // Ҍʂ̊mF
        // ߂l̊mF
        assertEquals(0, actual.length);
    }

    /**
     * {@link jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#getParameterValues(String)}
     *  eXg:
     * <ul>
     * <li>p[^null̏ꍇAnullԋpB</li>
     * </ul>
     * mFeXg\bhB
     * <p>
     * <dl>
     * <dt><b>i`FbN</b></dt>
     * <dd>@\ &gt; U镑 &gt; ȕɂU镑̐</dd>
     * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
     * <dd>gꂽp[^̔z擾܂B</dd>
     * </dl>
     * </p>
     * 
     * @throws java.lang.Exception
     * @see jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#getParameterValues(String)
     * @ractes.javadocgen
     */
    @GeneratedByRactes
    public final void testGetParameterValuesString005() throws Exception {
        // eXgΏۃCX^X̐
        if (null == this.testObject) {
            MockHttpServletRequest param1A = new MockHttpServletRequest();
            // l
            String param2A = "^[@\\s]*|[@\\s]*$";
            this.testObject = new ParameterTrimmedHttpServletRequest(param1A,
                    param2A);
        }

        // Ȍ
        // OrequesttB[h̏
        MockHttpServletRequest requestA = new MockHttpServletRequest();
        String param1B = "key1";
        String[] param2B = new String[3];
        param2B[0] = " value1 ";
        param2B[1] = "value2 ";
        param2B[2] = "value3 ";
        requestA.setParameter(param1B, param2B);
        this.testObject.setRequest(requestA);

        // ͒l̏
        // namȅ
        // null
        String nameA = null;

        // eXg\bh̎s
        String[] actual = this.testObject.getParameterValues(nameA);

        // Ҍʂ̊mF
        // ߂l̊mF
        assertEquals(null, actual);
    }

    /**
     * {@link jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#getParameterMap()}
     *  eXg:
     * <ul>
     * <li>}bv̗vfȏꍇA}bvvaluegp^[̐K\Ɉvӏgꂽ}bvԂ</li>
     * </ul>
     * mFeXg\bhB
     * <p>
     * <dl>
     * <dt><b>i`FbN</b></dt>
     * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
     * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
     * <dd>gꂽp[^̃}bv擾܂B</dd>
     * </dl>
     * </p>
     * 
     * @throws java.lang.Exception
     * @see jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#getParameterMap()
     * @ractes.javadocgen
     */
    @GeneratedByRactes
    public final void testGetParameterMap001() throws Exception {
        // eXgΏۃCX^X̐
        if (null == this.testObject) {
            MockHttpServletRequest param1A = new MockHttpServletRequest();
            // l
            String param2A = "^[@\\s]*|[@\\s]*$";
            this.testObject = new ParameterTrimmedHttpServletRequest(param1A,
                    param2A);
        }

        // Ȍ
        // OrequesttB[h̏
        MockHttpServletRequest requestA = new MockHttpServletRequest();
        String param1B = "key1";
        String[] param2B = new String[1];
        param2B[0] = " value1 ";
        requestA.setParameter(param1B, param2B);
        this.testObject.setRequest(requestA);

        // eXg\bh̎s
        Map<String, String[]> actual = this.testObject.getParameterMap();

        // Ҍʂ̊mF
        // ߂l̊mF
        assertEquals(1, actual.size());
        String actual_0_key = "key1";
        String[] actual_0_value = actual.get(actual_0_key);
        assertEquals(1, actual_0_value.length);
        assertEquals("value1", actual_0_value[0]);
    }

    /**
     * {@link jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#getParameterMap()}
     *  eXg:
     * <ul>
     * <li>}bv̗vfȏꍇA}bvvaluegp^[̐K\Ɉvӏgꂽ}bvԂ</li>
     * </ul>
     * mFeXg\bhB
     * <p>
     * <dl>
     * <dt><b>i`FbN</b></dt>
     * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
     * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
     * <dd>gꂽp[^̃}bv擾܂B</dd>
     * </dl>
     * </p>
     * 
     * @throws java.lang.Exception
     * @see jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#getParameterMap()
     * @ractes.javadocgen
     */
    @GeneratedByRactes
    public final void testGetParameterMap002() throws Exception {
        // eXgΏۃCX^X̐
        if (null == this.testObject) {
            MockHttpServletRequest param1A = new MockHttpServletRequest();
            // l
            String param2A = "^[@\\s]*|[@\\s]*$";
            this.testObject = new ParameterTrimmedHttpServletRequest(param1A,
                    param2A);
        }

        // Ȍ
        // OrequesttB[h̏
        MockHttpServletRequest requestA = new MockHttpServletRequest();
        String param1B = "key1";
        String[] param2B = new String[1];
        param2B[0] = " value1 ";
        requestA.setParameter(param1B, param2B);
        String param3A = "key2";
        String[] param4A = new String[2];
        param4A[0] = " value1 ";
        param4A[1] = "value2 ";
        requestA.setParameter(param3A, param4A);
        String param5A = "key3";
        String[] param6A = new String[3];
        param6A[0] = " value1 ";
        param6A[1] = "value2 ";
        param6A[2] = " value3";
        requestA.setParameter(param5A, param6A);
        this.testObject.setRequest(requestA);

        // eXg\bh̎s
        Map<String, String[]> actual = this.testObject.getParameterMap();

        // Ҍʂ̊mF
        // ߂l̊mF
        assertEquals(3, actual.size());
        String actual_0_key = "key1";
        String[] actual_0_value = actual.get(actual_0_key);
        assertEquals(1, actual_0_value.length);
        assertEquals("value1", actual_0_value[0]);
        String actual_1_key = "key2";
        String[] actual_1_value = actual.get(actual_1_key);
        assertEquals(2, actual_1_value.length);
        assertEquals("value1", actual_1_value[0]);
        assertEquals("value2", actual_1_value[1]);
        String actual_2_key = "key3";
        String[] actual_2_value = actual.get(actual_2_key);
        assertEquals(3, actual_2_value.length);
        assertEquals("value1", actual_2_value[0]);
        assertEquals("value2", actual_2_value[1]);
        assertEquals("value3", actual_2_value[2]);
    }

    /**
     * {@link jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#getParameterMap()}
     *  eXg:
     * <ul>
     * <li>p[^}bvnull̏ꍇAnullԋpB</li>
     * </ul>
     * mFeXg\bhB
     * <p>
     * <dl>
     * <dt><b>i`FbN</b></dt>
     * <dd>@\ &gt; U镑 &gt; ȕɂU镑̐</dd>
     * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
     * <dd>gꂽp[^̃}bv擾܂B</dd>
     * </dl>
     * </p>
     * 
     * @throws java.lang.Exception
     * @see jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#getParameterMap()
     * @ractes.javadocgen
     */
    @GeneratedByRactes
    public final void testGetParameterMap003() throws Exception {
        // eXgΏۃCX^X̐
        if (null == this.testObject) {
            MockHttpServletRequest param1A = new MockHttpServletRequest();
            // l
            String param2A = "^[@\\s]*|[@\\s]*$";
            this.testObject = new ParameterTrimmedHttpServletRequest(param1A,
                    param2A);
        }

        // Ȍ
        // OrequesttB[h̏
        MockHttpServletRequest mockRequestA = mock(MockHttpServletRequest.class);
        Map returnA = null;
        when(mockRequestA.getParameterMap()).thenReturn(returnA);
        this.testObject.setRequest(mockRequestA);

        // eXg\bh̎s
        Map<String, String[]> actual = this.testObject.getParameterMap();

        // Ҍʂ̊mF
        // ߂l̊mF
        assertEquals(null, actual);
    }

    /**
     * {@link jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#trim(String)}
     *  eXg:
     * <ul>
     * <li>NGXgp[^̒l̃gp^[Ɉvӏgꂽlԋp</li>
     * </ul>
     * mFeXg\bhB
     * <p>
     * <dl>
     * <dt><b>i`FbN</b></dt>
     * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
     * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
     * <dd>p[^lg܂B</dd>
     * </dl>
     * </p>
     * 
     * @throws java.lang.Exception
     * @see jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#trim(String)
     * @ractes.javadocgen
     */
    @GeneratedByRactes
    public final void testTrimString001() throws Exception {
        // eXgΏۃCX^X̐
        if (null == this.testObject) {
            MockHttpServletRequest param1A = new MockHttpServletRequest();
            // l
            String param2A = "^[@\\s]*|[@\\s]*$";
            this.testObject = new ParameterTrimmedHttpServletRequest(param1A,
                    param2A);
        }

        // ͒l̏
        // valuȅ
        // l(g)
        String valueA = "  test  ";

        // eXg\bh̎s
        String actual = this.testObject.trim(valueA);

        // Ҍʂ̊mF
        // ߂l̊mF
        // l(g)
        assertEquals("test", actual);
    }

    /**
     * {@link jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#trim(String)}
     *  eXg:
     * <ul>
     * <li>NGXgp[^̒l̃gp^[Ɉvӏgꂽlԋp</li>
     * </ul>
     * mFeXg\bhB
     * <p>
     * <dl>
     * <dt><b>i`FbN</b></dt>
     * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
     * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
     * <dd>p[^lg܂B</dd>
     * </dl>
     * </p>
     * 
     * @throws java.lang.Exception
     * @see jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#trim(String)
     * @ractes.javadocgen
     */
    @GeneratedByRactes
    public final void testTrimString002() throws Exception {
        // eXgΏۃCX^X̐
        if (null == this.testObject) {
            MockHttpServletRequest param1A = new MockHttpServletRequest();
            // l
            String param2A = "^[@\\s]*|[@\\s]*$";
            this.testObject = new ParameterTrimmedHttpServletRequest(param1A,
                    param2A);
        }

        // ͒l̏
        // valuȅ
        // l(gȂ)
        String valueA = "te   st";

        // eXg\bh̎s
        String actual = this.testObject.trim(valueA);

        // Ҍʂ̊mF
        // ߂l̊mF
        // l(gȂ)
        assertEquals("te   st", actual);
    }

    /**
     * {@link jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#trim(String)}
     *  eXg:
     * <ul>
     * <li>NGXgp[^̒lnull̏ꍇAnullԋpB</li>
     * </ul>
     * mFeXg\bhB
     * <p>
     * <dl>
     * <dt><b>i`FbN</b></dt>
     * <dd>@\ &gt; U镑 &gt; ȕɂU镑̐</dd>
     * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
     * <dd>p[^lg܂B</dd>
     * </dl>
     * </p>
     * 
     * @throws java.lang.Exception
     * @see jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#trim(String)
     * @ractes.javadocgen
     */
    @GeneratedByRactes
    public final void testTrimString003() throws Exception {
        // eXgΏۃCX^X̐
        if (null == this.testObject) {
            MockHttpServletRequest param1A = new MockHttpServletRequest();
            // l
            String param2A = "^[@\\s]*|[@\\s]*$";
            this.testObject = new ParameterTrimmedHttpServletRequest(param1A,
                    param2A);
        }

        // ͒l̏
        // valuȅ
        // null
        String valueA = null;

        // eXg\bh̎s
        String actual = this.testObject.trim(valueA);

        // Ҍʂ̊mF
        // ߂l̊mF
        // null
        assertEquals(null, actual);
    }

    /**
     * {@link jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#trim(String)}
     *  eXg:
     * <ul>
     * <li>NGXgp[^̒l󕶎̏ꍇAg͍sꂸɕԋpB</li>
     * </ul>
     * mFeXg\bhB
     * <p>
     * <dl>
     * <dt><b>i`FbN</b></dt>
     * <dd>@\ &gt; U镑 &gt; ȕɂU镑̐</dd>
     * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
     * <dd>p[^lg܂B</dd>
     * </dl>
     * </p>
     * 
     * @throws java.lang.Exception
     * @see jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#trim(String)
     * @ractes.javadocgen
     */
    @GeneratedByRactes
    public final void testTrimString004() throws Exception {
        // eXgΏۃCX^X̐
        if (null == this.testObject) {
            MockHttpServletRequest param1A = new MockHttpServletRequest();
            // l
            String param2A = "^[@\\s]*|[@\\s]*$";
            this.testObject = new ParameterTrimmedHttpServletRequest(param1A,
                    param2A);
        }

        // ͒l̏
        // valuȅ
        // 󕶎
        String valueA = "";

        // eXg\bh̎s
        String actual = this.testObject.trim(valueA);

        // Ҍʂ̊mF
        // ߂l̊mF
        // 󕶎
        assertEquals("", actual);
    }

    /**
     * {@link jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#trim(String)}
     *  eXg:
     * <ul>
     * <li>gp^[ُȒl̏ꍇAG[sB</li>
     * </ul>
     * mFeXg\bhB
     * <p>
     * <dl>
     * <dt><b>i`FbN</b></dt>
     * <dd>@\ &gt; U镑 &gt; f[^t[̊Siԗj</dd>
     * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
     * <dd>p[^lg܂B</dd>
     * </dl>
     * </p>
     * 
     * @throws java.lang.Exception
     * @see jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#trim(String)
     * @ractes.javadocgen
     */
    @GeneratedByRactes
    public final void testTrimString005() throws Exception {
        // eXgΏۃCX^X̐
        if (null == this.testObject) {
            MockHttpServletRequest param1A = new MockHttpServletRequest();
            // ُl
            String param2A = "\\";
            this.testObject = new ParameterTrimmedHttpServletRequest(param1A,
                    param2A);
        }

        // ͒l̏
        // valuȅ
        // l(g)
        String valueA = "  test  ";

        // eXg\bh̎s
        try {
            this.testObject.trim(valueA);
            fail();
        } catch (PatternSyntaxException ex) {
            ex.printStackTrace();
        }
    }

    /**
     * {@link jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#trim(String)}
     *  eXg:
     * <ul>
     * <li>gp^[null̏ꍇAG[s</li>
     * </ul>
     * mFeXg\bhB
     * <p>
     * <dl>
     * <dt><b>i`FbN</b></dt>
     * <dd>@\ &gt; U镑 &gt; ȕɂU镑̐</dd>
     * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
     * <dd>p[^lg܂B</dd>
     * </dl>
     * </p>
     * 
     * @throws java.lang.Exception
     * @see jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#trim(String)
     * @ractes.javadocgen
     */
    @GeneratedByRactes
    public final void testTrimString006() throws Exception {
        // eXgΏۃCX^X̐
        if (null == this.testObject) {
            MockHttpServletRequest param1A = new MockHttpServletRequest();
            // null
            String param2A = null;
            this.testObject = new ParameterTrimmedHttpServletRequest(param1A,
                    param2A);
        }

        // ͒l̏
        // valuȅ
        // l(g)
        String valueA = "  test  ";

        // eXg\bh̎s
        try {
            this.testObject.trim(valueA);
            fail();
        } catch (NullPointerException ex) {
            ex.printStackTrace();
        }
    }

    /**
     * {@link jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#trim(String)}
     *  eXg:
     * <ul>
     * <li>gp^[󕶎̏ꍇAg͍sꂸɕԋpB</li>
     * </ul>
     * mFeXg\bhB
     * <p>
     * <dl>
     * <dt><b>i`FbN</b></dt>
     * <dd>@\ &gt; U镑 &gt; ȕɂU镑̐</dd>
     * <dt><b>eXgΏۃ\bh̊Tv</b></dt>
     * <dd>p[^lg܂B</dd>
     * </dl>
     * </p>
     * 
     * @throws java.lang.Exception
     * @see jp.terasoluna.fw.ex.web.thin.ParameterTrimmedHttpServletRequest#trim(String)
     * @ractes.javadocgen
     */
    @GeneratedByRactes
    public final void testTrimString007() throws Exception {
        // eXgΏۃCX^X̐
        if (null == this.testObject) {
            MockHttpServletRequest param1A = new MockHttpServletRequest();
            // 󕶎
            String param2A = "";
            this.testObject = new ParameterTrimmedHttpServletRequest(param1A,
                    param2A);
        }

        // ͒l̏
        // valuȅ
        // l(g)
        String valueA = "  test  ";

        // eXg\bh̎s
        String actual = this.testObject.trim(valueA);

        // Ҍʂ̊mF
        // ߂l̊mF
        // ُl(gȂ)
        assertEquals("  test  ", actual);
    }

}
