/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.connector.cci;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.connector.cci.MockRecord;
import com.mockrunner.util.common.ArrayUtil;
import com.mockrunner.util.common.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.resource.cci.Streamable;

public class MockStreamableByteArrayRecord
extends MockRecord
implements Streamable {
    private byte[] content = null;

    public MockStreamableByteArrayRecord() {
        this(MockStreamableByteArrayRecord.class.getName());
    }

    public MockStreamableByteArrayRecord(String string) {
        this(string, string);
    }

    public MockStreamableByteArrayRecord(String string, String string2) {
        super(string, string2);
    }

    public byte[] getContent() {
        if (null == this.content) {
            return null;
        }
        return (byte[])this.content.clone();
    }

    public void setContent(byte[] byArray) {
        this.content = (byte[])(null == byArray ? null : (byte[])byArray.clone());
    }

    public void read(InputStream inputStream) throws IOException {
        this.content = (byte[])(null == inputStream ? null : StreamUtil.getStreamAsByteArray(inputStream));
    }

    public void write(OutputStream outputStream) throws IOException {
        if (null != outputStream && null != this.content) {
            outputStream.write(this.content);
            outputStream.flush();
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        MockStreamableByteArrayRecord mockStreamableByteArrayRecord = (MockStreamableByteArrayRecord)object;
        return ArrayUtil.areArraysEqual(this.content, mockStreamableByteArrayRecord.content);
    }

    public int hashCode() {
        return super.hashCode() * 31 + ArrayUtil.computeHashCode(this.content);
    }

    public Object clone() {
        try {
            MockStreamableByteArrayRecord mockStreamableByteArrayRecord = (MockStreamableByteArrayRecord)super.clone();
            mockStreamableByteArrayRecord.setContent(this.content);
            return mockStreamableByteArrayRecord;
        }
        catch (Exception exception) {
            throw new NestedApplicationException(exception);
        }
    }
}

