/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile;

import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sqlj.runtime.profile.Loader;

public class DefaultLoader
implements Loader {
    private WeakReference m_loader;

    public DefaultLoader(ClassLoader classLoader) {
        this.m_loader = new WeakReference<ClassLoader>(classLoader);
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        if (this.getClassLoader() == null) {
            return Class.forName(string);
        }
        return this.getClassLoader().loadClass(string);
    }

    public InputStream getResourceAsStream(String string) {
        return (InputStream)AccessController.doPrivileged(new SqljPrivilegedAction(this.getClassLoader(), string));
    }

    private ClassLoader getClassLoader() {
        return (ClassLoader)this.m_loader.get();
    }

    class SqljPrivilegedAction
    implements PrivilegedAction {
        private ClassLoader m_load;
        private String m_name;

        SqljPrivilegedAction(ClassLoader classLoader, String string) {
            this.m_load = classLoader;
            this.m_name = string;
        }

        public Object run() {
            try {
                if (this.m_load == null) {
                    return ClassLoader.getSystemResourceAsStream(this.m_name);
                }
                return this.m_load.getResourceAsStream(this.m_name);
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
    }
}

