/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.taglib;

import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import jp.terasoluna.fw.util.StringUtil;
import jp.terasoluna.fw.web.taglib.TagUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputCalendarTag
extends TagSupport {
    private static final long serialVersionUID = -3163804374592471898L;
    private String forId = null;
    private String format = "yyyy/MM/dd";
    private String formatKey = null;
    protected static final String CALENDAR_IMG_DIR = "calendar.img.dir";
    protected static final String CALENDAR_TODAY_STRING = "calendar.today.string";
    protected static final String CALENDAR_BUTTON_VALUE = "calendar.button.value";
    protected static final String CALENDAR_STYLE_THEMEPREFIX = "calendar.style.themeprefix";
    protected static final String CALENDAR_STYLESHEET_DIR = "calendar.stylesheet.dir";
    protected static final String CALENDAR_JAVASCRIPT_DIR = "calendar.javascript.dir";
    protected static final String CALENDAR_HOLIDAY_PREFIX = "calendar.holiday";
    protected static final String CALENDAR_DEFAULT_FORMAT = "yyyy/MM/dd";
    protected static final String CALENDAR_DEFAULT_STYLEPREFIX_NAME = "BlueStyle";
    protected static final String CALENDAR_DEFAULT_IMAGE_PATH = "img/calendar/";
    protected static final String CALENDAR_DEFAULT_BUTTON_VALUE = "Calendar";
    protected static final String CALENDAR_DEFAULT_STYLESHEET_DIR = "css/";
    protected static final String CALENDAR_DEFAULT_JAVASCRIPT_DIR = "js/";
    protected static final String CALENDAR_JAVASCRIPT_FILE_NAME = "InputCalendar.js";
    protected static final String CALENDAR_STYLESHEET_FILE_NAME = "InputCalendar.css";
    protected static final String INPUTCALENDAR_FLG = "InputCalendarFlg";
    protected static final String FORMAT_VALUE = "yMd ./-";

    public String getFor() {
        return this.forId;
    }

    public void setFor(String forId) {
        this.forId = forId;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormatKey() {
        return this.formatKey;
    }

    public void setFormatKey(String formatKey) {
        this.formatKey = formatKey;
    }

    public int doStartTag() throws JspException {
        ResourceBundle calendarBundle = null;
        Locale locale = this.pageContext.getRequest().getLocale();
        try {
            calendarBundle = ResourceBundle.getBundle("calendar", locale);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (!this.getPageContextFlg(this.pageContext, INPUTCALENDAR_FLG)) {
            this.defineJavaScript(calendarBundle);
            this.setPageContextFlg(this.pageContext, INPUTCALENDAR_FLG);
        }
        this.defineButton(calendarBundle);
        return 0;
    }

    protected void defineJavaScript(ResourceBundle calendarBundle) throws JspException {
        Locale currentLocale = this.pageContext.getRequest().getLocale();
        boolean jpFlg = false;
        if (Locale.JAPAN.getLanguage().equals(currentLocale.getLanguage())) {
            jpFlg = true;
        }
        DateFormatSymbols symbols = new DateFormatSymbols(currentLocale);
        String[] weekdays = this.mapWeekdays(symbols);
        String[] months = this.mapMonths(symbols);
        String todayString = this.getParameter(calendarBundle, CALENDAR_TODAY_STRING, "");
        String styleThemePrefix = this.getParameter(calendarBundle, CALENDAR_STYLE_THEMEPREFIX, CALENDAR_DEFAULT_STYLEPREFIX_NAME);
        String imageDir = this.getParameter(calendarBundle, CALENDAR_IMG_DIR, CALENDAR_DEFAULT_IMAGE_PATH);
        imageDir = imageDir + styleThemePrefix + "/";
        String styleFileName = styleThemePrefix + CALENDAR_STYLESHEET_FILE_NAME;
        String styleSheetDir = this.getParameter(calendarBundle, CALENDAR_STYLESHEET_DIR, CALENDAR_DEFAULT_STYLESHEET_DIR);
        String javaScriptFileName = CALENDAR_JAVASCRIPT_FILE_NAME;
        String javaScriptDir = this.getParameter(calendarBundle, CALENDAR_JAVASCRIPT_DIR, CALENDAR_DEFAULT_JAVASCRIPT_DIR);
        TagUtil.writeln(this.pageContext, "<script type=\"text/javascript\">");
        TagUtil.writeln(this.pageContext, "<!--");
        TagUtil.writeln(this.pageContext, this.defineObjectVariable("localja", String.valueOf(jpFlg)));
        TagUtil.writeln(this.pageContext, this.defineArrayVariable("jscalendarMonthName", months));
        TagUtil.writeln(this.pageContext, this.defineArrayVariable("jscalendarDayName", weekdays));
        TagUtil.writeln(this.pageContext, this.defineStringVariable("jscalendarTodayString", todayString));
        TagUtil.writeln(this.pageContext, this.defineStringVariable("jscalendarThemePrefix", styleThemePrefix));
        TagUtil.writeln(this.pageContext, this.defineStringVariable("jscalendarImgDir", imageDir));
        TagUtil.writeln(this.pageContext, "-->");
        TagUtil.writeln(this.pageContext, "</script>");
        TagUtil.write(this.pageContext, "<script type=\"text/javascript\" src=\"");
        TagUtil.write(this.pageContext, javaScriptDir);
        TagUtil.write(this.pageContext, javaScriptFileName);
        TagUtil.writeln(this.pageContext, "\" ></script>");
        TagUtil.writeln(this.pageContext, "<link rel=\"stylesheet\" href=\"" + styleSheetDir + styleFileName + "\"  type=\"text/css\"/>");
        TagUtil.writeln(this.pageContext, "<script type=\"text/javascript\">");
        TagUtil.writeln(this.pageContext, "<!--");
        List<Map<String, String>> holidays = this.getHolidayList(calendarBundle);
        for (int i = 0; i < holidays.size(); ++i) {
            Map<String, String> map = holidays.get(i);
            TagUtil.write(this.pageContext, "jscalendarAddHoliday('");
            TagUtil.write(this.pageContext, map.get("year"));
            TagUtil.write(this.pageContext, "', '");
            TagUtil.write(this.pageContext, map.get("month"));
            TagUtil.write(this.pageContext, "', '");
            TagUtil.write(this.pageContext, map.get("day"));
            TagUtil.write(this.pageContext, "', '");
            TagUtil.write(this.pageContext, map.get("desc"));
            TagUtil.writeln(this.pageContext, "');");
        }
        TagUtil.writeln(this.pageContext, "");
        TagUtil.writeln(this.pageContext, "jscalendarInit();");
        TagUtil.writeln(this.pageContext, "-->");
        TagUtil.writeln(this.pageContext, "</script>");
    }

    protected List<Map<String, String>> getHolidayList(ResourceBundle calendarBundle) {
        ArrayList<Map<String, String>> holidays = new ArrayList<Map<String, String>>();
        if (calendarBundle == null) {
            return holidays;
        }
        int i = 1;
        while (true) {
            HashMap<String, String> map = new HashMap<String, String>();
            String key = "calendar.holiday." + i;
            String param = null;
            try {
                param = calendarBundle.getString(key);
            }
            catch (MissingResourceException e) {
                break;
            }
            String[] paramSprit = param.split(",");
            if (paramSprit.length == 4) {
                map.put("year", StringUtil.trim((String)paramSprit[0]));
                map.put("month", StringUtil.trim((String)paramSprit[1]));
                map.put("day", StringUtil.trim((String)paramSprit[2]));
                map.put("desc", StringUtil.trim((String)paramSprit[3]));
                holidays.add(map);
            }
            ++i;
        }
        return holidays;
    }

    protected void defineButton(ResourceBundle calendarBundle) throws JspException {
        String dateFormat = null;
        dateFormat = this.formatKey != null ? this.createFormat(this.getParameter(calendarBundle, this.formatKey, CALENDAR_DEFAULT_FORMAT)) : this.createFormat(this.format);
        String buttonValue = this.getParameter(calendarBundle, CALENDAR_BUTTON_VALUE, CALENDAR_DEFAULT_BUTTON_VALUE);
        TagUtil.writeln(this.pageContext, "<input type=\"button\" onclick=\"jscalendarPopUpCalendar(this,this.form.elements['" + this.forId + "'],'" + dateFormat + "');\" value=\"" + buttonValue + "\" />");
    }

    protected String getParameter(ResourceBundle calendarBundle, String key, String def) {
        if (calendarBundle == null || key == null || "".equals(key)) {
            return def;
        }
        String retValue = null;
        try {
            retValue = calendarBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return def;
        }
        return retValue;
    }

    protected String defineStringVariable(String name, String value) {
        StringBuilder retValue = new StringBuilder("var ");
        retValue.append(name);
        retValue.append(" = \"");
        retValue.append(value);
        retValue.append("\";");
        return retValue.toString();
    }

    protected String defineObjectVariable(String name, String value) {
        StringBuilder retValue = new StringBuilder("var ");
        retValue.append(name);
        retValue.append(" = ");
        retValue.append(value);
        retValue.append(";");
        return retValue.toString();
    }

    protected String defineArrayVariable(String arrayName, String[] array) {
        StringBuilder retValue = new StringBuilder("var ");
        retValue.append(arrayName);
        retValue.append(" = new Array(");
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                retValue.append(",");
            }
            retValue.append("\"");
            retValue.append(array[i]);
            retValue.append("\"");
        }
        retValue.append(");");
        return retValue.toString();
    }

    protected String[] mapWeekdays(DateFormatSymbols symbols) {
        String[] weekdays = new String[7];
        String[] localeWeekdays = symbols.getShortWeekdays();
        weekdays[0] = localeWeekdays[1];
        weekdays[1] = localeWeekdays[2];
        weekdays[2] = localeWeekdays[3];
        weekdays[3] = localeWeekdays[4];
        weekdays[4] = localeWeekdays[5];
        weekdays[5] = localeWeekdays[6];
        weekdays[6] = localeWeekdays[7];
        return weekdays;
    }

    protected String[] mapMonths(DateFormatSymbols symbols) {
        String[] months = new String[12];
        String[] localeMonths = symbols.getMonths();
        months[0] = localeMonths[0];
        months[1] = localeMonths[1];
        months[2] = localeMonths[2];
        months[3] = localeMonths[3];
        months[4] = localeMonths[4];
        months[5] = localeMonths[5];
        months[6] = localeMonths[6];
        months[7] = localeMonths[7];
        months[8] = localeMonths[8];
        months[9] = localeMonths[9];
        months[10] = localeMonths[10];
        months[11] = localeMonths[11];
        return months;
    }

    protected boolean getPageContextFlg(PageContext pageContext, String key) {
        Object obj = pageContext.getAttribute(key);
        Boolean bol = false;
        if (obj != null && obj instanceof Boolean) {
            bol = (Boolean)obj;
        }
        return bol;
    }

    protected void setPageContextFlg(PageContext pageContext, String key) {
        pageContext.setAttribute(key, (Object)true);
    }

    protected String createFormat(String format) {
        if (format == null || "".equals(format)) {
            return CALENDAR_DEFAULT_FORMAT;
        }
        StringBuilder retValue = new StringBuilder("");
        for (int i = 0; i < format.length(); ++i) {
            char c = format.charAt(i);
            if (FORMAT_VALUE.indexOf(String.valueOf(c)) == -1) continue;
            retValue.append(c);
        }
        return StringUtil.trim((String)retValue.toString());
    }

    public void release() {
        super.release();
        this.forId = null;
        this.format = CALENDAR_DEFAULT_FORMAT;
        this.formatKey = null;
    }
}

