/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import oracle.net.TNSAddress.SOException;
import oracle.net.jndi.JndiAttrs;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.resolver.NameResolver;
import oracle.net.resolver.NameResolverFactory;
import oracle.net.resolver.NavDescriptionList;
import oracle.net.resolver.NavSchemaObjectFactory;
import oracle.net.resolver.NavServiceAlias;

public class AddrResolution {
    private ConnStrategy cs;
    private Properties up;
    private static final String default_proxy_rules = "__jdbc__";
    private static final String service_alias_name = "ora-net-service-alias";
    private static final String service_attr_name = "orclnetdescstring";
    private static final int length_of_alias_prefix = 6;
    public static final int DEFAULT_DATABASE_PORT = 1521;
    public static final String DEFAULT_CONNECT_PROTOCOL = "TCP";
    private boolean newSyntax = true;
    public boolean connection_revised = false;
    public boolean connection_redirected = false;
    private String TNSAddress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddrResolution(String string, Properties properties) throws NetException {
        this.up = properties;
        this.TNSAddress = string;
        if (this.up.containsKey("java.naming.provider.url") || string.startsWith("ldap:") || string.startsWith("ldaps:")) {
            boolean bl = false;
            if (string.startsWith("ldap:") || string.startsWith("ldaps:")) {
                if (string.indexOf(32) > 0) {
                    bl = true;
                } else {
                    int n2 = string.lastIndexOf(47);
                    if (n2 == -1) {
                        throw new NetException(124);
                    }
                    this.up.put("java.naming.provider.url", string.substring(0, n2));
                    this.TNSAddress = string.substring(n2 + 1, string.length());
                }
            }
            if (!bl) {
                String[] stringArray = new String[1];
                JndiAttrs jndiAttrs = new JndiAttrs(this.up);
                stringArray[0] = service_attr_name;
                Vector vector = null;
                try {
                    vector = jndiAttrs.getAttrs(this.TNSAddress, stringArray);
                }
                finally {
                    jndiAttrs.close();
                }
                this.TNSAddress = (String)vector.firstElement();
                this.connection_revised = true;
            } else {
                this.processLdapFailoverLoadblance(string);
            }
        }
        if (this.up.getProperty("oracle.net.oldSyntax") == "YES") {
            this.newSyntax = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLdapFailoverLoadblance(String string) throws NetException {
        Object object;
        String string2;
        String string3;
        int n2 = 0;
        Vector vector = new Vector(10);
        char[] cArray = string.toCharArray();
        int n3 = cArray.length;
        while (n2 < n3) {
            int n4;
            for (n4 = n2 + 1; n4 < n3 && cArray[n4] != ' '; ++n4) {
            }
            string3 = new String(cArray, n2, n4 - n2);
            if (!string3.startsWith("ldap")) {
                throw new NetException(124);
            }
            vector.addElement(string3);
            for (n2 = n4 + 1; n2 < n3 && cArray[n2] == ' '; ++n2) {
            }
        }
        if (vector.size() <= 0) {
            throw new NetException(124);
        }
        boolean bl = true;
        boolean bl2 = true;
        String string4 = this.up.getProperty("oracle.net.ldap_failover");
        if (string4 != null && (string4.equalsIgnoreCase("OFF") || string4.equalsIgnoreCase("FALSE") || string4.equalsIgnoreCase("NO"))) {
            bl = false;
        }
        if ((string4 = this.up.getProperty("oracle.net.ldap_loadbalance")) != null && (string4.equalsIgnoreCase("OFF") || string4.equalsIgnoreCase("FALSE") || string4.equalsIgnoreCase("NO"))) {
            bl2 = false;
        }
        if (vector.size() > 1) {
            vector = NavDescriptionList.setActiveChildren(vector, bl, bl2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = vector.size();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(n5);
        for (int i2 = 0; i2 < n5; ++i2) {
            string3 = (String)vector.elementAt(i2);
            int n6 = string3.lastIndexOf(47);
            if (n6 == -1) {
                throw new NetException(124);
            }
            string2 = string3.substring(0, n6);
            object = string3.substring(n6 + 1, string3.length());
            stringBuffer.append(string2);
            if (i2 < n5 - 1) {
                stringBuffer.append(' ');
            }
            hashtable.put(string2, (String)object);
        }
        String string5 = new String(stringBuffer);
        this.up.put("java.naming.provider.url", string5);
        JndiAttrs jndiAttrs = new JndiAttrs(this.up);
        string2 = jndiAttrs.getLdapUrlUsed();
        this.TNSAddress = (String)hashtable.get(string2);
        object = null;
        String[] stringArray = new String[]{service_attr_name};
        try {
            object = jndiAttrs.getAttrs(this.TNSAddress, stringArray);
        }
        finally {
            jndiAttrs.close();
        }
        this.TNSAddress = (String)((Vector)object).firstElement();
        this.connection_revised = true;
    }

    public String getTNSAddress() {
        return this.TNSAddress.toUpperCase();
    }

    public ConnOption resolveAndExecute(String string) throws NetException, IOException {
        ConnStrategy connStrategy = this.cs;
        if (string != null) {
            this.cs = new ConnStrategy(this.up);
            if (this.connection_redirected) {
                this.cs.sdu = connStrategy.sdu;
                this.cs.tdu = connStrategy.tdu;
                this.cs.socketOptions = connStrategy.socketOptions;
                this.cs.reuseOpt = true;
                this.connection_redirected = false;
            }
            if (string.indexOf(41) == -1) {
                int n2 = 0;
                if (string.startsWith("//")) {
                    n2 = 2;
                }
                if (string.charAt(n2) == '[') {
                    n2 = string.indexOf(93, n2 + 1);
                }
                if ((n2 = string.indexOf(58, n2)) != -1 && string.indexOf(58, n2 + 1) != -1) {
                    this.resolveSimple(string);
                } else {
                    String string2 = System.getProperty("oracle.net.tns_admin");
                    NameResolver nameResolver = NameResolverFactory.getNameResolver(string2, this.cs.getOSUsername());
                    this.resolveAddrTree(nameResolver.resolveName(string));
                }
            } else if (this.newSyntax) {
                this.resolveAddrTree(string);
            } else {
                this.resolveAddr(string);
            }
        } else if (this.cs == null || !this.cs.hasMoreOptions()) {
            return null;
        }
        return this.cs.execute();
    }

    private void resolveSimple(String string) throws NetException {
        ConnOption connOption = new ConnOption();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        if (string.startsWith("[")) {
            n5 = string.indexOf(93);
            if (n5 == -1) {
                throw new NetException(115);
            }
            bl = true;
        }
        if ((n2 = string.indexOf(58, n5)) == -1 || (n3 = string.indexOf(58, n2 + 1)) == -1) {
            throw new NetException(115);
        }
        n4 = string.indexOf(58, n3 + 1);
        if (n4 != -1) {
            throw new NetException(115);
        }
        try {
            connOption.host = bl ? string.substring(1, n2 - 1) : string.substring(0, n2);
            connOption.port = Integer.parseInt(string.substring(n2 + 1, n3));
            connOption.addr = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + connOption.host + ")(PORT=" + connOption.port + "))";
            connOption.sid = string.substring(n3 + 1, string.length());
            String string2 = "(DESCRIPTION=(CONNECT_DATA=(SID=" + connOption.sid + ")(CID=(PROGRAM=)(HOST=__jdbc__)(USER=" + this.cs.getOSUsername() + ")))" + "(ADDRESS=" + "(PROTOCOL=tcp)(HOST=" + connOption.host + ")(PORT=" + connOption.port + ")))";
            connOption.protocol = DEFAULT_CONNECT_PROTOCOL;
            connOption.conn_data = new StringBuffer(string2);
            this.cs.addOption(connOption);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NetException(116);
        }
    }

    private void resolveAddr(String string) throws NetException {
        Object object;
        if (string.startsWith("alias=")) {
            object = string;
            string = ((String)object).substring(((String)object).indexOf("alias=") + 6, ((String)object).length());
        }
        object = new ConnOption();
        NVFactory nVFactory = new NVFactory();
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair = null;
        NVPair nVPair2 = null;
        try {
            nVPair = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "CID");
            nVPair2 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "address");
        }
        catch (NLException nLException) {
            System.err.println(nLException.getMessage());
        }
        NVPair nVPair3 = nVNavigator.findNVPair(nVPair2, "protocol");
        if (nVPair3 == null) {
            throw new NetException(100);
        }
        ((ConnOption)object).protocol = nVPair3.getAtom();
        if (!(((ConnOption)object).protocol.equals(DEFAULT_CONNECT_PROTOCOL) || ((ConnOption)object).protocol.equals("tcp") || ((ConnOption)object).protocol.equals("SSL") || ((ConnOption)object).protocol.equals("ssl") || ((ConnOption)object).protocol.equals("ANO") || ((ConnOption)object).protocol.equals("ano"))) {
            throw new NetException(102);
        }
        nVPair3 = nVNavigator.findNVPair(nVPair2, "Host");
        if (nVPair3 == null) {
            throw new NetException(103);
        }
        ((ConnOption)object).host = nVPair3.getAtom();
        nVPair3 = nVNavigator.findNVPair(nVPair2, "Port");
        if (nVPair3 == null) {
            throw new NetException(104);
        }
        ((ConnOption)object).port = Integer.parseInt(nVPair3.getAtom());
        nVPair3 = nVNavigator.findNVPair(nVPair2, "sduSize");
        if (nVPair3 != null) {
            ((ConnOption)object).sdu = Integer.parseInt(nVPair3.getAtom());
        }
        if ((nVPair3 = nVNavigator.findNVPair(nVPair2, "tduSize")) != null) {
            ((ConnOption)object).tdu = Integer.parseInt(nVPair3.getAtom());
        }
        NVPair nVPair4 = null;
        try {
            nVPair4 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "connect_data");
        }
        catch (NLException nLException) {
            System.err.println(nLException.getMessage());
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        ((ConnOption)object).conn_data = nVPair4 != null ? this.insertCID(string) : stringBuffer;
        ((ConnOption)object).addr = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + ((ConnOption)object).host + ")(PORT=" + ((ConnOption)object).port + "))";
        this.cs.addOption((ConnOption)object);
    }

    private void resolveAddrTree(String string) throws NetException {
        NavSchemaObjectFactory navSchemaObjectFactory = new NavSchemaObjectFactory();
        NavServiceAlias navServiceAlias = (NavServiceAlias)navSchemaObjectFactory.create(4);
        try {
            String string2 = string.startsWith("alias=") ? string : "alias=" + string;
            navServiceAlias.initFromString(string2);
        }
        catch (NLException nLException) {
            throw new NetException(501);
        }
        catch (SOException sOException) {
            throw new NetException(502, sOException.getMessage());
        }
        navServiceAlias.navigate(this.cs, null);
    }

    private StringBuffer insertCID(String string) throws NetException {
        NVFactory nVFactory = new NVFactory();
        NVNavigator nVNavigator = new NVNavigator();
        StringBuffer stringBuffer = new StringBuffer(2048);
        NVPair nVPair = null;
        NVPair nVPair2 = null;
        NVPair nVPair3 = null;
        NVPair nVPair4 = null;
        NVPair nVPair5 = null;
        try {
            nVPair = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "description");
            nVPair2 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "address_list");
            nVPair3 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "address");
            nVPair4 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "connect_data");
            nVPair5 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "source_route");
        }
        catch (NLException nLException) {
            System.err.println(nLException.getMessage());
        }
        NVPair nVPair6 = null;
        NVPair nVPair7 = null;
        NVPair nVPair8 = null;
        if (nVPair4 == null) {
            throw new NetException(105);
        }
        nVPair6 = nVNavigator.findNVPair(nVPair4, "SID");
        nVPair7 = nVNavigator.findNVPair(nVPair4, "CID");
        nVPair8 = nVNavigator.findNVPair(nVPair4, "SERVICE_NAME");
        if (nVPair6 == null && nVPair8 == null) {
            throw new NetException(106);
        }
        stringBuffer.append("(DESCRIPTION=");
        if (nVPair2 != null && nVPair2.getListSize() > 0) {
            for (int i2 = 0; i2 < nVPair2.getListSize(); ++i2) {
                NVPair nVPair9 = nVPair2.getListElement(i2);
                stringBuffer.append(nVPair9.toString());
            }
        } else if (nVPair3 != null) {
            stringBuffer.append(nVPair3.toString());
        } else {
            throw new NetException(107);
        }
        if (nVPair8 != null) {
            stringBuffer.append("(CONNECT_DATA=" + nVPair8.toString() + "(CID=(PROGRAM=)(HOST=__jdbc__)(USER=" + this.cs.getOSUsername() + ")))");
        } else {
            stringBuffer.append("(CONNECT_DATA=" + nVPair6.toString() + "(CID=(PROGRAM=)(HOST=__jdbc__)(USER=" + this.cs.getOSUsername() + ")))");
        }
        if (nVPair5 != null) {
            stringBuffer.append(nVPair5.toString());
        }
        stringBuffer.append(")");
        return stringBuffer;
    }

    public Properties getUp() {
        return this.up;
    }
}

