/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.sql.CLOB;
import oracle.sql.Datum;

public class OracleTypeCLOB
extends OracleType
implements Serializable {
    static final long serialVersionUID = 1122821330765834411L;
    static int fixedDataSize = 86;
    transient OracleConnection connection;
    int form;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Oct_30_03:26:03_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    protected OracleTypeCLOB() {
    }

    public OracleTypeCLOB(OracleConnection oracleConnection) {
        this.connection = oracleConnection;
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        CLOB cLOB = null;
        if (object != null) {
            if (object instanceof CLOB) {
                cLOB = (CLOB)object;
            } else {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59, object);
            }
        }
        return cLOB;
    }

    public int getTypeCode() {
        return 2005;
    }

    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        if (n2 == 1 || n2 == 2) {
            return this.connection.createClob(byArray);
        }
        if (n2 == 3) {
            return byArray;
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59, byArray);
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.connection = oracleConnection;
    }

    public boolean isNCHAR() throws SQLException {
        return this.form == 2;
    }

    public void setForm(int n2) {
        this.form = n2;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }
}

