/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.sql.Statement;
import java.util.Map;
import java.util.Vector;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.ArrayDescriptor;
import oracle.sql.AttributeDescriptor;
import oracle.sql.Datum;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.OracleJdbc2SQLInput;
import oracle.sql.OracleSQLOutput;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.TypeDescriptor;

public class StructDescriptor
extends TypeDescriptor
implements Serializable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1013921343538311063L;
    final int LOCAL_TYPE = 0;
    final int LOOK_FOR_USER_SYNONYM = 1;
    final int LOOK_FOR_PUBLIC_SYNONYM = 2;
    final String[] initMetaData1_9_0_SQL = new String[]{"SELECT INSTANTIABLE, supertype_owner, supertype_name, LOCAL_ATTRIBUTES FROM all_types WHERE type_name = :1 AND owner = :2 ", "DECLARE \n bind_synonym_name user_synonyms.synonym_name%type := :1; \n the_table_owner  user_synonyms.table_owner%type; \n the_table_name   user_synonyms.table_name%type; \n the_db_link      user_synonyms.db_link%type; \n sql_string       VARCHAR2(1000); \nBEGIN \n   SELECT  TABLE_NAME, TABLE_OWNER, DB_LINK INTO  \n         the_table_name, the_table_owner, the_db_link \n         FROM USER_SYNONYMS WHERE \n         SYNONYM_NAME = bind_synonym_name; \n \n   sql_string := 'SELECT  INSTANTIABLE, SUPERTYPE_OWNER,      SUPERTYPE_NAME, LOCAL_ATTRIBUTES FROM ALL_TYPES'; \n \n   IF the_db_link IS NOT NULL  \n   THEN \n     sql_string := sql_string || '@' || the_db_link; \n   END IF; \n   sql_string := sql_string       || ' WHERE TYPE_NAME = '''       || the_table_name   || ''' AND OWNER = '''       || the_table_owner  || ''''; \n   OPEN :2 FOR sql_string; \nEND;", "DECLARE \n bind_synonym_name user_synonyms.synonym_name%type := :1; \n the_table_owner  user_synonyms.table_owner%type; \n the_table_name   user_synonyms.table_name%type; \n the_db_link      user_synonyms.db_link%type; \n sql_string       VARCHAR2(1000); \nBEGIN \n   SELECT  TABLE_NAME, TABLE_OWNER, DB_LINK INTO  \n         the_table_name, the_table_owner, the_db_link \n         FROM ALL_SYNONYMS WHERE \n         OWNER = 'PUBLIC' AND \n         SYNONYM_NAME = bind_synonym_name; \n \n   sql_string := 'SELECT  INSTANTIABLE, SUPERTYPE_OWNER,      SUPERTYPE_NAME, LOCAL_ATTRIBUTES FROM ALL_TYPES'; \n \n   IF the_db_link IS NOT NULL  \n   THEN \n     sql_string := sql_string || '@' || the_db_link; \n   END IF; \n   sql_string := sql_string       || ' WHERE TYPE_NAME = '''       || the_table_name   || ''' AND OWNER = '''       || the_table_owner  || ''''; \n   OPEN :2 FOR sql_string; \nEND;"};
    String sqlHint = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Oct_30_03:32:07_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public static StructDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        return StructDescriptor.createDescriptor(string, connection, false, false);
    }

    public static StructDescriptor createDescriptor(String string, Connection connection, boolean bl, boolean bl2) throws SQLException {
        if (string == null || string.length() == 0 || connection == null) {
            DatabaseError.throwSqlException(null, 60, "Invalid arguments");
        }
        SQLName sQLName = new SQLName(string, (oracle.jdbc.OracleConnection)connection);
        StructDescriptor structDescriptor = StructDescriptor.createDescriptor(sQLName, connection, bl, bl2);
        return structDescriptor;
    }

    public static StructDescriptor createDescriptor(SQLName sQLName, Connection connection, boolean bl, boolean bl2) throws SQLException {
        String string = sQLName.getName();
        StructDescriptor structDescriptor = null;
        if (!bl2 && (structDescriptor = (StructDescriptor)((oracle.jdbc.OracleConnection)connection).getDescriptor(string)) == null) {
            structDescriptor = new StructDescriptor(sQLName, connection);
            if (bl) {
                structDescriptor.initNamesRecursively();
            }
            ((oracle.jdbc.OracleConnection)connection).putDescriptor(string, structDescriptor);
        }
        return structDescriptor;
    }

    public static StructDescriptor createDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        return StructDescriptor.createDescriptor(sQLName, connection, false, false);
    }

    public static StructDescriptor createDescriptor(OracleTypeADT oracleTypeADT) throws SQLException {
        String string = oracleTypeADT.getFullName();
        OracleConnection oracleConnection = oracleTypeADT.getConnection();
        StructDescriptor structDescriptor = (StructDescriptor)oracleConnection.getDescriptor(string);
        if (structDescriptor == null) {
            SQLName sQLName = new SQLName(oracleTypeADT.getSchemaName(), oracleTypeADT.getSimpleName(), oracleTypeADT.getConnection());
            structDescriptor = new StructDescriptor(sQLName, oracleTypeADT, (Connection)oracleConnection);
            oracleConnection.putDescriptor(string, (Object)structDescriptor);
        }
        return structDescriptor;
    }

    public static StructDescriptor createDescriptor(SQLName sQLName, byte[] byArray, int n2, byte[] byArray2, OracleConnection oracleConnection) throws SQLException {
        OracleTypeADT oracleTypeADT = new OracleTypeADT(sQLName, byArray, n2, byArray2, oracleConnection);
        return new StructDescriptor(sQLName, oracleTypeADT, (Connection)oracleConnection);
    }

    public StructDescriptor(OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        super((short)108, oracleTypeADT, connection);
    }

    public StructDescriptor(String string, Connection connection) throws SQLException {
        super((short)108, string, connection);
        this.initPickler();
    }

    public StructDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        super((short)108, sQLName, connection);
        this.initPickler();
    }

    public StructDescriptor(SQLName sQLName, OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        super((short)108, sQLName, oracleTypeADT, connection);
        this.toid = oracleTypeADT.getTOID();
    }

    StructDescriptor(byte[] byArray, int n2, Connection connection) throws SQLException {
        super((short)108);
        this.toid = byArray;
        this.toidVersion = n2;
        this.setPhysicalConnectionOf(connection);
        this.initPickler();
    }

    StructDescriptor(AttributeDescriptor[] attributeDescriptorArray, Connection connection) throws SQLException {
        super((short)108);
        this.attributesDescriptor = attributeDescriptorArray;
        this.setPhysicalConnectionOf(connection);
        this.isTransient = true;
        this.initPickler();
        this.isInstanciable = new Boolean(true);
    }

    private void initPickler() throws SQLException {
        try {
            if (this.isTransient) {
                this.pickler = new OracleTypeADT(this.attributesDescriptor, this.connection);
            } else {
                this.pickler = new OracleTypeADT(this.getName(), (Connection)this.connection);
                ((OracleTypeADT)this.pickler).init(this.connection);
                this.toid = ((OracleTypeADT)this.pickler).getTOID();
            }
            this.pickler.setDescriptor(this);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"" + this.getName() + "\"");
        }
    }

    @Override
    public int getTypeCode() throws SQLException {
        int n2 = this.getOracleTypeADT().getTypeCode();
        return n2;
    }

    public int getTypeVersion() throws SQLException {
        int n2 = this.getOracleTypeADT().getTypeVersion();
        return n2;
    }

    void setAttributesDescriptor(AttributeDescriptor[] attributeDescriptorArray) {
        this.attributesDescriptor = attributeDescriptorArray;
    }

    public AttributeDescriptor[] getAttributesDescriptor() {
        return this.attributesDescriptor;
    }

    byte[] toBytes(STRUCT sTRUCT, boolean bl) throws SQLException {
        byte[] byArray = sTRUCT.shareBytes();
        if (byArray == null) {
            if (sTRUCT.datumArray != null) {
                byArray = this.pickler.linearize(sTRUCT);
                if (!bl) {
                    sTRUCT.setShareBytes(null);
                }
            } else if (sTRUCT.objectArray != null) {
                sTRUCT.datumArray = this.toOracleArray(sTRUCT.objectArray);
                byArray = this.pickler.linearize(sTRUCT);
                if (!bl) {
                    sTRUCT.datumArray = null;
                    sTRUCT.setShareBytes(null);
                }
            } else {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1);
            }
        } else if (sTRUCT.imageLength != 0L && (sTRUCT.imageOffset != 0L || sTRUCT.imageLength != (long)byArray.length)) {
            byte[] byArray2 = new byte[(int)sTRUCT.imageLength];
            System.arraycopy(byArray, (int)sTRUCT.imageOffset, byArray2, 0, (int)sTRUCT.imageLength);
            sTRUCT.setImage(byArray2, 0L, 0L);
            byArray = byArray2;
        }
        return byArray;
    }

    Datum[] toOracleArray(STRUCT sTRUCT, boolean bl) throws SQLException {
        Datum[] datumArray = sTRUCT.datumArray;
        Datum[] datumArray2 = null;
        if (datumArray == null) {
            if (sTRUCT.objectArray != null) {
                datumArray = this.toOracleArray(sTRUCT.objectArray);
            } else if (sTRUCT.shareBytes() != null) {
                if ((sTRUCT.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.pickler).isEmbeddedADT()) {
                    this.pickler = OracleTypeADT.shallowClone((OracleTypeADT)this.pickler);
                }
                this.pickler.unlinearize(sTRUCT.shareBytes(), sTRUCT.imageOffset, sTRUCT, 1, null);
                datumArray = sTRUCT.datumArray;
                if (!bl) {
                    sTRUCT.datumArray = null;
                }
            } else {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1);
            }
        }
        if (bl) {
            sTRUCT.datumArray = datumArray;
            datumArray2 = (Datum[])datumArray.clone();
        } else {
            datumArray2 = datumArray;
        }
        return datumArray2;
    }

    Object[] toArray(STRUCT sTRUCT, Map map, boolean bl) throws SQLException {
        Object[] objectArray = null;
        if (sTRUCT.objectArray == null) {
            if (sTRUCT.datumArray != null) {
                objectArray = new Object[sTRUCT.datumArray.length];
                for (int i2 = 0; i2 < sTRUCT.datumArray.length; ++i2) {
                    if (sTRUCT.datumArray[i2] == null) continue;
                    objectArray[i2] = sTRUCT.datumArray[i2] instanceof STRUCT ? ((STRUCT)sTRUCT.datumArray[i2]).toJdbc(map) : sTRUCT.datumArray[i2].toJdbc();
                }
            } else if (sTRUCT.shareBytes() != null) {
                if ((sTRUCT.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.pickler).isEmbeddedADT()) {
                    this.pickler = OracleTypeADT.shallowClone((OracleTypeADT)this.pickler);
                }
                this.pickler.unlinearize(sTRUCT.shareBytes(), sTRUCT.imageOffset, sTRUCT, 2, map);
                objectArray = sTRUCT.objectArray;
                sTRUCT.objectArray = null;
            } else {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1);
            }
        } else {
            objectArray = (Object[])sTRUCT.objectArray.clone();
        }
        return objectArray;
    }

    public int getLength() throws SQLException {
        return this.getFieldTypes().length;
    }

    public OracleTypeADT getOracleTypeADT() throws SQLException {
        if (this.pickler == null) {
            this.initPickler();
        }
        OracleTypeADT oracleTypeADT = (OracleTypeADT)this.pickler;
        return oracleTypeADT;
    }

    private OracleType[] getFieldTypes() throws SQLException {
        return ((OracleTypeADT)this.pickler).getAttrTypes();
    }

    public SQLInput toJdbc2SQLInput(STRUCT sTRUCT, Map map) throws SQLException {
        return new OracleJdbc2SQLInput(this.toOracleArray(sTRUCT, false), map, this.connection);
    }

    public SQLOutput toJdbc2SQLOutput() throws SQLException {
        return new OracleSQLOutput(this, this.connection);
    }

    public Datum[] toOracleArray(Object[] objectArray) throws SQLException {
        Datum[] datumArray = null;
        if (objectArray != null) {
            OracleType[] oracleTypeArray = this.getFieldTypes();
            int n2 = oracleTypeArray.length;
            if (objectArray.length != n2) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 49, null);
            }
            datumArray = new Datum[n2];
            OracleConnection oracleConnection = this.connection;
            for (int i2 = 0; i2 < n2; ++i2) {
                datumArray[i2] = oracleTypeArray[i2].toDatum(objectArray[i2], oracleConnection);
            }
        }
        return datumArray;
    }

    public Datum[] toOracleArray(Map map) throws SQLException {
        Datum[] datumArray = null;
        int n2 = 0;
        if (map != null) {
            OracleType[] oracleTypeArray = this.getFieldTypes();
            int n3 = oracleTypeArray.length;
            int n4 = map.size();
            datumArray = new Datum[n3];
            OracleConnection oracleConnection = this.connection;
            for (int i2 = 0; i2 < n3; ++i2) {
                Object v = map.get(((OracleTypeADT)this.pickler).getAttributeName(i2 + 1));
                datumArray[i2] = oracleTypeArray[i2].toDatum(v, oracleConnection);
                if (v == null && !map.containsKey(((OracleTypeADT)this.pickler).getAttributeName(i2 + 1))) continue;
                ++n2;
            }
            if (n2 < n4) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, null);
            }
        }
        return datumArray;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.connection.newStructMetaData(this);
    }

    public boolean isFinalType() throws SQLException {
        return this.getOracleTypeADT().isFinalType();
    }

    public boolean isSubtype() throws SQLException {
        return this.getOracleTypeADT().isSubType();
    }

    @Override
    public boolean isInHierarchyOf(String string) throws SQLException {
        StructDescriptor structDescriptor = this;
        String string2 = structDescriptor.getName();
        boolean bl = false;
        if (string.equals(string2)) {
            bl = true;
        } else {
            while (true) {
                if ((string2 = structDescriptor.getSupertypeName()) == null) {
                    bl = false;
                    break;
                }
                if (string.equals(string2)) {
                    bl = true;
                    break;
                }
                structDescriptor = StructDescriptor.createDescriptor(string2, (Connection)this.connection);
            }
        }
        return bl;
    }

    public boolean isInstantiable() throws SQLException {
        if (this.isInstanciable == null) {
            this.initMetaData1();
        }
        return this.isInstanciable;
    }

    public boolean isJavaObject() throws SQLException {
        return this.getOracleTypeADT().isJavaObject();
    }

    public String getSupertypeName() throws SQLException {
        String string = null;
        if (this.isSubtype()) {
            if (this.supertype == null) {
                this.initMetaData1();
            }
            string = this.supertype;
        }
        return string;
    }

    public int getLocalAttributeCount() throws SQLException {
        int n2;
        if (!this.isSubtype()) {
            n2 = this.getOracleTypeADT().getAttrTypes().length;
        } else {
            if (this.numLocalAttrs == -1) {
                this.initMetaData1();
            }
            n2 = this.numLocalAttrs;
        }
        return n2;
    }

    public String[] getSubtypeNames() throws SQLException {
        if (this.subtypes == null) {
            this.initMetaData2();
        }
        return this.subtypes;
    }

    public String getJavaClassName() throws SQLException {
        String string = null;
        if (this.isJavaObject()) {
            string = StructDescriptor.getJavaObjectClassName(this.connection, this);
        }
        return string;
    }

    public String getAttributeJavaName(int n2) throws SQLException {
        String string = null;
        if (this.isJavaObject()) {
            if (this.attrJavaNames == null) {
                this.initMetaData3();
            }
            string = this.attrJavaNames[n2];
        }
        return string;
    }

    public String[] getAttributeJavaNames() throws SQLException {
        String[] stringArray = null;
        if (this.isJavaObject()) {
            if (this.attrJavaNames == null) {
                this.initMetaData3();
            }
            stringArray = this.attrJavaNames;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public String getLanguage() throws SQLException {
        String string = null;
        string = this.isJavaObject() ? "JAVA" : "SQL";
        return string;
    }

    public Class getClass(Map map) throws SQLException {
        String string = this.getName();
        Class clazz = (Class)map.get(string);
        String string2 = this.getSchemaName();
        String string3 = this.getTypeName();
        if (clazz == null) {
            clazz = (Class)map.get(string3);
        }
        if (SQLName.s_parseAllFormat) {
            if (clazz == null && this.connection.getDefaultSchemaNameForNamedTypes().equals(string2)) {
                clazz = (Class)map.get("\"" + string3 + "\"");
            }
            if (clazz == null) {
                clazz = (Class)map.get("\"" + string2 + "\"" + "." + "\"" + string3 + "\"");
            }
            if (clazz == null) {
                clazz = (Class)map.get("\"" + string2 + "\"" + "." + string3);
            }
            if (clazz == null) {
                clazz = (Class)map.get(string2 + "." + "\"" + string3 + "\"");
            }
        }
        return clazz;
    }

    public static String getJavaObjectClassName(Connection connection, StructDescriptor structDescriptor) throws SQLException {
        return StructDescriptor.getJavaObjectClassName(connection, structDescriptor.getSchemaName(), structDescriptor.getTypeName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJavaObjectClassName(Connection connection, String string, String string2) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string3 = null;
        try {
            preparedStatement = connection.prepareStatement("select external_name from all_sqlj_types where owner = :1 and type_name = :2");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string3 = resultSet.getString(1);
            } else {
                DatabaseError.throwSqlException(null, 100);
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return string3;
    }

    public String descType() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        return this.descType(stringBuffer, 0);
    }

    String descType(StringBuffer stringBuffer, int n2) throws SQLException {
        String string = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + "  ";
        }
        String string2 = string + "  ";
        stringBuffer.append(string);
        stringBuffer.append(this.getTypeName());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("Subtype=" + this.getOracleTypeADT().isSubType());
        stringBuffer.append(" JavaObject=" + this.getOracleTypeADT().isJavaObject());
        stringBuffer.append(" FinalType=" + this.getOracleTypeADT().isFinalType());
        stringBuffer.append("\n");
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        for (int i3 = 0; i3 < n3; ++i3) {
            TypeDescriptor typeDescriptor;
            int n4 = resultSetMetaData.getColumnType(i3 + 1);
            if (n4 == 2002 || n4 == 2008) {
                typeDescriptor = StructDescriptor.createDescriptor(resultSetMetaData.getColumnTypeName(i3 + 1), (Connection)this.connection);
                ((StructDescriptor)typeDescriptor).descType(stringBuffer, n2 + 1);
                continue;
            }
            if (n4 == 2003) {
                typeDescriptor = ArrayDescriptor.createDescriptor(resultSetMetaData.getColumnTypeName(i3 + 1), (Connection)this.connection);
                ((ArrayDescriptor)typeDescriptor).descType(stringBuffer, n2 + 1);
                continue;
            }
            if (n4 == 2007) {
                typeDescriptor = OpaqueDescriptor.createDescriptor(resultSetMetaData.getColumnTypeName(i3 + 1), (Connection)this.connection);
                ((OpaqueDescriptor)typeDescriptor).descType(stringBuffer, n2 + 1);
                continue;
            }
            stringBuffer.append(string2);
            stringBuffer.append(resultSetMetaData.getColumnTypeName(i3 + 1));
            stringBuffer.append("\n");
        }
        return stringBuffer.substring(0, stringBuffer.length());
    }

    public byte[] toBytes(Object[] objectArray) throws SQLException {
        Datum[] datumArray = this.toOracleArray(objectArray);
        return this.toBytes(datumArray);
    }

    public byte[] toBytes(Datum[] datumArray) throws SQLException {
        STRUCT sTRUCT = new STRUCT(this, (byte[])null, this.connection);
        sTRUCT.setDatumArray(datumArray);
        return this.pickler.linearize(sTRUCT);
    }

    public Datum[] toArray(Object[] objectArray) throws SQLException {
        return this.toOracleArray(objectArray);
    }

    public Datum[] toArray(byte[] byArray) throws SQLException {
        STRUCT sTRUCT = new STRUCT(this, byArray, this.connection);
        return this.toOracleArray(sTRUCT, false);
    }

    private void initMetaData1() throws SQLException {
        short s2 = this.connection.getVersionNumber();
        if (s2 >= 9000) {
            this.initMetaData1_9_0();
        } else {
            this.initMetaData1_pre_9_0();
        }
    }

    private String getSqlHint() throws SQLException {
        if (this.sqlHint == null) {
            this.sqlHint = this.connection.getVersionNumber() >= 11000 ? "" : "/*+RULE*/";
        }
        return this.sqlHint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData1_9_0() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            int n2 = 0;
            if (this.numLocalAttrs == -1) {
                Statement statement = null;
                Statement statement2 = null;
                ResultSet resultSet = null;
                int n3 = -1;
                try {
                    block12: while (true) {
                        switch (n2) {
                            case 0: {
                                statement = this.connection.prepareStatement(this.getSqlHint() + this.initMetaData1_9_0_SQL[n2]);
                                statement.setString(1, this.getTypeName());
                                statement.setString(2, this.getSchemaName());
                                statement.setFetchSize(1);
                                resultSet = statement.executeQuery();
                                break;
                            }
                            case 1: 
                            case 2: {
                                try {
                                    statement2 = (OracleCallableStatement)this.connection.prepareCall(this.getSqlHint() + this.initMetaData1_9_0_SQL[n2]);
                                    statement2.setString(1, this.getTypeName());
                                    statement2.registerOutParameter(2, -10);
                                    statement2.execute();
                                    resultSet = statement2.getCursor(2);
                                    resultSet.setFetchSize(1);
                                    break;
                                }
                                catch (SQLException sQLException) {
                                    if (sQLException.getErrorCode() == 1403) {
                                        if (n2 == 1) {
                                            statement2.close();
                                            ++n2;
                                            continue block12;
                                        }
                                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Inconsistent catalog view");
                                        break;
                                    }
                                    throw sQLException;
                                }
                            }
                        }
                        if (resultSet.next()) {
                            this.isInstanciable = new Boolean(resultSet.getString(1).equals("YES"));
                            this.supertype = resultSet.getString(2) + "." + resultSet.getString(3);
                            n3 = resultSet.getInt(4);
                            break;
                        }
                        if (n2 == 2) {
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Inconsistent catalog view");
                            continue;
                        }
                        resultSet.close();
                        if (statement2 != null) {
                            statement2.close();
                        }
                        ++n2;
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (statement2 != null) {
                        statement2.close();
                    }
                }
                this.numLocalAttrs = n3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData1_pre_9_0() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            this.isInstanciable = new Boolean(true);
            this.supertype = "";
            this.numLocalAttrs = 0;
        }
    }

    private void initMetaData2() throws SQLException {
        short s2 = this.connection.getVersionNumber();
        if (s2 >= 9000) {
            this.initMetaData2_9_0();
        } else {
            this.initMetaData2_pre_9_0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData2_9_0() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            if (this.subtypes == null) {
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                String[] stringArray = null;
                try {
                    preparedStatement = this.connection.prepareStatement("select owner, type_name from all_types where supertype_name = :1 and supertype_owner = :2");
                    preparedStatement.setString(1, this.getTypeName());
                    preparedStatement.setString(2, this.getSchemaName());
                    resultSet = preparedStatement.executeQuery();
                    Vector<String> vector = new Vector<String>();
                    while (resultSet.next()) {
                        vector.addElement(resultSet.getString(1) + "." + resultSet.getString(2));
                    }
                    stringArray = new String[vector.size()];
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        stringArray[i2] = (String)vector.elementAt(i2);
                    }
                    vector.removeAllElements();
                    vector = null;
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                this.subtypes = stringArray;
            }
        }
    }

    private void initMetaData2_pre_9_0() throws SQLException {
        this.subtypes = new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData3() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            if (this.attrJavaNames == null) {
                String[] stringArray = null;
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    preparedStatement = this.connection.prepareStatement("select EXTERNAL_ATTR_NAME from all_sqlj_type_attrs where owner = :1 and type_name = :2");
                    preparedStatement.setString(1, this.getSchemaName());
                    preparedStatement.setString(2, this.getTypeName());
                    resultSet = preparedStatement.executeQuery();
                    stringArray = new String[this.getOracleTypeADT().getAttrTypes().length];
                    int n2 = 0;
                    while (resultSet.next()) {
                        stringArray[n2] = resultSet.getString(1);
                        ++n2;
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                this.attrJavaNames = stringArray;
            }
        }
    }

    @Override
    String tagName() {
        return "StructDescriptor";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }
}

