/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;

public abstract class OracleXAResource
implements XAResource {
    public static final int XA_OK = 0;
    public static final short DEFAULT_XA_TIMEOUT = 60;
    protected boolean savedConnectionAutoCommit = false;
    protected boolean savedXAConnectionAutoCommit = false;
    public static final int TMNOFLAGS = 0;
    public static final int TMNOMIGRATE = 2;
    public static final int TMENDRSCAN = 0x800000;
    public static final int TMFAIL = 0x20000000;
    public static final int TMMIGRATE = 0x100000;
    public static final int TMJOIN = 0x200000;
    public static final int TMONEPHASE = 0x40000000;
    public static final int TMRESUME = 0x8000000;
    public static final int TMSTARTRSCAN = 0x1000000;
    public static final int TMSUCCESS = 0x4000000;
    public static final int TMSUSPEND = 0x2000000;
    public static final int ORATMREADONLY = 256;
    public static final int ORATMREADWRITE = 512;
    public static final int ORATMSERIALIZABLE = 1024;
    public static final int ORAISOLATIONMASK = 65280;
    public static final int ORATRANSLOOSE = 65536;
    protected Connection connection = null;
    protected OracleXAConnection xaconnection = null;
    protected int timeout = 60;
    protected String dblink = null;
    private Connection logicalConnection = null;
    private String synchronizeBeforeRecoverNewCall = "BEGIN sys.dbms_xa.dist_txn_sync \n; END;";
    private String synchronizeBeforeRecoverOldCall = "BEGIN sys.dbms_system.dist_txn_sync(0) \n; END;";
    private String recoverySqlRows = "SELECT formatid, globalid, branchid FROM SYS.DBA_PENDING_TRANSACTIONS";
    protected Vector locallySuspendedTransactions = new Vector();
    protected boolean canBeMigratablySuspended = false;
    protected XidListEntry xidHead = null;
    protected XidListEntry xidTail = null;
    protected XidListEntry currentXidListEntry = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Oct_30_03:32:37_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public OracleXAResource() {
    }

    public OracleXAResource(Connection connection, OracleXAConnection oracleXAConnection) throws XAException {
        this.connection = connection;
        this.xaconnection = oracleXAConnection;
        if (this.connection == null) {
            throw new XAException(-7);
        }
    }

    public synchronized void setConnection(Connection connection) throws XAException {
        this.connection = connection;
        if (this.connection == null) {
            throw new XAException(-7);
        }
    }

    final XidListEntry getMatchingXidListEntry(Xid xid) {
        XidListEntry xidListEntry = this.xidHead;
        while (xidListEntry != null && !this.isSameXid(xidListEntry.xid, xid)) {
            xidListEntry = xidListEntry.next;
        }
        return xidListEntry;
    }

    protected final boolean removeXidFromList(Xid xid) {
        if (!this.isXidListEmpty()) {
            if (this.isSameXid(this.xidHead.xid, xid)) {
                this.xidHead = this.xidHead.next;
                if (this.xidHead == null) {
                    this.xidTail = this.xidHead;
                }
                return true;
            }
            XidListEntry xidListEntry = this.xidHead.next;
            XidListEntry xidListEntry2 = this.xidHead;
            while (xidListEntry != null) {
                if (this.isSameXid(xidListEntry.xid, xid)) {
                    xidListEntry2.next = xidListEntry.next;
                    if (this.xidTail == xidListEntry) {
                        this.xidTail = xidListEntry2;
                    }
                    return true;
                }
                xidListEntry2 = xidListEntry;
                xidListEntry = xidListEntry.next;
            }
        }
        return false;
    }

    final boolean isSameXid(Xid xid, Xid xid2) {
        int n2;
        if (xid == xid2) {
            return true;
        }
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid2.getGlobalTransactionId();
        byte[] byArray3 = xid.getBranchQualifier();
        byte[] byArray4 = xid2.getBranchQualifier();
        if (xid.getFormatId() != xid2.getFormatId() || byArray == null || byArray2 == null || byArray3 == null || byArray4 == null || byArray.length != byArray2.length || byArray3.length != byArray4.length) {
            return false;
        }
        for (n2 = 0; n2 < byArray.length; ++n2) {
            if (byArray[n2] == byArray2[n2]) continue;
            return false;
        }
        for (n2 = 0; n2 < byArray3.length; ++n2) {
            if (byArray3[n2] == byArray4[n2]) continue;
            return false;
        }
        return true;
    }

    protected final boolean isXidListEmpty() {
        return this.xidHead == null;
    }

    protected final boolean isCurrentXidSuspended(Xid xid) {
        return this.currentXidListEntry != null && this.isSameXid(this.currentXidListEntry.xid, xid) && this.currentXidListEntry.isSuspended;
    }

    protected void createOrUpdateXid(Xid xid, boolean bl, boolean[] blArray) {
        XidListEntry xidListEntry = this.getMatchingXidListEntry(xid);
        if (xidListEntry != null) {
            blArray[0] = true;
            xidListEntry.isSuspended = bl;
        } else {
            xidListEntry = new XidListEntry(xid, bl);
            if (this.xidTail == null) {
                this.xidHead = this.xidTail = xidListEntry;
            } else {
                this.xidTail.next = xidListEntry;
                this.xidTail = xidListEntry;
            }
        }
        if (!bl) {
            this.enterGlobalTxnMode();
        }
        this.currentXidListEntry = xidListEntry;
    }

    protected boolean updateXidList(Xid xid, boolean[] blArray) {
        boolean bl = false;
        XidListEntry xidListEntry = this.getMatchingXidListEntry(xid);
        if (xidListEntry != null) {
            bl = true;
            blArray[0] = true;
            blArray[1] = xidListEntry.isSuspended;
            if (xidListEntry.isSuspended) {
                this.enterGlobalTxnMode();
            } else {
                this.exitGlobalTxnMode();
            }
        }
        return bl;
    }

    protected Xid suspendStacked(Xid xid) throws XAException {
        Xid xid2 = null;
        if (!this.isXidListEmpty() && this.currentXidListEntry != null && !this.isSameXid(this.currentXidListEntry.xid, xid)) {
            xid2 = this.xidTail.xid;
            this.end(xid2, 0x2000000);
        }
        return xid2;
    }

    protected Xid suspendStacked(Xid xid, int n2) throws XAException {
        Xid xid2 = null;
        if (n2 == 0x4000000 && this.xidTail != null && this.currentXidListEntry != null && !this.isSameXid(this.currentXidListEntry.xid, xid)) {
            this.allowGlobalTxnModeOnly(-3);
            xid2 = this.xidTail.xid;
            this.end(xid2, 0x2000000);
            this.start(xid, 0x8000000);
        }
        return xid2;
    }

    protected void resumeStacked(Xid xid) throws XAException {
        if (xid != null) {
            this.start(xid, 0x8000000);
        }
    }

    @Override
    public abstract void start(Xid var1, int var2) throws XAException;

    @Override
    public abstract void end(Xid var1, int var2) throws XAException;

    @Override
    public abstract void commit(Xid var1, boolean var2) throws XAException;

    @Override
    public abstract int prepare(Xid var1) throws XAException;

    @Override
    public abstract void forget(Xid var1) throws XAException;

    @Override
    public abstract void rollback(Xid var1) throws XAException;

    @Override
    public Xid[] recover(int n2) throws XAException {
        if ((n2 & 0x1800000) != n2) {
            throw new XAException(-5);
        }
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<OracleXid> arrayList = new ArrayList<OracleXid>(50);
        try {
            statement = this.connection.createStatement();
            try {
                statement.execute(this.synchronizeBeforeRecoverNewCall);
            }
            catch (Exception exception) {
                statement.execute(this.synchronizeBeforeRecoverOldCall);
            }
            resultSet = statement.executeQuery(this.recoverySqlRows);
            while (resultSet.next()) {
                arrayList.add(new OracleXid(resultSet.getInt(1), resultSet.getBytes(2), resultSet.getBytes(3)));
            }
        }
        catch (SQLException sQLException) {
            throw new XAException(-3);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
        }
        int n3 = arrayList.size();
        Xid[] xidArray = new Xid[n3];
        System.arraycopy(arrayList.toArray(), 0, xidArray, 0, n3);
        return xidArray;
    }

    protected void restoreAutoCommitModeForGlobalTransaction() throws XAException {
        if (this.savedConnectionAutoCommit && ((OracleConnection)this.connection).getTxnMode() != 1) {
            try {
                this.connection.setAutoCommit(this.savedConnectionAutoCommit);
                this.xaconnection.setAutoCommit(this.savedXAConnectionAutoCommit);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void saveAndAlterAutoCommitModeForGlobalTransaction() throws XAException {
        try {
            this.savedConnectionAutoCommit = this.connection.getAutoCommit();
            this.connection.setAutoCommit(false);
            this.savedXAConnectionAutoCommit = this.xaconnection.getAutoCommit();
            this.xaconnection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void resume(Xid xid) throws XAException {
        this.start(xid, 0x8000000);
    }

    public void join(Xid xid) throws XAException {
        this.start(xid, 0x200000);
    }

    public void suspend(Xid xid) throws XAException {
        this.end(xid, 0x2000000);
    }

    public void join(Xid xid, int n2) throws XAException {
        this.timeout = n2;
        this.start(xid, 0x200000);
    }

    public void resume(Xid xid, int n2) throws XAException {
        this.timeout = n2;
        this.start(xid, 0x8000000);
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    @Override
    public boolean isSameRM(XAResource xAResource) throws XAException {
        Connection connection = null;
        if (!(xAResource instanceof OracleXAResource)) {
            return false;
        }
        connection = ((OracleXAResource)xAResource).getConnection();
        try {
            if (this.connection == null || ((OracleConnection)this.connection).isClosed()) {
                return false;
            }
            String string = ((OracleConnection)this.connection).getURL();
            String string2 = ((OracleConnection)this.connection).getProtocolType();
            if (connection != null) {
                boolean bl = connection.equals(this.connection) || ((OracleConnection)connection).getURL().equals(string) || ((OracleConnection)connection).getProtocolType().equals(string2) && string2.equals("kprb");
                return bl;
            }
        }
        catch (SQLException sQLException) {
            throw new XAException(-3);
        }
        return false;
    }

    @Override
    public boolean setTransactionTimeout(int n2) throws XAException {
        if (n2 < 0) {
            throw new XAException(-5);
        }
        this.timeout = n2;
        return true;
    }

    public String getDBLink() {
        return this.dblink;
    }

    public void setDBLink(String string) {
        this.dblink = string;
    }

    public void setLogicalConnection(Connection connection) {
        this.logicalConnection = connection;
    }

    protected void allowGlobalTxnModeOnly(int n2) throws XAException {
        if (((OracleConnection)this.connection).getTxnMode() != 1) {
            throw new XAException(n2);
        }
    }

    protected void exitGlobalTxnMode() {
        ((OracleConnection)this.connection).setTxnMode(0);
    }

    protected void enterGlobalTxnMode() {
        ((OracleConnection)this.connection).setTxnMode(1);
    }

    protected void checkError(int n2) throws OracleXAException {
        if ((n2 & 0xFFFF) != 0) {
            throw new OracleXAException(n2);
        }
    }

    protected void checkError(int n2, int n3) throws OracleXAException {
        if ((n2 & 0xFFFF) != 0) {
            throw new OracleXAException(n2, n3);
        }
    }

    class XidListEntry {
        Xid xid;
        boolean isSuspended;
        XidListEntry next = null;

        XidListEntry(Xid xid, boolean bl) {
            this.xid = xid;
            this.isSuspended = bl;
        }
    }
}

