/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.RefTypeAccessor;
import oracle.jdbc.driver.T4CMAREngine;

class T4CRefTypeAccessor
extends RefTypeAccessor {
    static final int maxLength = 4000;
    T4CMAREngine mare;
    final int[] meta = new int[1];
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Oct_30_03:32:30_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    T4CRefTypeAccessor(OracleStatement oracleStatement, String string, short s2, int n2, boolean bl, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, string, s2, n2, bl);
        this.mare = t4CMAREngine;
        this.byteLength = 4000;
    }

    T4CRefTypeAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2, String string, int n8, int n9, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, bl, n3, n4, n5, n6, n7, s2, string);
        this.mare = t4CMAREngine;
        this.definedColumnType = n8;
        this.definedColumnSize = n9;
        this.byteLength = 4000;
    }

    void processIndicator(int n2) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.mare.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (this.statement.sqlKind != 1 && this.statement.sqlKind != 4) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind == 1 || this.statement.sqlKind == 4 || this.isDMLReturnedParam) {
            this.mare.processIndicator(n2 <= 0, n2);
        }
    }

    @Override
    String getString(int n2) throws SQLException {
        String string = super.getString(n2);
        if (string != null && this.definedColumnSize > 0 && string.length() > this.definedColumnSize) {
            string = string.substring(0, this.definedColumnSize);
        }
        return string;
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        int n2 = this.columnIndex + this.lastRowProcessed * this.byteLength;
        byte[] byArray = this.mare.unmarshalCLRforREFS();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.pickledBytes[this.lastRowProcessed] = byArray;
        this.meta[0] = byArray.length;
        this.processIndicator(this.meta[0]);
        int n3 = this.indicatorIndex + this.lastRowProcessed;
        int n4 = this.lengthIndex + this.lastRowProcessed;
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[n3] = -1;
            this.rowSpaceIndicator[n4] = 0;
        } else {
            this.rowSpaceIndicator[n4] = (short)this.meta[0];
            this.rowSpaceIndicator[n3] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }
}

