/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import oracle.jdbc.NotificationRegistration;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.NTFAQRegistration;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.Namespace;
import oracle.jdbc.driver.OracleBlobInputStream;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleClobInputStream;
import oracle.jdbc.driver.OracleClobOutputStream;
import oracle.jdbc.driver.OracleClobReader;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4C7Ocommoncall;
import oracle.jdbc.driver.T4C7Oversion;
import oracle.jdbc.driver.T4C8Oall;
import oracle.jdbc.driver.T4C8Oclose;
import oracle.jdbc.driver.T4C8Odscrarr;
import oracle.jdbc.driver.T4C8TTIBfile;
import oracle.jdbc.driver.T4C8TTIBlob;
import oracle.jdbc.driver.T4C8TTIClob;
import oracle.jdbc.driver.T4C8TTIdty;
import oracle.jdbc.driver.T4C8TTIpro;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CStatement;
import oracle.jdbc.driver.T4CTTIOtxen;
import oracle.jdbc.driver.T4CTTIOtxse;
import oracle.jdbc.driver.T4CTTIk2rpc;
import oracle.jdbc.driver.T4CTTIoauthenticate;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.driver.T4CTTIokeyval;
import oracle.jdbc.driver.T4CTTIokpn;
import oracle.jdbc.driver.T4CTTIoping;
import oracle.jdbc.driver.T4CTTIoscid;
import oracle.jdbc.driver.T4CTTIoses;
import oracle.jdbc.driver.T4CTTIoxssao;
import oracle.jdbc.driver.T4CTTIoxsscs;
import oracle.jdbc.driver.T4CTTIoxssso;
import oracle.jdbc.driver.T4CTTIrxd;
import oracle.jdbc.driver.T4CTTIspfp;
import oracle.jdbc.driver.T4CTTIsto;
import oracle.jdbc.driver.T4CXAResource;
import oracle.jdbc.driver.T4Caqdq;
import oracle.jdbc.driver.T4Caqe;
import oracle.jdbc.internal.KeywordValue;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.net.ns.Communication;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NetException;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.ClobDBAccess;
import oracle.sql.LobPlsqlUtil;

class T4CConnection
extends PhysicalConnection
implements BfileDBAccess,
BlobDBAccess,
ClobDBAccess {
    static final short MIN_OVERSION_SUPPORTED = 7230;
    static final short MIN_TTCVER_SUPPORTED = 4;
    static final short V8_TTCVER_SUPPORTED = 5;
    static final short MAX_TTCVER_SUPPORTED = 6;
    static final int DEFAULT_LONG_PREFETCH_SIZE = 4080;
    static final String DEFAULT_CONNECT_STRING = "localhost:1521:orcl";
    static final int STREAM_CHUNK_SIZE = 255;
    static final int REFCURSOR_SIZE = 5;
    long LOGON_MODE = 0L;
    static final long SYSDBA = 8L;
    static final long SYSOPER = 16L;
    static final long SYSASM = 128L;
    boolean isLoggedOn;
    private String password;
    Communication net;
    boolean readAsNonStream;
    T4CTTIoer oer;
    T4CMAREngine mare;
    T4C8TTIpro pro;
    T4C8TTIdty dty;
    T4CTTIrxd rxd;
    T4CTTIsto sto;
    T4CTTIspfp spfp;
    T4CTTIoauthenticate auth;
    T4C7Oversion ver;
    T4C8Odscrarr describe;
    T4C8Oall all8;
    T4C8Oclose close8;
    T4C7Ocommoncall commoncall;
    T4Caqe aqe;
    T4Caqdq aqdq;
    T4C8TTIBfile bfileMsg;
    T4C8TTIBlob blobMsg;
    T4C8TTIClob clobMsg;
    T4CTTIoses oses;
    T4CTTIoping oping;
    T4CTTIokpn okpn;
    byte[] EMPTY_BYTE = new byte[0];
    T4CTTIOtxen otxen;
    T4CTTIOtxse otxse;
    T4CTTIk2rpc k2rpc;
    T4CTTIoscid oscid;
    T4CTTIokeyval okeyval;
    T4CTTIoxsscs oxsscs;
    T4CTTIoxssso oxssso;
    T4CTTIoxssao oxssao;
    int[] cursorToClose = new int[4];
    int cursorToCloseOffset = 0;
    int[] queryToClose = new int[10];
    int queryToCloseOffset = 0;
    int[] lusFunctionId = new int[10];
    byte[][] lusSessionId = new byte[10][];
    String[] lusNamespace = new String[10];
    String[] lusAttributeName = new String[10];
    KeywordValue[][] lusInKeyVal = new KeywordValue[10][];
    int[] lusInFlags = new int[10];
    int lusOffset = 0;
    int sessionId;
    int serialNumber;
    byte[] sccap;
    byte[] srcap;
    Hashtable namespaces;
    byte[] internalName;
    byte[] externalName;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Oct_30_03:32:28_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    T4CConnection(String string, Properties properties, OracleDriverExtension oracleDriverExtension) throws SQLException {
        super(string, properties, oracleDriverExtension);
        this.minVcsBindSize = 0;
        this.streamChunkSize = 255;
        this.namespaces = new Hashtable(5);
    }

    @Override
    final void initializePassword(String string) throws SQLException {
        this.password = string;
    }

    @Override
    void logon() throws SQLException {
        try {
            if (this.isLoggedOn) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 428);
            }
            if (this.database == null) {
                this.database = DEFAULT_CONNECT_STRING;
            }
            this.connect(this.database);
            this.all8 = new T4C8Oall(this.mare, this, this.oer);
            this.okpn = new T4CTTIokpn(this.mare, this.oer, this);
            this.close8 = new T4C8Oclose(this.mare);
            this.sto = new T4CTTIsto(this.mare, this.oer, this);
            this.spfp = new T4CTTIspfp(this.mare, this.oer, this);
            this.commoncall = new T4C7Ocommoncall(this.mare, this.oer, this);
            this.describe = new T4C8Odscrarr(this.mare, this.oer);
            this.bfileMsg = new T4C8TTIBfile(this.mare, this.oer);
            this.blobMsg = new T4C8TTIBlob(this.mare, this.oer);
            this.clobMsg = new T4C8TTIClob(this.mare, this.oer);
            this.otxen = new T4CTTIOtxen(this.mare, this.oer, this);
            this.otxse = new T4CTTIOtxse(this.mare, this.oer, this);
            this.oping = new T4CTTIoping(this.mare, this.oer, this);
            this.k2rpc = new T4CTTIk2rpc(this.mare, this.oer, this);
            this.oses = new T4CTTIoses(this.mare);
            this.okeyval = new T4CTTIokeyval(this.mare);
            this.oxsscs = new T4CTTIoxsscs(this.mare, this.oer, this);
            this.oxssso = new T4CTTIoxssso(this.mare, this.oer, this);
            this.oxssao = new T4CTTIoxssao(this.mare, this.oer, this);
            this.aqe = new T4Caqe(this.mare, this, this.oer);
            this.aqdq = new T4Caqdq(this.mare, this, this.oer);
            this.oscid = new T4CTTIoscid(this.mare);
            this.dty = new T4C8TTIdty(this.mare);
            if (this.logonCap != null && this.logonCap.trim().equals("o3")) {
                this.dty.CTcap[4] = 0;
            }
            this.dty.marshal(this.sccap);
            this.dty.receive();
            this.ver = new T4C7Oversion(this.mare, this.oer, this);
            this.ver.marshal();
            this.ver.receive();
            this.mare.versionNumber = this.versionNumber = this.ver.getVersionNumber();
            if (this.versionNumber < 7230) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 441);
            }
            this.mare.types.setVersion(this.versionNumber);
            this.LOGON_MODE = 0L;
            if (this.internalLogon != null) {
                if (this.internalLogon.equalsIgnoreCase("sysoper")) {
                    this.LOGON_MODE = 64L;
                } else if (this.internalLogon.equalsIgnoreCase("sysdba")) {
                    this.LOGON_MODE = 32L;
                } else if (this.internalLogon.equalsIgnoreCase("sysasm")) {
                    this.LOGON_MODE = 0x400000L;
                }
            }
            if (this.prelimAuth) {
                this.LOGON_MODE |= 0x80L;
            }
            this.auth = new T4CTTIoauthenticate(this.mare, this.resourceManagerId, this.oer, this);
            if (this.userName != null && this.userName.length() != 0) {
                this.auth.marshalOsesskey(this.userName, this.LOGON_MODE);
                this.auth.receiveOsesskey();
            }
            this.auth.marshalOauth(this.userName, this.password, this.LOGON_MODE);
            this.auth.receiveOauth();
            this.sessionId = this.getSessionId();
            this.serialNumber = this.getSerialNumber();
            this.internalName = this.auth.internalName;
            this.externalName = this.auth.externalName;
            this.instanceName = this.sessionProperties.getProperty("AUTH_INSTANCENAME");
            this.isLoggedOn = true;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
        catch (SQLException sQLException) {
            try {
                this.net.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.isLoggedOn = false;
            throw sQLException;
        }
    }

    void handleIOException(IOException iOException) throws SQLException {
        try {
            this.mare.pipeState = -1;
            this.net.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isLoggedOn = false;
        this.lifecycle = 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void logoff() throws SQLException {
        try {
            this.assertLoggedOn("T4CConnection.logoff");
            if (this.lifecycle == 8) {
                return;
            }
            this.sendPiggyBackedMessages();
            this.commoncall.init((short)9);
            this.commoncall.marshal();
            this.commoncall.receive();
            this.net.disconnect();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            if (this.lifecycle != 8) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            }
        }
        finally {
            this.isLoggedOn = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    synchronized void doCommit(int n2) throws SQLException {
        try {
            this.assertLoggedOn("T4CConnection.do_commit");
            this.sendPiggyBackedMessages();
            int n3 = 0;
            if ((n2 & OracleConnection.CommitOption.WRITEBATCH.getCode()) != 0) {
                n3 = n3 | 2 | 1;
            } else if ((n2 & OracleConnection.CommitOption.WRITEIMMED.getCode()) != 0) {
                n3 |= 2;
            }
            if ((n2 & OracleConnection.CommitOption.NOWAIT.getCode()) != 0) {
                n3 = n3 | 8 | 4;
            } else if ((n2 & OracleConnection.CommitOption.WAIT.getCode()) != 0) {
                n3 |= 8;
            }
            this.otxen.marshal(1, null, null, 0, 0, 0, 0, 4, n3);
            int[] nArray = new int[1];
            int n4 = this.otxen.receive(nArray);
            if (n4 != 2 && n4 == 4) return;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    synchronized void doRollback() throws SQLException {
        try {
            this.assertLoggedOn("T4CConnection.do_rollback");
            this.sendPiggyBackedMessages();
            this.commoncall.init((short)15);
            this.commoncall.marshal();
            this.commoncall.receive();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    synchronized void doSetAutoCommit(boolean bl) throws SQLException {
    }

    @Override
    public synchronized void open(OracleStatement oracleStatement) throws SQLException {
        this.assertLoggedOn("T4CConnection.open");
        oracleStatement.setCursorId(0);
    }

    @Override
    synchronized String doGetDatabaseProductVersion() throws SQLException {
        this.assertLoggedOn("T4CConnection.do_getDatabaseProductVersion");
        String string = null;
        byte[] byArray = this.ver.getVersion();
        try {
            string = new String(byArray, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), unsupportedEncodingException);
        }
        return string;
    }

    @Override
    synchronized short doGetVersionNumber() throws SQLException {
        this.assertLoggedOn("T4CConnection.do_getVersionNumber");
        short s2 = this.ver.getVersionNumber();
        return s2;
    }

    @Override
    OracleStatement RefCursorBytesToStatement(byte[] byArray, OracleStatement oracleStatement) throws SQLException {
        T4CStatement t4CStatement = new T4CStatement(this, -1, -1);
        try {
            int n2 = this.mare.unmarshalRefCursor(byArray);
            t4CStatement.setCursorId(n2);
            t4CStatement.isOpen = true;
            t4CStatement.sqlObject = oracleStatement.sqlObject;
            t4CStatement.serverCursor = true;
            oracleStatement.addChild(t4CStatement);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
        t4CStatement.sqlStringChanged = false;
        t4CStatement.needToParse = false;
        return t4CStatement;
    }

    @Override
    void cancelOperationOnServer() throws SQLException {
        try {
            switch (this.mare.pipeState) {
                case -1: {
                    return;
                }
                case 1: {
                    this.net.sendBreak();
                    break;
                }
                case 2: {
                    this.net.sendInterrupt();
                }
            }
            this.mare.sentCancel = true;
        }
        catch (NetException netException) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), netException);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    void connect(String string) throws IOException, SQLException {
        if (string == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 433);
        }
        Properties properties = new Properties();
        if (this.thinNetProfile != null) {
            properties.setProperty("oracle.net.profile", this.thinNetProfile);
        }
        if (this.thinNetAuthenticationServices != null) {
            properties.setProperty("oracle.net.authentication_services", this.thinNetAuthenticationServices);
        }
        if (this.thinNetAuthenticationKrb5Mutual != null) {
            properties.setProperty("oracle.net.kerberos5_mutual_authentication", this.thinNetAuthenticationKrb5Mutual);
        }
        if (this.thinNetAuthenticationKrb5CcName != null) {
            properties.setProperty("oracle.net.kerberos5_cc_name", this.thinNetAuthenticationKrb5CcName);
        }
        if (this.thinNetEncryptionLevel != null) {
            properties.setProperty("oracle.net.encryption_client", this.thinNetEncryptionLevel);
        }
        if (this.thinNetEncryptionTypes != null) {
            properties.setProperty("oracle.net.encryption_types_client", this.thinNetEncryptionTypes);
        }
        if (this.thinNetChecksumLevel != null) {
            properties.setProperty("oracle.net.crypto_checksum_client", this.thinNetChecksumLevel);
        }
        if (this.thinNetChecksumTypes != null) {
            properties.setProperty("oracle.net.crypto_checksum_types_client", this.thinNetChecksumTypes);
        }
        if (this.thinNetCryptoSeed != null) {
            properties.setProperty("oracle.net.crypto_seed", this.thinNetCryptoSeed);
        }
        if (this.thinTcpNoDelay) {
            properties.setProperty("TCP.NODELAY", "YES");
        }
        if (this.thinReadTimeout != null) {
            properties.setProperty("oracle.net.READ_TIMEOUT", this.thinReadTimeout);
        }
        if (this.thinNetConnectTimeout != null) {
            properties.setProperty("oracle.net.CONNECT_TIMEOUT", this.thinNetConnectTimeout);
        }
        if (this.thinSslServerDnMatch != null) {
            properties.setProperty("oracle.net.ssl_server_dn_match", this.thinSslServerDnMatch);
        }
        if (this.walletLocation != null) {
            properties.setProperty("oracle.net.wallet_location", this.walletLocation);
        }
        if (this.thinSslVersion != null) {
            properties.setProperty("oracle.net.ssl_version", this.thinSslVersion);
        }
        if (this.thinSslCipherSuites != null) {
            properties.setProperty("oracle.net.ssl_cipher_suites", this.thinSslCipherSuites);
        }
        if (this.thinJavaxNetSslKeystore != null) {
            properties.setProperty("javax.net.ssl.keyStore", this.thinJavaxNetSslKeystore);
        }
        if (this.thinJavaxNetSslKeystoretype != null) {
            properties.setProperty("javax.net.ssl.keyStoreType", this.thinJavaxNetSslKeystoretype);
        }
        if (this.thinJavaxNetSslKeystorepassword != null) {
            properties.setProperty("javax.net.ssl.keyStorePassword", this.thinJavaxNetSslKeystorepassword);
        }
        if (this.thinJavaxNetSslTruststore != null) {
            properties.setProperty("javax.net.ssl.trustStore", this.thinJavaxNetSslTruststore);
        }
        if (this.thinJavaxNetSslTruststoretype != null) {
            properties.setProperty("javax.net.ssl.trustStoreType", this.thinJavaxNetSslTruststoretype);
        }
        if (this.thinJavaxNetSslTruststorepassword != null) {
            properties.setProperty("javax.net.ssl.trustStorePassword", this.thinJavaxNetSslTruststorepassword);
        }
        if (this.thinSslKeymanagerfactoryAlgorithm != null) {
            properties.setProperty("ssl.keyManagerFactory.algorithm", this.thinSslKeymanagerfactoryAlgorithm);
        }
        if (this.thinSslTrustmanagerfactoryAlgorithm != null) {
            properties.setProperty("ssl.trustManagerFactory.algorithm", this.thinSslTrustmanagerfactoryAlgorithm);
        }
        if (this.thinNetOldsyntax != null) {
            properties.setProperty("oracle.net.oldSyntax", this.thinNetOldsyntax);
        }
        if (this.thinNamingContextInitial != null) {
            properties.setProperty("java.naming.factory.initial", this.thinNamingContextInitial);
        }
        if (this.thinNamingProviderUrl != null) {
            properties.setProperty("java.naming.provider.url", this.thinNamingProviderUrl);
        }
        if (this.thinNamingSecurityAuthentication != null) {
            properties.setProperty("java.naming.security.authentication", this.thinNamingSecurityAuthentication);
        }
        if (this.thinNamingSecurityPrincipal != null) {
            properties.setProperty("java.naming.security.principal", this.thinNamingSecurityPrincipal);
        }
        if (this.thinNamingSecurityCredentials != null) {
            properties.setProperty("java.naming.security.credentials", this.thinNamingSecurityCredentials);
        }
        if (this.thinNetDisableOutOfBandBreak) {
            properties.setProperty("DISABLE_OOB", "" + this.thinNetDisableOutOfBandBreak);
        }
        properties.setProperty("oracle.jdbc.v$session.osuser", this.thinVsessionOsuser);
        this.net = new NSProtocol();
        try {
            this.net.connect(string, properties);
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        this.mare = new T4CMAREngine(this.net);
        this.oer = new T4CTTIoer(this.mare, this);
        this.pro = new T4C8TTIpro(this.mare);
        this.pro.marshal();
        this.sccap = this.pro.receive();
        this.srcap = this.pro.getServerRuntimeCapabilities();
        short s2 = this.pro.getOracleVersion();
        short s3 = this.pro.getCharacterSet();
        short s4 = DBConversion.findDriverCharSet(s3, s2);
        this.conversion = new DBConversion(s3, s4, this.pro.getncharCHARSET());
        this.mare.types.setServerConversion(s4 != s3);
        this.mare.types.setVersion(s2);
        if (DBConversion.isCharSetMultibyte(s4)) {
            if (DBConversion.isCharSetMultibyte(this.pro.getCharacterSet())) {
                this.mare.types.setFlags((byte)1);
            } else {
                this.mare.types.setFlags((byte)2);
            }
        } else {
            this.mare.types.setFlags(this.pro.getFlags());
        }
        this.mare.conv = this.conversion;
    }

    @Override
    void doStartup(int n2) throws SQLException {
        try {
            int n3 = 0;
            if (n2 == OracleConnection.DatabaseStartupMode.FORCE.getMode()) {
                n3 = 16;
            } else if (n2 == OracleConnection.DatabaseStartupMode.RESTRICT.getMode()) {
                n3 = 1;
            }
            this.spfp.marshal();
            this.spfp.receive();
            this.sto.marshalStartup(n3);
            this.sto.receive();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    void doShutdown(int n2) throws SQLException {
        try {
            int n3 = 4;
            if (n2 == OracleConnection.DatabaseShutdownMode.TRANSACTIONAL.getMode()) {
                n3 = 128;
            } else if (n2 == OracleConnection.DatabaseShutdownMode.TRANSACTIONAL_LOCAL.getMode()) {
                n3 = 256;
            } else if (n2 == OracleConnection.DatabaseShutdownMode.IMMEDIATE.getMode()) {
                n3 = 2;
            } else if (n2 == OracleConnection.DatabaseShutdownMode.FINAL.getMode()) {
                n3 = 8;
            } else if (n2 == OracleConnection.DatabaseShutdownMode.ABORT.getMode()) {
                n3 = 64;
            }
            this.sendPiggyBackedMessages();
            this.sto.marshalShutdown(n3);
            this.sto.receive();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    void sendPiggyBackedMessages() throws SQLException, IOException {
        int n2;
        this.sendPiggyBackedClose();
        if (this.endToEndAnyChanged && this.versionNumber >= 10000) {
            this.oscid.marshal(this.endToEndHasChanged, this.endToEndValues, this.endToEndECIDSequenceNumber);
            for (n2 = 0; n2 < 4; ++n2) {
                if (!this.endToEndHasChanged[n2]) continue;
                this.endToEndHasChanged[n2] = false;
            }
        }
        this.endToEndAnyChanged = false;
        if (!this.namespaces.isEmpty()) {
            if (this.versionNumber >= 10200) {
                Object[] objectArray = this.namespaces.values().toArray();
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    this.okeyval.marshal((Namespace)objectArray[i2]);
                }
            }
            this.namespaces.clear();
        }
        if (this.lusOffset > 0) {
            for (n2 = 0; n2 < this.lusOffset; ++n2) {
                this.oxssao.marshal(this.lusFunctionId[n2], this.lusSessionId[n2], this.lusNamespace[n2], this.lusAttributeName[n2], this.lusInKeyVal[n2], this.lusInFlags[n2]);
            }
            this.lusOffset = 0;
        }
    }

    private void sendPiggyBackedClose() throws SQLException, IOException {
        if (this.queryToCloseOffset > 0) {
            this.close8.initCloseQuery();
            this.close8.marshal(this.queryToClose, this.queryToCloseOffset);
            this.queryToCloseOffset = 0;
        }
        if (this.cursorToCloseOffset > 0) {
            this.close8.initCloseStatement();
            this.close8.marshal(this.cursorToClose, this.cursorToCloseOffset);
            this.cursorToCloseOffset = 0;
        }
    }

    @Override
    void doProxySession(int n2, Properties properties) throws SQLException {
        try {
            this.sendPiggyBackedMessages();
            this.auth.marshalOauth(n2, properties, this.sessionId, this.serialNumber);
            this.auth.receiveOauth();
            int n3 = this.getSessionId();
            int n4 = this.getSerialNumber();
            this.oses.marshal(n3, n4, 1);
            this.savedUser = this.userName;
            this.userName = n2 == 1 ? properties.getProperty("PROXY_USER_NAME") : null;
            this.isProxy = true;
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    void closeProxySession() throws SQLException {
        try {
            this.sendPiggyBackedMessages();
            this.commoncall.init((short)9);
            this.commoncall.marshal();
            this.commoncall.receive();
            this.oses.marshal(this.sessionId, this.serialNumber, 1);
            this.userName = this.savedUser;
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    public Properties getServerSessionInfo() throws SQLException {
        if (this.getVersionNumber() < 10200) {
            this.queryFCFProperties(this.sessionProperties);
        }
        return this.sessionProperties;
    }

    @Override
    public String getSessionTimeZoneOffset() throws SQLException {
        String string = this.getServerSessionInfo().getProperty("SESSION_TIME_ZONE");
        if (string == null) {
            string = super.getSessionTimeZoneOffset();
        }
        return string;
    }

    int getSessionId() {
        int n2 = -1;
        String string = this.sessionProperties.getProperty("AUTH_SESSION_ID");
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    int getSerialNumber() {
        int n2 = -1;
        String string = this.sessionProperties.getProperty("AUTH_SERIAL_NUM");
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    @Override
    public byte getInstanceProperty(OracleConnection.InstanceProperty instanceProperty) throws SQLException {
        byte by = 0;
        if (instanceProperty == OracleConnection.InstanceProperty.ASM_VOLUME_SUPPORTED) {
            if (this.srcap == null || this.srcap.length < 6) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 256);
            }
            by = this.srcap[5];
        } else if (instanceProperty == OracleConnection.InstanceProperty.INSTANCE_TYPE) {
            if (this.srcap == null || this.srcap.length < 4) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 256);
            }
            by = this.srcap[3];
        }
        return by;
    }

    @Override
    public synchronized BlobDBAccess createBlobDBAccess() throws SQLException {
        return this;
    }

    @Override
    public synchronized ClobDBAccess createClobDBAccess() throws SQLException {
        return this;
    }

    @Override
    public synchronized BfileDBAccess createBfileDBAccess() throws SQLException {
        return this;
    }

    @Override
    public synchronized long length(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("length");
        this.assertNotNull(bFILE.shareBytes(), "length");
        this.needLine();
        long l2 = 0L;
        try {
            l2 = this.bfileMsg.getLength(bFILE.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
        return l2;
    }

    @Override
    public synchronized long position(BFILE bFILE, byte[] byArray, long l2) throws SQLException {
        long l3;
        if (l2 < 1L) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
        }
        l3 = (l3 = LobPlsqlUtil.hasPattern(bFILE, byArray, l2)) == 0L ? -1L : l3;
        return l3;
    }

    @Override
    public long position(BFILE bFILE, BFILE bFILE2, long l2) throws SQLException {
        long l3;
        if (l2 < 1L) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
        }
        l3 = (l3 = LobPlsqlUtil.isSubLob(bFILE, bFILE2, l2)) == 0L ? -1L : l3;
        return l3;
    }

    @Override
    public synchronized int getBytes(BFILE bFILE, long l2, int n2, byte[] byArray) throws SQLException {
        this.assertLoggedOn("getBytes");
        if (l2 < 1L) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "getBytes()");
        }
        if (n2 <= 0 || byArray == null) {
            return 0;
        }
        this.needLine();
        long l3 = 0L;
        if (n2 != 0) {
            try {
                l3 = this.bfileMsg.read(bFILE.shareBytes(), l2, n2, byArray);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            }
        }
        return (int)l3;
    }

    @Override
    public String getName(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("getName");
        this.assertNotNull(bFILE.shareBytes(), "getName");
        String string = LobPlsqlUtil.fileGetName(bFILE);
        return string;
    }

    @Override
    public String getDirAlias(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("getDirAlias");
        this.assertNotNull(bFILE.shareBytes(), "getDirAlias");
        String string = LobPlsqlUtil.fileGetDirAlias(bFILE);
        return string;
    }

    @Override
    public synchronized void openFile(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("openFile");
        this.assertNotNull(bFILE.shareBytes(), "openFile");
        this.needLine();
        try {
            this.bfileMsg.open(bFILE.shareBytes(), 11);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    public synchronized boolean isFileOpen(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("openFile");
        this.assertNotNull(bFILE.shareBytes(), "openFile");
        this.needLine();
        boolean bl = false;
        try {
            bl = this.bfileMsg.isOpen(bFILE.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
        return bl;
    }

    @Override
    public synchronized boolean fileExists(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("fileExists");
        this.assertNotNull(bFILE.shareBytes(), "fileExists");
        this.needLine();
        boolean bl = false;
        try {
            bl = this.bfileMsg.doesExist(bFILE.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
        return bl;
    }

    @Override
    public synchronized void closeFile(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("closeFile");
        this.assertNotNull(bFILE.shareBytes(), "closeFile");
        this.needLine();
        try {
            this.bfileMsg.close(bFILE.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    public synchronized void open(BFILE bFILE, int n2) throws SQLException {
        this.assertLoggedOn("open");
        this.assertNotNull(bFILE.shareBytes(), "open");
        this.needLine();
        try {
            this.bfileMsg.open(bFILE.shareBytes(), n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    public synchronized void close(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("close");
        this.assertNotNull(bFILE.shareBytes(), "close");
        this.needLine();
        try {
            this.bfileMsg.close(bFILE.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    public synchronized boolean isOpen(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("isOpen");
        this.assertNotNull(bFILE.shareBytes(), "isOpen");
        this.needLine();
        boolean bl = false;
        try {
            bl = this.bfileMsg.isOpen(bFILE.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
        return bl;
    }

    @Override
    public InputStream newInputStream(BFILE bFILE, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleBlobInputStream(bFILE, n2);
        }
        return new OracleBlobInputStream(bFILE, n2, l2);
    }

    @Override
    public InputStream newConversionInputStream(BFILE bFILE, int n2) throws SQLException {
        this.assertNotNull(bFILE.shareBytes(), "newConversionInputStream");
        OracleConversionInputStream oracleConversionInputStream = new OracleConversionInputStream(this.conversion, bFILE.getBinaryStream(), n2);
        return oracleConversionInputStream;
    }

    @Override
    public Reader newConversionReader(BFILE bFILE, int n2) throws SQLException {
        this.assertNotNull(bFILE.shareBytes(), "newConversionReader");
        OracleConversionReader oracleConversionReader = new OracleConversionReader(this.conversion, bFILE.getBinaryStream(), n2);
        return oracleConversionReader;
    }

    @Override
    public synchronized long length(BLOB bLOB) throws SQLException {
        this.assertLoggedOn("length");
        this.assertNotNull(bLOB.shareBytes(), "length");
        this.needLine();
        long l2 = 0L;
        try {
            l2 = this.blobMsg.getLength(bLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
        return l2;
    }

    @Override
    public long position(BLOB bLOB, byte[] byArray, long l2) throws SQLException {
        long l3;
        this.assertLoggedOn("position");
        this.assertNotNull(bLOB.shareBytes(), "position");
        if (l2 < 1L) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
        }
        l3 = (l3 = LobPlsqlUtil.hasPattern(bLOB, byArray, l2)) == 0L ? -1L : l3;
        return l3;
    }

    @Override
    public long position(BLOB bLOB, BLOB bLOB2, long l2) throws SQLException {
        long l3;
        this.assertLoggedOn("position");
        this.assertNotNull(bLOB.shareBytes(), "position");
        this.assertNotNull(bLOB2.shareBytes(), "position");
        if (l2 < 1L) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
        }
        l3 = (l3 = LobPlsqlUtil.isSubLob(bLOB, bLOB2, l2)) == 0L ? -1L : l3;
        return l3;
    }

    @Override
    public synchronized int getBytes(BLOB bLOB, long l2, int n2, byte[] byArray) throws SQLException {
        this.assertLoggedOn("getBytes");
        this.assertNotNull(bLOB.shareBytes(), "getBytes");
        if (l2 < 1L) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "getBytes()");
        }
        if (n2 <= 0 || byArray == null) {
            return 0;
        }
        this.needLine();
        long l3 = 0L;
        if (n2 != 0) {
            try {
                l3 = this.blobMsg.read(bLOB.shareBytes(), l2, n2, byArray);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            }
        }
        return (int)l3;
    }

    @Override
    public synchronized int putBytes(BLOB bLOB, long l2, byte[] byArray, int n2, int n3) throws SQLException {
        this.assertLoggedOn("putBytes");
        this.assertNotNull(bLOB.shareBytes(), "putBytes");
        if (l2 < 1L) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "putBytes()");
        }
        if (byArray == null || n3 <= 0) {
            return 0;
        }
        this.needLine();
        long l3 = 0L;
        if (n3 != 0) {
            try {
                l3 = this.blobMsg.write(bLOB.shareBytes(), l2, byArray, n2, n3);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            }
        }
        return (int)l3;
    }

    @Override
    public synchronized int getChunkSize(BLOB bLOB) throws SQLException {
        this.assertLoggedOn("getChunkSize");
        this.assertNotNull(bLOB.shareBytes(), "getChunkSize");
        this.needLine();
        long l2 = 0L;
        try {
            l2 = this.blobMsg.getChunkSize(bLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
        return (int)l2;
    }

    @Override
    public synchronized void trim(BLOB bLOB, long l2) throws SQLException {
        this.assertLoggedOn("trim");
        this.assertNotNull(bLOB.shareBytes(), "trim");
        if (l2 < 0L) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "trim()");
        }
        this.needLine();
        try {
            this.blobMsg.trim(bLOB.shareBytes(), l2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    public synchronized BLOB createTemporaryBlob(Connection connection, boolean bl, int n2) throws SQLException {
        this.assertLoggedOn("createTemporaryBlob");
        this.needLine();
        BLOB bLOB = null;
        try {
            bLOB = (BLOB)this.blobMsg.createTemporaryLob(this, bl, n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
        return bLOB;
    }

    @Override
    public synchronized void freeTemporary(BLOB bLOB) throws SQLException {
        this.assertLoggedOn("freeTemporary");
        this.assertNotNull(bLOB.shareBytes(), "freeTemporary");
        this.needLine();
        try {
            this.blobMsg.freeTemporaryLob(bLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    public boolean isTemporary(BLOB bLOB) throws SQLException {
        boolean bl = false;
        byte[] byArray = bLOB.shareBytes();
        if ((byArray[7] & 1) > 0 || (byArray[4] & 0x40) > 0) {
            bl = true;
        }
        return bl;
    }

    @Override
    public synchronized void open(BLOB bLOB, int n2) throws SQLException {
        this.assertLoggedOn("open");
        this.assertNotNull(bLOB.shareBytes(), "open");
        this.needLine();
        try {
            this.blobMsg.open(bLOB.shareBytes(), n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    public synchronized void close(BLOB bLOB) throws SQLException {
        this.assertLoggedOn("close");
        this.assertNotNull(bLOB.shareBytes(), "close");
        this.needLine();
        try {
            this.blobMsg.close(bLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    public synchronized boolean isOpen(BLOB bLOB) throws SQLException {
        this.assertLoggedOn("isOpen");
        this.assertNotNull(bLOB.shareBytes(), "isOpen");
        this.needLine();
        boolean bl = false;
        try {
            bl = this.blobMsg.isOpen(bLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
        return bl;
    }

    @Override
    public InputStream newInputStream(BLOB bLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleBlobInputStream(bLOB, n2);
        }
        return new OracleBlobInputStream(bLOB, n2, l2);
    }

    @Override
    public InputStream newInputStream(BLOB bLOB, int n2, long l2, long l3) throws SQLException {
        return new OracleBlobInputStream(bLOB, n2, l2, l3);
    }

    @Override
    public OutputStream newOutputStream(BLOB bLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleBlobOutputStream(bLOB, n2);
        }
        return new OracleBlobOutputStream(bLOB, n2, l2);
    }

    @Override
    public InputStream newConversionInputStream(BLOB bLOB, int n2) throws SQLException {
        this.assertNotNull(bLOB.shareBytes(), "newConversionInputStream");
        OracleConversionInputStream oracleConversionInputStream = new OracleConversionInputStream(this.conversion, bLOB.getBinaryStream(), n2);
        return oracleConversionInputStream;
    }

    @Override
    public Reader newConversionReader(BLOB bLOB, int n2) throws SQLException {
        this.assertNotNull(bLOB.shareBytes(), "newConversionReader");
        OracleConversionReader oracleConversionReader = new OracleConversionReader(this.conversion, bLOB.getBinaryStream(), n2);
        return oracleConversionReader;
    }

    @Override
    public synchronized long length(CLOB cLOB) throws SQLException {
        this.assertLoggedOn("length");
        this.assertNotNull(cLOB.shareBytes(), "length");
        this.needLine();
        long l2 = 0L;
        try {
            l2 = this.clobMsg.getLength(cLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
        return l2;
    }

    @Override
    public long position(CLOB cLOB, String string, long l2) throws SQLException {
        if (string == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
        }
        this.assertLoggedOn("position");
        this.assertNotNull(cLOB.shareBytes(), "position");
        if (l2 < 1L) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        long l3 = LobPlsqlUtil.hasPattern(cLOB, cArray, l2);
        l3 = l3 == 0L ? -1L : l3;
        return l3;
    }

    @Override
    public long position(CLOB cLOB, CLOB cLOB2, long l2) throws SQLException {
        long l3;
        if (cLOB2 == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
        }
        this.assertLoggedOn("position");
        this.assertNotNull(cLOB.shareBytes(), "position");
        this.assertNotNull(cLOB2.shareBytes(), "position");
        if (l2 < 1L) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
        }
        l3 = (l3 = LobPlsqlUtil.isSubLob(cLOB, cLOB2, l2)) == 0L ? -1L : l3;
        return l3;
    }

    @Override
    public synchronized int getChars(CLOB cLOB, long l2, int n2, char[] cArray) throws SQLException {
        this.assertLoggedOn("getChars");
        this.assertNotNull(cLOB.shareBytes(), "getChars");
        if (l2 < 1L) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "getChars()");
        }
        if (n2 <= 0 || cArray == null) {
            return 0;
        }
        this.needLine();
        long l3 = 0L;
        if (n2 != 0) {
            try {
                boolean bl = cLOB.isNCLOB();
                l3 = this.clobMsg.read(cLOB.shareBytes(), l2, n2, bl, cArray);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            }
        }
        return (int)l3;
    }

    @Override
    public synchronized int putChars(CLOB cLOB, long l2, char[] cArray, int n2, int n3) throws SQLException {
        this.assertLoggedOn("putChars");
        this.assertNotNull(cLOB.shareBytes(), "putChars");
        if (l2 < 1L) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "putChars()");
        }
        if (cArray == null || n3 <= 0) {
            return 0;
        }
        this.needLine();
        long l3 = 0L;
        if (n3 != 0) {
            try {
                boolean bl = cLOB.isNCLOB();
                l3 = this.clobMsg.write(cLOB.shareBytes(), l2, bl, cArray, n2, n3);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            }
        }
        return (int)l3;
    }

    @Override
    public synchronized int getChunkSize(CLOB cLOB) throws SQLException {
        this.assertLoggedOn("getChunkSize");
        this.assertNotNull(cLOB.shareBytes(), "getChunkSize");
        this.needLine();
        long l2 = 0L;
        try {
            l2 = this.clobMsg.getChunkSize(cLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
        return (int)l2;
    }

    @Override
    public synchronized void trim(CLOB cLOB, long l2) throws SQLException {
        this.assertLoggedOn("trim");
        this.assertNotNull(cLOB.shareBytes(), "trim");
        if (l2 < 0L) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "trim()");
        }
        this.needLine();
        try {
            this.clobMsg.trim(cLOB.shareBytes(), l2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    public synchronized CLOB createTemporaryClob(Connection connection, boolean bl, int n2, short s2) throws SQLException {
        this.assertLoggedOn("createTemporaryClob");
        this.needLine();
        CLOB cLOB = null;
        try {
            cLOB = (CLOB)this.clobMsg.createTemporaryLob(this, bl, n2, s2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
        return cLOB;
    }

    @Override
    public synchronized void freeTemporary(CLOB cLOB) throws SQLException {
        this.assertLoggedOn("freeTemporary");
        this.assertNotNull(cLOB.shareBytes(), "freeTemporary");
        this.needLine();
        try {
            this.clobMsg.freeTemporaryLob(cLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    public boolean isTemporary(CLOB cLOB) throws SQLException {
        boolean bl = false;
        byte[] byArray = cLOB.shareBytes();
        if ((byArray[7] & 1) > 0 || (byArray[4] & 0x40) > 0) {
            bl = true;
        }
        return bl;
    }

    @Override
    public synchronized void open(CLOB cLOB, int n2) throws SQLException {
        this.assertLoggedOn("open");
        this.assertNotNull(cLOB.shareBytes(), "open");
        this.needLine();
        try {
            this.clobMsg.open(cLOB.shareBytes(), n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    public synchronized void close(CLOB cLOB) throws SQLException {
        this.assertLoggedOn("close");
        this.assertNotNull(cLOB.shareBytes(), "close");
        this.needLine();
        try {
            this.clobMsg.close(cLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    public synchronized boolean isOpen(CLOB cLOB) throws SQLException {
        this.assertLoggedOn("isOpen");
        this.assertNotNull(cLOB.shareBytes(), "isOpen");
        boolean bl = false;
        this.needLine();
        try {
            bl = this.clobMsg.isOpen(cLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
        return bl;
    }

    @Override
    public InputStream newInputStream(CLOB cLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleClobInputStream(cLOB, n2);
        }
        return new OracleClobInputStream(cLOB, n2, l2);
    }

    @Override
    public OutputStream newOutputStream(CLOB cLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleClobOutputStream(cLOB, n2);
        }
        return new OracleClobOutputStream(cLOB, n2, l2);
    }

    @Override
    public Reader newReader(CLOB cLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleClobReader(cLOB, n2);
        }
        return new OracleClobReader(cLOB, n2, l2);
    }

    @Override
    public Reader newReader(CLOB cLOB, int n2, long l2, long l3) throws SQLException {
        return new OracleClobReader(cLOB, n2, l2, l3);
    }

    @Override
    public Writer newWriter(CLOB cLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleClobWriter(cLOB, n2);
        }
        return new OracleClobWriter(cLOB, n2, l2);
    }

    void assertLoggedOn(String string) throws SQLException {
        if (!this.isLoggedOn) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 430);
        }
    }

    void assertNotNull(byte[] byArray, String string) throws NullPointerException {
        if (byArray == null) {
            throw new NullPointerException("bytes are null");
        }
    }

    @Override
    void internalClose() throws SQLException {
        super.internalClose();
        this.isLoggedOn = false;
    }

    @Override
    void doAbort() throws SQLException {
        try {
            this.net.abort();
        }
        catch (NetException netException) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), netException);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    protected void doDescribeTable(AutoKeyInfo autoKeyInfo) throws SQLException {
        T4CStatement t4CStatement = new T4CStatement(this, -1, -1);
        t4CStatement.open();
        String string = autoKeyInfo.getTableName();
        String string2 = "SELECT * FROM " + string;
        t4CStatement.sqlObject.initialize(string2);
        Accessor[] accessorArray = null;
        try {
            this.describe.init(t4CStatement, 0);
            this.describe.sqltext = t4CStatement.sqlObject.getSqlBytes(false, false);
            this.describe.marshal();
            accessorArray = this.describe.receive(accessorArray);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
        int n2 = this.describe.numuds;
        autoKeyInfo.allocateSpaceForDescribedData(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Accessor accessor = accessorArray[i2];
            String string3 = accessor.columnName;
            int n3 = accessor.describeType;
            int n4 = accessor.describeMaxLength;
            boolean bl = accessor.nullable;
            short s2 = accessor.formOfUse;
            int n5 = accessor.precision;
            int n6 = accessor.scale;
            String string4 = accessor.describeTypeName;
            autoKeyInfo.fillDescribedData(i2, string3, n3, n4, bl, s2, n5, n6, string4);
        }
        t4CStatement.close();
    }

    @Override
    void doSetApplicationContext(String string, String string2, String string3) throws SQLException {
        Namespace namespace = (Namespace)this.namespaces.get(string);
        if (namespace == null) {
            namespace = new Namespace(string);
            this.namespaces.put(string, namespace);
        }
        namespace.setAttribute(string2, string3);
    }

    @Override
    void doClearAllApplicationContext(String string) throws SQLException {
        Namespace namespace = new Namespace(string);
        namespace.clear();
        this.namespaces.put(string, namespace);
    }

    @Override
    public void getPropertyForPooledConnection(OraclePooledConnection oraclePooledConnection) throws SQLException {
        super.getPropertyForPooledConnection(oraclePooledConnection, this.password);
    }

    final void getPasswordInternal(T4CXAResource t4CXAResource) throws SQLException {
        t4CXAResource.setPasswordInternal(this.password);
    }

    @Override
    synchronized void doEnqueue(String string, AQEnqueueOptions aQEnqueueOptions, AQMessagePropertiesI aQMessagePropertiesI, byte[] byArray, byte[] byArray2, byte[][] byArray3, boolean bl) throws SQLException {
        try {
            this.needLine();
            this.sendPiggyBackedMessages();
            this.aqe.marshal(string, aQEnqueueOptions, aQMessagePropertiesI, byArray2, byArray, bl);
            this.aqe.receive(aQEnqueueOptions, byArray3);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    synchronized boolean doDequeue(String string, AQDequeueOptions aQDequeueOptions, AQMessagePropertiesI aQMessagePropertiesI, byte[] byArray, byte[][] byArray2, byte[][] byArray3, boolean bl) throws SQLException {
        boolean bl2 = false;
        try {
            this.needLine();
            this.sendPiggyBackedMessages();
            this.aqdq.marshal(string, aQDequeueOptions, byArray);
            bl2 = this.aqdq.receive(aQDequeueOptions, byArray2, aQMessagePropertiesI, byArray3, bl);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
        return bl2;
    }

    @Override
    synchronized int doPingDatabase() throws SQLException {
        if (this.versionNumber >= 10102) {
            try {
                this.needLine();
                this.sendPiggyBackedMessages();
                this.oping.marshal();
                this.oping.receive();
            }
            catch (IOException iOException) {
                return -1;
            }
            catch (SQLException sQLException) {
                return -1;
            }
            return 0;
        }
        return super.doPingDatabase();
    }

    @Override
    synchronized NTFAQRegistration[] doRegisterAQNotification(String[] stringArray, String string, int n2, Properties[] propertiesArray) throws SQLException {
        int n3;
        int n4 = stringArray.length;
        int[] nArray = new int[n4];
        byte[][] byArrayArray = new byte[n4][];
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[n4];
        int[] nArray4 = new int[n4];
        int[] nArray5 = new int[n4];
        int[] nArray6 = new int[n4];
        int[] nArray7 = new int[n4];
        int[] nArray8 = new int[n4];
        boolean bl = false;
        if (n2 == 0) {
            bl = true;
            n2 = 47632;
        }
        int[] nArray9 = new int[]{n2};
        boolean bl2 = PhysicalConnection.ntfManager.listenOnPortT4C(nArray9, bl);
        n2 = nArray9[0];
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray[i2] = PhysicalConnection.ntfManager.getNextJdbcRegId();
            byArrayArray[i2] = new byte[4];
            byArrayArray[i2][0] = (byte)((nArray[i2] & 0xFF000000) >> 24);
            byArrayArray[i2][1] = (byte)((nArray[i2] & 0xFF0000) >> 16);
            byArrayArray[i2][2] = (byte)((nArray[i2] & 0xFF00) >> 8);
            byArrayArray[i2][3] = (byte)(nArray[i2] & 0xFF);
            nArray2[i2] = 1;
            nArray3[i2] = 23;
            if (propertiesArray.length <= i2 || propertiesArray[i2] == null) continue;
            if (propertiesArray[i2].getProperty("NTF_QOS_RELIABLE", "false").compareToIgnoreCase("true") == 0) {
                int n5 = i2;
                nArray4[n5] = nArray4[n5] | 1;
            }
            if (propertiesArray[i2].getProperty("NTF_QOS_PURGE_ON_NTFN", "false").compareToIgnoreCase("true") == 0) {
                int n6 = i2;
                nArray4[n6] = nArray4[n6] | 0x10;
            }
            if (propertiesArray[i2].getProperty("NTF_AQ_PAYLOAD", "false").compareToIgnoreCase("true") == 0) {
                int n7 = i2;
                nArray4[n7] = nArray4[n7] | 2;
            }
            nArray5[i2] = this.readNTFtimeout(propertiesArray[i2]);
        }
        String string2 = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + string + ")(PORT=" + n2 + "))?PR=0";
        try {
            try {
                int n8 = bl2 ? 1 : 0;
                this.sendPiggyBackedMessages();
                this.okpn.marshal(1, n8, this.userName, string2, n4, nArray2, stringArray, byArrayArray, nArray3, nArray4, nArray5, nArray6, nArray7, nArray8);
                this.okpn.receive();
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            }
        }
        catch (SQLException sQLException) {
            if (bl2) {
                PhysicalConnection.ntfManager.cleanListenersT4C(n2);
            }
            throw sQLException;
        }
        NTFAQRegistration[] nTFAQRegistrationArray = new NTFAQRegistration[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nTFAQRegistrationArray[n3] = new NTFAQRegistration(nArray[n3], true, this.instanceName, this.userName, string, n2, propertiesArray[n3], stringArray[n3], this.versionNumber);
        }
        for (n3 = 0; n3 < nTFAQRegistrationArray.length; ++n3) {
            PhysicalConnection.ntfManager.addRegistration(nTFAQRegistrationArray[n3]);
        }
        return nTFAQRegistrationArray;
    }

    @Override
    synchronized void doUnregisterAQNotification(NTFAQRegistration nTFAQRegistration) throws SQLException {
        String string = nTFAQRegistration.getClientHost();
        int n2 = nTFAQRegistration.getClientTCPPort();
        if (string == null) {
            return;
        }
        PhysicalConnection.ntfManager.removeRegistration(nTFAQRegistration);
        PhysicalConnection.ntfManager.freeJdbcRegId(nTFAQRegistration.getJdbcRegId());
        PhysicalConnection.ntfManager.cleanListenersT4C(nTFAQRegistration.getClientTCPPort());
        nTFAQRegistration.setState(NotificationRegistration.RegistrationState.CLOSED);
        String string2 = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + string + ")(PORT=" + n2 + "))?PR=0";
        int[] nArray = new int[]{1};
        String[] stringArray = new String[]{nTFAQRegistration.getQueueName()};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        int[] nArray5 = new int[]{0};
        int[] nArray6 = new int[]{0};
        int[] nArray7 = new int[]{0};
        byte[][] byArrayArray = new byte[1][];
        int n3 = nTFAQRegistration.getJdbcRegId();
        byArrayArray[0] = new byte[4];
        byArrayArray[0][0] = (byte)((n3 & 0xFF000000) >> 24);
        byArrayArray[0][1] = (byte)((n3 & 0xFF0000) >> 16);
        byArrayArray[0][2] = (byte)((n3 & 0xFF00) >> 8);
        byArrayArray[0][3] = (byte)(n3 & 0xFF);
        try {
            this.sendPiggyBackedMessages();
            this.okpn.marshal(2, 0, this.userName, string2, 1, nArray, stringArray, byArrayArray, nArray2, nArray3, nArray4, nArray5, nArray6, nArray7);
            this.okpn.receive();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    synchronized NTFDCNRegistration doRegisterDatabaseChangeNotification(String string, int n2, Properties properties, int n3, int n4) throws SQLException {
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        if (n2 == 0) {
            bl = true;
            n2 = 47632;
        }
        int[] nArray = new int[]{n2};
        boolean bl2 = PhysicalConnection.ntfManager.listenOnPortT4C(nArray, bl);
        n2 = nArray[0];
        if (properties.getProperty("NTF_QOS_RELIABLE", "false").compareToIgnoreCase("true") == 0) {
            n6 |= 1;
        }
        if (properties.getProperty("NTF_QOS_PURGE_ON_NTFN", "false").compareToIgnoreCase("true") == 0) {
            n6 |= 0x10;
        }
        if (properties.getProperty("DCN_NOTIFY_ROWIDS", "false").compareToIgnoreCase("true") == 0) {
            n5 |= 0x10;
        }
        if (properties.getProperty("DCN_QUERY_CHANGE_NOTIFICATION", "false").compareToIgnoreCase("true") == 0) {
            n5 |= 0x20;
        }
        if (properties.getProperty("DCN_BEST_EFFORT", "false").compareToIgnoreCase("true") == 0) {
            n5 |= 0x40;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (properties.getProperty("DCN_IGNORE_INSERTOP", "false").compareToIgnoreCase("true") == 0) {
            bl3 = true;
        }
        if (properties.getProperty("DCN_IGNORE_UPDATEOP", "false").compareToIgnoreCase("true") == 0) {
            bl4 = true;
        }
        if (properties.getProperty("DCN_IGNORE_DELETEOP", "false").compareToIgnoreCase("true") == 0) {
            bl5 = true;
        }
        if (bl3 || bl4 || bl5) {
            n5 |= 0xF;
            if (bl3) {
                n5 -= 2;
            }
            if (bl4) {
                n5 -= 4;
            }
            if (bl5) {
                n5 -= 8;
            }
        }
        String string2 = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + string + ")(PORT=" + n2 + "))?PR=0";
        int[] nArray2 = new int[]{2};
        String[] stringArray = new String[1];
        int[] nArray3 = new int[]{23};
        int[] nArray4 = new int[]{n6};
        int[] nArray5 = new int[]{n3};
        int[] nArray6 = new int[]{n5};
        int[] nArray7 = new int[]{n4};
        int[] nArray8 = new int[]{0};
        int n7 = PhysicalConnection.ntfManager.getNextJdbcRegId();
        byte[][] byArrayArray = new byte[][]{new byte[4]};
        byArrayArray[0][0] = (byte)((n7 & 0xFF000000) >> 24);
        byArrayArray[0][1] = (byte)((n7 & 0xFF0000) >> 16);
        byArrayArray[0][2] = (byte)((n7 & 0xFF00) >> 8);
        byArrayArray[0][3] = (byte)(n7 & 0xFF);
        int n8 = 0;
        try {
            try {
                int n9 = bl2 ? 1 : 0;
                this.sendPiggyBackedMessages();
                this.okpn.marshal(1, n9, this.userName, string2, 1, nArray2, stringArray, byArrayArray, nArray3, nArray4, nArray5, nArray6, nArray7, nArray8);
                n8 = this.okpn.receive();
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            }
        }
        catch (SQLException sQLException) {
            if (bl2) {
                PhysicalConnection.ntfManager.cleanListenersT4C(n2);
            }
            throw sQLException;
        }
        NTFDCNRegistration nTFDCNRegistration = new NTFDCNRegistration(n7, true, this.instanceName, n8, this.userName, string, n2, properties, this.versionNumber);
        return nTFDCNRegistration;
    }

    @Override
    synchronized void doUnregisterDatabaseChangeNotification(int n2, String string, int n3) throws SQLException {
        if (string == null) {
            return;
        }
        String string2 = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + string + ")(PORT=" + n3 + "))?PR=0";
        int[] nArray = new int[]{2};
        String[] stringArray = new String[1];
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        int[] nArray5 = new int[]{0};
        int[] nArray6 = new int[]{0};
        int[] nArray7 = new int[]{n2};
        byte[][] byArrayArray = new byte[1][];
        try {
            this.sendPiggyBackedMessages();
            this.okpn.marshal(2, 0, null, string2, 1, nArray, stringArray, byArrayArray, nArray2, nArray3, nArray4, nArray5, nArray6, nArray7);
            this.okpn.receive();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    synchronized void doUnregisterDatabaseChangeNotification(NTFDCNRegistration nTFDCNRegistration) throws SQLException {
        PhysicalConnection.ntfManager.removeRegistration(nTFDCNRegistration);
        PhysicalConnection.ntfManager.freeJdbcRegId(nTFDCNRegistration.getJdbcRegId());
        PhysicalConnection.ntfManager.cleanListenersT4C(nTFDCNRegistration.getClientTCPPort());
        nTFDCNRegistration.setState(NotificationRegistration.RegistrationState.CLOSED);
        this.doUnregisterDatabaseChangeNotification(nTFDCNRegistration.getRegistrationId(), nTFDCNRegistration.getClientHost(), nTFDCNRegistration.getClientTCPPort());
    }

    @Override
    public synchronized byte[] createLightweightUserSession(String string, KeywordValue[] keywordValueArray, int n2, KeywordValue[][] keywordValueArray2, int[] nArray) throws SQLException {
        if (keywordValueArray2.length != 1 || nArray.length != 1) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
        }
        byte[] byArray = null;
        try {
            this.sendPiggyBackedMessages();
            this.oxsscs.marshal(string, keywordValueArray, n2);
            byte[][] byArrayArray = new byte[1][];
            this.oxsscs.receive(byArrayArray, keywordValueArray2, nArray);
            byArray = byArrayArray[0];
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
        return byArray;
    }

    @Override
    public synchronized void executeLightweightUserSessionFunction(int n2, byte[] byArray, KeywordValue[] keywordValueArray, int n3, KeywordValue[][] keywordValueArray2, int[] nArray) throws SQLException {
        if (keywordValueArray2.length != 1 || nArray.length != 1) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
        }
        try {
            this.sendPiggyBackedMessages();
            this.oxssso.marshal(n2, byArray, keywordValueArray, n3);
            this.oxssso.receive(keywordValueArray2, nArray);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    public synchronized void executeLightweightUserSessionAttributeFunction(int n2, byte[] byArray, String string, String string2, KeywordValue[] keywordValueArray, int n3) throws SQLException {
        if (this.lusOffset == this.lusFunctionId.length) {
            int n4 = this.lusFunctionId.length;
            int[] nArray = new int[n4 * 2];
            System.arraycopy(this.lusFunctionId, 0, nArray, 0, n4);
            byte[][] byArrayArray = new byte[n4 * 2][];
            System.arraycopy(this.lusSessionId, 0, byArrayArray, 0, n4);
            String[] stringArray = new String[n4 * 2];
            System.arraycopy(this.lusNamespace, 0, stringArray, 0, n4);
            String[] stringArray2 = new String[n4 * 2];
            System.arraycopy(this.lusAttributeName, 0, stringArray2, 0, n4);
            KeywordValue[][] keywordValueArrayArray = new KeywordValue[n4 * 2][];
            System.arraycopy(this.lusInKeyVal, 0, keywordValueArrayArray, 0, n4);
            int[] nArray2 = new int[n4 * 2];
            System.arraycopy(this.lusInFlags, 0, nArray2, 0, n4);
            this.lusFunctionId = nArray;
            this.lusSessionId = byArrayArray;
            this.lusNamespace = stringArray;
            this.lusAttributeName = stringArray2;
            this.lusInKeyVal = keywordValueArrayArray;
            this.lusInFlags = nArray2;
        }
        this.lusFunctionId[this.lusOffset] = n2;
        this.lusSessionId[this.lusOffset] = byArray;
        this.lusNamespace[this.lusOffset] = string;
        this.lusAttributeName[this.lusOffset] = string2;
        this.lusInKeyVal[this.lusOffset] = keywordValueArray;
        this.lusInFlags[this.lusOffset] = n3;
        ++this.lusOffset;
    }

    @Override
    public String getDataIntegrityAlgorithmName() throws SQLException {
        return this.net.getDataIntegrityName();
    }

    @Override
    public String getEncryptionAlgorithmName() throws SQLException {
        return this.net.getEncryptionName();
    }

    @Override
    public String getAuthenticationAdaptorName() throws SQLException {
        return this.net.getAuthenticationAdaptorName();
    }
}

