/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.beans.jxpath;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;

import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * commons-JXPath̃oO(JXPATH-152)ppb`ANeBx[gNXB
 * <p>
 * NX[h̃^C~OŁA
 * JXPathIntrospectoŕAĂprivate statictB[h(byClass, byInterface)HashMap
 * pb`IuWFNg({@link HashMapForJXPathIntrospector})ɍւB<br>
 * </p>
 * <p>
 * ̃ANeBx[^gpɂ́AAvP[VNɁÃNX[h([hĂȂƂɃ[h)KvB<br>
 * applicationContext.xmlɁAȉ̋Lqǉ邱ƂŁA\łB
 * <fieldset>
 * <legend>applicationContext.xml</legend>
 * &lt;bean id=&quot;jxpathPatchActivator&quot; class=&quot;jp.terasoluna.fw.beans.jxpath.JXPATH152PatchActivator&quot;/&gt;
 * </fieldset>
 * </p>
 * <p>
 * LF<br>
 * ̃NX́AJXPathIntrospectorprivate statictB[hɃANZX邽߁A
 * ZLeB}l[Wݒ肵Ăꍇɂ́A
 * privatetB[hւ̃ANZX(java.lang.reflect.ReflectPermissionsuppressAccessChecks)t^KvB<br>
 * ȂAprivatetB[hANZX͓[hŎs(ĂяõNX̌ႢꍇłÃNXɗ^ꂽŎs)߁A
 * ANZX̕t^Ώۂi肽ꍇ́Aȉ̗̂悤ɁA
 * ̃NX܂jart@Ĉ݂Ɍ肵privatetB[hւ̃ANZXt^΂悢B
 * <fieldset>
 * <legend>ZLeB|V[t@C̐ݒ(Tomcat̗)</legend>
 * <pre>
 * grant codeBase "file:${catalina.home}/webapps/ContextRoot/WEB-INF/lib/̃NX܂jart@C" {
 *     permission java.lang.reflect.ReflectPermission "suppressAccessChecks";
 * };
 * </pre>
 * </fieldset>
 * (ANZX̕t^ΏۂiKvꍇ́AucodeBase "file:`"v̕ȗB)<br>
 * ZLeB}l[WLsŃpb`ANeBx[głȂꍇA
 * commons-JXPath-1.3ƂJXPathIntrospector̎قȂo[Wcommons-JXPathgpȂǂ
 * pb`ANeBx[głȂꍇɂ́AFATALOo͂B<br>
 * AErrorȂApb`ANeBx[głȂĂAO̓X[ȂB<br>
 * āAErrorꍇApb`ANeBx[głȂꍇApb`ĂȂԂŃAvP[VpB
 * </p>
 * @see HashMapForJXPathIntrospector
 */
public class JXPATH152PatchActivator {

    /**
     * ONXB
     */
    private static final Log log = LogFactory.getLog(JXPATH152PatchActivator.class);

    static {
        // [hŎsB
        // (ĂяõNX̌ႢꍇłÃNXɗ^ꂽŎsB)
        AccessController.doPrivileged(new PrivilegedAction<Void>() {
            public Void run() {
                activate();
                return null;
            }
        });
    }

    /**
     * pb`ANeBx[gB
     */
    @SuppressWarnings("unchecked")
    private static void activate() {
        try {
            // ƂƎgpĂMapIuWFNg擾
            Field byClassField = JXPathIntrospector.class
                    .getDeclaredField("byClass");
            byClassField.setAccessible(true);
            Map byClass = (Map) byClassField.get(null);

            Field byInterfaceField = JXPathIntrospector.class
                    .getDeclaredField("byInterface");
            byInterfaceField.setAccessible(true);
            Map byInterface = (Map) byInterfaceField.get(null);

            // MapIuWFNgւ
            byClassField.set(null, new HashMapForJXPathIntrospector(byClass));
            byInterfaceField.set(null, new HashMapForJXPathIntrospector(
                    byInterface));

            log.info("JXPATH-152 Patch activation succeeded.");
        } catch (Exception e) {
            // ZLeB}l[W̐ɂOA
            // z肵ĂȂo[Wcommons-JXPathgpƂɂO
            log.fatal("JXPATH-152 Patch activation failed.", e);
        }
    }
}
