/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * <p>
 *  <code>date</code>^O̎NXB
 * </p>
 * <p>
 *  <code>pattern</code> ɂĎw肳ꂽ`ɏ]
 *  tEtH[}bgB
 *  <code>DateTag</code> NXł́A<code>pattern</code> Ŏw肳ꂽ
 *  o͌`̕ <code>java.text.SimpleDateFormat</code> NX
 *  <em>p^[</em>Ƃĉ߂AtH[}bgB
 *  p^[̏ڍׂɂẮA<code>java.text.SimpleDateFormat</code>
 *  NX̃hLgQƂ̂ƁB
 * </p>
 *
 * <br>
 *
 * <h5>^OT|[g鑮</h5>
 * <p>{@link DateFormatterTagBase} QƁB</p>
 *
 * <br>
 *
 * <h5>JX^^ÕXNveBOϐ</h5>
 * <p>{@link DateFormatterTagBase} QƁB</p>
 *
 * <br>
 *
 * <h5>gp@</h5>
 * <li>
 *  <code>&quot;form0001&quot;</code> bean
 *  <code>&quot;field001&quot;</code> vpeB̒lw肵`ɃtH[}bg
 *  ďo͂B
 * </li>
 * <p><code><pre>
 *  &lt;t:date name="form0001"
 *             property="field001"
 *             pattern="yyyyy.MMMMM.dd GGG hh:mm aaa" /&gt;
 * =&gt 1996.July.10 AD 12:08 PM
 * </pre></code></p>
 * <br>
 * <li>
 *  L beañvpeBAo͂ɃXNveBOϐ
 *  <code>&quot;formatted&quot;</code>փZbgB
 * </li>
 * <p><code><pre>
 *  &lt;t:date id="formatted"
 *             name="form0001"
 *             property="field001"
 *             pattern="yyyyy.MMMMM.dd GGG hh:mm aaa" /&gt;
 * </pre></code></p>
 * <br>
 * <li>
 *  tH[}bgtf[^ <code>bean</code> oɁA
 *  ^O <code>value</code>ɂĎw肷ꍇB
 * </li>
 * <p><code><pre>
 *  &lt;t:date value="2002/07/25 04:56:23"
 *             pattern="yyyyy.MMMMM.dd GGG hh:mm aaa" /&gt;
 * </pre></code></p>
 *
 * @see java.text.SimpleDateFormat
 * @see jp.terasoluna.fw.web.taglib.DateFormatterTagBase
 *
 */
public class DateTag extends DateFormatterTagBase {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = -9087010541359988539L;

    /**
     * <code>pattern</code> Ŏw肳ꂽ <code>SimpleDateFormat</code>
     * `̃tH[}bgɏ]āAw肳ꂽtf[^tH[}bgB
     *
     * @param date tf[^
     * @return <code>pattern</code> Ŏw肳ꂽo͌`̕
     */
    @Override
    protected String doFormat(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

}
