/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.form;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

import javax.servlet.http.HttpServletRequest;

import jp.terasoluna.fw.beans.IndexedBeanWrapper;
import jp.terasoluna.fw.beans.JXPathIndexedBeanWrapperImpl;
import jp.terasoluna.fw.util.ClassLoadException;
import jp.terasoluna.fw.util.ClassUtil;
import jp.terasoluna.fw.util.PropertyUtil;

import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.GenericTypeValidator;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.RequestUtils;
import org.apache.struts.validator.FieldChecks;
import org.apache.struts.validator.Resources;
import org.apache.struts.validator.validwhen.ValidWhen;

/**
 * <code>Validator</code> ǉ[NXB
 * 
 * <p>
 * <code>Struts</code>񋟂 {@link FieldChecks} g̓`FbNNXB<br>
 * {@link FieldChecksEx} ̊g[ƂẮAȉ̂̂B
 * </p>
 * <table border="1">
 * <tr>
 * <td><center><b>ؖ</b></center></td>
 * <td><center><b>NCAg`FbN</b></center></td>
 * <td><center><b>\bh</b></center></td>
 * <td><center><b>(validation-rules.xmlɋLq) [</b></center></td>
 * <td><center><b>Tv</b></center></td>
 * </tr>
 * <tr>
 * <td>p`FbN</td>
 * <td><center></center></td>
 * <td>{@link #validateAlphaNumericString(Object, ValidatorAction, Field,
 * ActionMessages, Validator, HttpServletRequest) validateAlphaNumericString()}</td>
 * <td><code>alphaNumericString</code></td>
 * <td>tB[hlpp݂̂ō\Ă邩ǂ`FbNB</td>
 * </tr>
 * <tr>
 * <td>啶p`FbN</td>
 * <td><center></center></td>
 * <td>{@link #validateCapAlphaNumericString(Object, ValidatorAction, Field,
 * ActionMessages, Validator, HttpServletRequest)
 * validateCapAlphaNumericString()}</td>
 * <td><code>capAlphaNumericString</code></td>
 * <td>l啶̔pp݂̂ō\Ă邩ǂ`FbNB </td>
 * </tr>
 * <tr>
 * <td>tB[hl`FbN</td>
 * <td><center></center></td>
 * <td>{@link #validateNumber(Object, ValidatorAction, Field, ActionMessages,
 * Validator, HttpServletRequest) validateNumber()}</td>
 * <td><code>number</code></td>
 * <td>tB[hllł邱Ƃ`FbNB</td>
 * </tr>
 * <tr>
 * <td>pJi`FbN</td>
 * <td><center></center></td>
 * <td>{@link #validateHankakuKanaString(Object, ValidatorAction, Field,
 * ActionMessages, Validator, HttpServletRequest) validateHankakuKanaString()}</td>
 * <td><code>hankakuKanaString</code></td>
 * <td>tB[hlpJî݂ō\Ă邱Ƃ`FbNB</td>
 * </tr>
 * <tr>
 * <td>p`FbN</td>
 * <td><center></center></td>
 * <td>{@link #validateHankakuString(Object, ValidatorAction, Field,
 * ActionMessages, Validator, HttpServletRequest) validateHankakuString()}</td>
 * <td><code>hankakuString</code></td>
 * <td>tB[hlp݂̂̕ō\Ă邱Ƃ`FbNB</td>
 * </tr>
 * <tr>
 * <td>Sp`FbN</td>
 * <td><center></center></td>
 * <td>{@link #validateZenkakuString(Object, ValidatorAction, Field,
 * ActionMessages, Validator, HttpServletRequest) validateZenkakuString()}</td>
 * <td><code>zenkakuString</code></td>
 * <td>tB[hlSp݂̂̕ō\Ă邱Ƃ`FbNB</td>
 * </tr>
 * <tr>
 * <td>SpJi`FbN</td>
 * <td><center></center></td>
 * <td>{@link #validateZenkakuKanaString(Object, ValidatorAction, Field,
 * ActionMessages, Validator, HttpServletRequest) validateZenkakuKanaString()}</td>
 * <td><code>zenkakuKanaString</code></td>
 * <td>tB[hlSpJî݂ō\Ă邱Ƃ`FbNB</td>
 * </tr>
 * <tr>
 * <td>͋֎~`FbN</td>
 * <td><center>~</center></td>
 * <td>{@link #validateProhibited(Object, ValidatorAction, Field,
 * ActionMessages, Validator, HttpServletRequest) validateProhibited()}</td>
 * <td><code>prohibited</code></td>
 * <td>tB[hlɓ͋֎~܂܂ĂȂƂ`FbNB</td>
 * </tr>
 * <tr>
 * <td>񒷈v`FbN</td>
 * <td><center></center></td>
 * <td>{@link #validateStringLength(Object, ValidatorAction, Field,
 * ActionMessages, Validator, HttpServletRequest) validateStringLength()}</td>
 * <td><code>stringLength</code></td>
 * <td>tB[hlw肵񒷂ƈv邱Ƃ`FbNB</td>
 * </tr>
 * <tr>
 * <td>`FbN</td>
 * <td><center></center></td>
 * <td>{@link #validateNumericString(Object, ValidatorAction, Field,
 * ActionMessages, Validator, HttpServletRequest) validateNumericString()}</td>
 * <td><code>numericString</code></td>
 * <td>tB[hl݂̂ō\Ă邱Ƃ`FbNB</td>
 * </tr>
 * <tr>
 * <td>oCg񒷃`FbN</td>
 * <td><center>~</center></td>
 * <td>{@link #validateByteLength(Object, ValidatorAction, Field,
 * ActionMessages, Validator, HttpServletRequest) validateByteLength()}</td>
 * <td><code>byteLength</code></td>
 * <td>tB[hl̃oCg񒷂w肵ƈv邱Ƃ`FbNB</td>
 * </tr>
 * <tr>
 * <td>oCg͈̓`FbN</td>
 * <td><center>~</center></td>
 * <td>{@link #validateByteRange(Object, ValidatorAction, Field,
 * ActionMessages, Validator, HttpServletRequest) validateByteRange()}</td>
 * <td><code>byteRange</code></td>
 * <td>tB[hl̃oCg񒷂w肵͈͈ȓł邱Ƃ`FbNB</td>
 * </tr>
 * <tr>
 * <td>t͈̓`FbN</td>
 * <td><center></center></td>
 * <td>{@link #validateDateRange(Object, ValidatorAction, Field,
 * ActionMessages, Validator, HttpServletRequest) validateDateRange()}</td>
 * <td><code>dateRange</code></td>
 * <td>tB[hl̓tw肵͈͈ȓł邱Ƃ`FbNB</td>
 * </tr>
 * <tr>
 * <td>tB[h`FbN</td>
 * <td><center>~</center></td>
 * <td>{@link #validateMultiField(Object, ValidatorAction, Field,
 * ActionMessages, Validator, HttpServletRequest) validateMultiField()}</td>
 * <td><code>multiField</code></td>
 * <td>tB[hԂ̑փ`FbNB</td>
 * </tr>
 * <tr>
 * <td>zERNV^tB[hSvf`FbN</td>
 * <td><center>~</center></td>
 * <td>{@link #validateArraysIndex(Object, ValidatorAction, Field,
 * ActionMessages, Validator, HttpServletRequest) validateArraysIndex()}</td>
 * <td>(<code>validation.xml</code> <code>&lt;depend&gt;</code>vfŌ)</td>
 * <td>dependsŎw肳ꂽ̓`FbNzERNV^̃tB[hl ̑SĂ̒lɑ΂ă`FbNsB</td>
 * </tr>
 * </ul>
 * </table>
 * <p>
 * tB[h`FbN̏ڍׂɂẮAe\bh̐QƁB<br>
 * gValidator𗘗p邽߂ɂ́AANV ؓeLq`t@C( <code>validation.xml</code> )
 * 쐬KvB
 * </p>
 * <p>K{`FbNȊÕ`FbN[ł́A
 * pXy[X݂̂̕񂪓͒lƂēnĂꍇAG[Ɣ肳ȂB
 * G[Ƃꍇ͕K{`FbNƑgݍ킹邩A
 * pXy[X̃`FbNǉ邱ƁB</p>
 * 
 * <h5>P̂̃tB[h</h5>
 * <p>
 * <code>&lt;formset&gt;</code>^O <code>&lt;form&gt;</code> vf
 * <code>name</code> ɁA <code>struts-config.xml</code>Œ`Ă
 * ANṼpXLqB<br>
 * LqȂꍇ́AYANVpX̌؂͈؍sȂB <code>&lt;field&gt;</code>vf
 * <code>property</code> ɁA Ώۂ̃tB[hA<code>depends</code>
 * <code>validation-rules.xml</code>Œ`Ă ؃[LqB
 * ЂƂ̃tH[ɕ̌؂sꍇiK{́AȂǁj́A J}؂ŋLqĂB<br>
 * Ao͂G[bZ[W͂PtB[hɑ΂A P݂̂łB iK{́A`FbN̗ɈᔽĂꍇAǂꂩP
 * G[o͂Ȃj
 * </p>
 * <h5>validation.xml̋LqiP̃tB[h؁j</h5>
 * <code><pre>
 *  &lt;formset&gt;
 *    EEE
 *    &lt;!-- P̂̃tB[h --&gt;
 *    &lt;form name=&quot;/logon&quot;&gt;
 *      &lt;field property=&quot;companyId&quot;
 *          depends=&quot;required,alphaNumericString,maxlength&quot;&gt;
 *        &lt;arg0 key=&quot;logon.companyId&quot;/&gt;
 *        &lt;arg1 key=&quot;${var:maxlength}&quot; resource=&quot;false&quot;/&gt;
 *        &lt;var&gt;
 *          &lt;var-name&gt;maxlength&lt;/var-name&gt;
 *          &lt;var-value&gt;10&lt;/var-value&gt;
 *        &lt;/var&gt;
 *      &lt;/field&gt;
 *    &lt;/form&gt;
 *    EEE
 *  &lt;/formset&gt;
 * </pre></code>
 * <h5>zERNV^̈ꗗ</h5>
 * <p>
 * zERNV^̈ꗗ؂́AL̓_gĂB
 * <ul>
 * <li>ΏۃtB[h̔zERNVvfɑ΂ArŃG[ ԋpĂŌ̗vf܂Ō؂s</li>
 * <li>evf̃CfbNXԍG[bZ[Wɔfł</li>
 * </ul>
 * {Iɂ͒P̃tB[h؂Ɠl<code>validation.xml</code> <code>&lt;form&gt;</code>
 * vf쐬邪A zERNV^̈ꗗ؂s߂ɂ́AL̐ݒ肪KvłB
 * <ol>
 * <li>zERNV^̈ꗗ\ɂ́A<b>K <code>property</code> ŃtH[̃tB[hw肷</b>B܂vpeBɂ
 * JXPathIndexedBeanWrapperImpl̎dlɏ]AlXgvpeB w肷邱Ƃ\łB</li>
 * <li><code>&lt;depends&gt;</code>Ŏw肷郋[́A
 * <code>validation-rules.xml</code>  <code>Array</code> ł郋[pB</li>
 * <li>؂tH[FormExC^tF[X ĂKvB</li>
 * </li>
 * </ol>
 * zERNV^̈ꗗ؂ɑΉ郋[͈ȉ̒ʂłB
 * <ul>
 * <li><code>requiredArray</code></li>
 * <li><code>minLengthArray</code></li>
 * <li><code>maxLengthArray</code></li>
 * <li><code>maskArray</code></li>
 * <li><code>byteArray</code></li>
 * <li><code>shortArray</code></li>
 * <li><code>integerArray</code></li>
 * <li><code>longArray</code></li>
 * <li><code>floatArray</code></li>
 * <li><code>doubleArray</code></li>
 * <li><code>dateArray</code></li>
 * <li><code>intRangeArray</code></li>
 * <li><code>doubleRangeArray</code></li>
 * <li><code>floatRangeArray</code></li>
 * <li><code>creditCardArray</code></li>
 * <li><code>emailArray</code></li>
 * <li><code>urlArray</code></li>
 * <li><code>alphaNumericStringArray</code></li>
 * <li><code>hankakuKanaStringArray</code></li>
 * <li><code>hankakuStringArray</code></li>
 * <li><code>zenkakuStringArray</code></li>
 * <li><code>zenkakuKanaStringArray</code></li>
 * <li><code>capAlphaNumericStringArray</code></li>
 * <li><code>numberArray</code></li>
 * <li><code>numericStringArray</code></li>
 * <li><code>prohibitedArray</code></li>
 * <li><code>stringLengthArray</code></li>
 * <li><code>dateRangeArray</code></li>
 * <li><code>byteLengthArray</code></li>
 * <li><code>byteRangeArray</code></li>
 * </ul>
 * </p>
 * <h5>validation.xml̋LqizERNV^ꗗ\̌؁j</h5>
 * <code><pre>
 *  &lt;formset&gt;
 *    EEE
 *    &lt;!-- zERNV^ꗗ\̌؊mF --&gt;
 *    &lt;form name=&quot;/isValid&quot;&gt;
 *      &lt;field property=&quot;codeArray&quot;
 *          depends=&quot;requiredArray,alphaNumericStringArray&quot;&gt;
 *        &lt;arg0 &lt;b&gt;key=&quot;##INDEX&quot; resource=&quot;false&quot;&lt;/b&gt;/&gt;
 *        &lt;arg1 key=&quot;sampleValidate.codeArray&quot;/&gt;
 *      &lt;/field&gt;
 *    &lt;/form&gt;
 *    EEE
 *  &lt;/formset&gt;
 * </pre></code>
 * <p>
 * zERNV^̃CfbNXԍG[bZ[W ߍނ߂ɂ́A<code>&lt;arg0`3&gt;</code>vf̉ꂩ
 * <code>key</code> <code>&quot;##INDEX&quot;</code> Ƃw肵A<code>&lt;resource&gt;</code>
 * vf <code>&quot;false&quot;</code> ɂB<br>
 * P̂̃tB[h؂ƓlA<code>&lt;depends&gt;</code>
 * ŕ̌؂sꍇJ}؂ŕ̌؃[włB<br>
 * <code>Validator</code> t[[N𗘗ptH[́A <code>
 * {@link DynaValidatorActionFormEx}
 * </code>A
 * <code>
 * {@link ValidatorActionFormEx}
 * </code> QƁB
 * </p>
 * 
 * @see jp.terasoluna.fw.web.struts.form.FormEx
 * @see jp.terasoluna.fw.web.struts.form.DynaValidatorActionFormEx
 * @see jp.terasoluna.fw.web.struts.form.ValidatorActionFormEx
 * @see jp.terasoluna.fw.beans.JXPathIndexedBeanWrapperImpl
 * 
 */
public class FieldChecksEx extends FieldChecks {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = -5669122584668175380L;

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(FieldChecksEx.class);

    /**
     * zCfbNX^tB[hIndexlB
     */
    public static final String INDEX = "##INDEX";

    /**
     * pJiłB<code>ApplicationResources</code> t@Cɒ`B
     */
    protected static String hankakuKanaList = "¯֬ܦް";

    /**
     * SpJiB<code>ApplicationResources</code> t@Cɒ`B
     */
    protected static String zenkakuKanaList = "ACEGI@BDFHJLNPRKMOQSTVXZ\"
            + "UWY[]^`ceg_adfhijklmnqtwz" + "orux{psvy|}~"
            + "b[";

    /**
     * <code>ApplicationResources</code> t@Cɒ`ꂽpe[u擾L[B
     */
    protected static final String HANKAKU_KANA_LIST_KEY = "validation.hankaku.kana.list";

    /**
     * <code>ApplicationResources</code> t@Cɒ`ꂽSpe[u擾L[B
     */
    protected static final String ZENKAKU_KANA_LIST_KEY = "validation.zenkaku.kana.list";

    /**
     * UNICODER[h'\u0000''\u00ff'͈͓̔ɑ݂ SpB
     */
    protected static final String ZENKAKU_BEGIN_U00_LIST = "_Nʁ}L~";

    static {
        String value = null;
        // pJie[u擾
        value = PropertyUtil.getProperty(HANKAKU_KANA_LIST_KEY);
        if (value != null) {
            hankakuKanaList = value;
        }

        // SpJie[u擾
        value = PropertyUtil.getProperty(ZENKAKU_KANA_LIST_KEY);
        if (value != null) {
            zenkakuKanaList = value;
        }
    }

    /**
     * w肳ꂽpJił邱Ƃ`FbNB
     * 
     * @param c
     *            
     * @return pJił <code>true</code>
     */
    protected static boolean isHankakuKana(char c) {
        return hankakuKanaList.indexOf(c) >= 0;
    }

    /**
     * w肳ꂽpł邱Ƃ`FbNB
     * 
     * @param c
     *            
     * @return pł <code>true</code>
     */
    protected static boolean isHankaku(char c) {
        return (c <= '\u00ff' && ZENKAKU_BEGIN_U00_LIST.indexOf(c) < 0)
                || isHankakuKana(c);
    }

    /**
     * w肳ꂽSpł邱Ƃ`FbNB
     * 
     * @param c
     *            
     * @return Spł <code>true</code>
     */
    protected static boolean isZenkaku(char c) {
        return !isHankaku(c);
    }

    /**
     * w肳ꂽSpJił邱Ƃ`FbNB
     * 
     * @param c
     *            
     * @return SpJił <code>true</code>
     */
    protected static boolean isZenkakuKana(char c) {
        return zenkakuKanaList.indexOf(c) >= 0;
    }

    /**
     * w肳ꂽtB[hpł邱Ƃ`FbNB
     * 
     * <p>
     * G[ƂȂꍇɂ́AG[𐶐A w肳ꂽG[񃊃XgɒǉB G[bZ[W̃tH[}bǵA<code>validation-rules.xml</code>
     * ɋLqB
     * </p>
     * 
     * @param bean
     *            Ώۂ̃IuWFNg
     * @param va
     *            StrutsɂpӂꂽValidatorAction
     * @param field
     *            tB[hIuWFNg
     * @param errors
     *            ActionMessages ANVG[
     * @param validator
     *            ValidatorCX^X
     * @param request
     *            HTTPNGXg
     * @return ͒l <code>true</code>
     */
    public static boolean validateAlphaNumericString(Object bean,
            ValidatorAction va, Field field, ActionMessages errors,
            Validator validator, HttpServletRequest request) {
        // tB[h̃N[쐬
        Field fieldClone = (Field) field.clone();
        fieldClone.addVar("mask", "^[0-9a-zA-Z]*$", "false");
        // pl`FbNs
        return validateMask(bean, va, fieldClone, errors, validator, request);
    }

    /**
     * w肳ꂽtB[h啶pł邱Ƃ`FbNB
     * 
     * <p>
     * G[ƂȂꍇɂ́AG[𐶐A w肳ꂽG[񃊃XgɒǉB G[bZ[W̃tH[}bǵA<code>validation-rules.xml</code>
     * ɋLqB
     * </p>
     * 
     * @param bean
     *            Ώۂ̃IuWFNg
     * @param va
     *            StrutsɂpӂꂽValidatorAction
     * @param field
     *            tB[hIuWFNg
     * @param errors
     *            ActionMessages ANVG[
     * @param validator
     *            ValidatorCX^X
     * @param request
     *            HTTPNGXg
     * @return ͒l <code>true</code>
     */
    public static boolean validateCapAlphaNumericString(Object bean,
            ValidatorAction va, Field field, ActionMessages errors,
            Validator validator, HttpServletRequest request) {

        // tB[h̃N[쐬
        Field fieldClone = (Field) field.clone();
        fieldClone.addVar("mask", "^[0-9A-Z]*$", "false");
        // pl`FbNs
        return validateMask(bean, va, fieldClone, errors, validator, request);
    }

    /**
     * w肳ꂽtB[hlł邱Ƃ`FbNB
     * 
     * ܂A͂ꂽpA<code>BigDecimal</code> ^𐶐
     * Ős\Ȃ΃G[pActionMessage쐬A<code>false</code> ԋpB
     * 
     * ɐ̌w肳ĂꍇɁÅmFsB <code>validation.xml</code> 
     * <code>isAccordedInteger()</code>  <code>"true"</code> w肳Ăꍇ̂
     * ̓`FbNsB `FbNɈꍇ́AG[pActionMessage쐬AfalseԋpB
     * 
     * Ōɏ̌w肳ĂꍇɁÅmFsB
     * validation.xmlisAccordedScale"true"łꍇ̂ ̓`FbNsB
     * 
     * <p>
     * G[ƂȂꍇɂ́AG[𐶐A w肳ꂽG[񃊃XgɒǉB G[bZ[W̃tH[}bǵA<code>validation-rules.xml</code>
     * ɋLqB<br>
     * ĹA3A2ł鐔l؂łB
     * </p>
     * 
     * <h5>validation.xml̋Lq</h5>
     * <code><pre>
     * &lt;form name=&quot;/sample&quot;&gt;
     *  EEE
     *  &lt;field property=&quot;escape&quot;
     *      depends=&quot;number&quot;&gt;
     *    &lt;arg0 key=&quot;sample.escape&quot;/&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;integerLength&lt;/var-name&gt;
     *      &lt;var-value&gt;3&lt;/var-value&gt;
     *    &lt;/var&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;scale&lt;/var-name&gt;
     *      &lt;var-value&gt;2&lt;/var-value&gt;
     *    &lt;/var&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;isAccordedInteger&lt;/var-name&gt;
     *      &lt;var-value&gt;true&lt;/var-value&gt;
     *    &lt;/var&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;isAccordedScale&lt;/var-name&gt;
     *      &lt;var-value&gt;true&lt;/var-value&gt;
     *    &lt;/var&gt;
     *  &lt;/field&gt;
     *  EEE
     * &lt;/form&gt;
     * </pre></code>
     * <h5>validation.xmlɐݒv&lt;var&gt;vf</h5>
     * <table border="1">
     * <tr>
     * <td><center><b><code>var-name</code></b></center></td>
     * <td><center><b><code>var-value</code></b></center></td>
     * <td><center><b>K{</b></center></td>
     * <td><center><b>Tv</b></center></td>
     * </tr>
     * <tr>
     * <td> <code>integerLength</code> </td>
     * <td>  </td>
     * <td> <code>false</code> </td>
     * <td>̌ݒ肷A<code>isAccordedInteger</code>w肪
     * Ƃ́Aw茅ȓ̌؂sBȗA܂͔񐔒l ݒ肵Ƃ́A؂sȂȂB</td>
     * </tr>
     * <tr>
     * <td> <code>scale</code> </td>
     * <td>  </td>
     * <td> <code>false</code> </td>
     * <td>ľݒ肷A<code>isAccordedScale</code>w肪
     * Ƃ́Aw茅ȓ̌؂sBȗA܂͔񐔒l ݒ肵Ƃ́A؂sȂȂB</td>
     * </tr>
     * <tr>
     * <td> <code>isAccordedInteger</code> </td>
     * <td> v`FbN </td>
     * <td> <code>false</code> </td>
     * <td> <code>true</code>w肳ꂽƂÄv`FbN sȂBȗA<code>true</code>ȊO̕񂪐ݒ肳ꂽ
     * ȓ`FbNƂȂB</td>
     * </tr>
     * <tr>
     * <td> <code>isAccordedScale</code> </td>
     * <td> v`FbN </td>
     * <td> <code>false</code> </td>
     * <td> <code>true</code>w肳ꂽƂÄv`FbN sȂBȗA<code>true</code>ȊO̕񂪐ݒ肳ꂽ
     * ȓ`FbNƂȂB</td>
     * </tr>
     * </table>
     * 
     * @param bean
     *            Ώۂ̃IuWFNg
     * @param va
     *            StrutsɂpӂꂽValidatorAction
     * @param field
     *            tB[hIuWFNg
     * @param errors
     *            ActionMessages ANVG[
     * @param validator
     *            ValidatorCX^X
     * @param request
     *            HTTPNGXg
     * @return ͒l <code>true</code>
     */
    public static boolean validateNumber(Object bean, ValidatorAction va,
            Field field, ActionMessages errors, Validator validator,
            HttpServletRequest request) {

        // beannull̎AG[Oo͂AtrueԋpB
        if (bean == null) {
            log.error("bean is null.");
            return true;
        }
        // 擾
        String integerLength = field.getVarValue("integerLength");
        // 擾
        String scaleStr = field.getVarValue("scale");
        // v`FbN
        String isAccordedInteger = field.getVarValue("isAccordedInteger");
        // v`FbN
        String isAccordedScale = field.getVarValue("isAccordedScale");

        String value = null;
        if (isString(bean)) {
            value = (String) bean;
        } else {
            value = ValidatorUtils.getValueAsString(bean, field.getProperty());
        }
        // ؒlnull܂͋󕶎̎Atrueԋp
        if (GenericValidator.isBlankOrNull(value)) {
            return true;
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; i++) {
            if (!isHankaku(chars[i])) {
                errors.add(field.getKey(), Resources.getActionMessage(
                        validator, request, va, field));
                return false;
            }
        }
        // w肳ĂꍇA`FbNs
        if (GenericValidator.isInt(integerLength)) {
            try {
                BigDecimal bd = new BigDecimal(value);
                // Βl̂ݒo
                BigInteger bi = bd.toBigInteger().abs();
                // 
                int length = bi.toString().length();
                // validation.xmlŎw肳ꂽ
                int checkLength = Integer.valueOf(integerLength).intValue();
                // I[óAfalseԋp
                if (length > checkLength) {
                    errors.add(field.getKey(), Resources.getActionMessage(
                            validator, request, va, field));
                    return false;
                }
                // vw肳ĂƂ
                if (isAccordedInteger != null
                        && "true".equals(isAccordedInteger)) {
                    // sv́Afalseԋp
                    if (length != checkLength) {
                        errors.add(field.getKey(), Resources.getActionMessage(
                                validator, request, va, field));
                        return false;
                    }
                }
            } catch (NumberFormatException nfe) {
                // l^ɕϊłȂAfalseԋp
                errors.add(field.getKey(), Resources.getActionMessage(
                        validator, request, va, field));
                return false;
            }
        }

        // w肳ĂꍇA`FbNs
        if (GenericValidator.isInt(scaleStr)) {
            int scale = 0;
            int checkScale = 0;
            try {
                BigDecimal bd = new BigDecimal(value);
                scale = bd.scale();
                // validation.xmlŎw肳ꂽ
                checkScale = Integer.valueOf(scaleStr).intValue();
            } catch (NumberFormatException e) {
                // l^ɕϊłȂAfalseԋp
                errors.add(field.getKey(), Resources.getActionMessage(
                        validator, request, va, field));
                return false;
            }
            // I[óAfalseԋp
            if (scale > checkScale) {
                errors.add(field.getKey(), Resources.getActionMessage(
                        validator, request, va, field));
                return false;
            }
            // vw肳ĂƂ
            if (isAccordedScale != null && "true".equals(isAccordedScale)) {
                // sv́Afalseԋp
                if (scale != checkScale) {
                    errors.add(field.getKey(), Resources.getActionMessage(
                            validator, request, va, field));
                    return false;
                }
            }
        }
        return true;
    }

    /**
     * w肳ꂽtB[hpJił邱Ƃ`FbNB
     * 
     * <p>
     * G[ƂȂꍇɂ́AG[𐶐A w肳ꂽG[񃊃XgɒǉB G[bZ[W̃tH[}bǵA<code>validation-rules.xml</code>
     * ɋLqB
     * </p>
     * 
     * @param bean
     *            Ώۂ̃IuWFNg
     * @param va
     *            <code>Validator</code>ɂpӂꂽ <code>ValidatorAction</code>
     * @param field
     *            tB[hIuWFNg
     * @param errors
     *            ActionMessages ANVG[
     * @param validator
     *            ValidatorCX^X
     * @param request
     *            HTTPNGXg
     * @return ͒l <code>true</code>
     */
    public static boolean validateHankakuKanaString(Object bean,
            ValidatorAction va, Field field, ActionMessages errors,
            Validator validator, HttpServletRequest request) {

        // beannull̎AG[Oo͂AtrueԋpB
        if (bean == null) {
            log.error("bean is null.");
            return true;
        }
        String value = null;
        if (isString(bean)) {
            value = (String) bean;
        } else {
            value = ValidatorUtils.getValueAsString(bean, field.getProperty());
        }
        // ؒlnull܂͋󕶎̎Atrueԋp
        if (GenericValidator.isBlankOrNull(value)) {
            return true;
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; i++) {
            if (!isHankakuKana(chars[i])) {
                errors.add(field.getKey(), Resources.getActionMessage(
                        validator, request, va, field));
                return false;
            }
        }
        return true;
    }

    /**
     * w肳ꂽtB[hpł邱Ƃ`FbNB
     * 
     * <p>
     * G[ƂȂꍇɂ́AG[𐶐A w肳ꂽG[񃊃XgɒǉBG[bZ[W̃tH[}bǵA
     * <code>validation-rules.xml</code>ɋLqB
     * </p>
     * 
     * @param bean
     *            Ώۂ̃IuWFNg
     * @param va
     *            <code>Validator</code>ɂpӂꂽ <code>ValidatorAction</code>
     * @param field
     *            tB[hIuWFNg
     * @param errors
     *            ANVG[
     * @param validator
     *            ValidatorCX^X
     * @param request
     *            HTTPNGXg
     * @return ͒l <code>true</code>
     */
    public static boolean validateHankakuString(Object bean,
            ValidatorAction va, Field field, ActionMessages errors,
            Validator validator, HttpServletRequest request) {

        // beannull̎AG[Oo͂AtrueԋpB
        if (bean == null) {
            log.error("bean is null.");
            return true;
        }
        String value = null;
        if (isString(bean)) {
            value = (String) bean;
        } else {
            value = ValidatorUtils.getValueAsString(bean, field.getProperty());
        }
        // ؒlnull܂͋󕶎̎Atrueԋp
        if (GenericValidator.isBlankOrNull(value)) {
            return true;
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; i++) {
            if (!isHankaku(chars[i])) {
                errors.add(field.getKey(), Resources.getActionMessage(
                        validator, request, va, field));
                return false;
            }
        }
        return true;
    }

    /**
     * w肳ꂽtB[hSpł邱Ƃ`FbNB
     * 
     * <p>
     * G[ƂȂꍇɂ́AG[𐶐A w肳ꂽG[񃊃XgɒǉBG[bZ[W̃tH[}bǵA
     * <code>validation-rules.xml</code>ɋLqB
     * </p>
     * 
     * @param bean
     *            Ώۂ̃IuWFNg
     * @param va
     *            <code>Validator</code>ɂpӂꂽ <code>ValidatorAction</code>
     * @param field
     *            tB[hIuWFNg
     * @param errors
     *            ANVG[
     * @param validator
     *            ValidatorCX^X
     * @param request
     *            HTTPNGXg
     * @return ͒l <code>true</code>
     */
    public static boolean validateZenkakuString(Object bean,
            ValidatorAction va, Field field, ActionMessages errors,
            Validator validator, HttpServletRequest request) {

        // beannull̎AG[Oo͂AtrueԋpB
        if (bean == null) {
            log.error("bean is null.");
            return true;
        }
        String value = null;
        if (isString(bean)) {
            value = (String) bean;
        } else {
            value = ValidatorUtils.getValueAsString(bean, field.getProperty());
        }
        // ؒlnull܂͋󕶎̎Atrueԋp
        if (GenericValidator.isBlankOrNull(value)) {
            return true;
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; i++) {
            if (!isZenkaku(chars[i])) {
                errors.add(field.getKey(), Resources.getActionMessage(
                        validator, request, va, field));
                return false;
            }
        }
        return true;
    }

    /**
     * w肳ꂽtB[hSpJ^Jił邱Ƃ`FbNB
     * 
     * <p>
     * G[ƂȂꍇɂ́AG[𐶐A w肳ꂽG[񃊃XgɒǉBG[bZ[W̃tH[}bǵA
     * <code>validation-rules.xml</code>ɋLqB
     * </p>
     * 
     * @param bean
     *            Ώۂ̃IuWFNg
     * @param va
     *            <code>Validator</code>ɂpӂꂽ <code>ValidatorAction</code>
     * @param field
     *            tB[hIuWFNg
     * @param errors
     *            ANVG[
     * @param validator
     *            ValidatorCX^X
     * @param request
     *            HTTPNGXg
     * @return ͒l <code>true</code>
     */
    public static boolean validateZenkakuKanaString(Object bean,
            ValidatorAction va, Field field, ActionMessages errors,
            Validator validator, HttpServletRequest request) {

        // beannull̎AG[Oo͂AtrueԋpB
        if (bean == null) {
            log.error("bean is null.");
            return true;
        }
        String value = null;
        if (isString(bean)) {
            value = (String) bean;
        } else {
            value = ValidatorUtils.getValueAsString(bean, field.getProperty());
        }
        // ؒlnull܂͋󕶎̎Atrueԋp
        if (GenericValidator.isBlankOrNull(value)) {
            return true;
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; i++) {
            if (!isZenkakuKana(chars[i])) {
                errors.add(field.getKey(), Resources.getActionMessage(
                        validator, request, va, field));
                return false;
            }
        }
        return true;
    }

    /**
     * w肳ꂽtB[hɓ͋֎~񂪍Ă邩 ǂ`FbNB
     * 
     * <p>
     * G[ƂȂꍇɂ́AG[𐶐A w肳ꂽG[񃊃XgɒǉB G[bZ[W̃tH[}bǵA
     * <code>validation-rules.xml</code>ɋLqB<br>
     * ȉ́A֎~`FbN̐ݒłB
     * </p>
     * <h5>validation.xml̋Lq</h5>
     * <code><pre>
     * &lt;form name=&quot;/sample&quot;&gt;
     *  EEE
     *  &lt;field property=&quot;escape&quot;
     *      depends=&quot;prohibited&quot;&gt;
     *    &lt;arg0 key=&quot;sample.escape&quot;/&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;chars&lt;/var-name&gt;
     *      &lt;var-value&gt;!&quot;#$%&amp;'()&lt;/var-value&gt;
     *    &lt;/var&gt;
     *  &lt;/field&gt;
     *  EEE
     * &lt;/form&gt;
     * </pre></code>
     * <h5>validation.xmlɐݒv&lt;var&gt;vf</h5>
     * <table border="1">
     * <tr>
     * <td><center><b><code>var-name</code></b></center></td>
     * <td><center><b><code>var-value</code></b></center></td>
     * <td><center><b>K{</b></center></td>
     * <td><center><b>Tv</b></center></td>
     * </tr>
     * <tr>
     * <td> chars </td>
     * <td>͋֎~LN^</td>
     * <td>false</td>
     * <td>͕񂪁A͋֎~LN^̉ꂩɑΉƂA <code>false</code>ԋpBȗ<code>true</code></td>
     * </tr>
     * </table>
     * 
     * @param bean
     *            Ώۂ̃IuWFNg
     * @param va
     *            <code>Validator</code>ɂpӂꂽ <code>ValidatorAction</code>
     * @param field
     *            tB[hIuWFNg
     * @param errors
     *            ANVG[
     * @param validator
     *            ValidatorCX^X
     * @param request
     *            HTTPNGXg
     * @return ͒l <code>true</code>
     */
    public static boolean validateProhibited(Object bean, ValidatorAction va,
            Field field, ActionMessages errors, Validator validator,
            HttpServletRequest request) {

        // beannull̎AG[Oo͂AtrueԋpB
        if (bean == null) {
            log.error("bean is null.");
            return true;
        }

        // ͋֎~
        String prohibitedStr = field.getVarValue("chars");
        if (prohibitedStr == null || "".equals(prohibitedStr)) {
            // ͋֎~null܂͋󕶎̎Atrueԋp
            return true;
        }

        String value = null;
        if (isString(bean)) {
            value = (String) bean;
        } else {
            value = ValidatorUtils.getValueAsString(bean, field.getProperty());
        }

        // ؒlnull܂͋󕶎̎Atrueԋp
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        char[] chars = value.toCharArray();

        // ͋֎~񂪖ݒ̏ꍇA`FbNsȂ
        for (int i = 0; i < chars.length; i++) {
            if (prohibitedStr.indexOf(chars[i]) >= 0) {
                errors.add(field.getKey(), Resources.getActionMessage(
                        validator, request, va, field));
                return false;
            }
        }
        return true;
    }

    /**
     * w肳ꂽtB[ĥ݂Ȃ镶ł邱Ƃ `FbNB
     * 
     * <p>
     * G[ƂȂꍇɂ́AG[𐶐A w肳ꂽG[񃊃XgɒǉB G[bZ[W̃tH[}bǵA
     * <code>validation-rules.xml</code>ɋLqB
     * </p>
     * 
     * @param bean
     *            Ώۂ̃IuWFNg
     * @param va
     *            <code>Validator</code>ɂpӂꂽ <code>ValidatorAction</code>
     * @param field
     *            tB[hIuWFNg
     * @param errors
     *            ANVG[
     * @param validator
     *            ValidatorCX^X
     * @param request
     *            HTTPNGXg
     * @return ͒l <code>true</code>
     */
    public static boolean validateNumericString(Object bean,
            ValidatorAction va, Field field, ActionMessages errors,
            Validator validator, HttpServletRequest request) {
        // tB[h̃N[쐬
        Field fieldClone = (Field) field.clone();
        fieldClone.addVar("mask", "^[0-9]*$", "false");
        // l`FbNs
        return validateMask(bean, va, fieldClone, errors, validator, request);
    }

    /**
     * w肳ꂽtB[h̕񒷂vĂ邱Ƃ`FbNB
     * 
     * <p>
     * G[ƂȂꍇɂ́AG[𐶐A w肳ꂽG[񃊃XgɒǉB G[bZ[W̃tH[}bǵA
     * <code>validation-rules.xml</code>ɋLqB<br>
     * ȉ́A񒷂5łƂ̂<code>true</code>ԋp ؂̐ݒłB
     * </p>
     * <h5>validation.xml̋Lq</h5>
     * <code><pre>
     * &lt;form name=&quot;/sample&quot;&gt;
     *  EEE
     *  &lt;field property=&quot;escape&quot;
     *      depends=&quot;stringLength&quot;&gt;
     *    &lt;arg0 key=&quot;sample.escape&quot;/&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;length&lt;/var-name&gt;
     *      &lt;var-value&gt;5&lt;/var-value&gt;
     *    &lt;/var&gt;
     *  &lt;/field&gt;
     *  EEE
     * &lt;/form&gt;
     * </pre></code>
     * <h5>validation.xmlɐݒv&lt;var&gt;vf</h5>
     * <table border="1">
     * <tr>
     * <td><center><b><code>var-name</code></b></center></td>
     * <td><center><b><code>var-value</code></b></center></td>
     * <td><center><b>K{</b></center></td>
     * <td><center><b>Tv</b></center></td>
     * </tr>
     * <tr>
     * <td> stringLength </td>
     * <td>͕񌅐</td>
     * <td>false</td>
     * <td>͕񒷂w肳ꂽłƂ <code>true</code> ȗ<code>true</code>ԋpB</td>
     * </tr>
     * </table>
     * 
     * @param bean
     *            Ώۂ̃IuWFNg
     * @param va
     *            ValidatorɂpӂꂽValidatorAction
     * @param field
     *            tB[hIuWFNg
     * @param errors
     *            ANVG[
     * @param validator
     *            ValidatorCX^X
     * @param request
     *            HTTPNGXg
     * @return ͒l <code>true</code>
     */
    public static boolean validateStringLength(Object bean, ValidatorAction va,
            Field field, ActionMessages errors, Validator validator,
            HttpServletRequest request) {

        // beannull̎AG[Oo͂AtrueԋpB
        if (bean == null) {
            log.error("bean is null.");
            return true;
        }

        // 
        String lengthStr = field.getVarValue("stringLength");
        // 񒷎w肪݂ȂA`FbNsȂ
        if (lengthStr == null || "".equals(lengthStr)) {
            return true;
        }
        String value = null;
        if (isString(bean)) {
            value = (String) bean;
        } else {
            value = ValidatorUtils.getValueAsString(bean, field.getProperty());
        }
        // ؒlnull܂͋󕶎̎Atrueԋp
        if (GenericValidator.isBlankOrNull(value)) {
            return true;
        }

        int checkLength = 0;
        try {
            checkLength = Integer.valueOf(lengthStr).intValue();
        } catch (NumberFormatException e) {
            // 񒷎w肪intϊs\ȏꍇ
            log.error("stringLength is not numeric(integer).", e);
            return true;
        }
        // ͂ꂽlengthȂAfalseԋp
        if (value.length() != checkLength) {
            errors.add(field.getKey(), Resources.getActionMessage(validator,
                    request, va, field));
            return false;
        }

        return true;
    }

    /**
     * w肳ꂽtB[h̃oCg񒷂vĂ邱Ƃ`FbNB
     * 
     * <p>
     * G[ƂȂꍇɂ́AG[𐶐A w肳ꂽG[񃊃XgɒǉB G[bZ[W̃tH[}bǵA
     * <code>validation-rules.xml</code>ɋLqB<br>
     * ȉ́AoCg񒷂5łƂ̂<code>true</code>ԋp ؂̐ݒłB
     * </p>
     * <h5>validation.xml̋Lq</h5>
     * <code><pre>
     * &lt;form name=&quot;/sample&quot;&gt;
     *  EEE
     *  &lt;field property=&quot;escape&quot;
     *      depends=&quot;byteLength&quot;&gt;
     *    &lt;arg0 key=&quot;sample.escape&quot;/&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;byteLength&lt;/var-name&gt;
     *      &lt;var-value&gt;5&lt;/var-value&gt;
     *    &lt;/var&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;encoding&lt;/var-name&gt;
     *      &lt;var-value&gt;Windows-31J&lt;/var-value&gt;
     *    &lt;/var&gt;
     *  &lt;/field&gt;
     *  EEE
     * &lt;/form&gt;
     * </pre></code>
     * <h5>validation.xmlɐݒv&lt;var&gt;vf</h5>
     * <table border="1">
     * <tr>
     * <td><center><b><code>var-name</code></b></center></td>
     * <td><center><b><code>var-value</code></b></center></td>
     * <td><center><b>K{</b></center></td>
     * <td><center><b>Tv</b></center></td>
     * </tr>
     * <tr>
     * <td> byteLength </td>
     * <td>͕oCg</td>
     * <td>false</td>
     * <td>͕oCg؂邽߂̃oCgB</td>
     * </tr>
     * <tr>
     * <td> encoding </td>
     * <td>GR[fBO</td>
     * <td>false</td>
     * <td>͕oCgɕϊۂɎgp镶GR[fBOB ȗꂽꍇVM̃ftHgGR[fBOgpB</td>
     * </tr>
     * </table>
     * 
     * @param bean
     *            Ώۂ̃IuWFNg
     * @param va
     *            ValidatorɂpӂꂽValidatorAction
     * @param field
     *            tB[hIuWFNg
     * @param errors
     *            ANVG[
     * @param validator
     *            ValidatorCX^X
     * @param request
     *            HTTPNGXg
     * @return ͒l <code>true</code>
     */
    public static boolean validateByteLength(Object bean, ValidatorAction va,
            Field field, ActionMessages errors, Validator validator,
            HttpServletRequest request) {

        // beannull̎AG[Oo͂AtrueԋpB
        if (bean == null) {
            log.error("bean is null.");
            return true;
        }

        // ͒l擾
        String value = null;
        if (isString(bean)) {
            value = (String) bean;
        } else {
            value = ValidatorUtils.getValueAsString(bean, field.getProperty());
        }
        // ؒlnull܂͋󕶎̎Atrueԋp
        if (GenericValidator.isBlankOrNull(value)) {
            return true;
        }

        // oCg
        String lengthStr = field.getVarValue("byteLength");
        // oCgw肪݂ȂA`FbNsȂ
        if (lengthStr == null || "".equals(lengthStr)) {
            if (log.isInfoEnabled()) {
                log.info("length is not specified.");
            }
            return true;
        }
        int checkLength = 0;
        try {
            checkLength = Integer.valueOf(lengthStr).intValue();
        } catch (NumberFormatException e) {
            // 񒷎w肪intϊs\ȏꍇ
            log.error("byteLength is not numeric(integer).", e);
            return true;
        }

        // GR[fBO
        String encoding = field.getVarValue("encoding");

        int bytesLength = getByteLength(value, encoding);

        // ͂ꂽ̃oCglengthȂAfalseԋp
        if (bytesLength != checkLength) {
            errors.add(field.getKey(), Resources.getActionMessage(validator,
                    request, va, field));
            return false;
        }

        return true;
    }

    /**
     * w肳ꂽtB[h̃oCg񒷂 w肵͈͓ł邱Ƃ`FbNB
     * 
     * <p>
     * G[ƂȂꍇɂ́AG[𐶐A w肳ꂽG[񃊃XgɒǉB G[bZ[W̃tH[}bǵA
     * <code>validation-rules.xml</code>ɋLqB<br>
     * ȉ́AoCg񒷂5ȏA10ȉłƂ̂ <code>true</code> ԋp錟؂̐ݒłB
     * </p>
     * <h5>validation.xml̋Lq</h5>
     * <code><pre>
     * &lt;form name=&quot;/sample&quot;&gt;
     *  EEE
     *  &lt;field property=&quot;escape&quot;
     *      depends=&quot;byteRange&quot;&gt;
     *    &lt;arg0 key=&quot;sample.escape&quot;/&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;maxByte&lt;/var-name&gt;
     *      &lt;var-value&gt;10&lt;/var-value&gt;
     *    &lt;/var&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;minByte&lt;/var-name&gt;
     *      &lt;var-value&gt;5&lt;/var-value&gt;
     *    &lt;/var&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;encoding&lt;/var-name&gt;
     *      &lt;var-value&gt;Windows-31J&lt;/var-value&gt;
     *    &lt;/var&gt;
     *  &lt;/field&gt;
     *  EEE
     * &lt;/form&gt;
     * </pre></code>
     * <h5>validation.xmlɐݒv&lt;var&gt;vf</h5>
     * <table border="1">
     * <tr>
     * <td><center><b><code>var-name</code></b></center></td>
     * <td><center><b><code>var-value</code></b></center></td>
     * <td><center><b>K{</b></center></td>
     * <td><center><b>Tv</b></center></td>
     * </tr>
     * <tr>
     * <td> maxByte </td>
     * <td>őoCg</td>
     * <td>false</td>
     * <td>͕oCg؂邽߂̍őoCgB ȗꍇint^̍őlB</td>
     * </tr>
     * <tr>
     * <td> minByte </td>
     * <td>őoCg</td>
     * <td>false</td>
     * <td>͕oCg؂邽߂̍ŏoCgB ȗꍇ0B</td>
     * </tr>
     * <tr>
     * <td> encoding </td>
     * <td>GR[fBO</td>
     * <td>false</td>
     * <td>͕oCgɕϊۂɎgp镶GR[fBOB ȗꂽꍇVM̃ftHgGR[fBOgpB</td>
     * </tr>
     * </table>
     * 
     * @param bean
     *            Ώۂ̃IuWFNg
     * @param va
     *            ValidatorɂpӂꂽValidatorAction
     * @param field
     *            tB[hIuWFNg
     * @param errors
     *            ANVG[
     * @param validator
     *            ValidatorCX^X
     * @param request
     *            HTTPNGXg
     * @return ͒l <code>true</code>
     */
    public static boolean validateByteRange(Object bean, ValidatorAction va,
            Field field, ActionMessages errors, Validator validator,
            HttpServletRequest request) {

        // beannull̎AG[Oo͂AtrueԋpB
        if (bean == null) {
            log.error("bean is null.");
            return true;
        }

        // ͒l擾
        String value = null;
        if (isString(bean)) {
            value = (String) bean;
        } else {
            value = ValidatorUtils.getValueAsString(bean, field.getProperty());
        }

        // ؒlnull܂͋󕶎̎Atrueԋp
        if (GenericValidator.isBlankOrNull(value)) {
            return true;
        }

        // GR[fBO
        String encoding = field.getVarValue("encoding");

        // ͕̃oCg
        int bytesLength = getByteLength(value, encoding);

        int min = 0;
        String minStr = field.getVarValue("minByte");
        if (!GenericValidator.isBlankOrNull(minStr)) {
            try {
                min = Integer.parseInt(minStr);
            } catch (NumberFormatException e) {
                log.error("", e);
            }
        }
        
        int max = Integer.MAX_VALUE;
        String maxStr = field.getVarValue("maxByte");
        if (!GenericValidator.isBlankOrNull(maxStr)) {
            try {
                max = Integer.parseInt(maxStr);
            } catch (NumberFormatException e) {
                log.error("", e);
            }
        }

        if (!GenericValidator.isInRange(bytesLength, min, max)) {
            errors.add(field.getKey(), Resources.getActionMessage(validator,
                    request, va, field));
            return false;
        }
        return true;
    }

    /**
     * tw肵͈͓ł邩ǂ`FbNB
     * 
     * <p>
     * G[ƂȂꍇɂ́AG[𐶐A w肳ꂽG[񃊃XgɒǉB G[bZ[W̃tH[}bǵA
     * <code>validation-rules.xml</code>ɋLqB<br>
     * ȉ́At2000/01/012010/12/31͈͓̔ł邩ǂ ؂̐ݒłB
     * </p>
     * <h5>validation.xml̋Lq</h5>
     * <code><pre>
     * &lt;form name=&quot;/sample&quot;&gt;
     *  EEE
     *  &lt;field property=&quot;date&quot;
     *      depends=&quot;dateRange&quot;&gt;
     *    &lt;arg key=&quot;label.date&quot; position=&quot;0&quot;/&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;startDate&lt;/var-name&gt;
     *      &lt;var-value&gt;2000/01/01&lt;/var-value&gt;
     *    &lt;/var&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;endDate&lt;/var-name&gt;
     *      &lt;var-value&gt;2010/12/31&lt;/var-value&gt;
     *    &lt;/var&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;datePattern&lt;/var-name&gt;
     *      &lt;var-value&gt;yyyy/MM/dd&lt;/var-value&gt;
     *    &lt;/var&gt;
     *  &lt;/field&gt;
     *  EEE
     * &lt;/form&gt;
     * </pre></code>
     * <h5>validation.xmlɐݒv&lt;var&gt;vf</h5>
     * <table border="1">
     * <tr>
     * <td><center><b><code>var-name</code></b></center></td>
     * <td><center><b><code>var-value</code></b></center></td>
     * <td><center><b>K{</b></center></td>
     * <td><center><b>Tv</b></center></td>
     * </tr>
     * <tr>
     * <td> startDate </td>
     * <td>Jnt</td>
     * <td>false</td>
     * <td>t͈͂̊Jn臒lƂȂtB
     * datePattern܂datePatternStrictŎw肵ttH[}bgƈv邱ƁB</td>
     * </tr>
     * <tr>
     * <td> endDate </td>
     * <td>It</td>
     * <td>false</td>
     * <td>t͈͂̏I臒lƂȂtB
     * datePattern܂datePatternStrictŎw肵ttH[}bgƈv邱ƁB</td>
     * </tr>
     * <tr>
     * <td> datePattern </td>
     * <td>tp^[</td>
     * <td>false</td>
     * <td>t̃p^[BDate^̃tH[}bg[ɏ]B</td>
     * </tr>
     * <tr>
     * <td> datePatternStrict </td>
     * <td>t̃p^[BDate^̃tH[}bg[ɏ]B</td>
     * <td>false</td>
     * <td>tp^[̃`FbNɍsǂB tp^[yyyy/MM/dd̏ꍇA2001/1/1̓G[ƂȂB
     * datePatternw肳ĂꍇAdatePatternŎw肳ꂽtH[}bg D悳B</td>
     * </tr>
     * </table>
     * 
     * @param bean
     *            Ώۂ̃IuWFNg
     * @param va
     *            ValidatorɂpӂꂽValidatorAction
     * @param field
     *            tB[hIuWFNg
     * @param errors
     *            ANVG[
     * @param validator
     *            ValidatorCX^X
     * @param request
     *            HTTPNGXg
     * @return ͒l <code>true</code>
     */
    public static boolean validateDateRange(Object bean, ValidatorAction va,
            Field field, ActionMessages errors, Validator validator,
            HttpServletRequest request) {

        // beannull̎AG[Oo͂AtrueԋpB
        if (bean == null) {
            log.error("bean is null.");
            return true;
        }

        String value = null;
        if (isString(bean)) {
            value = (String) bean;
        } else {
            value = ValidatorUtils.getValueAsString(bean, field.getProperty());
        }
        // ؒlnull܂͋󕶎̎Atrueԋp
        if (GenericValidator.isBlankOrNull(value)) {
            return true;
        }

        // ͓t̑Ó`FbN
        String datePattern = field.getVarValue("datePattern");
        String datePatternStrict = field.getVarValue("datePatternStrict");
        Locale locale = RequestUtils.getUserLocale(request, null);
        Date result = null;
        try {
            if (datePattern != null && datePattern.length() > 0) {
                result = GenericTypeValidator.formatDate(value, datePattern,
                        false);
            } else if (datePatternStrict != null
                    && datePatternStrict.length() > 0) {
                result = GenericTypeValidator.formatDate(value,
                        datePatternStrict, true);
            } else {
                result = GenericTypeValidator.formatDate(value, locale);
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }

        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator,
                    request, va, field));
            return false;
        }

        // t͈̓`FbN
        // Jn
        String startDateStr = field.getVarValue("startDate");
        // I
        String endDateStr = field.getVarValue("endDate");

        if (startDateStr == null && endDateStr == null) {
            // t͈͂w肳ĂȂꍇ͐Ƃ݂Ȃ
            return true;
        }

        // Jntȍ~ǂ`FbN
        if (startDateStr != null && startDateStr.length() > 0) {
            Date startDate = null;

            if (datePattern != null && datePattern.length() > 0) {
                startDate = GenericTypeValidator.formatDate(startDateStr,
                        datePattern, false);
            } else if (datePatternStrict != null
                    && datePatternStrict.length() > 0) {
                startDate = GenericTypeValidator.formatDate(startDateStr,
                        datePatternStrict, true);
            } else {
                startDate = GenericTypeValidator.formatDate(startDateStr,
                        locale);
            }

            if (startDate == null) {
                errors.add(field.getKey(), Resources.getActionMessage(
                        validator, request, va, field));
                return false;
            }
            if (result.before(startDate)) {
                errors.add(field.getKey(), Resources.getActionMessage(
                        validator, request, va, field));
                return false;
            }
        }

        // ItȑOǂ`FbN
        if (endDateStr != null && endDateStr.length() > 0) {
            Date endDate = null;

            if (datePattern != null && datePattern.length() > 0) {
                endDate = GenericTypeValidator.formatDate(endDateStr,
                        datePattern, false);
            } else if (datePatternStrict != null
                    && datePatternStrict.length() > 0) {
                endDate = GenericTypeValidator.formatDate(endDateStr,
                        datePatternStrict, true);
            } else {
                endDate = GenericTypeValidator.formatDate(endDateStr, locale);
            }

            if (endDate == null) {
                errors.add(field.getKey(), Resources.getActionMessage(
                        validator, request, va, field));
                return false;
            }
            if (result.after(endDate)) {
                errors.add(field.getKey(), Resources.getActionMessage(
                        validator, request, va, field));
                return false;
            }
        }

        return true;
    }

    /**
     * tB[h̑փ`FbNsB
     * 
     * ̌؃[̎sɂ{@link MultiFieldValidator} ̎NX KvBNX
     * <code>validation.xml</code> ɐݒsB<br>
     * G[ƂȂꍇɂ́AG[𐶐A w肳ꂽG[񃊃XgɒǉB ̌؃[ɂ̓ftHg̃G[bZ[WȂ߁A
     * bZ[W <code>validation.xml</code> ɕKLq邱ƁB<br>
     * ANVtH[valuetB[h̒lAvalue1tB[h̒lȏA
     * value2tB[h̒lȉł邱Ƃ؂ꍇAȉ̂悤ɎA ݒsB
     * <h5>{@link MultiFieldValidator} ̎</h5>
     * <code><pre>
     * public boolean validate(String value, String[] depends) {
     *  int value0 = Integer.parseInt(value);
     *  int value1 = Integer.parseInt(depends[0]);
     *  int value2 = Integer.parseInt(depends[1]);
     *  return (value1 &lt;= value0 &amp;&amp; value2 &gt;= value0);
     * }
     * </pre></code>
     * <h5>validation.xml̐ݒ</h5>
     * <code><pre>
     * &lt;form name=&quot;/validateMultiField&quot;&gt;
     *   &lt;field property=&quot;value&quot; depends=&quot;multiField&quot;&gt;
     *     &lt;msg key=&quot;errors.multiField&quot;
     *             name=&quot;multiField&quot;/&gt;
     *     &lt;arg key=&quot;label.value&quot; position=&quot;0&quot; /&gt;
     *     &lt;arg key=&quot;label.value1&quot; position=&quot;1&quot; /&gt;
     *     &lt;arg key=&quot;label.value2&quot; position=&quot;2&quot; /&gt;
     *     &lt;var&gt;
     *       &lt;var-name&gt;fields&lt;/var-name&gt;
     *       &lt;var-value&gt;value1,value2&lt;/var-value&gt;
     *     &lt;/var&gt;
     *     &lt;var&gt;
     *       &lt;var-name&gt;multiFieldValidator&lt;/var-name&gt;
     *       &lt;var-value&gt;sample.SampleMultiFieldValidator&lt;/var-value&gt;
     *     &lt;/var&gt;
     *   &lt;/field&gt;
     * &lt;/form&gt;
     * </pre></code>
     * <h5>bZ[W\[Xt@C̐ݒ</h5>
     * <code>
     * errors.multiField={0}{1}{2}̊Ԃ̒l͂ĂB
     * </code>
     * 
     * <h5>validation.xmlɐݒv&lt;var&gt;vf</h5>
     * <table border="1">
     * <tr>
     * <td><center><b><code>var-name</code></b></center></td>
     * <td><center><b><code>var-value</code></b></center></td>
     * <td><center><b>K{</b></center></td>
     * <td><center><b>Tv</b></center></td>
     * </tr>
     * <tr>
     * <td> fields </td>
     * <td>؂ɕKvȑ̃tB[h</td>
     * <td>false</td>
     * <td>̃tB[hw肷ꍇ̓tB[hJ}؂ w肷B</td>
     * </tr>
     * <tr>
     * <td> multiFieldValidator </td>
     * <td>{@link MultiFieldValidator} NX</td>
     * <td>false</td>
     * <td>tB[h̑փ`FbNs {@link MultiFieldValidator} NXB</td>
     * </tr>
     * </table>
     * 
     * @param bean
     *            Ώۂ̃IuWFNg
     * @param va
     *            ValidatorɂpӂꂽValidatorAction
     * @param field
     *            tB[hIuWFNg
     * @param errors
     *            ANVG[
     * @param validator
     *            ValidatorCX^X
     * @param request
     *            HTTPNGXg
     * @return ͒l <code>true</code>
     */
    public static boolean validateMultiField(Object bean, ValidatorAction va,
            Field field, ActionMessages errors, Validator validator,
            HttpServletRequest request) {

        // beannull̎AG[Oo͂AtrueԋpB
        if (bean == null) {
            log.error("bean is null.");
            return true;
        }

        // ؑΏۂ̒l擾
        String value = null;
        if (isString(bean)) {
            value = (String) bean;
        } else {
            value = ValidatorUtils.getValueAsString(bean, field.getProperty());
        }
        // ̃tB[hɈˑK{̓`FbNlA
        // ؒlnull܂͋󕶎̏ꍇłtB[h`FbN͎sB

        // MultiFieldValidatorNX擾
        String multiFieldValidatorClass = field
                .getVarValue("multiFieldValidator");

        if (multiFieldValidatorClass == null
                || "".equals(multiFieldValidatorClass)) {
            log.error("var value[multiFieldValidator] is required.");
            throw new IllegalArgumentException(
                    "var value[multiFieldValidator] is required.");
        }

        MultiFieldValidator mfv = null;
        try {
            mfv = (MultiFieldValidator) ClassUtil
                    .create(multiFieldValidatorClass);
        } catch (ClassLoadException e) {
            log.error("var value[multiFieldValidator] is invalid.", e);
            throw new IllegalArgumentException(
                    "var value[multiFieldValidator] is invalid.", e);
        } catch (ClassCastException e) {
            log.error("var value[multiFieldValidator] is invalid.", e);
            throw new IllegalArgumentException(
                    "var value[multiFieldValidator] is invalid.", e);
        }

        // ؂̈ˑtB[h̒l擾
        String fields = field.getVarValue("fields");
        List<String> valueList = new ArrayList<String>();
        if (fields != null) {
            StringTokenizer st = new StringTokenizer(fields, ",");
            while (st.hasMoreTokens()) {
                String f = st.nextToken();
                f = f.trim();
                valueList.add(ValidatorUtils.getValueAsString(bean, f));
            }
        }

        if (log.isDebugEnabled()) {
            log.debug("dependent fields:" + valueList);
        }

        String[] values = new String[valueList.size()];

        valueList.toArray(values);

        boolean result = mfv.validate(value, values);

        if (!result) {
            errors.add(field.getKey(), Resources.getActionMessage(validator,
                    request, va, field));
            return false;
        }

        return true;
    }

    /**
     * zERNV^̃tB[hlSvf`FbNB
     * <p>
     * zERNV^̃tH[̗vfׂČ؂A CfbNX <code>ActionMessage</code>ɒǉB
     * sTu\bḧ̌^ÁÃ\bh vĂKvB
     * FieldpropertyɂJXPathIndexedBeanWrapperImpl̎dlɏ]A
     * lXgvpeBݒ肷邱Ƃ\łB
     * </p>
     * 
     * @param bean
     *            Ώۂ̃IuWFNg
     * @param va
     *            Strutsɂpӂꂽ<code>ValidatorAction</code>
     * @param field
     *            tB[hIuWFNg
     * @param errors
     *            ANVG[
     * @param validator
     *            ValidatorCX^X
     * @param request
     *            HTTPNGXg
     * @return vfׂĂ̓͒l <code>true</code>
     */
    public static boolean validateArraysIndex(@SuppressWarnings("unused")
    Object bean, ValidatorAction va, Field field, ActionMessages errors,
            Validator validator, HttpServletRequest request) {

        // ͈̐
        int methodArgCount = 6;

        // zERNV̑ʁiłfalseԋpꂽꍇAfalsej
        boolean totalResult = true;
        try {
            // RXgN^̈ƂȂNXp^[擾
            Class[] paramClass = getParamClass(va);
            if (paramClass == null) {
                log.error("Can not get class pattern.");
                return true;
            }
            // paramClassvf=0̂ƂAG[Oo͂Atrueԋp
            if (paramClass.length == 0) {
                log.error("Class pattern length is zero.");
                return true;
            }

            // evf̌؂s\bh擾
            Method method = getMethod(va, paramClass);
            if (method == null) {
                log.error("Can not get validateMethod.");
                return true;
            }

            // tH[IuWFNg擾
            ActionForm form = getActionForm(request);
            if (form == null) {
                log.error("Can not get ActionForm.");
                return true;
            }

            // vfƂ̃of[V[ɋʂłA
            // OݒsṽIuWFNg
            Object[] argParams = new Object[methodArgCount];
            argParams[0] = form;
            argParams[1] = va;
            argParams[3] = errors;
            argParams[4] = validator;
            argParams[5] = request;

            IndexedBeanWrapper wrapper = new JXPathIndexedBeanWrapperImpl(form);
            Map<String, Object> propertyMap = wrapper
                    .getIndexedPropertyValues(field.getKey());

            int index = 0;

            for (String key : propertyMap.keySet()) {
                // CfbNXt̃vpeBŃtB[h
                Field indexedField = (Field) field.clone();
                indexedField.setIndexedListProperty(null);
                indexedField = getArrayIndexField(indexedField, index);
                indexedField.setKey(key);
                indexedField.setProperty(key);

                argParams[2] = indexedField; // tB[h

                // ̓`FbN\bȟĂяo
                Object resultObj = method
                        .invoke(FieldChecksEx.class, argParams);
                // ʉ
                if (!isValid(resultObj)) {
                    totalResult = false;
                }
                index++;
            }

        } catch (IllegalArgumentException e) {
            log.error("", e);
            return true;
        } catch (IllegalAccessException e) {
            log.error("", e);
            return true;
        } catch (InvocationTargetException e) {
            log.error("", e);
            return true;
        }
        return totalResult;
    }

    /**
     * tH[IuWFNg擾B
     * 
     * <b>̃\bh̓ANVtH[ΏۂƂĂ邽 tH[ȊOŁApsȂƂ𐄏ȂB</b>
     * 
     * @param request
     *            HTTPNGXg
     * @return tH[IuWFNg
     */
    protected static ActionForm getActionForm(HttpServletRequest request) {

        // NGXgŐݒ肳ĂANVtH[擾
        String formName = ActionFormUtil.getActionFormName(request);
        // tH[擾łȂꍇnullԋp
        if (formName == null) {
            return null;
        }

        // ZbVtH[擾
        Object obj = request.getSession(true).getAttribute(formName);
        ActionForm form = null;
        if (obj instanceof ActionForm) {
            form = (ActionForm) obj;
        }

        // ZbVɑ݂ȂANGXg擾
        if (form == null) {
            obj = request.getAttribute(formName);
            if (obj instanceof ActionForm) {
                form = (ActionForm) obj;
            }
        }
        return form;
    }

    /**
     * ؃[\bhɓnNXz擾B
     * 
     * <b>̃\bh̓ANVtH[ΏۂƂĂ邽 tH[ȊOŁApsȂƂ𐄏ȂB</b>
     * 
     * @param va
     *            Strutsɂpӂꂽ<code>ValidatorAction</code>
     * @return NXz
     */
    protected static Class[] getParamClass(ValidatorAction va) {

        String methodParams = va.getMethodParams();
        if (methodParams == null) {
            return null;
        }

        StringTokenizer st = new StringTokenizer(methodParams, ",");
        Class[] paramClass = new Class[st.countTokens()];

        for (int i = 0; st.hasMoreTokens(); i++) {
            try {
                String key = st.nextToken().trim();
                paramClass[i] = ClassUtils.getClass(key);
            } catch (ClassNotFoundException e) {
                log.error("", e);
                return null;
            }
        }
        return paramClass;
    }

    /**
     * zERNV̗vf؂郁\bh擾B
     * 
     * <b>̃\bh̓ANVtH[ΏۂƂĂ邽 tH[ȊOŁApsȂƂ𐄏ȂB</b>
     * 
     * @param va
     *            Strutsɂpӂꂽ<code>ValidatorAction</code>
     * @param paramClass
     *            NXz
     * @return ؃\bhIuWFNg
     */
    protected static Method getMethod(ValidatorAction va, Class[] paramClass) {

        String methodNameSource = va.getName();
        if (methodNameSource == null || "".equals(methodNameSource)) {
            // \bhw肪null܂͋󕶎̂ƂnullԋpB
            return null;
        }

        // name"Array"\bh𐶐
        // xxxxArrayvalidateXxxx
        char[] chars = methodNameSource.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        String validate = "validate" + new String(chars);
        String methodName = validate.substring(0, validate.length()
                - "Array".length());

        Method method = null;
        try {
            method = FieldChecksEx.class.getMethod(methodName, paramClass);
        } catch (NoSuchMethodException e) {
            try {
                method = ValidWhen.class.getMethod(methodName, paramClass);
            } catch (NoSuchMethodException e1) {
                log.error("", e);
                log.error("", e1);
                return null;
            }
        }
        return method;
    }

    /**
     * tNVpĎsꂽ\bȟ IuWFNgA؂ۂ`FbNB
     * 
     * <b>̃\bh̓ANVtH[ΏۂƂĂ邽 tH[ȊOŁApsȂƂ𐄏ȂB</b>
     * 
     * @param result
     *            ʃIuWFNg
     * @return ؐ <code>true</code>
     */
    protected static boolean isValid(Object result) {
        boolean isValid = false;

        if (result instanceof Boolean) {
            Boolean valid = (Boolean) result;
            isValid = valid.booleanValue();
        } else {
            // Boolean^ł͂ȂƂAtrueԋpB
            return true;
        }

        return isValid;
    }

    /**
     * w肳ꂽIndex̃tB[h擾B
     * 
     * <b>̃\bh̓ANVtH[ΏۂƂĂ邽 tH[ȊOŁApsȂƂ𐄏ȂB</b>
     * 
     * @param field
     *            utB[hIuWFNg
     * @param pos
     *            ̃CfbNX
     * @return ũtB[hIuWFNg
     */
    protected static Field getArrayIndexField(Field field, int pos) {
        Field cloneField = (Field) field.clone();

        // ##indexA݂̗vfɏ
        Arg argParam = null;
        String argStr = null;

        argParam = cloneField.getArg(0);
        if (argParam != null) {
            argStr = argParam.getKey();
            cloneField.getArg(0).setKey(replaceIndexString(argStr, pos + 1));
        }

        argParam = cloneField.getArg(1);
        if (argParam != null) {
            argStr = argParam.getKey();
            cloneField.getArg(1).setKey(replaceIndexString(argStr, pos + 1));
        }

        argParam = cloneField.getArg(2);
        if (argParam != null) {
            argStr = argParam.getKey();
            cloneField.getArg(2).setKey(replaceIndexString(argStr, pos + 1));
        }

        argParam = cloneField.getArg(3);
        if (argParam != null) {
            argStr = argParam.getKey();
            cloneField.getArg(3).setKey(replaceIndexString(argStr, pos + 1));
        }

        return cloneField;
    }

    /**
     * <code>arg</code>̒l##INDEX̎ÃCfbNXl u
     * 
     * <b>̃\bh̓ANVtH[ΏۂƂĂ邽 tH[ȊOŁApsȂƂ𐄏ȂB</b>
     * 
     * @param arg
     *            <code>ActionMessage</code>̒uL[
     * @param pos
     *            ̃CfbNX
     * @return L[##INDEX̎Ã݂CfbNXԋp
     */
    protected static String replaceIndexString(String arg, int pos) {
        if (arg == null) {
            return null;
        }
        if (INDEX.equalsIgnoreCase(arg)) {
            return Integer.toString(pos);
        }
        return arg;
    }

    /**
     * w肳ꂽ̃oCg񒷂擾B<br>
     * ̃GR[fBOŃoCgɕϊ邪Aw肳ĂȂ AGR[hɎsꍇ̓ftHg̃GR[fBO
     * oCgɕϊsB
     * 
     * @param value
     *            oCg񒷂擾Ώۂ̕
     * @param encoding
     *            GR[fBO
     * @return oCg
     */
    protected static int getByteLength(String value, String encoding) {
        if (value == null || "".equals(value)) {
            return 0;
        }
        byte[] bytes = null;
        if (encoding == null || "".equals(encoding)) {
            bytes = value.getBytes();
        } else {
            try {
                bytes = value.getBytes(encoding);
            } catch (UnsupportedEncodingException e) {
                if (log.isWarnEnabled()) {
                    log.warn(encoding + " is not supported.");
                }
                bytes = value.getBytes();
            }
        }
        return bytes == null ? 0 : bytes.length;
    }

    /**
     * pJĩXg擾B
     * 
     * @return pJiXg
     */
    public static String getHankakuKanaList() {
        return hankakuKanaList;
    }

    /**
     * SpJĩXg擾B
     * 
     * @return SpJiXg
     */
    public static String getZenkakuKanaList() {
        return zenkakuKanaList;
    }

}
