/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.messageex.web.action;


import java.util.Map;
import jp.terasoluna.thin.functionsample.messageex.bean.MessageExPriorityOrderParam;
import jp.terasoluna.thin.functionsample.messageex.service.MessageExPriorityOrderService;
import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.struts.actions.AbstractBLogicAction;

/**
 * ʂ擾f[^𗘗părWlXWbNďo
 *
 */
public class MessageExPriorityOrderAction 
            extends AbstractBLogicAction<MessageExPriorityOrderParam> {
    
    private MessageExPriorityOrderService messageExService ;

    /**
     * 1. bZ[WL[擾B<br>
     * 2. IbZ[WbZ[WNXɓ͂B<br>
     * 3. D揇ʃbZ[WbZ[WNXɓ͂B<br>
     *
     * @param param D揇ʃ`FbN{bNXNX
     * @return ʃNX
     */
    @Override
    public BLogicResult doExecuteBLogic(MessageExPriorityOrderParam params) 
                                                    throws Exception {
    	BLogicResult result = new BLogicResult();

        /*
         * D揇ʃbZ[WINX̕ϐnullɐݒ肳B
         * nulllϐfalseɍďB
         */
        if(params.getCheck1()==null) {
            params.setCheck1(false);            
        } if(params.getCheck2()==null) {
            params.setCheck2(false);            
        } if(params.getCheck3()==null) {
            params.setCheck3(false);            
        } if(params.getCheck4()==null) {
            params.setCheck4(false);            
        }
        
        Map<String, String> mapKey = messageExService.execute(params);
        if (mapKey != null) {
        	BLogicMessages mess = new BLogicMessages();
            // IbZ[WbZ[WNXɓ͂B
            mess.add("select", 
                    new BLogicMessage(mapKey.get("select"), mapKey.get("0"),
                            mapKey.get("1"), mapKey.get("2"), 
                            mapKey.get("3")));
            
            // D揇ʃbZ[WbZ[WNXɓ͂B
            mess.add("message", 
                    new BLogicMessage(mapKey.get("message")));
            result.setMessages(mess);
            result.setResultString("success");
        }
        
        return result;
    }
    
    /**
     * messageExService擾B
     * @return gbZ[W\[X擾NX
     */
    public MessageExPriorityOrderService getMessageExService() {
        return messageExService;
    }

    /**
     * messageExServiceݒ肷B
     * @param messageExService gbZ[W\[X擾NX
     */
    public void setMessageExService
                (MessageExPriorityOrderService messageExService) {
        this.messageExService = messageExService;
    }
}