/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

/**
 * ServletFilterŔOȂǁA
 * web.xmlerror-pageݒɂOnhO
 * sƂɎgpRg[B
 * 
 * <p>̃NXłServletFilterŔOX[A
 * Spring-MVC̗OnhO@\ɏ𓊂邱ƂӖƂB
 * X[ÓA{@link jp.terasoluna.fw.web.rich.springmvc.servlet.handler.SimpleMappingExceptionResolverEx}
 * œK؂ɃnhO邱Ƃz肵ĂB</p>
 * 
 * <p>Bean`t@CɈȉ̐ݒ邱ƁB</p>
 * 
 * <hr>
 * <p>
 *  y<code>Bean`t@C</code>̐ݒz<br>
 *  <code><pre>
 *  &lt;bean name="/exceptionController" 
        class="jp.terasoluna.fw.web.rich.springmvc.controller.ErrorPageHandlingController"/&gt;
 * </pre></code>
 * </p>
 * <hr>
 * 
 * ܂ÃNXgpɂ
 * {@link jp.terasoluna.fw.web.rich.springmvc.servlet.handler.ErrorPageHandlerMapping}
 * NXBean`t@Cɐݒ肵ĂKvBڍׂ
 * {@link jp.terasoluna.fw.web.rich.springmvc.servlet.handler.ErrorPageHandlerMapping}
 * NXJavaDocQƂ邱ƁB
 * 
 * @see jp.terasoluna.fw.web.rich.springmvc.servlet.handler.ErrorPageHandlerMapping
 * @see jp.terasoluna.fw.web.rich.springmvc.servlet.handler.SimpleMappingExceptionResolverEx
 * 
 */
public class ErrorPageHandlingController implements Controller {

    /**
     * HTTPNGXgŔOێĂL[B
     */
    private static final String JAVAX_SERVLET_ERROR_EXCEPTION = 
        "javax.servlet.error.exception";

    /**
     * NGXgsB
     * NGXgێĂOX[B
     * NGXgɗOȂꍇA{@link java.lang.IllegalArgumentException}
     * X[B
     * 
     * @param request HTTPNGXgB
     * @param response HTTPX|XB
     * @return X|X_O邽߂ModelAndViewB
     * @throws Exception OB
     */
    public ModelAndView handleRequest(
            HttpServletRequest request, 
            HttpServletResponse response) throws Exception {
        Exception e = 
            (Exception) request.getAttribute(JAVAX_SERVLET_ERROR_EXCEPTION);
        
        if (e == null) {
            String message = "ErrorPageHandlingController must be set "
                + "Exception in Request Data.";
            throw new IllegalStateException(message);
        }
        throw e;
    }
}
