/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.validation;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.StringTokenizer;
import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.fw.util.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.GenericTypeValidator;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.UrlValidator;

public class ValidationUtil {
    protected static String hankakuKanaList = "\uff71\uff72\uff73\uff74\uff75\uff67\uff68\uff69\uff6a\uff6b\uff76\uff77\uff78\uff79\uff7a\uff7b\uff7c\uff7d\uff7e\uff7f\uff80\uff81\uff82\uff6f\uff83\uff84\uff85\uff86\uff87\uff88\uff89\uff8a\uff8b\uff8c\uff8d\uff8e\uff8f\uff90\uff91\uff92\uff93\uff94\uff95\uff96\uff6c\uff6d\uff6e\uff97\uff98\uff99\uff9a\uff9b\uff9c\uff66\uff9d\uff9f\uff9e\uff70\uff65\uff64\uff61\uff62\uff63";
    protected static String zenkakuKanaList = "\u30a2\u30a4\u30a6\u30f4\u30a8\u30aa\u30a1\u30a3\u30a5\u30a7\u30a9\u30ab\u30ad\u30af\u30b1\u30b3\u30f5\u30f6\u30ac\u30ae\u30b0\u30b2\u30b4\u30b5\u30b7\u30b9\u30bb\u30bd\u30b6\u30b8\u30ba\u30bc\u30be\u30bf\u30c1\u30c4\u30c6\u30c8\u30c0\u30c2\u30c5\u30c7\u30c9\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30d0\u30d3\u30d6\u30d9\u30dc\u30d1\u30d4\u30d7\u30da\u30dd\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e3\u30e5\u30e7\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30ee\u30f0\u30f1\u30f2\u30c3\u30f3\u30fc";
    protected static final String HANKAKU_KANA_LIST_KEY = "validation.hankaku.kana.list";
    protected static final String ZENKAKU_KANA_LIST_KEY = "validation.zenkaku.kana.list";
    protected static final String ZENKAKU_BEGIN_U00_LIST = "\uff3c\uffe0\uffe1\u00a7\u00a8\uffe2\u00b0\u00b1\u00b4\u00b6\u00d7\u00f7";

    protected static void setHankakuKanaList() {
        String value = null;
        value = PropertyUtil.getProperty((String)HANKAKU_KANA_LIST_KEY);
        if (value != null) {
            hankakuKanaList = value;
        }
    }

    protected static void setZenkakuKanaList() {
        String value = null;
        value = PropertyUtil.getProperty((String)ZENKAKU_KANA_LIST_KEY);
        if (value != null) {
            zenkakuKanaList = value;
        }
    }

    protected static boolean isHankakuKanaChar(char c) {
        return hankakuKanaList.indexOf(c) >= 0;
    }

    protected static boolean isHankakuChar(char c) {
        return c <= '\u00ff' && ZENKAKU_BEGIN_U00_LIST.indexOf(c) < 0 || ValidationUtil.isHankakuKanaChar(c);
    }

    protected static boolean isZenkakuChar(char c) {
        return !ValidationUtil.isHankakuChar(c);
    }

    protected static boolean isZenkakuKanaChar(char c) {
        return zenkakuKanaList.indexOf(c) >= 0;
    }

    public static boolean matchRegexp(String value, String mask) {
        return StringUtils.isEmpty((String)value) || GenericValidator.matchRegexp((String)value, (String)mask);
    }

    public static boolean isAlphaNumericString(String value) {
        return ValidationUtil.matchRegexp(value, "^([0-9]|[a-z]|[A-Z])*$");
    }

    public static boolean isUpperAlphaNumericString(String value) {
        return ValidationUtil.matchRegexp(value, "^([0-9]|[A-Z])*$");
    }

    public static boolean isNumericString(String value) {
        return ValidationUtil.matchRegexp(value, "^([0-9])*$");
    }

    public static boolean isNumber(BigDecimal value, int integerLength, boolean isAccordedInteger, int scaleLength, boolean isAccordedScale) {
        if (value == null) {
            return true;
        }
        BigInteger bi = value.toBigInteger().abs();
        int length = bi.toString().length();
        if (!ValidationUtil.checkNumberFigures(length, integerLength, isAccordedInteger)) {
            return false;
        }
        int scale = value.scale();
        return ValidationUtil.checkNumberFigures(scale, scaleLength, isAccordedScale);
    }

    protected static boolean checkNumberFigures(int length, int checkLength, boolean isAccorded) {
        if (length > checkLength) {
            return false;
        }
        return !isAccorded || length == checkLength;
    }

    public static boolean isHankakuKanaString(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (ValidationUtil.isHankakuKanaChar(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isHankakuString(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (ValidationUtil.isHankakuChar(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isZenkakuString(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (ValidationUtil.isZenkakuChar(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isZenkakuKanaString(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (ValidationUtil.isZenkakuKanaChar(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean hasNotProhibitedChar(String value, String prohibitedChars) {
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        char[] chars = value.toCharArray();
        if (prohibitedChars == null || "".equals(prohibitedChars)) {
            return true;
        }
        for (int i = 0; i < chars.length; ++i) {
            if (prohibitedChars.indexOf(chars[i]) < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isArrayInRange(Object obj, int min, int max) {
        int targetLength = 0;
        if (obj == null) {
            targetLength = 0;
        } else if (obj instanceof Collection) {
            targetLength = ((Collection)obj).size();
        } else if (obj.getClass().isArray()) {
            targetLength = Array.getLength(obj);
        } else {
            throw new IllegalArgumentException(obj.getClass().getName() + " is neither Array nor Collection.");
        }
        return GenericValidator.isInRange((int)targetLength, (int)min, (int)max);
    }

    public static boolean isUrl(String value, boolean allowallschemes, boolean allow2slashes, boolean nofragments, String schemesVar) {
        UrlValidator urlValidator;
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        int options = 0;
        if (allowallschemes) {
            ++options;
        }
        if (allow2slashes) {
            options += 2;
        }
        if (nofragments) {
            options += 4;
        }
        if (options == 0 && schemesVar == null) {
            return GenericValidator.isUrl((String)value);
        }
        String[] schemes = null;
        if (schemesVar != null) {
            StringTokenizer st = new StringTokenizer(schemesVar, ",");
            schemes = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                schemes[i++] = st.nextToken().trim();
            }
        }
        return (urlValidator = new UrlValidator(schemes, options)).isValid(value);
    }

    public static boolean isByteInRange(String value, String encoding, int min, int max) {
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        int bytesLength = 0;
        try {
            bytesLength = StringUtil.getByteLength((String)value, (String)encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return GenericValidator.isInRange((int)bytesLength, (int)min, (int)max);
    }

    public static boolean isDateInRange(String value, String startDateStr, String endDateStr, String datePattern, String datePatternStrict) {
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        Date result = ValidationUtil.toDate(value, datePattern, datePatternStrict);
        if (result == null) {
            return false;
        }
        if (GenericValidator.isBlankOrNull((String)startDateStr) && GenericValidator.isBlankOrNull((String)endDateStr)) {
            return true;
        }
        if (!GenericValidator.isBlankOrNull((String)startDateStr)) {
            Date startDate = ValidationUtil.toDate(startDateStr, datePattern, datePatternStrict);
            if (startDate == null) {
                throw new IllegalArgumentException("startDate is unparseable[" + startDateStr + "]");
            }
            if (result.before(startDate)) {
                return false;
            }
        }
        if (!GenericValidator.isBlankOrNull((String)endDateStr)) {
            Date endDate = ValidationUtil.toDate(endDateStr, datePattern, datePatternStrict);
            if (endDate == null) {
                throw new IllegalArgumentException("endDate is unparseable[" + endDateStr + "]");
            }
            if (result.after(endDate)) {
                return false;
            }
        }
        return true;
    }

    public static Date toDate(String value, String datePattern, String datePatternStrict) {
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        Date result = null;
        if (datePattern != null && datePattern.length() > 0) {
            result = GenericTypeValidator.formatDate((String)value, (String)datePattern, (boolean)false);
        } else if (datePatternStrict != null && datePatternStrict.length() > 0) {
            result = GenericTypeValidator.formatDate((String)value, (String)datePatternStrict, (boolean)true);
        } else {
            throw new IllegalArgumentException("datePattern or datePatternStrict must be specified.");
        }
        return result;
    }

    static {
        ValidationUtil.setHankakuKanaList();
        ValidationUtil.setZenkakuKanaList();
    }
}

