/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.terasoluna.batch.tutorial.sample004;

import java.util.Date;
import java.util.Map;

import jp.terasoluna.batch.tutorial.common.NyusyukkinData;
import jp.terasoluna.batch.tutorial.common.NyusyukkinFileOutput;
import jp.terasoluna.fw.batch.blogic.AbstractTransactionBLogic;
import jp.terasoluna.fw.batch.blogic.vo.BLogicParam;
import jp.terasoluna.fw.collector.Collector;
import jp.terasoluna.fw.collector.file.FileCollector;
import jp.terasoluna.fw.collector.util.CollectorUtility;
import jp.terasoluna.fw.collector.util.ControlBreakChecker;
import jp.terasoluna.fw.file.dao.FileLineWriter;
import jp.terasoluna.fw.file.dao.FileQueryDAO;
import jp.terasoluna.fw.file.dao.FileUpdateDAO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

/**
 * rWlXWbNNXBiCSVt@Cǂݍ݁Acsvt@Cɏo͂NXj
 */
@Component
public class SMP004BLogic extends AbstractTransactionBLogic {

	private static final Log log = LogFactory.getLog(SMP004BLogic.class);

	@Autowired
	@Qualifier(value = "csvFileQueryDAO")
	protected FileQueryDAO csvFileQueryDAO;

	@Autowired
	@Qualifier(value = "csvFileUpdateDAO")
	protected FileUpdateDAO csvFileUpdateDAO;

	public int doMain(BLogicParam param) {

		// WuIR[hi0:IA-1:ُIj
		int returnCode = 0;

		// RN^
		Collector<NyusyukkinData> collector = new FileCollector<NyusyukkinData>(
				this.csvFileQueryDAO, "inputFile/SMP004_input.csv",
				NyusyukkinData.class);

		// t@Co͗psC^̎擾
		FileLineWriter<NyusyukkinFileOutput> fileLineWriter = csvFileUpdateDAO
				.execute("outputFile/SMP004_output.csv",
						NyusyukkinFileOutput.class);

		try {
			// t@C擾f[^i[IuWFNg
			NyusyukkinData inputData = null;

			// ̃JEgp
			int nyukinNum = 0;
			// õJEgp
			int syukkinNum = 0;
			// vp
			int nyukinSum = 0;
			// ovp
			int syukkinSum = 0;

			while (collector.hasNext()) {
				// t@Cf[^擾
				inputData = collector.next();

				// Rg[uCN
				// xXAɕύXꍇ
				boolean ctrlBreak = ControlBreakChecker.isBreak(collector,
						"torihikibi", "shitenName");

				// o敪̃JEgAvvZ
				if (inputData != null && inputData.getNyusyukkinKubun() == 0) {
					syukkinNum++;
					syukkinSum += inputData.getKingaku();
				} else if (inputData != null
						&& inputData.getNyusyukkinKubun() == 1) {
					nyukinNum++;
					nyukinSum += inputData.getKingaku();
				}

				// Rg[uCN
				if (ctrlBreak) {
					// L[f[^}bvŎ擾
					Map<String, Object> brkMap = ControlBreakChecker
							.getBreakKey(collector, "torihikibi", "shitenName");
					Date torihikibi = null;
					String shitenName = null;
					if (brkMap.containsKey("torihikibi")) {
						torihikibi = (Date) brkMap.get("torihikibi");
					} else {
						torihikibi = inputData.getTorihikibi();
					}
					if (brkMap.containsKey("shitenName")) {
						shitenName = (String) brkMap.get("shitenName");
					} else {
						shitenName = inputData.getShitenName();
					}

					// Rg[uCÑf[^̍쐬
					NyusyukkinFileOutput outputData = new NyusyukkinFileOutput();
					outputData.setTorihikibi(torihikibi);
					outputData.setShitenName(shitenName);
					outputData.setNyukinNum(nyukinNum);
					outputData.setNyukinSum(nyukinSum);
					outputData.setSyukkinNum(syukkinNum);
					outputData.setSyukkinSum(syukkinSum);

					// f[^t@C֏ói1sj
					fileLineWriter.printDataLine(outputData);

					// o敪JEg̏
					nyukinNum = 0;
					syukkinNum = 0;
					nyukinSum = 0;
					syukkinSum = 0;
				}
			}
		} catch (DataAccessException e) {
			if (log.isErrorEnabled()) {
				log.error("f[^ANZXG[܂", e);
			}

			returnCode = -1;
		} catch (Exception e) {
			if (log.isErrorEnabled()) {
				log.error("G[܂", e);
			}

			returnCode = -1;
		} finally {
			// RN^̃N[Y
			CollectorUtility.closeQuietly(collector);

			// t@C̃N[Y
			CollectorUtility.closeQuietly(fileLineWriter);

			// ĨO
			if (returnCode == 0 && log.isInfoEnabled()) {
				log.info("t@C݂ɏI܂B");
			}
		}

		return returnCode;
	}
}
