/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.commons;

import java.io.Serializable;
import java.io.StringReader;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.GenericTypeValidator;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.util.ValidatorUtils;
import org.springframework.validation.Errors;
import org.springmodules.validation.commons.MessageUtils;
import org.springmodules.validation.commons.validwhen.ValidWhenLexer;
import org.springmodules.validation.commons.validwhen.ValidWhenParser;

public class FieldChecks
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$springmodules$validation$commons$FieldChecks == null ? (class$org$springmodules$validation$commons$FieldChecks = FieldChecks.class$("org.springmodules.validation.commons.FieldChecks")) : class$org$springmodules$validation$commons$FieldChecks));
    public static final String FIELD_TEST_NULL = "NULL";
    public static final String FIELD_TEST_NOTNULL = "NOTNULL";
    public static final String FIELD_TEST_EQUAL = "EQUAL";
    static /* synthetic */ Class class$org$springmodules$validation$commons$FieldChecks;
    static /* synthetic */ Class class$java$lang$String;

    public static boolean validateRequired(Object bean, ValidatorAction va, Field field, Errors errors) {
        String value = FieldChecks.extractValue(bean, field);
        if (GenericValidator.isBlankOrNull((String)value)) {
            FieldChecks.rejectValue(errors, field, va);
            return false;
        }
        return true;
    }

    public static boolean validateRequiredIf(Object bean, ValidatorAction va, Field field, Errors errors, Validator validator) {
        Object form = validator.getParameterValue("java.lang.Object");
        boolean required = false;
        String value = FieldChecks.extractValue(bean, field);
        int i = 0;
        String fieldJoin = "AND";
        if (!GenericValidator.isBlankOrNull((String)field.getVarValue("fieldJoin"))) {
            fieldJoin = field.getVarValue("fieldJoin");
        }
        if (fieldJoin.equalsIgnoreCase("AND")) {
            required = true;
        }
        while (!GenericValidator.isBlankOrNull((String)field.getVarValue("field[" + i + "]"))) {
            String key;
            String dependProp = field.getVarValue("field[" + i + "]");
            String dependTest = field.getVarValue("fieldTest[" + i + "]");
            String dependTestValue = field.getVarValue("fieldValue[" + i + "]");
            String dependIndexed = field.getVarValue("fieldIndexed[" + i + "]");
            if (dependIndexed == null) {
                dependIndexed = "false";
            }
            String dependVal = null;
            boolean thisRequired = false;
            if (field.isIndexed() && dependIndexed.equalsIgnoreCase("true") && (key = field.getKey()).indexOf("[") > -1 && key.indexOf("]") > -1) {
                String ind = key.substring(0, key.indexOf(".") + 1);
                dependProp = ind + dependProp;
            }
            dependVal = ValidatorUtils.getValueAsString((Object)form, (String)dependProp);
            if (dependTest.equals(FIELD_TEST_NULL)) {
                boolean bl = thisRequired = dependVal != null && dependVal.length() > 0;
            }
            if (dependTest.equals(FIELD_TEST_NOTNULL)) {
                boolean bl = thisRequired = dependVal != null && dependVal.length() > 0;
            }
            if (dependTest.equals(FIELD_TEST_EQUAL)) {
                thisRequired = dependTestValue.equalsIgnoreCase(dependVal);
            }
            required = fieldJoin.equalsIgnoreCase("AND") ? required && thisRequired : required || thisRequired;
            ++i;
        }
        if (required) {
            if (GenericValidator.isBlankOrNull((String)value)) {
                FieldChecks.rejectValue(errors, field, va);
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean validateMask(Object bean, ValidatorAction va, Field field, Errors errors) {
        String mask = field.getVarValue("mask");
        String value = FieldChecks.extractValue(bean, field);
        try {
            if (!GenericValidator.isBlankOrNull((String)value) && !GenericValidator.matchRegexp((String)value, (String)mask)) {
                FieldChecks.rejectValue(errors, field, va);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return true;
        }
    }

    public static Byte validateByte(Object bean, ValidatorAction va, Field field, Errors errors) {
        Byte result = null;
        String value = FieldChecks.extractValue(bean, field);
        if (!GenericValidator.isBlankOrNull((String)value) && (result = GenericTypeValidator.formatByte((String)value)) == null) {
            FieldChecks.rejectValue(errors, field, va);
        }
        return result;
    }

    public static Short validateShort(Object bean, ValidatorAction va, Field field, Errors errors) {
        Short result = null;
        String value = FieldChecks.extractValue(bean, field);
        if (!GenericValidator.isBlankOrNull((String)value) && (result = GenericTypeValidator.formatShort((String)value)) == null) {
            FieldChecks.rejectValue(errors, field, va);
        }
        return result;
    }

    public static Integer validateInteger(Object bean, ValidatorAction va, Field field, Errors errors) {
        Integer result = null;
        String value = FieldChecks.extractValue(bean, field);
        if (!GenericValidator.isBlankOrNull((String)value) && (result = GenericTypeValidator.formatInt((String)value)) == null) {
            FieldChecks.rejectValue(errors, field, va);
        }
        return result;
    }

    public static Long validateLong(Object bean, ValidatorAction va, Field field, Errors errors) {
        Long result = null;
        String value = FieldChecks.extractValue(bean, field);
        if (!GenericValidator.isBlankOrNull((String)value) && (result = GenericTypeValidator.formatLong((String)value)) == null) {
            FieldChecks.rejectValue(errors, field, va);
        }
        return result;
    }

    public static Float validateFloat(Object bean, ValidatorAction va, Field field, Errors errors) {
        Float result = null;
        String value = FieldChecks.extractValue(bean, field);
        if (!GenericValidator.isBlankOrNull((String)value) && (result = GenericTypeValidator.formatFloat((String)value)) == null) {
            FieldChecks.rejectValue(errors, field, va);
        }
        return result;
    }

    public static Double validateDouble(Object bean, ValidatorAction va, Field field, Errors errors) {
        Double result = null;
        String value = FieldChecks.extractValue(bean, field);
        if (!GenericValidator.isBlankOrNull((String)value) && (result = GenericTypeValidator.formatDouble((String)value)) == null) {
            FieldChecks.rejectValue(errors, field, va);
        }
        return result;
    }

    public static Date validateDate(Object bean, ValidatorAction va, Field field, Errors errors) {
        Date result = null;
        String value = FieldChecks.extractValue(bean, field);
        String datePattern = field.getVarValue("datePattern");
        String datePatternStrict = field.getVarValue("datePatternStrict");
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                if (datePattern != null && datePattern.length() > 0) {
                    result = GenericTypeValidator.formatDate((String)value, (String)datePattern, (boolean)false);
                } else if (datePatternStrict != null && datePatternStrict.length() > 0) {
                    result = GenericTypeValidator.formatDate((String)value, (String)datePatternStrict, (boolean)true);
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (result == null) {
                FieldChecks.rejectValue(errors, field, va);
            }
        }
        return result;
    }

    public static boolean validateRange(Object bean, ValidatorAction va, Field field, Errors errors) {
        return FieldChecks.validateIntRange(bean, va, field, errors);
    }

    public static boolean validateIntRange(Object bean, ValidatorAction va, Field field, Errors errors) {
        String value = FieldChecks.extractValue(bean, field);
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                int intValue = Integer.parseInt(value);
                int min = Integer.parseInt(field.getVarValue("min"));
                int max = Integer.parseInt(field.getVarValue("max"));
                if (!GenericValidator.isInRange((int)intValue, (int)min, (int)max)) {
                    FieldChecks.rejectValue(errors, field, va);
                    return false;
                }
            }
            catch (Exception e) {
                FieldChecks.rejectValue(errors, field, va);
                return false;
            }
        }
        return true;
    }

    public static boolean validateDoubleRange(Object bean, ValidatorAction va, Field field, Errors errors) {
        String value = FieldChecks.extractValue(bean, field);
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                double doubleValue = Double.parseDouble(value);
                double min = Double.parseDouble(field.getVarValue("min"));
                double max = Double.parseDouble(field.getVarValue("max"));
                if (!GenericValidator.isInRange((double)doubleValue, (double)min, (double)max)) {
                    FieldChecks.rejectValue(errors, field, va);
                    return false;
                }
            }
            catch (Exception e) {
                FieldChecks.rejectValue(errors, field, va);
                return false;
            }
        }
        return true;
    }

    public static boolean validateFloatRange(Object bean, ValidatorAction va, Field field, Errors errors) {
        String value = FieldChecks.extractValue(bean, field);
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                float floatValue = Float.parseFloat(value);
                float min = Float.parseFloat(field.getVarValue("min"));
                float max = Float.parseFloat(field.getVarValue("max"));
                if (!GenericValidator.isInRange((float)floatValue, (float)min, (float)max)) {
                    FieldChecks.rejectValue(errors, field, va);
                    return false;
                }
            }
            catch (Exception e) {
                FieldChecks.rejectValue(errors, field, va);
                return false;
            }
        }
        return true;
    }

    public static Long validateCreditCard(Object bean, ValidatorAction va, Field field, Errors errors) {
        Long result = null;
        String value = FieldChecks.extractValue(bean, field);
        if (!GenericValidator.isBlankOrNull((String)value) && (result = GenericTypeValidator.formatCreditCard((String)value)) == null) {
            FieldChecks.rejectValue(errors, field, va);
        }
        return result;
    }

    public static boolean validateEmail(Object bean, ValidatorAction va, Field field, Errors errors) {
        String value = FieldChecks.extractValue(bean, field);
        if (!GenericValidator.isBlankOrNull((String)value) && !GenericValidator.isEmail((String)value)) {
            FieldChecks.rejectValue(errors, field, va);
            return false;
        }
        return true;
    }

    public static boolean validateMaxLength(Object bean, ValidatorAction va, Field field, Errors errors) {
        String value = FieldChecks.extractValue(bean, field);
        if (value != null) {
            try {
                int max = Integer.parseInt(field.getVarValue("maxlength"));
                if (!GenericValidator.maxLength((String)value, (int)max)) {
                    FieldChecks.rejectValue(errors, field, va);
                    return false;
                }
            }
            catch (Exception e) {
                FieldChecks.rejectValue(errors, field, va);
                return false;
            }
        }
        return true;
    }

    public static boolean validateMinLength(Object bean, ValidatorAction va, Field field, Errors errors) {
        String value = FieldChecks.extractValue(bean, field);
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                int min = Integer.parseInt(field.getVarValue("minlength"));
                if (!GenericValidator.minLength((String)value, (int)min)) {
                    FieldChecks.rejectValue(errors, field, va);
                    return false;
                }
            }
            catch (Exception e) {
                FieldChecks.rejectValue(errors, field, va);
                return false;
            }
        }
        return true;
    }

    public static boolean validateValidWhen(Object bean, ValidatorAction va, Field field, Errors errors, Validator validator) {
        Object form = validator.getParameterValue("java.lang.Object");
        String value = null;
        boolean valid = false;
        int index = -1;
        if (field.isIndexed()) {
            String key = field.getKey();
            int leftBracket = key.indexOf("[");
            int rightBracket = key.indexOf("]");
            if (leftBracket > -1 && rightBracket > -1) {
                index = Integer.parseInt(key.substring(leftBracket + 1, rightBracket));
            }
        }
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        String test = field.getVarValue("test");
        if (test == null) {
            String msg = "ValidWhen Error 'test' parameter is missing for field ' " + field.getKey() + "'";
            errors.rejectValue(field.getKey(), msg);
            log.error((Object)msg);
            return false;
        }
        ValidWhenLexer lexer = null;
        try {
            lexer = new ValidWhenLexer(new StringReader(test));
        }
        catch (Exception ex) {
            String msg = "ValidWhenLexer Error for field ' " + field.getKey() + "' - " + ex;
            errors.rejectValue(field.getKey(), msg);
            log.error((Object)msg);
            log.debug((Object)msg, (Throwable)ex);
            return false;
        }
        ValidWhenParser parser = null;
        try {
            parser = new ValidWhenParser(lexer);
        }
        catch (Exception ex) {
            String msg = "ValidWhenParser Error for field ' " + field.getKey() + "' - " + ex;
            errors.rejectValue(field.getKey(), msg);
            log.error((Object)msg);
            log.debug((Object)msg, (Throwable)ex);
            return false;
        }
        parser.setForm(form);
        parser.setIndex(index);
        parser.setValue(value);
        try {
            parser.expression();
            valid = parser.getResult();
        }
        catch (Exception ex) {
            String msg = "ValidWhen Error for field ' " + field.getKey() + "' - " + ex;
            errors.rejectValue(field.getKey(), msg);
            log.error((Object)msg);
            log.debug((Object)msg, (Throwable)ex);
            return false;
        }
        if (!valid) {
            FieldChecks.rejectValue(errors, field, va);
            return false;
        }
        return true;
    }

    protected static String extractValue(Object bean, Field field) {
        String value = null;
        if (bean == null) {
            return null;
        }
        value = bean instanceof String ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return value;
    }

    public static void rejectValue(Errors errors, Field field, ValidatorAction va) {
        String fieldCode = field.getKey();
        fieldCode = fieldCode.replace('(', '[').replace(')', ']');
        String errorCode = MessageUtils.getMessageKey(va, field);
        Object[] args = MessageUtils.getArgs(va, field);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Rejecting value [field='" + fieldCode + "', errorCode='" + errorCode + "']"));
        }
        errors.rejectValue(fieldCode, errorCode, args, errorCode);
    }

    private static boolean isString(Object obj) {
        return obj == null ? true : (class$java$lang$String == null ? (class$java$lang$String = FieldChecks.class$("java.lang.String")) : class$java$lang$String).isInstance(obj);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

