/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.file.dao.standard;

import java.io.IOException;
import java.io.Reader;

import jp.terasoluna.fw.file.dao.FileException;

/**
 * t@Cf[^̃f[^1sǂݎAƂČďoɕԋpB
 */
public class EncloseCharLineFeed1LineReader implements LineReader {

    /**
     * ؂蕶B
     */
    private char delimiterCharacter = Character.MIN_VALUE;

    /**
     * ͂ݕB
     */
    private char encloseCharacter = Character.MIN_VALUE;

    /**
     * JƂ̈͂ݕB
     */
    private char[] columnEncloseCharacter = null;

    /**
     * t@CANZXp̕Xg[B
     */
    private Reader reader = null;

    /**
     * s؂蕶B
     */
    private String lineFeedChar = null;

    /**
     * RXgN^B
     * @param delimiterCharacter ؂蕶
     * @param encloseCharacter ͂ݕ
     * @param columnEncloseCharacter JƂ̈͂ݕ
     * @param reader t@CANZXp̕Xg[
     * @param lineFeedChar s؂蕶
     * @throws IllegalArgumentException ̐ݒ肪ԈꍇB
     */
    public EncloseCharLineFeed1LineReader(char delimiterCharacter,
            char encloseCharacter, char[] columnEncloseCharacter,
            Reader reader, String lineFeedChar) {

        if (delimiterCharacter == Character.MIN_VALUE) {
            throw new IllegalArgumentException(
                    "delimiterCharacter can not use '\\u0000'.");
        }

        if (columnEncloseCharacter == null) {
            throw new IllegalArgumentException(
                    "columnEncloseCharacter is required.");
        }

        if (reader == null) {
            throw new IllegalArgumentException("reader is required.");
        }

        if (lineFeedChar == null) {
            throw new IllegalArgumentException("lineFeedChar is required.");
        }

        if (lineFeedChar.length() != 1) {
            throw new IllegalArgumentException("lineFeedChar should be defined"
                    + " by 1 digit of character string.");
        }

        this.delimiterCharacter = delimiterCharacter;
        this.encloseCharacter = encloseCharacter;
        this.columnEncloseCharacter = columnEncloseCharacter;
        this.reader = reader;
        this.lineFeedChar = lineFeedChar;
    }

    /**
     * t@Cf[^̃f[^1sǂݎAƂČďoɕԋpB
     * @return f[^̂Ps̕
     * @throws FileException ReadeȑŗOꍇB
     */
    public String readLine() {
        // 1J̕i[obt@
        StringBuilder currentLineStringBuilder = new StringBuilder();

        // `FbNΏە̒O̕
        char previousChar = Character.MIN_VALUE;

        // `FbNΏە
        char currentChar = Character.MIN_VALUE;

        // ͂ݕIĂ邩mFtOBtrueȂJ͈͂ݕň͂܂ĂB
        boolean isEnclosed = true;

        // GXP[vV[PXǂݍ񂾂trueɁBȊȌꍇfalseB
        boolean isEscape = false;

        // s؂蕶1ځB
        char lineFeedChar1 = lineFeedChar.charAt(0);

        int chr = 0;
        int fieldCount = 0;
        try {
            while ((chr = reader.read()) != -1) {
                currentChar = (char) chr;
                if (previousChar == Character.MIN_VALUE) {
                    previousChar = currentChar;
                }
                if (previousChar == getEncloseCharcter(fieldCount)) {
                    if (isEnclosed) {
                        if (currentChar == getEncloseCharcter(fieldCount)) {
                            isEnclosed = false;
                        }
                        currentLineStringBuilder.append(currentChar);
                    } else {
                        if (currentChar == getEncloseCharcter(fieldCount)
                                && !isEscape) {
                            isEscape = true;
                        } else if (currentChar == getEncloseCharcter(fieldCount)
                                && isEscape) {
                            isEscape = false;
                            currentLineStringBuilder
                                    .append(getEncloseCharcter(fieldCount));
                            currentLineStringBuilder.append(currentChar);
                        } else if (currentChar == delimiterCharacter) {
                            if (isEscape) {
                                currentLineStringBuilder
                                        .append(getEncloseCharcter(fieldCount));
                                previousChar = Character.MIN_VALUE;
                                isEnclosed = true;
                                isEscape = false;
                                fieldCount++;
                            }
                            currentLineStringBuilder.append(currentChar);
                        } else if (currentChar == lineFeedChar1) {
                            if (isEscape) {
                                currentLineStringBuilder
                                        .append(getEncloseCharcter(fieldCount));
                                previousChar = Character.MIN_VALUE;
                                isEnclosed = true;
                                isEscape = false;
                                break;
                            } else {
                                currentLineStringBuilder.append(currentChar);
                            }
                        } else {
                            if (isEscape) {
                                currentLineStringBuilder
                                        .append(getEncloseCharcter(fieldCount));
                                previousChar = Character.MIN_VALUE;
                                isEnclosed = true;
                                isEscape = false;
                            }
                            currentLineStringBuilder.append(currentChar);
                        }
                    }
                } else if (previousChar == lineFeedChar1) {
                    previousChar = Character.MIN_VALUE;
                    isEnclosed = true;
                    isEscape = false;
                    break;
                } else {
                    if (currentChar == delimiterCharacter) {
                        fieldCount++;
                        currentLineStringBuilder.append(currentChar);
                        previousChar = Character.MIN_VALUE;
                        isEnclosed = true;
                        isEscape = false;
                    } else if (currentChar == lineFeedChar1) {
                        previousChar = Character.MIN_VALUE;
                        isEnclosed = true;
                        isEscape = false;
                        break;
                    } else {
                        currentLineStringBuilder.append(currentChar);
                    }
                }
            }
        } catch (IOException e) {
            throw new FileException("Reader control operation was failed.", e);
        }

        return currentLineStringBuilder.toString();
    }

    /**
     * JɑΉ͂ݕ擾B
     * @param index J̃CfbNX
     * @return ͂ݕ
     */
    private char getEncloseCharcter(int index) {
        if (columnEncloseCharacter.length == 0
                || index >= columnEncloseCharacter.length) {
            return encloseCharacter;
        } else {
            return columnEncloseCharacter[index];
        }
    }
}
