/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.executor;

import jp.terasoluna.fw.batch.executor.AbstractBatchExecutor;
import jp.terasoluna.fw.batch.executor.vo.BLogicResult;
import jp.terasoluna.fw.batch.executor.vo.BatchJobData;
import jp.terasoluna.fw.batch.util.JobUtil;
import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.logger.TLogger;
import jp.terasoluna.fw.util.PropertyUtil;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public abstract class AbstractJobBatchExecutor
extends AbstractBatchExecutor {
    private static final TLogger LOGGER = TLogger.getLogger(AbstractJobBatchExecutor.class);
    protected static final String JOB_INTERVAL_TIME = "polling.interval";
    protected static final String EXECUTOR_END_MONITORING_FILE = "executor.endMonitoringFile";
    protected static final String EXECUTOR_JOB_TERMINATE_WAIT_INTERVAL_TIME = "executor.jobTerminateWaitInterval";
    protected static final long DEFAULT_JOB_INTERVAL_TIME = 1000L;
    protected static final boolean DEFAULT_JOB_AFTER_GC = true;
    protected static final long DEFAULT_EXECUTOR_LOOP_INTERVAL_TIME = 1000L;
    protected static final String DEFAULT_EXECUTOR_END_MONITORING_FILE = null;
    protected static final long DEFAULT_EXECUTOR_QUEUE_CHECK_INTERVAL_TIME = 1000L;
    protected static final long DEFAULT_EXECUTOR_JOB_TERMINATE_WAIT_INTERVAL_TIME = 5000L;
    protected long jobIntervalTime = 1000L;
    protected String executorEndMonitoringFile = DEFAULT_EXECUTOR_END_MONITORING_FILE;
    protected long executorJobTerminateWaitIntervalTime = 5000L;
    protected boolean changeStartStatus = false;

    protected AbstractJobBatchExecutor() {
        this.initParameter();
    }

    protected void initDefaultAppContext() {
        String defaultAppContextName = AbstractJobBatchExecutor.getDefaultBeanFileName();
        if (defaultAppContextName == null || "".equals(defaultAppContextName)) {
            LOGGER.error("EAL025003");
            return;
        }
        String dataSourceAppContextName = AbstractJobBatchExecutor.getDataSourceBeanFileName();
        if (dataSourceAppContextName == null || "".equals(dataSourceAppContextName)) {
            LOGGER.error("EAL025003");
            return;
        }
        this.defaultApplicationContext = AbstractJobBatchExecutor.getApplicationContext(defaultAppContextName, dataSourceAppContextName);
        if (this.defaultApplicationContext == null) {
            LOGGER.error("EAL025016", new Object[]{defaultAppContextName, dataSourceAppContextName});
            return;
        }
    }

    protected void initSystemDatasourceDao() {
        if (this.defaultApplicationContext == null) {
            return;
        }
        String queryDaoKey = PropertyUtil.getProperty((String)"systemDataSource.queryDAO");
        String updateDaoKey = PropertyUtil.getProperty((String)"systemDataSource.updateDAO");
        String transactionManagerKey = PropertyUtil.getProperty((String)"systemDataSource.transactionManager");
        if (queryDaoKey != null && queryDaoKey.length() != 0 && this.defaultApplicationContext.containsBean(queryDaoKey)) {
            try {
                this.sysQueryDAO = (QueryDAO)this.defaultApplicationContext.getBean(queryDaoKey, QueryDAO.class);
            }
            catch (Throwable e) {
                LOGGER.error("EAL025017", e, new Object[]{queryDaoKey});
            }
        }
        if (updateDaoKey != null && updateDaoKey.length() != 0 && this.defaultApplicationContext.containsBean(updateDaoKey)) {
            try {
                this.sysUpdateDAO = (UpdateDAO)this.defaultApplicationContext.getBean(updateDaoKey, UpdateDAO.class);
            }
            catch (Throwable e) {
                LOGGER.error("EAL025018", e, new Object[]{updateDaoKey});
            }
        }
        if (transactionManagerKey != null && transactionManagerKey.length() != 0 && this.defaultApplicationContext.containsBean(transactionManagerKey)) {
            try {
                this.sysTransactionManager = (PlatformTransactionManager)this.defaultApplicationContext.getBean(transactionManagerKey, PlatformTransactionManager.class);
            }
            catch (Throwable e) {
                LOGGER.error("EAL025019", e, new Object[]{transactionManagerKey});
            }
        }
        if (this.sysQueryDAO == null) {
            LOGGER.error("EAL025020");
        }
        if (this.sysUpdateDAO == null) {
            LOGGER.error("EAL025021");
        }
        if (this.sysTransactionManager == null) {
            LOGGER.error("EAL025022");
        }
    }

    protected void initParameter() {
        String executorEndMonitoringFileStr;
        String jobIntervalTimeStr = PropertyUtil.getProperty((String)JOB_INTERVAL_TIME);
        if (jobIntervalTimeStr != null && jobIntervalTimeStr.length() != 0) {
            try {
                this.jobIntervalTime = Long.parseLong(jobIntervalTimeStr);
            }
            catch (NumberFormatException e) {
                this.jobIntervalTime = 1000L;
            }
        } else {
            this.jobIntervalTime = 1000L;
        }
        this.executorEndMonitoringFile = (executorEndMonitoringFileStr = PropertyUtil.getProperty((String)EXECUTOR_END_MONITORING_FILE)) != null && executorEndMonitoringFileStr.length() != 0 ? executorEndMonitoringFileStr : DEFAULT_EXECUTOR_END_MONITORING_FILE;
        String executorJobTerminateWaitIntervalTimeStr = PropertyUtil.getProperty((String)EXECUTOR_JOB_TERMINATE_WAIT_INTERVAL_TIME);
        if (executorJobTerminateWaitIntervalTimeStr != null && executorJobTerminateWaitIntervalTimeStr.length() != 0) {
            try {
                this.executorJobTerminateWaitIntervalTime = Long.parseLong(executorJobTerminateWaitIntervalTimeStr);
            }
            catch (NumberFormatException e) {
                this.executorJobTerminateWaitIntervalTime = 5000L;
            }
        } else {
            this.executorJobTerminateWaitIntervalTime = 5000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public BLogicResult executeBatch(String jobSequenceId) {
        block20: {
            block21: {
                block18: {
                    block19: {
                        block16: {
                            block17: {
                                result = new BLogicResult();
                                st = false;
                                AbstractJobBatchExecutor.LOGGER.info("IAL025001", new Object[]{jobSequenceId});
                                try {
                                    if (this.sysQueryDAO != null && this.sysUpdateDAO != null && this.sysTransactionManager != null) break block16;
                                    AbstractJobBatchExecutor.LOGGER.error("EAL025023", new Object[]{jobSequenceId});
                                    var4_4 = result;
                                    st = this.endBatchStatus(jobSequenceId, result, this.sysQueryDAO, this.sysUpdateDAO, this.sysTransactionManager);
                                    if (st) break block17;
                                }
                                catch (Throwable var6_8) {
                                    st = this.endBatchStatus(jobSequenceId, result, this.sysQueryDAO, this.sysUpdateDAO, this.sysTransactionManager);
                                    if (!st) {
                                        if (AbstractJobBatchExecutor.LOGGER.isErrorEnabled()) {
                                            AbstractJobBatchExecutor.LOGGER.error("EAL025025", new Object[]{jobSequenceId, result.getBlogicStatus()});
                                        }
                                        return result;
                                    }
                                    throw var6_8;
                                }
                                if (AbstractJobBatchExecutor.LOGGER.isErrorEnabled()) {
                                    AbstractJobBatchExecutor.LOGGER.error("EAL025025", new Object[]{jobSequenceId, result.getBlogicStatus()});
                                }
                                return result;
                            }
                            return var4_4;
                        }
                        jobRecord = JobUtil.selectJob(jobSequenceId, false, this.sysQueryDAO);
                        if (jobRecord != null) break block18;
                        AbstractJobBatchExecutor.LOGGER.error("EAL025024", new Object[]{jobSequenceId});
                        var5_6 = result;
                        st = this.endBatchStatus(jobSequenceId, result, this.sysQueryDAO, this.sysUpdateDAO, this.sysTransactionManager);
                        if (st) break block19;
                        if (AbstractJobBatchExecutor.LOGGER.isErrorEnabled()) {
                            AbstractJobBatchExecutor.LOGGER.error("EAL025025", new Object[]{jobSequenceId, result.getBlogicStatus()});
                        }
                        return result;
                    }
                    return var5_6;
                }
                if (!this.changeStartStatus || (st = this.startBatchStatus(jobSequenceId, this.sysQueryDAO, this.sysUpdateDAO, this.sysTransactionManager))) break block20;
                if (AbstractJobBatchExecutor.LOGGER.isInfoEnabled()) {
                    AbstractJobBatchExecutor.LOGGER.info("IAL025002", new Object[]{jobSequenceId, result.getBlogicStatus()});
                }
                var5_7 = result;
                st = this.endBatchStatus(jobSequenceId, result, this.sysQueryDAO, this.sysUpdateDAO, this.sysTransactionManager);
                if (st) break block21;
                if (AbstractJobBatchExecutor.LOGGER.isErrorEnabled()) {
                    AbstractJobBatchExecutor.LOGGER.error("EAL025025", new Object[]{jobSequenceId, result.getBlogicStatus()});
                }
                return result;
            }
            return var5_7;
        }
        if (jobRecord.getJobAppCd() != null) {
            jobRecord.setJobAppCd(jobRecord.getJobAppCd().trim());
        }
        result = this.executeBatch(jobRecord);
        if (AbstractJobBatchExecutor.LOGGER.isDebugEnabled()) {
            AbstractJobBatchExecutor.LOGGER.debug("DAL025021", new Object[]{result.getBlogicStatus()});
        }
        ** if (st = this.endBatchStatus((String)jobSequenceId, (BLogicResult)result, (QueryDAO)this.sysQueryDAO, (UpdateDAO)this.sysUpdateDAO, (PlatformTransactionManager)this.sysTransactionManager)) goto lbl60
lbl-1000:
        // 1 sources

        {
            if (AbstractJobBatchExecutor.LOGGER.isErrorEnabled()) {
                AbstractJobBatchExecutor.LOGGER.error("EAL025025", new Object[]{jobSequenceId, result.getBlogicStatus()});
            }
            return result;
        }
        {
        }
lbl60:
        // 1 sources

        if (AbstractJobBatchExecutor.LOGGER.isInfoEnabled()) {
            AbstractJobBatchExecutor.LOGGER.info("IAL025003", new Object[]{jobSequenceId, result.getBlogicStatus()});
        }
        return result;
    }

    protected boolean startBatchStatus(String jobSequenceId, QueryDAO queryDAO, UpdateDAO updateDAO, PlatformTransactionManager transactionManager) {
        return this.updateBatchStatus(jobSequenceId, "0", null, queryDAO, updateDAO, transactionManager);
    }

    protected boolean endBatchStatus(String jobSequenceId, BLogicResult result, QueryDAO queryDAO, UpdateDAO updateDAO, PlatformTransactionManager transactionManager) {
        String blogicStatus = null;
        if (result != null) {
            blogicStatus = Integer.toString(result.getBlogicStatus());
        }
        return this.updateBatchStatus(jobSequenceId, "1", blogicStatus, queryDAO, updateDAO, transactionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateBatchStatus(String jobSequenceId, String eventCode, String blogicStatus, QueryDAO queryDAO, UpdateDAO updateDAO, PlatformTransactionManager transactionManager) {
        TransactionStatus tranStatus = null;
        try {
            DefaultTransactionDefinition tranDef = new DefaultTransactionDefinition();
            tranStatus = transactionManager.getTransaction((TransactionDefinition)tranDef);
            LOGGER.debug("DAL025022");
            BatchJobData job = JobUtil.selectJob(jobSequenceId, true, queryDAO);
            if (job == null) {
                LOGGER.error("EAL025026", new Object[]{jobSequenceId});
                boolean bl = false;
                return bl;
            }
            String changeStatus = this.judgmentStatus(job, jobSequenceId, eventCode, blogicStatus);
            if (changeStatus == null) {
                boolean bl = true;
                return bl;
            }
            LOGGER.debug("DAL025023", new Object[]{jobSequenceId, changeStatus});
            JobUtil.updateJobStatus(job.getJobSequenceId(), changeStatus, null, blogicStatus, queryDAO, updateDAO);
            transactionManager.commit(tranStatus);
            LOGGER.debug("DAL025024");
        }
        catch (Exception e) {
            LOGGER.error("EAL025027", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (tranStatus != null && !tranStatus.isCompleted()) {
                    transactionManager.rollback(tranStatus);
                }
                LOGGER.debug("DAL025025");
            }
            catch (Exception e) {
                LOGGER.error("EAL025028", (Throwable)e);
            }
        }
        return true;
    }

    protected String judgmentStatus(BatchJobData job, String jobSequenceId, String eventCode, String blogicStatus) {
        String judge = null;
        judge = "0".equals(eventCode) ? ("0".equals(job.getCurAppStatus()) ? "1" : null) : ("1".equals(job.getCurAppStatus()) ? "2" : null);
        if (judge == null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("IAL025004", new Object[]{jobSequenceId, blogicStatus, eventCode, job.getCurAppStatus(), judge});
            }
            return null;
        }
        return judge.toString();
    }

    public long getJobIntervalTime() {
        return this.jobIntervalTime;
    }

    public String getExecutorEndMonitoringFile() {
        return this.executorEndMonitoringFile;
    }

    public long getExecutorJobTerminateWaitIntervalTime() {
        return this.executorJobTerminateWaitIntervalTime;
    }

    public void setChangeStartStatus(boolean changeStartStatus) {
        this.changeStartStatus = changeStartStatus;
    }
}

