/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.file.dao.standard;

import java.io.IOException;
import java.io.Reader;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.dao.standard.LineReader;

public class LineFeed0LineReader
implements LineReader {
    private Reader reader = null;
    private String fileEncoding = null;
    private int totalBytes = 0;

    public LineFeed0LineReader(Reader reader, String fileEncoding, int totalBytes) {
        if (reader == null) {
            throw new IllegalArgumentException("reader is required.");
        }
        if (fileEncoding == null) {
            throw new IllegalArgumentException("fileEncoding is required.");
        }
        if (totalBytes <= 0) {
            throw new IllegalArgumentException("totalBytes is larger than 0.");
        }
        this.reader = reader;
        this.fileEncoding = fileEncoding;
        this.totalBytes = totalBytes;
    }

    public String readLine() {
        StringBuilder currentLineStringBuilder = new StringBuilder();
        int chr = 0;
        int size = 0;
        try {
            while ((chr = this.reader.read()) != -1) {
                char currentChar = (char)chr;
                currentLineStringBuilder.append(currentChar);
                if ((size += Character.toString(currentChar).getBytes(this.fileEncoding).length) < this.totalBytes) continue;
                break;
            }
        }
        catch (IOException e) {
            throw new FileException("Reader control operation was failed.", e);
        }
        return currentLineStringBuilder.toString();
    }
}

