﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using TERASOLUNA.Fw.Web;
using TERASOLUNA.Fw.Web.Session;

namespace TutorialServerWeb.Form
{
    /// <summary>
    /// マスターページ。
    /// </summary>
    public partial class Tutorial : System.Web.UI.MasterPage
    {
        /// <summary>
        /// セッション管理クラス。
        /// </summary>
        private SessionManager _sessionManager = null;

        /// <summary>
        /// 初期化メソッドをオーバーライドし、SessionManagerのインスタンスを生成する。
        /// </summary>
        /// <param name="e">イベントデータを格納している<see cref="EventArgs"/>。</param>
        protected override void OnInit(EventArgs e)
        {
            base.OnInit(e);

            // セッション管理クラスの生成
            _sessionManager = new SessionManager(this.Session);
        }

        /// <summary>
        /// ユーザIDをセッションから取得し、ラベルに反映する。
        /// </summary>
        /// <param name="sender">イベントのソース。</param>
        /// <param name="e">イベントデータを格納している<see cref="EventArgs"/>。</param>
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack){
                //ユーザIDをセッションから取得し、ラベルに反映する
                LabelUserId.Text = (string)_sessionManager["UserId"];
            }
        }

        /// <summary>
        /// ログオン画面に遷移する。
        /// </summary>
        /// <param name="sender">イベントのソース。</param>
        /// <param name="e">イベントデータを格納している<see cref="EventArgs"/>。</param>
        protected void ButtonLogout_Click(object sender, EventArgs e)
        {
            WebUtils.Transit("LogonForm");
        }
    }
}
