﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using TERASOLUNA.Fw.Web;
using TERASOLUNA.Fw.Web.Session;

namespace TutorialServerWeb.Form
{
    public partial class MenuForm : System.Web.UI.Page
    {
        /// <summary>
        /// セッション管理クラス。
        /// </summary>
        private SessionManager _sessionManager = null;

        /// <summary>
        /// 初期化メソッドをオーバーライドし、SessionManagerのインスタンスを生成する。
        /// </summary>
        /// <param name="e">イベントデータを格納している<see cref="EventArgs"/>。</param>
        protected override void OnInit(EventArgs e)
        {
            base.OnInit(e);

            // セッション管理クラスの生成
            _sessionManager = new SessionManager(this.Session);
        }

        /// <summary>
        /// 初期化イベント。
        /// </summary>
        /// <param name="sender">イベントのソース。</param>
        /// <param name="e">イベントデータを格納している<see cref="EventArgs"/>。</param>
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                // ライフサイクルレベル1のセッションを削除する。
                _sessionManager.Remove(1);
            }
        }

        /// <summary>
        /// 計算画面に遷移する。
        /// </summary>
        /// <param name="sender">イベントのソース。</param>
        /// <param name="e">イベントデータを格納している<see cref="EventArgs"/>。</param>
        protected void ButtonCalc_Click(object sender, EventArgs e)
        {
            WebUtils.Transit("CalcForm");
        }

        /// <summary>
        /// 商品選択画面に遷移する。
        /// </summary>
        /// <param name="sender">イベントのソース。</param>
        /// <param name="e">イベントデータを格納している<see cref="EventArgs"/>。</param>
        protected void ButtonItemSelect_Click(object sender, EventArgs e)
        {
            WebUtils.Transit("SelectItemForm");
        }

        /// <summary>
        /// ApplicationException例外をスローする。
        /// </summary>
        /// <param name="sender">イベントのソース。</param>
        /// <param name="e">イベントデータを格納している<see cref="EventArgs"/>。</param>
        protected void ButtonException_Click(object sender, EventArgs e)
        {
            throw new ApplicationException();
        }

    }
}
