﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using TERASOLUNA.Fw.Web.Session;
using TERASOLUNA.Fw.Web;
using TutorialServerWeb.Dto;

namespace TutorialServerWeb.Form
{
    /// <summary>
    /// 商品確認画面。
    /// </summary>
    public partial class ConfirmItemForm : System.Web.UI.Page
    {
        /// <summary>
        /// セッション管理クラス。
        /// </summary>
        private SessionManager _sessionManager = null;

        /// <summary>
        /// 前の画面で選択された商品情報を一覧表示する。
        /// </summary>
        /// <param name="sender">イベントのソース。</param>
        /// <param name="e">イベントデータを格納している<see cref="EventArgs"/>。</param>
        protected void Page_Load(object sender, EventArgs e)
        {
            // セッション管理クラスを作成する。
            _sessionManager = new SessionManager(this.Session);

            // セッションからデータセットを取得して、GridViewにバインドする
            ItemDataSet itemDataSet = (ItemDataSet)_sessionManager["ItemDataSet"];
            GridView1.DataSource = itemDataSet;
            GridView1.DataBind();
        }

        /// <summary>
        /// 商品確定画面に遷移する。
        /// </summary>
        /// <param name="sender">イベントのソース。</param>
        /// <param name="e">イベントデータを格納している<see cref="EventArgs"/>。</param>
        protected void ButtonItemComplete_Click(object sender, EventArgs e)
        {
            WebUtils.Transit("CompleteItemForm");
        }

        /// <summary>
        /// 商品選択画面に遷移する。
        /// </summary>
        /// <param name="sender">イベントのソース。</param>
        /// <param name="e">イベントデータを格納している<see cref="EventArgs"/>。</param>
        protected void ButtonItemSelect_Click(object sender, EventArgs e)
        {
            WebUtils.Transit("SelectItemForm");
        }
    }
}
