// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Web.Controller;
using System.Runtime.Serialization;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;

namespace TERASOLUNA.Fw.WebUT.Controller
{
    /// <summary>
    ///TERASOLUNA.Fw.Web.Controller.InvalidRequestException のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Web.Controller.InvalidRequestException 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class InvalidRequestExceptionTest
    {
        private TestContext testContextInstance;

        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        ///--------------------------------------------------------------------
        /// <summary>
        /// TerasolunaException () のテスト
        /// </summary>
        /// <TestTarget>ctor</TestTarget>
        /// <TestPreCondition></TestPreCondition>
        /// <TestAssertion>インスタンスが返却されること</TestAssertion>
        /// <remarks></remarks>
        ///--------------------------------------------------------------------
        [TestMethod()]
        public void TestCtor01()
        {
            InvalidRequestException target = new InvalidRequestException();

            Assert.IsNotNull(target);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(InvalidRequestException), LogLevel.INFO));
        }

        ///--------------------------------------------------------------------
        /// <summary>
        /// TerasolunaException (string) のテスト
        /// </summary>
        /// <TestTarget>ctor</TestTarget>
        /// <TestPreCondition></TestPreCondition>
        /// <TestAssertion>設定したメッセージを取得できること</TestAssertion>
        /// <remarks></remarks>
        ///--------------------------------------------------------------------
        [TestMethod()]
        public void TestCtor02()
        {
            string message = "TERASOLUNA";
            InvalidRequestException target = new InvalidRequestException(message);
            Assert.AreEqual("TERASOLUNA", target.Message);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(InvalidRequestException), LogLevel.INFO));
        }

        ///--------------------------------------------------------------------
        /// <summary>
        /// TerasolunaException (string, Exception) のテスト
        /// </summary>
        /// <TestTarget>ctor</TestTarget>
        /// <TestPreCondition></TestPreCondition>
        /// <TestAssertion>設定したメッセージを取得できること</TestAssertion>
        /// <TestAssertion>設定した例外を取得できること</TestAssertion>
        /// <remarks></remarks>
        ///--------------------------------------------------------------------
        [TestMethod()]
        public void TestCtor03()
        {
            string message = "TERASOLUNA";
            System.Exception inner = new ArgumentException();
            InvalidRequestException target =
                new InvalidRequestException(message, inner);
            Assert.AreEqual("TERASOLUNA", target.Message);
            Assert.IsTrue(target.InnerException is ArgumentException);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(InvalidRequestException), LogLevel.INFO));
        }

        ///--------------------------------------------------------------------
        /// <summary>
        /// TerasolunaException (string) のテスト
        /// </summary>
        /// <TestTarget>ctor</TestTarget>
        /// <TestPreCondition>引数に空文字を指定</TestPreCondition>
        /// <TestAssertion>例外がスローされないこと</TestAssertion>
        /// <remarks></remarks>
        ///--------------------------------------------------------------------
        [TestMethod()]
        public void TestCtor06()
        {
            string message = "";

            InvalidRequestException target = new InvalidRequestException(message);

            Assert.IsNotNull(target);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(InvalidRequestException), LogLevel.INFO));
        }

        ///--------------------------------------------------------------------
        /// <summary>
        /// TerasolunaException (string) のテスト
        /// </summary>
        /// <TestTarget>ctor</TestTarget>
        /// <TestPreCondition>引数にnullを指定</TestPreCondition>
        /// <TestAssertion>例外がスローされないこと</TestAssertion>
        /// <remarks></remarks>
        ///--------------------------------------------------------------------
        [TestMethod()]
        public void TestCtor07()
        {
            string message = null;

            InvalidRequestException target = new InvalidRequestException(message);

            Assert.IsNotNull(target);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(InvalidRequestException), LogLevel.INFO));
        }


        ///--------------------------------------------------------------------
        /// <summary>
        /// TerasolunaException (string, Exception) のテスト
        /// </summary>
        /// <TestTarget>ctor</TestTarget>
        /// <TestPreCondition></TestPreCondition>
        /// <TestPreCondition>第一引数に空文字を指定</TestPreCondition>
        /// <TestAssertion>例外がスローされないこと</TestAssertion>
        /// <remarks></remarks>
        ///--------------------------------------------------------------------
        [TestMethod()]
        public void TestCtor08()
        {
            string message = "";
            Exception inner = new ArgumentException();

            InvalidRequestException target = new InvalidRequestException(message, inner);
            Assert.IsNotNull(target);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(InvalidRequestException), LogLevel.INFO));
        }

        ///--------------------------------------------------------------------
        /// <summary>
        /// TerasolunaException (string, Exception) のテスト
        /// </summary>
        /// <TestTarget>ctor</TestTarget>
        /// <TestPreCondition></TestPreCondition>
        /// <TestPreCondition>第一引数にnullを指定</TestPreCondition>
        /// <TestAssertion>例外がスローされないこと</TestAssertion>
        /// <remarks></remarks>
        ///--------------------------------------------------------------------
        [TestMethod()]
        public void TestCtor09()
        {
            string message = null;
            Exception inner = new ArgumentException();

            InvalidRequestException target = new InvalidRequestException(message, inner);

            Assert.IsNotNull(target);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(InvalidRequestException), LogLevel.INFO));
        }

        ///--------------------------------------------------------------------
        /// <summary>
        /// TerasolunaException (string, Exception) のテスト
        /// </summary>
        /// <TestTarget>ctor</TestTarget>
        /// <TestPreCondition></TestPreCondition>
        /// <TestPreCondition>第二引数にnullを指定</TestPreCondition>
        /// <TestAssertion>例外がスローされないこと</TestAssertion>
        /// <remarks></remarks>
        ///--------------------------------------------------------------------
        [TestMethod()]
        public void TestCtor10()
        {
            string message = "TERASOLUNA";
            System.Exception inner = new ArgumentException();
            inner = null;

            InvalidRequestException target = new InvalidRequestException(message, inner);

            Assert.IsNotNull(target);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(InvalidRequestException), LogLevel.INFO));
        }

        ///--------------------------------------------------------------------
        /// <summary>
        /// TerasolunaException(SerializationInfo, StreamingContext) のテスト
        /// </summary>
        /// <TestTarget>ctor</TestTarget>
        /// <TestAssertion>例外がスローされないこと</TestAssertion>
        /// <remarks></remarks>
        ///--------------------------------------------------------------------
        [TestMethod()]
        public void TestCtor11()
        {
            string expectedMessage = "TERASOLUNA";
            InvalidRequestException newException = new InvalidRequestException(expectedMessage);
            InvalidRequestException deserializeException = null;

            // シリアライズ用に利用
            using (MemoryStream stream = new MemoryStream())
            {
                // 例外をシリアライズ
                IFormatter formatter = new BinaryFormatter();
                formatter.Serialize(stream, newException);

                // シリアライズした例外をデシリアライズ
                stream.Position = 0;
                deserializeException = (InvalidRequestException)formatter.Deserialize(stream);
            }

            //確認
            Assert.IsNotNull(newException);
            Assert.IsNotNull(deserializeException);
            Assert.AreEqual(expectedMessage, deserializeException.Message);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(InvalidRequestException), LogLevel.INFO));
        }
    }
}
