// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Configuration;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using Microsoft.Practices.EnterpriseLibrary.Validation.Configuration;
using TERASOLUNA.Fw.Common.Validation.Validators;

namespace TERASOLUNA.Fw.Common.Validation.Configuration
{
    /// <summary>
    /// ݒ񂩂 <see cref="ByteRangeValidator"/> 𐶐E邽߂ <see cref="ValidatorData"/> pNXłB
    /// </summary>
    public class ByteRangeValidatorData : ValueValidatorData
    {
        private const string MAXBYTE_LENGTH_PROPERTY_NAME = "maxByteLength";
        private const string MINBYTE_LENGTH_PROPERTY_NAME = "minByteLength";
        private const string ENCODING_NAME_PROPERTY_NAME = "encodingName";

        /// <summary>
        /// <see cref="ByteRangeValidatorData"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public ByteRangeValidatorData()
        { }

        /// <summary>
        /// oCg̍ől擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>oCg̍őlB</value>
        [ConfigurationProperty(MAXBYTE_LENGTH_PROPERTY_NAME, DefaultValue = int.MaxValue)]
        public int MaxByteLength
        {
            get { return (int)this[MAXBYTE_LENGTH_PROPERTY_NAME]; }
            set { this[MAXBYTE_LENGTH_PROPERTY_NAME] = value; }
        }

        /// <summary>
        /// oCg̍ŏl擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>oCg̍ŏlB</value>
        [ConfigurationProperty(MINBYTE_LENGTH_PROPERTY_NAME, DefaultValue = 0)]
        public int MinByteLength
        {
            get { return (int)this[MINBYTE_LENGTH_PROPERTY_NAME]; }
            set { this[MINBYTE_LENGTH_PROPERTY_NAME] = value; }
        }

        /// <summary>
        /// oCgɕϊۗpGR[h擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>GR[hB</value>
        [ConfigurationProperty(ENCODING_NAME_PROPERTY_NAME, DefaultValue = "utf-8")]
        public string EncodingName
        {
            get { return (string)this[ENCODING_NAME_PROPERTY_NAME]; }
            set { this[ENCODING_NAME_PROPERTY_NAME] = value; }
        }

        /// <summary>
        /// ݒ <see cref="ByteRangeValidator"/> ̃CX^X𐶐܂B
        /// </summary>
        /// <remarks>
        /// <see cref="ByteRangeValidator"/> ̃CX^X𐶐Aԋp܂B
        /// </remarks>
        /// <param name="targetType">ؑΏۂ̒ľ^B</param>
        /// <returns>ꂽ <see cref="ByteRangeValidator"/> B</returns>
        /// <exception cref="ArgumentException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="minByteLength"/>  0 łB
        /// </item>
        /// <item>
        /// <paramref name="maxByteLength"/>  0 łB
        /// </item>
        /// <item>
        /// <paramref name="maxByteLength"/>  <paramref name="minByteLength"/> 菬łB
        /// </item>
        /// <item>
        /// <paramref name="encodingName"/> 󕶎łB
        /// </item>
        /// <item>
        /// <paramref name="encodingName"/> LȃGR[hłȂB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="encodingName"/>  null QƂłB
        /// </exception>    
        protected override Validator DoCreateValidator(Type targetType)
        {
            return new ByteRangeValidator(MinByteLength,
                                       MaxByteLength,
                                       EncodingName,
                                       MessageTemplate,
                                       Tag,
                                       Negated);
        }
    }
}
