// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Web.Controller;
using System.Data;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.WebUT.Controller
{
    /// <summary>
    ///TERASOLUNA.Fw.Web.Controller.ControllerInfoAttribute のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Web.Controller.ControllerInfoAttribute 単体テストをここに含めます
    ///</summary>
    
    [TestClass()]
    public class ControllerInfoAttributeTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        ///RequestType のテスト
        ///</summary>
        /// <TestTarget>RequestType</TestTarget>
        /// <TestCondition>設定する値を空文字以外の文字列とすること</TestCondition>
        /// <TestAssertion>RequestTypeプロパティに設定した値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestRequestType01()
        {
            ControllerInfoAttribute target = new ControllerInfoAttribute();

            string val = "Normal";

            target.RequestType = val;

            Assert.AreEqual(val, target.RequestType);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ControllerInfoAttribute), LogLevel.INFO));

        }

        /// <summary>
        ///RequestType のテスト
        ///</summary>
        /// <TestTarget>RequestType</TestTarget>
        /// <TestCondition>設定する値を空文字とすること</TestCondition>
        /// <TestAssertion>RequestTypeプロパティに設定した値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestRequestType02()
        {
            ControllerInfoAttribute target = new ControllerInfoAttribute();

            string val = "";

            target.RequestType = val;

            Assert.AreEqual(val, target.RequestType);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ControllerInfoAttribute), LogLevel.INFO));

        }

        /// <summary>
        ///RequestType のテスト
        ///</summary>
        /// <TestTarget>RequestType</TestTarget>
        /// <TestCondition>設定する値をnullとすること</TestCondition>
        /// <TestAssertion>RequestTypeプロパティに設定した値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestRequestType03()
        {
            ControllerInfoAttribute target = new ControllerInfoAttribute();

            string val = null;

            target.RequestType = val;

            Assert.AreEqual(val, target.RequestType);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ControllerInfoAttribute), LogLevel.INFO));

        }

        /// <summary>
        ///InputDataSetType のテスト
        ///</summary>
        /// <TestTarget>InputDataSetType</TestTarget>
        /// <TestCondition>設定する値を空文字以外の文字列とすること</TestCondition>
        /// <TestAssertion>InputDataSetTypeプロパティに設定した値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestInputDataSetType01()
        {
            ControllerInfoAttribute target = new ControllerInfoAttribute();

            Type val = typeof(DataSet);

            target.InputDataSetType = val;

            Assert.AreEqual(val, target.InputDataSetType);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ControllerInfoAttribute), LogLevel.INFO));

        }

        /// <summary>
        ///InputDataSetType のテスト
        ///</summary>
        /// <TestTarget>InputDataSetType</TestTarget>
        /// <TestCondition>設定する値をnullとすること</TestCondition>
        /// <TestAssertion>InputDataSetTypeプロパティに設定した値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestInputDataSetType02()
        {
            ControllerInfoAttribute target = new ControllerInfoAttribute();

            Type val = null;

            target.InputDataSetType = val;

            Assert.AreEqual(val, target.InputDataSetType);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ControllerInfoAttribute), LogLevel.INFO));

        }
    }
}
