// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Web.Configuration.ExceptionCode;
using TERASOLUNA.Fw.Web.Configuration.ExceptionTransition;
using TERASOLUNA.Fw.Web.Configuration.Page;
using TERASOLUNA.Fw.Web.Configuration.RequestController;
using TERASOLUNA.Fw.Web.Configuration.Sql;
using TERASOLUNA.Fw.Web.Configuration;
using TERASOLUNA.Fw.Common.Configuration.BLogic;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
using System.Configuration;
using TERASOLUNA.Fw.Common;

namespace TERASOLUNA.Fw.WebUT.Configuration
{
    /// <summary>
    ///TERASOLUNA.Fw.Web.Configuration.TerasolunaWebConfiguration のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Web.Configuration.TerasolunaWebConfiguration 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class TerasolunaWebConfigurationTest
    {

        private TestContext testContextInstance;

        /// <summary>
        /// 現在のテストの実行についての情報および機能を
        /// 提供するテスト コンテキストを取得または設定します。
        /// </summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();

            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor._sqlConfigSection = null;
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor._pageConfigSection = null;
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor._exceptionTransitConfigSection = null;
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor._requestControllerConfigSection = null;
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor._exceptionCodeConfigSection = null;
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        [TestCleanup()]
        public void MyTestCleanup()
        {
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor.SQLCONFIGURAION_SECTION_NAME = "sqlConfiguration";
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor._sqlConfigSection = null;
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor.PAGECONFIGURAION_SECTION_NAME = "pageConfiguration";
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor._pageConfigSection = null;
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor.EXCEPTION_TRANSITION_CONFIGURATION_NAME = "exceptionTransitionConfiguration";
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor._exceptionTransitConfigSection = null;
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor.REQUEST_CONTROLLER_CONFIGURATION_NAME = "requestControllerConfiguration";
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor._requestControllerConfigSection = null;
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor.EXCEPTION_CODE_CONFIGURATION_NAME = "exceptionCodeConfiguration";
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor._exceptionCodeConfigSection = null;
        }
        
        #endregion

        /// <summary>
        /// SqlConfigSection のテスト
        /// </summary>
        /// <TestTarget>SqlConfigSection</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>SqlConfigurationSectionのインスタンスが取得され、Sql要素が存在すること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlExternal01.config")]
        public void TestSqlConfigSection01()
        {
            SqlConfigurationSection target = TerasolunaWebConfiguration.SqlConfigSection;

            Assert.IsInstanceOfType(target, typeof(SqlConfigurationSection));

            Assert.IsTrue(target.Sqls.Count > 0);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaWebConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// SqlConfigSection のテスト
        /// </summary>
        /// <TestTarget>SqlConfigSection</TestTarget>
        /// <TestCondition>
        /// 構成ファイルのappSettings要素に"sqlConfiguration"キーがあり、
        /// value 属性が SqlConfigurationSection 型ではないこと
        /// </TestCondition>
        /// <TestAssertion>ConfigurationErrorsException が発生すること</TestAssertion>
        [TestMethod()]
        public void TestSqlConfigSection02()
        {
            // 準備
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor.SQLCONFIGURAION_SECTION_NAME = "dummyConfiguration";

            try
            {
                // 実施
                SqlConfigurationSection target = TerasolunaWebConfiguration.SqlConfigSection;
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 確認
                string exceptionMessage = string.Format(
                    MessageManager.GetMessage("E_CONFIGURATION_INVALID_CAST", "SqlConfiguration", typeof(DummyConfigurationSection).FullName));
                Assert.AreEqual(exceptionMessage, e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            // 確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(TerasolunaWebConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(TerasolunaWebConfiguration), typeof(ConfigurationErrorsException),
                "E_CONFIGURATION_INVALID_CAST", "SqlConfiguration", typeof(DummyConfigurationSection).FullName));
        }

        /// <summary>
        /// SqlConfigSection のテスト
        /// </summary>
        /// <TestTarget>SqlConfigSection</TestTarget>
        /// <TestCondition>構成ファイルのappSettings要素に"sqlConfiguration"キーがないこと</TestCondition>
        /// <TestAssertion>nullが返却されること</TestAssertion>
        [TestMethod()]
        public void TestSqlConfigSection03()
        {
            // 準備
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor.SQLCONFIGURAION_SECTION_NAME = "noConfiguration";

            // 実施
            SqlConfigurationSection target = TerasolunaWebConfiguration.SqlConfigSection;

            // 確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaWebConfiguration), LogLevel.INFO));
            Assert.IsNull(target);
            Assert.IsNull(TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor._sqlConfigSection);
        }

        /// <summary>
        /// PageConfigSection のテスト
        /// </summary>
        /// <TestTarget>PageConfigSection</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>PageConfigurationSectionのインスタンスが取得され、page要素が存在すること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestPageConfigSection01()
        {
            PageConfigurationSection target = TerasolunaWebConfiguration.PageConfigSection;

            Assert.IsInstanceOfType(target, typeof(PageConfigurationSection));
            Assert.IsTrue(target.Pages.Count > 0);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaWebConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// PageConfigSection のテスト
        /// </summary>
        /// <TestTarget>PageConfigSection</TestTarget>
        /// <TestCondition>
        /// 構成ファイルのappSettings要素に"pageConfiguration"キーがあり、
        /// value 属性が PageConfigSection 型ではないこと
        /// </TestCondition>
        /// <TestAssertion>ConfigurationErrorsException が発生すること</TestAssertion>
        [TestMethod()]
        public void TestPageConfigSection02()
        {
            // 準備
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor.PAGECONFIGURAION_SECTION_NAME = "dummyConfiguration";

            try
            {
                // 実施
                PageConfigurationSection target = TerasolunaWebConfiguration.PageConfigSection;
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 確認
                string exceptionMessage = string.Format(
                    MessageManager.GetMessage("E_CONFIGURATION_INVALID_CAST", "PageConfiguration", typeof(DummyConfigurationSection).FullName));
                Assert.AreEqual(exceptionMessage, e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            // 確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(TerasolunaWebConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(TerasolunaWebConfiguration), typeof(ConfigurationErrorsException),
                "E_CONFIGURATION_INVALID_CAST", "PageConfiguration", typeof(DummyConfigurationSection).FullName));
        }

        /// <summary>
        /// PageConfigSection のテスト
        /// </summary>
        /// <TestTarget>PageConfigSection</TestTarget>
        /// <TestCondition>構成ファイルのappSettings要素に"pageConfiguration"キーがないこと</TestCondition>
        /// <TestAssertion>nullが返却されること</TestAssertion>
        [TestMethod()]
        public void TestPageConfigSection03()
        {
            // 準備
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor.PAGECONFIGURAION_SECTION_NAME = "noConfiguration";

            // 実施
            PageConfigurationSection target = TerasolunaWebConfiguration.PageConfigSection;

            // 確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaWebConfiguration), LogLevel.INFO));
            Assert.IsNull(target);
            Assert.IsNull(TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor._pageConfigSection);
        }

        /// <summary>
        /// ExceptionTransitionConfigSection のテスト
        /// </summary>
        /// <TestTarget>ExceptionTransitionConfigSection</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>ExceptionTransitionConfigurationSectionのインスタンスが取得され、exceptionTransition要素が存在すること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal01.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal02.config")]
        public void TestExceptionTransitionConfigSection01()
        {
            ExceptionTransitionConfigurationSection target = TerasolunaWebConfiguration.ExceptionTransitionConfigSection;

            Assert.IsInstanceOfType(target, typeof(ExceptionTransitionConfigurationSection));
            Assert.IsTrue(target.ExceptionTransitionCollection.Count > 0);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaWebConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// ExceptionTransitionConfigSection のテスト
        /// </summary>
        /// <TestTarget>ExceptionTransitionConfigSection</TestTarget>
        /// <TestCondition>
        /// 構成ファイルのappSettings要素に"exceptionTransitionConfiguration"キーがあり、
        /// value 属性が ExceptionTransitionConfigurationSection 型ではないこと
        /// </TestCondition>
        /// <TestAssertion>ConfigurationErrorsException が発生すること</TestAssertion>
        [TestMethod()]
        public void TestExceptionTransitionConfigSection02()
        {
            // 準備
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor.EXCEPTION_TRANSITION_CONFIGURATION_NAME = "dummyConfiguration";

            try
            {
                // 実施
                ExceptionTransitionConfigurationSection target = TerasolunaWebConfiguration.ExceptionTransitionConfigSection;
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 確認
                string exceptionMessage = string.Format(
                    MessageManager.GetMessage("E_CONFIGURATION_INVALID_CAST", "ExceptionTransitionConfiguration", typeof(DummyConfigurationSection).FullName));
                Assert.AreEqual(exceptionMessage, e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            // 確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(TerasolunaWebConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(TerasolunaWebConfiguration), typeof(ConfigurationErrorsException),
                "E_CONFIGURATION_INVALID_CAST", "ExceptionTransitionConfiguration", typeof(DummyConfigurationSection).FullName));
        }

        /// <summary>
        /// ExceptionTransitionConfigSection のテスト
        /// </summary>
        /// <TestTarget>ExceptionTransitionConfigSection</TestTarget>
        /// <TestCondition>構成ファイルのappSettings要素に"exceptionTransitionConfiguration"キーがないこと</TestCondition>
        /// <TestAssertion>nullが返却されること</TestAssertion>
        [TestMethod()]
        public void TestExceptionTransitionConfigSection03()
        {
            // 準備
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor.EXCEPTION_TRANSITION_CONFIGURATION_NAME = "noConfiguration";

            // 実施
            ExceptionTransitionConfigurationSection target = TerasolunaWebConfiguration.ExceptionTransitionConfigSection;

            // 確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaWebConfiguration), LogLevel.INFO));
            Assert.IsNull(target);
            Assert.IsNull(TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor._exceptionTransitConfigSection);
        }

        /// <summary>
        /// ExceptionCodeConfigSection のテスト
        /// </summary>
        /// <TestTarget>ExceptionCodeConfigSection</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>ExceptionCodeConfigSectionのインスタンスが取得され、exceptionCode要素が存在すること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeExternal01.config")]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeExternal11.config")]
        public void TestExceptionCodeConfigSection01()
        {
            ExceptionCodeConfigurationSection target = TerasolunaWebConfiguration.ExceptionCodeConfigSection;

            Assert.IsInstanceOfType(target, typeof(ExceptionCodeConfigurationSection));
            Assert.IsTrue(target.ExceptionCodeCollection.Count > 0);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaWebConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// ExceptionCodeConfigSection のテスト
        /// </summary>
        /// <TestTarget>ExceptionCodeConfigSection</TestTarget>
        /// <TestCondition>
        /// 構成ファイルのappSettings要素に"exceptionCodeConfiguration"キーがあり、
        /// value 属性が ExceptionCodeConfigurationSection 型ではないこと
        /// </TestCondition>
        /// <TestAssertion>ConfigurationErrorsException が発生すること</TestAssertion>
        [TestMethod()]
        public void TestExceptionCodeConfigSection02()
        {
            // 準備
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor.EXCEPTION_CODE_CONFIGURATION_NAME = "dummyConfiguration";

            try
            {
                // 実施
                ExceptionCodeConfigurationSection target = TerasolunaWebConfiguration.ExceptionCodeConfigSection;
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 確認
                string exceptionMessage = string.Format(
                    MessageManager.GetMessage("E_CONFIGURATION_INVALID_CAST", "ExceptionCodeConfiguration", typeof(DummyConfigurationSection).FullName));
                Assert.AreEqual(exceptionMessage, e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            // 確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(TerasolunaWebConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(TerasolunaWebConfiguration), typeof(ConfigurationErrorsException),
                "E_CONFIGURATION_INVALID_CAST", "ExceptionCodeConfiguration", typeof(DummyConfigurationSection).FullName));
        }

        /// <summary>
        /// ExceptionCodeConfigurationSection のテスト
        /// </summary>
        /// <TestTarget>ExceptionCodeConfigurationSection</TestTarget>
        /// <TestCondition>構成ファイルのappSettings要素に"exceptionCodeConfiguration"キーがないこと</TestCondition>
        /// <TestAssertion>nullが返却されること</TestAssertion>
        [TestMethod()]
        public void TestExceptionCodeConfigSection03()
        {
            // 準備
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor.EXCEPTION_CODE_CONFIGURATION_NAME = "noConfiguration";

            // 実施
            ExceptionCodeConfigurationSection target = TerasolunaWebConfiguration.ExceptionCodeConfigSection;

            // 確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaWebConfiguration), LogLevel.INFO));
            Assert.IsNull(target);
            Assert.IsNull(TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor._exceptionCodeConfigSection);
        }

        /// <summary>
        /// RequestControllerConfigSection のテスト
        /// </summary>
        /// <TestTarget>RequestControllerConfigSection</TestTarget>
        /// <TestCondition>構成ファイルが正常なこと</TestCondition>
        /// <TestAssertion>RequestControllerConfigSectionのインスタンスが取得され、controllers要素が存在すること</TestAssertion>
        [TestMethod()]
        public void TestRequestControllerConfigSection01()
        {
            RequestControllerConfigurationSection target = TerasolunaWebConfiguration.RequestControllerConfigSection;

            Assert.IsInstanceOfType(target, typeof(RequestControllerConfigurationSection));
            Assert.IsTrue(target.Controllers.Count > 0);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaWebConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// RequestControllerConfigSection のテスト
        /// </summary>
        /// <TestTarget>RequestControllerConfigSection</TestTarget>
        /// <TestCondition>
        /// 構成ファイルのappSettings要素に"requestControllerConfiguration"キーがあり、
        /// value 属性が RequestControllerConfigurationSection 型ではないこと
        /// </TestCondition>
        /// <TestAssertion>ConfigurationErrorsException が発生すること</TestAssertion>
        [TestMethod()]
        public void TestRequestControllerConfigSection02()
        {
            // 準備
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor.REQUEST_CONTROLLER_CONFIGURATION_NAME = "dummyConfiguration";

            try
            {
                // 実施
                RequestControllerConfigurationSection target = TerasolunaWebConfiguration.RequestControllerConfigSection;
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 確認
                string exceptionMessage = string.Format(
                    MessageManager.GetMessage("E_CONFIGURATION_INVALID_CAST", "RequestControllerConfiguration", typeof(DummyConfigurationSection).FullName));
                Assert.AreEqual(exceptionMessage, e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            // 確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(TerasolunaWebConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(TerasolunaWebConfiguration), typeof(ConfigurationErrorsException),
                "E_CONFIGURATION_INVALID_CAST", "RequestControllerConfiguration", typeof(DummyConfigurationSection).FullName));
        }

        /// <summary>
        /// RequestControllerConfigSection のテスト
        /// </summary>
        /// <TestTarget>RequestControllerConfigSection</TestTarget>
        /// <TestCondition>構成ファイルのappSettings要素に"requestControllerConfiguration"キーがないこと</TestCondition>
        /// <TestAssertion>nullが返却されること</TestAssertion>
        [TestMethod()]
        public void TestRequestControllerConfigSection03()
        {
            // 準備
            TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor.REQUEST_CONTROLLER_CONFIGURATION_NAME = "noConfiguration";

            // 実施
            RequestControllerConfigurationSection target = TerasolunaWebConfiguration.RequestControllerConfigSection;

            // 確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaWebConfiguration), LogLevel.INFO));
            Assert.IsNull(target);
            Assert.IsNull(TERASOLUNA_Fw_Web_Configuration_TerasolunaWebConfigurationAccessor._requestControllerConfigSection);
        }
    }
}
