// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Web.Configuration.Sql;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.WebUT.Configuration.Sql
{
    /// <summary>
    /// TERASOLUNA.Fw.Common.Configuration.SqlElement のテスト クラスです。すべての
    /// TERASOLUNA.Fw.Common.Configuration.SqlElement 単体テストをここに含めます
    /// </summary>
   
    [TestClass()]
    public class SqlElementTest
    {

        private TestContext testContextInstance;

        /// <summary>
        /// 現在のテストの実行についての情報および機能を
        /// 提供するテスト コンテキストを取得または設定します。
        /// </summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        /// SqlElement () のテスト
        /// </summary>
        /// <TestTarget>Constructor()</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>インスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor01()
        {
            SqlElement target = new SqlElement();
            Assert.IsNotNull(target);
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlElement), LogLevel.INFO));
        }

        /// <summary>
        /// SqlElement (string, string) のテスト
        /// </summary>
        /// <TestTarget>Constructor(string, string)</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor02()
        {
            string name = "SQL1";
            string statement = "SELECT * FROM TEST";

            SqlElement target = new SqlElement(name, statement);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(statement, target.Statement);
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlElement), LogLevel.INFO));
        }

        /// <summary>
        /// Name のテスト
        /// </summary>
        /// <TestTarget>Name</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>name属性の値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestName01()
        {
            string name = "SQL1";
            string statement = "SELECT * FROM TEST";

            SqlElement target = new SqlElement(name, statement);

            Assert.AreEqual(name, target.Name);
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlElement), LogLevel.INFO));
        }

        /// <summary>
        /// Statement のテスト
        /// </summary>
        /// <TestTarget>Statement</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>statement属性の値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestStatement01()
        {
            string name = "SQL1";
            string statement = "SELECT * FROM TEST";

            SqlElement target = new SqlElement(name, statement);

            Assert.AreEqual(statement, target.Statement);
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlElement), LogLevel.INFO));
        }

        /// <summary>
        /// SqlElement (string, string) のテスト
        /// </summary>
        /// <TestTarget>Constructor(string, string)</TestTarget>
        /// <TestCondition>nameが空文字の場合</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor03()
        {
            string name = "";
            string statement = "SELECT * FROM TEST";

            SqlElement target = new SqlElement(name, statement);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(statement, target.Statement);
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlElement), LogLevel.INFO));
        }

        /// <summary>
        /// SqlElement (string, string) のテスト
        /// </summary>
        /// <TestTarget>Constructor(string, string)</TestTarget>
        /// <TestCondition>nameがnullの場合</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor04()
        {
            string name = null;
            string statement = "SELECT * FROM TEST";

            SqlElement target = new SqlElement(name, statement);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(statement, target.Statement);
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlElement), LogLevel.INFO));
        }

        /// <summary>
        /// SqlElement (string, string) のテスト
        /// </summary>
        /// <TestTarget>Constructor(string, string)</TestTarget>
        /// <TestCondition>statementが空文字の場合</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor05()
        {
            string name = "SQL1";
            string statement = "";

            SqlElement target = new SqlElement(name, statement);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(statement, target.Statement);
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlElement), LogLevel.INFO));
        }

        /// <summary>
        /// SqlElement (string, string) のテスト
        /// </summary>
        /// <TestTarget>Constructor(string, string)</TestTarget>
        /// <TestCondition>statementがnullの場合</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor06()
        {
            string name = "SQL1";
            string statement = null;

            SqlElement target = new SqlElement(name, statement);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(statement, target.Statement);
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlElement), LogLevel.INFO));
        }
    }
}
