// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Web.Configuration.Page;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.WebUT.Configuration.Page
{
    /// <summary>
    ///TERASOLUNA.Fw.Common.Configuration.PageElement のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Common.Configuration.PageElement 単体テストをここに含めます
    ///</summary>

    [TestClass()]
    public class PageElementTest
    {

        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        ///PageElement () のテスト
        ///</summary>
        /// <TestTarget>Constructor()</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>インスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor01()
        {
            PageElement target = new PageElement();
            Assert.IsNotNull(target);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageElement), LogLevel.INFO));
        }

        /// <summary>
        ///PageElement (string, string, string, string, string, string) のテスト
        ///</summary>
        /// <TestTarget>Constructor(string, string, string, string, string, string)</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor02()
        {
            string name = "XXX_001";
            string path = "/XXX001.aspx";
            string preventDoubleSubmit = "on";
            string setToken = "off";
            string checkToken = "off";
            string updateToken = "off";

            PageElement target = new PageElement(name, path, preventDoubleSubmit, setToken, checkToken, updateToken);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(path, target.Path);
            Assert.AreEqual(preventDoubleSubmit, target.Pds);
            Assert.AreEqual(setToken, target.SetToken);
            Assert.AreEqual(checkToken, target.CheckToken);
            Assert.AreEqual(updateToken, target.UpdateToken);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageElement), LogLevel.INFO));
        }

        /// <summary>
        ///PageElement (string, string, string, string, string, string) のテスト
        ///</summary>
        /// <TestTarget>Constructor(string, string, string, string, string, string)</TestTarget>
        /// <TestCondition>引数nameにnullを設定すること</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor03()
        {
            string name = null;
            string path = "/XXX001.aspx";
            string preventDoubleSubmit = "on";
            string setToken = "off";
            string checkToken = "off";
            string updateToken = "off";

            PageElement target = new PageElement(name, path, preventDoubleSubmit, setToken, checkToken, updateToken);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(path, target.Path);
            Assert.AreEqual(preventDoubleSubmit, target.Pds);
            Assert.AreEqual(setToken, target.SetToken);
            Assert.AreEqual(checkToken, target.CheckToken);
            Assert.AreEqual(updateToken, target.UpdateToken);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageElement), LogLevel.INFO));
        }

        /// <summary>
        ///PageElement (string, string, string, string, string, string) のテスト
        ///</summary>
        /// <TestTarget>Constructor(string, string, string, string, string, string)</TestTarget>
        /// <TestCondition>引数nameに空文字を設定すること</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor04()
        {
            string name = "";
            string path = "/XXX001.aspx";
            string preventDoubleSubmit = "on";
            string setToken = "off";
            string checkToken = "off";
            string updateToken = "off";

            PageElement target = new PageElement(name, path, preventDoubleSubmit, setToken, checkToken, updateToken);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(path, target.Path);
            Assert.AreEqual(preventDoubleSubmit, target.Pds);
            Assert.AreEqual(setToken, target.SetToken);
            Assert.AreEqual(checkToken, target.CheckToken);
            Assert.AreEqual(updateToken, target.UpdateToken);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageElement), LogLevel.INFO));
        }

        /// <summary>
        ///PageElement (string, string, string, string, string, string) のテスト
        ///</summary>
        /// <TestTarget>Constructor(string, string, string, string, string, string)</TestTarget>
        /// <TestCondition>引数pathにnullを設定すること</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor05()
        {
            string name = "XXX_001";
            string path = null;
            string preventDoubleSubmit = "on";
            string setToken = "off";
            string checkToken = "off";
            string updateToken = "off";

            PageElement target = new PageElement(name, path, preventDoubleSubmit, setToken, checkToken, updateToken);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(path, target.Path);
            Assert.AreEqual(preventDoubleSubmit, target.Pds);
            Assert.AreEqual(setToken, target.SetToken);
            Assert.AreEqual(checkToken, target.CheckToken);
            Assert.AreEqual(updateToken, target.UpdateToken);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageElement), LogLevel.INFO));
        }

        /// <summary>
        ///PageElement (string, string, string, string, string, string) のテスト
        ///</summary>
        /// <TestTarget>Constructor(string, string, string, string, string, string)</TestTarget>
        /// <TestCondition>引数pathに空文字を設定すること</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor06()
        {
            string name = "XXX_001";
            string path = "";
            string preventDoubleSubmit = "on";
            string setToken = "off";
            string checkToken = "off";
            string updateToken = "off";

            PageElement target = new PageElement(name, path, preventDoubleSubmit, setToken, checkToken, updateToken);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(path, target.Path);
            Assert.AreEqual(preventDoubleSubmit, target.Pds);
            Assert.AreEqual(setToken, target.SetToken);
            Assert.AreEqual(checkToken, target.CheckToken);
            Assert.AreEqual(updateToken, target.UpdateToken);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageElement), LogLevel.INFO));
        }

        /// <summary>
        ///PageElement (string, string, string, string, string, string) のテスト
        ///</summary>
        /// <TestTarget>Constructor(string, string, string, string, string, string)</TestTarget>
        /// <TestCondition>引数preventDoubleSubmitにnullを設定すること</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor07()
        {
            string name = "XXX_001";
            string path = "/XXX001.aspx";
            string preventDoubleSubmit = null;
            string setToken = "off";
            string checkToken = "off";
            string updateToken = "off";

            PageElement target = new PageElement(name, path, preventDoubleSubmit, setToken, checkToken, updateToken);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(path, target.Path);
            Assert.AreEqual(preventDoubleSubmit, target.Pds);
            Assert.AreEqual(setToken, target.SetToken);
            Assert.AreEqual(checkToken, target.CheckToken);
            Assert.AreEqual(updateToken, target.UpdateToken);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageElement), LogLevel.INFO));
        }

        /// <summary>
        ///PageElement (string, string, string, string, string, string) のテスト
        ///</summary>
        /// <TestTarget>Constructor(string, string, string, string, string, string)</TestTarget>
        /// <TestCondition>引数preventDoubleSubmitに空文字を設定すること</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor08()
        {
            string name = "XXX_001";
            string path = "/XXX001.aspx";
            string preventDoubleSubmit = "";
            string setToken = "off";
            string checkToken = "off";
            string updateToken = "off";

            PageElement target = new PageElement(name, path, preventDoubleSubmit, setToken, checkToken, updateToken);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(path, target.Path);
            Assert.AreEqual(preventDoubleSubmit, target.Pds);
            Assert.AreEqual(setToken, target.SetToken);
            Assert.AreEqual(checkToken, target.CheckToken);
            Assert.AreEqual(updateToken, target.UpdateToken);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageElement), LogLevel.INFO));
        }

        /// <summary>
        ///PageElement (string, string, string, string, string, string) のテスト
        ///</summary>
        /// <TestTarget>Constructor(string, string, string, string, string, string)</TestTarget>
        /// <TestCondition>引数setTokenにnullを設定すること</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor09()
        {
            string name = "XXX_001";
            string path = "/XXX001.aspx";
            string preventDoubleSubmit = "on";
            string setToken = null;
            string checkToken = "off";
            string updateToken = "off";

            PageElement target = new PageElement(name, path, preventDoubleSubmit, setToken, checkToken, updateToken);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(path, target.Path);
            Assert.AreEqual(preventDoubleSubmit, target.Pds);
            Assert.AreEqual(setToken, target.SetToken);
            Assert.AreEqual(checkToken, target.CheckToken);
            Assert.AreEqual(updateToken, target.UpdateToken);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageElement), LogLevel.INFO));
        }

        /// <summary>
        ///PageElement (string, string, string, string, string, string) のテスト
        ///</summary>
        /// <TestTarget>Constructor(string, string, string, string, string, string)</TestTarget>
        /// <TestCondition>引数setTokenに空文字を設定すること</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor10()
        {
            string name = "XXX_001";
            string path = "/XXX001.aspx";
            string preventDoubleSubmit = "on";
            string setToken = "";
            string checkToken = "off";
            string updateToken = "off";

            PageElement target = new PageElement(name, path, preventDoubleSubmit, setToken, checkToken, updateToken);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(path, target.Path);
            Assert.AreEqual(preventDoubleSubmit, target.Pds);
            Assert.AreEqual(setToken, target.SetToken);
            Assert.AreEqual(checkToken, target.CheckToken);
            Assert.AreEqual(updateToken, target.UpdateToken);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageElement), LogLevel.INFO));
        }

        /// <summary>
        ///PageElement (string, string, string, string, string, string) のテスト
        ///</summary>
        /// <TestTarget>Constructor(string, string, string, string, string, string)</TestTarget>
        /// <TestCondition>引数checkTokenにnullを設定すること</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor11()
        {
            string name = "XXX_001";
            string path = "/XXX001.aspx";
            string preventDoubleSubmit = "on";
            string setToken = "off";
            string checkToken = null;
            string updateToken = "off";

            PageElement target = new PageElement(name, path, preventDoubleSubmit, setToken, checkToken, updateToken);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(path, target.Path);
            Assert.AreEqual(preventDoubleSubmit, target.Pds);
            Assert.AreEqual(setToken, target.SetToken);
            Assert.AreEqual(checkToken, target.CheckToken);
            Assert.AreEqual(updateToken, target.UpdateToken);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageElement), LogLevel.INFO));
        }

        /// <summary>
        ///PageElement (string, string, string, string, string, string) のテスト
        ///</summary>
        /// <TestTarget>Constructor(string, string, string, string, string, string)</TestTarget>
        /// <TestCondition>引数updateTokenに空文字を設定すること</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor12()
        {
            string name = "XXX_001";
            string path = "/XXX001.aspx";
            string preventDoubleSubmit = "on";
            string setToken = "off";
            string checkToken = "";
            string updateToken = null;

            PageElement target = new PageElement(name, path, preventDoubleSubmit, setToken, checkToken, updateToken);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(path, target.Path);
            Assert.AreEqual(preventDoubleSubmit, target.Pds);
            Assert.AreEqual(setToken, target.SetToken);
            Assert.AreEqual(checkToken, target.CheckToken);
            Assert.AreEqual(updateToken, target.UpdateToken);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageElement), LogLevel.INFO));
        }

        /// <summary>
        ///PageElement (string, string, string, string, string, string) のテスト
        ///</summary>
        /// <TestTarget>Constructor(string, string, string, string, string, string)</TestTarget>
        /// <TestCondition>引数updateTokenに空文字を設定すること</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor13()
        {
            string name = "XXX_001";
            string path = "/XXX001.aspx";
            string preventDoubleSubmit = "on";
            string setToken = "off";
            string checkToken = "off";
            string updateToken = "";

            PageElement target = new PageElement(name, path, preventDoubleSubmit, setToken, checkToken, updateToken);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(path, target.Path);
            Assert.AreEqual(preventDoubleSubmit, target.Pds);
            Assert.AreEqual(setToken, target.SetToken);
            Assert.AreEqual(checkToken, target.CheckToken);
            Assert.AreEqual(updateToken, target.UpdateToken);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageElement), LogLevel.INFO));
        }

        /// <summary>
        ///PageElement (string, string, string, string, string, string) のテスト
        ///</summary>
        /// <TestTarget>Constructor(string, string, string, string, string, string)</TestTarget>
        /// <TestCondition>引数updateTokenにnullを設定すること</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor14()
        {
            string name = "XXX_001";
            string path = "/XXX001.aspx";
            string preventDoubleSubmit = "on";
            string setToken = "off";
            string checkToken = "off";
            string updateToken = null;

            PageElement target = new PageElement(name, path, preventDoubleSubmit, setToken, checkToken, updateToken);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(path, target.Path);
            Assert.AreEqual(preventDoubleSubmit, target.Pds);
            Assert.AreEqual(setToken, target.SetToken);
            Assert.AreEqual(checkToken, target.CheckToken);
            Assert.AreEqual(updateToken, target.UpdateToken);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageElement), LogLevel.INFO));
        }


        /// <summary>
        ///Name のテスト
        ///</summary>
        /// <TestTarget>Name</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>name要素の値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestName01()
        {
            string name = "XXX_001";
            string path = "/XXX001.aspx";
            string preventDoubleSubmit = "on";
            string setToken = "off";
            string checkToken = "off";
            string updateToken = "off";

            PageElement target = new PageElement(name, path, preventDoubleSubmit, setToken, checkToken, updateToken);

            Assert.AreEqual(name, target.Name);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageElement), LogLevel.INFO));
        }

        /// <summary>
        ///Path のテスト
        ///</summary>
        /// <TestTarget>Path</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>Path要素の値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestPath01()
        {
            string name = "XXX_001";
            string path = "/XXX001.aspx";
            string preventDoubleSubmit = "on";
            string setToken = "off";
            string checkToken = "off";
            string updateToken = "off";

            PageElement target = new PageElement(name, path, preventDoubleSubmit, setToken, checkToken, updateToken);

            Assert.AreEqual(path, target.Path);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageElement), LogLevel.INFO));
        }

        /// <summary>
        ///preventDoubleSubmit のテスト
        ///</summary>
        /// <TestTarget>preventDoubleSubmit</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>preventDoubleSubmit要素の値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestPds01()
        {
            string name = "XXX_001";
            string path = "/XXX001.aspx";
            string preventDoubleSubmit = "on";
            string setToken = "off";
            string checkToken = "off";
            string updateToken = "off";

            PageElement target = new PageElement(name, path, preventDoubleSubmit, setToken, checkToken, updateToken);

            Assert.AreEqual(preventDoubleSubmit, target.Pds);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageElement), LogLevel.INFO));
        }

        /// <summary>
        ///SetToken のテスト
        ///</summary>
        /// <TestTarget>SetToken</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>SetToken要素の値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestSetToken01()
        {
            string name = "XXX_001";
            string path = "/XXX001.aspx";
            string preventDoubleSubmit = "on";
            string setToken = "off";
            string checkToken = "off";
            string updateToken = "off";

            PageElement target = new PageElement(name, path, preventDoubleSubmit, setToken, checkToken, updateToken);

            Assert.AreEqual(setToken, target.SetToken);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageElement), LogLevel.INFO));
        }

        /// <summary>
        ///CheckToken のテスト
        ///</summary>
        /// <TestTarget>CheckToken</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>CheckToken要素の値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestCheckToken01()
        {
            string name = "XXX_001";
            string path = "/XXX001.aspx";
            string preventDoubleSubmit = "on";
            string setToken = "off";
            string checkToken = "off";
            string updateToken = "off";

            PageElement target = new PageElement(name, path, preventDoubleSubmit, setToken, checkToken, updateToken);

            Assert.AreEqual(checkToken, target.CheckToken);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageElement), LogLevel.INFO));
        }

        /// <summary>
        ///UpdateToken のテスト
        ///</summary>
        /// <TestTarget>UpdateToken</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>updateToken要素の値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestUpdateToken01()
        {
            string name = "XXX_001";
            string path = "/XXX001.aspx";
            string preventDoubleSubmit = "on";
            string setToken = "off";
            string checkToken = "off";
            string updateToken = "off";

            PageElement target = new PageElement(name, path, preventDoubleSubmit, setToken, checkToken, updateToken);

            Assert.AreEqual(updateToken, target.UpdateToken);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageElement), LogLevel.INFO));
        }
    }
}
