// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Web.Configuration.Page;
using System.Xml;
using TERASOLUNA.Fw.Common.Configuration;
using System.Configuration;
using System.IO;
using System.Xml.Schema;
using TERASOLUNA.Fw.WebUT.Configuration;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common;

namespace TERASOLUNA.Fw.WebUT.Configuration.Page
{
    /// <summary>
    /// TERASOLUNA.Fw.Web.Configuration.PageConfigurationSection のテスト クラスです。すべての
    /// TERASOLUNA.Fw.Web.Configuration.PageConfigurationSection 単体テストをここに含めます
    /// </summary>
   
    [TestClass()]
    public class PageConfigurationSectionTest
    {

        private TestContext testContextInstance;
        private const string PAGE_CONFIG_SECTION_FILE_NAME_01 = "TestItem_PageConfigSection01.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_02 = "TestItem_PageConfigSection02.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_03 = "TestItem_PageConfigSection03.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_04 = "TestItem_PageConfigSection04.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_05 = "TestItem_PageConfigSection05.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_06 = "TestItem_PageConfigSection06.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_07 = "TestItem_PageConfigSection07.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_08 = "TestItem_PageConfigSection08.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_09 = "TestItem_PageConfigSection09.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_10 = "TestItem_PageConfigSection10.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_11 = "TestItem_PageConfigSection11.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_12 = "TestItem_PageConfigSection12.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_13 = "TestItem_PageConfigSection13.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_14 = "TestItem_PageConfigSection14.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_15 = "TestItem_PageConfigSection15.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_16 = "TestItem_PageConfigSection16.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_17 = "TestItem_PageConfigSection17.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_18 = "TestItem_PageConfigSection18.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_19 = "TestItem_PageConfigSection19.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_20 = "TestItem_PageConfigSection20.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_21 = "TestItem_PageConfigSection21.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_22 = "TestItem_PageConfigSection22.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_23 = "TestItem_PageConfigSection23.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_24 = "TestItem_PageConfigSection24.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_25 = "TestItem_PageConfigSection25.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_26 = "TestItem_PageConfigSection26.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_27 = "TestItem_PageConfigSection27.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_28 = "TestItem_PageConfigSection28.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_29 = "TestItem_PageConfigSection29.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_30 = "TestItem_PageConfigSection30.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_31 = "TestItem_PageConfigSection31.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_32 = "TestItem_PageConfigSection32.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_33 = "TestItem_PageConfigSection33.config";
        private const string PAGE_CONFIG_SECTION_FILE_NAME_34 = "TestItem_PageConfigSection34.config";

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        ///PageConfigurationSection () のテスト
        ///</summary>
        /// <TestTarget>Constructor()</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>インスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor01()
        {
            PageConfigurationSection target = new PageConfigurationSection();
            Assert.IsNotNull(target);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// Files のテスト
        /// </summary>
        /// <TestTarget>Files</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>FilesCollectionが返却されること</TestAssertion>
        [TestMethod()]
        public void TestFiles01()
        {
            PageConfigurationSection target = new PageConfigurationSection();
            Assert.IsInstanceOfType(target.Files, typeof(FilesCollection));

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// Pages のテスト
        /// </summary>
        /// <TestTarget>Pages</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>PagesCollectionが返却されること</TestAssertion>
        [TestMethod()]
        public void TestPages01()
        {
            PageConfigurationSection target = new PageConfigurationSection();
            Assert.IsInstanceOfType(target.Pages, typeof(PagesCollection));

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>外部設定ファイルの設定情報がPagesプロパティに保持されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        public void TestCreatePageElements01()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_01);
            target.CreatePageElements();

            Assert.AreEqual("XXX_001", target.Pages[0].Name);
            Assert.AreEqual("/XXX001.aspx", target.Pages[0].Path);
            Assert.AreEqual("on", target.Pages[0].Pds);
            Assert.AreEqual("on", target.Pages[0].SetToken);
            Assert.AreEqual("on", target.Pages[0].CheckToken);
            Assert.AreEqual("on", target.Pages[0].UpdateToken);

            Assert.AreEqual("XXX_002", target.Pages[1].Name);
            Assert.AreEqual("/XXX002.aspx", target.Pages[1].Path);
            Assert.AreEqual("on", target.Pages[1].Pds);            // default値
            Assert.AreEqual("on", target.Pages[1].SetToken);
            Assert.AreEqual("on", target.Pages[1].CheckToken);
            Assert.AreEqual("on", target.Pages[1].UpdateToken);    // default値

            Assert.AreEqual("XXX_003", target.Pages[2].Name);
            Assert.AreEqual("/XXX003.aspx", target.Pages[2].Path);
            Assert.AreEqual("on", target.Pages[2].Pds);            // default値
            Assert.AreEqual("on", target.Pages[2].SetToken);       // default値
            Assert.AreEqual("on", target.Pages[2].CheckToken);
            Assert.AreEqual("on", target.Pages[2].UpdateToken);    // default値

            Assert.AreEqual("XXX_004", target.Pages[3].Name);
            Assert.AreEqual("/XXX004.aspx", target.Pages[3].Path);
            Assert.AreEqual("on", target.Pages[3].Pds);            // default値
            Assert.AreEqual("on", target.Pages[3].SetToken);       // default値
            Assert.AreEqual("on", target.Pages[3].CheckToken);     // default値
            Assert.AreEqual("on", target.Pages[3].UpdateToken);     // default値

            Assert.AreEqual("XXX_005", target.Pages[4].Name);
            Assert.AreEqual("/XXX005.aspx", target.Pages[4].Path);
            Assert.AreEqual("off", target.Pages[4].Pds);
            Assert.AreEqual("off", target.Pages[4].SetToken);
            Assert.AreEqual("off", target.Pages[4].CheckToken);
            Assert.AreEqual("off", target.Pages[4].UpdateToken);

            Assert.AreEqual("XXX_006", target.Pages[5].Name);
            Assert.AreEqual("/XXX006.aspx", target.Pages[5].Path);
            Assert.AreEqual("on", target.Pages[5].Pds);            // default値
            Assert.AreEqual("off", target.Pages[5].SetToken);
            Assert.AreEqual("off", target.Pages[5].CheckToken);
            Assert.AreEqual("on", target.Pages[5].UpdateToken);    // default値

            Assert.AreEqual("XXX_007", target.Pages[6].Name);
            Assert.AreEqual("/XXX007.aspx", target.Pages[6].Path);
            Assert.AreEqual("on", target.Pages[6].Pds);            // default値
            Assert.AreEqual("on", target.Pages[6].SetToken);       // default値
            Assert.AreEqual("off", target.Pages[6].CheckToken);
            Assert.AreEqual("on", target.Pages[6].UpdateToken);    // default値

            Assert.AreEqual("XXX_008", target.Pages[7].Name);
            Assert.AreEqual("/XXX008.aspx", target.Pages[7].Path);
            Assert.AreEqual("on", target.Pages[7].Pds);            // default値
            Assert.AreEqual("on", target.Pages[7].SetToken);        // default値
            Assert.AreEqual("on", target.Pages[7].CheckToken);      // default値
            Assert.AreEqual("on", target.Pages[7].UpdateToken);      // default値

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>構成ファイルに設定されている外部設定ファイルが存在しないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされることこと</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection02.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        public void TestCreatePageElements02()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_02);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_PageExternal99.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", "pageConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(FileNotFoundException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>構成ファイルにfile要素がないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされることこと</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection03.config")]
        public void TestCreatePageElements03()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_03);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_CUSTOM_SECTION_HANDLER", "pageConfiguration");
                Assert.AreEqual(message, e.Message);
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>外部設定ファイルがXML形式でないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされることこと</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection04.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal03.config")]
        public void TestCreatePageElements04()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_04);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_PageExternal03.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "pageConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>構成ファイルのfile要素のpath属性にファイル名に使用できない文字が含まれていること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされることこと</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection05.config")]
        public void TestCreatePageElements05()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_05);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + Path.DirectorySeparatorChar + @"TestItem_PageExternalX>.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", "pageConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(ArgumentException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>構成ファイルのfile要素のpath属性が260文字以上であること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされることこと</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection06.config")]
        public void TestCreatePageElements06()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_06);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\1111111111222222222233333333334444444444555555555566666666667777777777888888888899999999990000000000111111111122222222223333333333444444444455555555556666666666777777777788888888889999999999000000000011111111112222222222333333333344444\TestItem_SqlExternalXX.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", "pageConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(PathTooLongException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>構成ファイルのfile要素のpath属性が無効なパスであること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされることこと</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection07.config")]
        public void TestCreatePageElements07()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_07);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\a\a";
                string message = MessageManager.GetMessage("E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", "pageConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(DirectoryNotFoundException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのpage要素のname属性の値が重複していること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされることこと</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection08.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal04.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal05.config")]
        public void TestCreatePageElements08()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_08);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_MERGED_CONFIG", "page:pageConfiguration");
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのpage要素のpath属性の値が重複していること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされることこと</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection09.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal04.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal06.config")]
        public void TestCreatePageElements09()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_09);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_MERGED_CONFIG", "page:pageConfiguration");
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのpage要素のname,path属性の両方の値が重複していること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされることこと</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection10.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal04.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal07.config")]
        public void TestCreatePageElements10()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_10);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_MERGED_CONFIG", "page:pageConfiguration");
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのpageConfiguration要素が無いこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされることこと</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection11.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal08.config")]
        public void TestCreatePageElements11()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_11);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_PageExternal08.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "pageConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのpage要素が無いこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされることこと</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection12.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal09.config")]
        public void TestCreatePageElements12()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_12);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_PageExternal09.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "pageConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのpage要素のname属性が無いこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされることこと</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection13.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal10.config")]
        public void TestCreatePageElements13()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_13);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_PageExternal10.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "pageConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのpage要素のpath属性が無いこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされることこと</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection14.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal11.config")]
        public void TestCreatePageElements14()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_14);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_PageExternal11.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "pageConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのpage要素のpreventDoubleSubmit属性に列挙体以外が指定されている</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされることこと</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection15.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal12.config")]
        public void TestCreatePageElements15()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_15);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_PageExternal12.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "pageConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのpage要素のsetToken属性に列挙体以外が指定されている</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされることこと</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection16.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal13.config")]
        public void TestCreatePageElements16()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_16);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_PageExternal13.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "pageConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのpage要素のcheckToken属性に列挙体以外が指定されている</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされることこと</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection17.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal14.config")]
        public void TestCreatePageElements17()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_17);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_PageExternal14.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "pageConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>１つ目の外部設定ファイルに不正な要素が存在すること（１つ目の外部設定ファイルの検証処理を確認する）</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection18.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal15.config")]
        public void TestCreatePageElements18()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_18);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_PageExternal15.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "pageConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>２つ目の外部設定ファイルに不正な要素が存在すること（２つ目以降の外部設定ファイルの検証処理を確認する）</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection19.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal15.config")]
        public void TestCreatePageElements19()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_19);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_PageExternal15.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "pageConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのpage要素のpreventDoubleSubmit属性が無いこと</TestCondition>
        /// <TestAssertion>スキーマファイルのデフォルト設定がないときデフォルト値(on)が補完されるされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection20.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal16.config")]
        [DeploymentItem("TestItem_PageXMLSchema1.xsd")]
        public void TestCreatePageElements20()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_20);
            ConfigurationManager.AppSettings["pageSchemaName"] = "TestItem_PageXMLSchema1.xsd";
            ConfigurationManager.AppSettings["IsLoadFromFile"] = "true";

            target.CreatePageElements();
            Assert.AreEqual("on", target.Pages[0].Pds);

            ConfigurationManager.AppSettings["IsLoadFromFile"] = "false";

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのpage要素のsetToken属性が無いこと</TestCondition>
        /// <TestAssertion>スキーマファイルのデフォルト設定がないときデフォルト値(on)が補完されるされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection21.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal17.config")]
        [DeploymentItem("TestItem_PageXMLSchema1.xsd")]
        public void TestCreatePageElements21()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_21);
            ConfigurationManager.AppSettings["pageSchemaName"] = "TestItem_PageXMLSchema1.xsd";
            ConfigurationManager.AppSettings["IsLoadFromFile"] = "true";

            target.CreatePageElements();
            Assert.AreEqual("on", target.Pages[0].SetToken);

            ConfigurationManager.AppSettings["IsLoadFromFile"] = "false";

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのpage要素のcheckToken属性が無いこと</TestCondition>
        /// <TestAssertion>スキーマファイルのデフォルト設定がないときデフォルト値(on)が補完されるされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection22.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal18.config")]
        [DeploymentItem("TestItem_PageXMLSchema1.xsd")]
        public void TestCreatePageElements22()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_22);
            ConfigurationManager.AppSettings["pageSchemaName"] = "TestItem_PageXMLSchema1.xsd";
            ConfigurationManager.AppSettings["IsLoadFromFile"] = "true";

            target.CreatePageElements();
            Assert.AreEqual("on", target.Pages[0].CheckToken);

            ConfigurationManager.AppSettings["IsLoadFromFile"] = "false";

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>構成ファイルにpageConfiguration要素がないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection23.config")]
        public void TestCreatePageElements23()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_23);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_CUSTOM_SECTION_HANDLER", "pageConfiguration");
                Assert.AreEqual(message, e.Message);
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }
        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>構成ファイルにpageConfiguration要素がないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection24.config")]
        public void TestCreatePageElements24()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_24);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_CUSTOM_SECTION_HANDLER", "pageConfiguration");
                Assert.AreEqual(message, e.Message);
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }
        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>同一ページ情報設定ファイルでpage要素のname属性が重複すること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection25.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal19.config")]
        public void TestCreatePageElements25()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_25);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_PageExternal19.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "pageConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }
        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>ページ情報設定ファイルでpage要素のname属性が空文字であること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection26.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal20.config")]
        public void TestCreatePageElements26()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_26);

            target.CreatePageElements();
            Assert.AreEqual("", target.Pages[0].Name);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }
        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>Page情報設定ファイルのPath属性に空文字を設定すること</TestCondition>
        /// <TestAssertion>空文字が返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection27.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal21.config")]
        public void TestCreatePageElements27()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_27);

            target.CreatePageElements();
            Assert.AreEqual("", target.Pages[0].Path);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }
        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>同一Page情報設定ファイルに同じPath属性が含まれること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection28.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal22.config")]
        public void TestCreatePageElements28()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_28);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_PageExternal22.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "pageConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }
        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>Page情報設定ファイルのpreventDoubleClick属性に空文字を設定すること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection29.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal23.config")]
        public void TestCreatePageElements29()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_29);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_PageExternal23.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "pageConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }
        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>Page情報設定ファイルのsetToken属性に空文字を設定すること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection30.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal24.config")]
        public void TestCreatePageElements30()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_30);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_PageExternal24.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "pageConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }
        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>Page情報設定ファイルのcheckToken属性に空文字を設定すること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection31.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal25.config")]
        public void TestCreatePageElements31()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_31);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_PageExternal25.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "pageConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }
        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>Page情報設定ファイルのupdateToken属性に不正な文字列を設定すること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection32.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal26.config")]
        public void TestCreatePageElements32()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_32);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_PageExternal26.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "pageConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }
        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>Page情報設定ファイルのupdateToken属性に空文字を設定すること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection33.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal27.config")]
        public void TestCreatePageElements33()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_33);

            try
            {
                target.CreatePageElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_PageExternal27.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "pageConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }
        /// <summary>
        /// CreatePageElements () のテスト
        /// </summary>
        /// <TestTarget>CreatePageElements()</TestTarget>
        /// <TestCondition>Page情報設定ファイルのupdateToken属性に設定しないこと</TestCondition>
        /// <TestAssertion>updateTokenを保持するプロパティの値が"on"であること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageConfigSection34.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal28.config")]
        public void TestCreatePageElements34()
        {
            PageConfigurationSection target = ConfigTestHelper.GetPageConfigurationSectionFromCustomFile(PAGE_CONFIG_SECTION_FILE_NAME_34);

            target.CreatePageElements();
            Assert.AreEqual("on", target.Pages[0].UpdateToken);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfigurationSection), LogLevel.INFO));
        }
    }
}
