// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Web.Configuration.ExceptionCode;
using System.Xml;
using TERASOLUNA.Fw.Common.Configuration;
using System.Configuration;
using System.IO;
using System.Xml.Schema;
using TERASOLUNA.Fw.WebUT.Configuration;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Common;

namespace TERASOLUNA.Fw.WebUT.Configuration.ExceptionCode
{
    /// <summary>
    /// TERASOLUNA.Fw.Common.Configuration.ExceptionCodeConfigurationSection のテスト クラスです。すべての
    /// TERASOLUNA.Fw.Common.Configuration.ExceptionCodeConfigurationSection 単体テストをここに含めます
    /// </summary>

    [TestClass()]
    public class ExceptionCodeConfigurationSectionTest
    {

        private TestContext testContextInstance;
        private const string CONFIG_FILE_NAME_01 = "TestItem_ExceptionCodeConfigSection01.config";
        private const string CONFIG_FILE_NAME_02 = "TestItem_ExceptionCodeConfigSection02.config";
        private const string CONFIG_FILE_NAME_03 = "TestItem_ExceptionCodeConfigSection03.config";
        private const string CONFIG_FILE_NAME_04 = "TestItem_ExceptionCodeConfigSection04.config";
        private const string CONFIG_FILE_NAME_05 = "TestItem_ExceptionCodeConfigSection05.config";
        private const string CONFIG_FILE_NAME_06 = "TestItem_ExceptionCodeConfigSection06.config";
        private const string CONFIG_FILE_NAME_07 = "TestItem_ExceptionCodeConfigSection07.config";
        private const string CONFIG_FILE_NAME_08 = "TestItem_ExceptionCodeConfigSection08.config";
        private const string CONFIG_FILE_NAME_09 = "TestItem_ExceptionCodeConfigSection09.config";
        private const string CONFIG_FILE_NAME_10 = "TestItem_ExceptionCodeConfigSection10.config";
        private const string CONFIG_FILE_NAME_11 = "TestItem_ExceptionCodeConfigSection11.config";
        private const string CONFIG_FILE_NAME_12 = "TestItem_ExceptionCodeConfigSection12.config";
        private const string CONFIG_FILE_NAME_13 = "TestItem_ExceptionCodeConfigSection13.config";
        private const string CONFIG_FILE_NAME_14 = "TestItem_ExceptionCodeConfigSection14.config";

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        /// ExceptionCodeConfigurationSection () のテスト
        /// </summary>
        /// <TestTarget>Constructor()</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>インスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor01()
        {
            ExceptionCodeConfigurationSection target = new ExceptionCodeConfigurationSection();
            Assert.IsNotNull(target);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// Files のテスト
        /// </summary>
        /// <TestTarget>Files</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>FilesCollectionが返却されること</TestAssertion>
        [TestMethod()]
        public void TestFiles01()
        {
            ExceptionCodeConfigurationSection target = new ExceptionCodeConfigurationSection();
            Assert.IsInstanceOfType(target.Files, typeof(FilesCollection));

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeConfigurationSection), LogLevel.INFO));

        }

        /// <summary>
        /// ExceptionCodeCollection のテスト
        /// </summary>
        /// <TestTarget>ExceptionCodeCollection</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>ExceptionCodeCollectionが返却されること</TestAssertion>
        [TestMethod()]
        public void TestExceptionCodeCollection01()
        {
            ExceptionCodeConfigurationSection target = new ExceptionCodeConfigurationSection();
            Assert.IsInstanceOfType(target.ExceptionCodeCollection, typeof(ExceptionCodeCollection));

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateExceptionCodeElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionCodeElements()</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>外部設定ファイルの設定情報がExceptionCodeCollectionプロパティに保持されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeConfigSection01.config")]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeExternal01.config")]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeExternal02.config")]
        public void TestCreateExceptionCodeElements01()
        {
            ExceptionCodeConfigurationSection target =
                ConfigTestHelper.GetExceptionCodeConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_01);

            target.CreateExceptionCodeElements();

            Assert.AreEqual("System.ArgumentException", target.ExceptionCodeCollection[0].ExceptionType);
            Assert.AreEqual("E0001", target.ExceptionCodeCollection[0].Code);
            Assert.AreEqual("System.ArgumentNullException", target.ExceptionCodeCollection[1].ExceptionType);
            Assert.AreEqual("E0002", target.ExceptionCodeCollection[1].Code);
            Assert.AreEqual("System.ApplicationException", target.ExceptionCodeCollection[2].ExceptionType);
            Assert.AreEqual("E0003", target.ExceptionCodeCollection[2].Code);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateExceptionCodeElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionCodeElements()</TestTarget>
        /// <TestCondition>構成ファイルにfile要素がないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeConfigSection02.config")]
        public void TestCreateExceptionCodeElements02()
        {
            ExceptionCodeConfigurationSection target =
                ConfigTestHelper.GetExceptionCodeConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_02);

            try
            {
                target.CreateExceptionCodeElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_CUSTOM_SECTION_HANDLER", "exceptionCodeConfiguration");
                Assert.AreEqual(message, e.Message);
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeConfigurationSection), LogLevel.INFO));
        }
        /// <summary>
        /// CreateExceptionCodeElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionCodeElements()</TestTarget>
        /// <TestCondition>構成ファイルに設定されている外部設定ファイルが存在しないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeConfigSection03.config")]
        public void TestCreateExceptionCodeElements03()
        {
            ExceptionCodeConfigurationSection target =
                ConfigTestHelper.GetExceptionCodeConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_03);

            try
            {
                target.CreateExceptionCodeElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\Nothing.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", "exceptionCodeConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(FileNotFoundException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeConfigurationSection), LogLevel.INFO));

        }
        /// <summary>
        /// CreateExceptionCodeElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionCodeElements()</TestTarget>
        /// <TestCondition>構成ファイルのfile要素のpath属性にファイル名に使用できない文字が含まれていること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeConfigSection04.config")]
        public void TestCreateExceptionCodeElements04()
        {
            ExceptionCodeConfigurationSection target =
                ConfigTestHelper.GetExceptionCodeConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_04);

            try
            {
                target.CreateExceptionCodeElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + Path.DirectorySeparatorChar + @"TestItem_SqlExternalX>.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", "exceptionCodeConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(ArgumentException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeConfigurationSection), LogLevel.INFO));

        }

        /// <summary>
        /// CreateExceptionCodeElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionCodeElements()</TestTarget>
        /// <TestCondition>構成ファイルのfile要素のpath属性が無効なパスであること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeConfigSection05.config")]
        public void TestCreateExceptionCodeElements05()
        {
            ExceptionCodeConfigurationSection target =
                ConfigTestHelper.GetExceptionCodeConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_05);

            try
            {
                target.CreateExceptionCodeElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\a\a";
                string message = MessageManager.GetMessage("E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", "exceptionCodeConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(DirectoryNotFoundException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeConfigurationSection), LogLevel.INFO));

        }

        /// <summary>
        /// CreateExceptionCodeElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionCodeElements()</TestTarget>
        /// <TestCondition>構成ファイルのfile要素のpath属性が260文字以上であること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeConfigSection06.config")]
        public void TestCreateExceptionCodeElements06()
        {
            ExceptionCodeConfigurationSection target =
                ConfigTestHelper.GetExceptionCodeConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_06);

            try
            {
                target.CreateExceptionCodeElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\1111111111222222222233333333334444444444555555555566666666667777777777888888888899999999990000000000111111111122222222223333333333444444444455555555556666666666777777777788888888889999999999000000000011111111112222222222333333333344444\TestItem_SqlExternalXX.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", "exceptionCodeConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(PathTooLongException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeConfigurationSection), LogLevel.INFO));

        }
        /// <summary>
        /// CreateExceptionCodeElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionCodeElements()</TestTarget>
        /// <TestCondition>外部設定ファイルがXML形式でないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeConfigSection07.config")]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeExternal03.config")]
        public void TestCreateExceptionCodeElements07()
        {
            ExceptionCodeConfigurationSection target =
                ConfigTestHelper.GetExceptionCodeConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_07);

            try
            {
                target.CreateExceptionCodeElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_ExceptionCodeExternal03.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "exceptionCodeConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeConfigurationSection), LogLevel.INFO));

        }
        /// <summary>
        /// CreateExceptionCodeElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionCodeElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのexceptionCodeConfiguration要素が無いこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeConfigSection08.config")]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeExternal04.config")]
        public void TestCreateExceptionCodeElements08()
        {
            ExceptionCodeConfigurationSection target =
                ConfigTestHelper.GetExceptionCodeConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_08);

            try
            {
                target.CreateExceptionCodeElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_ExceptionCodeExternal04.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "exceptionCodeConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeConfigurationSection), LogLevel.INFO));

        }
        /// <summary>
        /// CreateExceptionCodeElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionCodeElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのexceptionCode要素が無いこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeConfigSection09.config")]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeExternal05.config")]
        public void TestCreateExceptionCodeElements09()
        {
            ExceptionCodeConfigurationSection target =
                ConfigTestHelper.GetExceptionCodeConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_09);

            try
            {
                target.CreateExceptionCodeElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_ExceptionCodeExternal05.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "exceptionCodeConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeConfigurationSection), LogLevel.INFO));

        }
        /// TODO:kokokara
        /// <summary>
        /// CreateExceptionCodeElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionCodeElements()</TestTarget>
        /// <TestCondition>外部設定ファイルに不正な要素が存在すること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeConfigSection10.config")]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeExternal06.config")]
        public void TestCreateExceptionCodeElements10()
        {
            ExceptionCodeConfigurationSection target =
                ConfigTestHelper.GetExceptionCodeConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_10);

            try
            {
                target.CreateExceptionCodeElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_ExceptionCodeExternal06.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "exceptionCodeConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeConfigurationSection), LogLevel.INFO));

        }
        /// <summary>
        /// CreateExceptionCodeElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionCodeElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのexceptionCode要素のexceptionType属性の値が重複していること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeConfigSection11.config")]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeExternal07.config")]
        public void TestCreateExceptionCodeElements11()
        {
            ExceptionCodeConfigurationSection target =
                ConfigTestHelper.GetExceptionCodeConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_11);

            try
            {
                target.CreateExceptionCodeElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_ExceptionCodeExternal07.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "exceptionCodeConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeConfigurationSection), LogLevel.INFO));
        }
        /// <summary>
        /// CreateExceptionCodeElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionCodeElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのexceptionType属性の値がマージ後重複すること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeConfigSection12.config")]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeExternal01.config")]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeExternal08.config")]
        public void TestCreateExceptionCodeElements12()
        {
            ExceptionCodeConfigurationSection target =
                ConfigTestHelper.GetExceptionCodeConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_12);

            try
            {
                target.CreateExceptionCodeElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_MERGED_CONFIG", "ex:exceptionCodeConfiguration");
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateExceptionCodeElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionCodeElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのexceptionCode要素のexceptionType属性が無いこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeConfigSection13.config")]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeExternal09.config")]
        public void TestCreateExceptionCodeElements13()
        {
            ExceptionCodeConfigurationSection target =
                ConfigTestHelper.GetExceptionCodeConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_13);

            try
            {
                target.CreateExceptionCodeElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_ExceptionCodeExternal09.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "exceptionCodeConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateExceptionCodeElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionCodeElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのexceptionCode要素のCode属性が無いこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeConfigSection14.config")]
        [DeploymentItem(@"Configuration\ExceptionCode\TestItem_ExceptionCodeExternal10.config")]
        public void TestCreateExceptionCodeElements14()
        {
            ExceptionCodeConfigurationSection target =
                ConfigTestHelper.GetExceptionCodeConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_14);

            try
            {
                target.CreateExceptionCodeElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_ExceptionCodeExternal10.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "exceptionCodeConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeConfigurationSection), LogLevel.INFO));
        }
    }
}
