// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Configuration;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Web.Configuration.RequestController
{
    /// <summary>
    /// AvP[V\t@C RequestControllerConfiguration ݒ擾܂B
    /// </summary>
    public static class RequestControllerConfiguration
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(RequestControllerConfiguration));

        /// <summary>
        /// w肳ꂽNGXg^CvɑΉ郊NGXgRg[NX̃AZuSĈ擾܂B
        /// </summary>
        /// <param name="reqCtrlName">NGXg^Cv</param>
        /// <returns>
        /// name Ɏw肳ꂽNGXg^CvɑΉ郊NGXgRg[NX̃AZuSĆB
        /// Ή郊NGXg^CvAvP[V\t@Cɐݒ肳ĂȂꍇ null QƂԋp܂B
        /// </returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="name"/>  null QƂłB
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// \t@CǂݍނƂł܂B
        /// </exception>
        public static string GetRequestControllerType(string reqCtrlName)
        {
            if (reqCtrlName == null)
            {
                ArgumentNullException exception = new ArgumentNullException("name");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Web.Properties.Resources.E_NULL_ARGUMENT, "name"), exception);
                }
                throw exception;
            }

            string ret = null;
            RequestControllerConfigurationSection rccs = TerasolunaWebConfiguration.RequestControllerConfigSection;
            if (rccs != null)
            {
                RequestControllerElement element = rccs.Controllers[reqCtrlName];
                if (element != null)
                {
                    ret = element.Type;
                }
            }

            if (_log.IsTraceEnabled)
            {
                if (ret == null)
                {
                    _log.Trace(string.Format(Properties.Resources.T_REQUEST_CONTROLLER_CONFIGURATION_NOT_LOAF_PARAMETER, reqCtrlName));
                }
                else
                {
                    _log.Trace(string.Format(Properties.Resources.T_REQUEST_CONTROLLER_CONFIGURATION_LOAF_PARAMETER, reqCtrlName, ret));
                }
            }

            return ret;
        }
    }
}
