// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System.Configuration;

namespace TERASOLUNA.Fw.Web.Configuration.Page
{
    /// <summary>
    /// y[Wݒt@C page vf\܂B
    /// </summary>
    /// <remarks>
    /// <see cref="PageElement"/> ́Ay[Wݒt@C page vf\܂B 
    /// ڍׂɂĂ <see cref="ConfigurationElement"/> QƂĂB
    /// </remarks>
    public sealed class PageElement : ConfigurationElement
    {
        /// <summary>
        /// name ̑łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "name" łB
        /// </remarks>
        private const string NAME_ATTRIBUTE_NAME = "name";

        /// <summary>
        /// path ̑łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "path" łB
        /// </remarks>
        private const string NAME_ATTRIBUTE_PATH = "path";

        /// <summary>
        /// preventDoubleSubmit ̑łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "preventDoubleSubmit" łB
        /// </remarks>
        private const string NAME_ATTRIBUTE_PDS = "preventDoubleSubmit";

        /// <summary>
        /// setToken ̑łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "setToken" łB
        /// </remarks>
        private const string NAME_ATTRIBUTE_SETTOKEN = "setToken";
        
        /// <summary>
        /// checkToken ̑łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "checkToken" łB
        /// </remarks>
        private const string NAME_ATTRIBUTE_CHECKTOKEN = "checkToken";

        /// <summary>
        /// updateToken ̑łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "updateToken" łB
        /// </remarks>
        private const string NAME_ATTRIBUTE_UPDATETOKEN = "updateToken";

        /// <summary>
        /// <see cref="PageElement"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public PageElement()
        {
        }

        /// <summary>
        /// <see cref="PageElement"/> NX̐VCX^X܂B
        /// </summary>
        /// <param name="name">name B</param>
        /// <param name="path">path B</param>
        /// <param name="preventDoubleSubmit">preventDoubleSubmit B</param>
        /// <param name="setToken">setToken B</param>
        /// <param name="checkToken">checkToken B</param>
        /// <param name="updateToken">updateToken B</param>
        /// <remarks>
        /// w肵lŏ܂B
        /// </remarks>
        public PageElement(string name, string path, string preventDoubleSubmit, string setToken, string checkToken, string updateToken)
        {
            this[NAME_ATTRIBUTE_NAME] = name;
            this[NAME_ATTRIBUTE_PATH] = path;
            this[NAME_ATTRIBUTE_PDS] = preventDoubleSubmit;
            this[NAME_ATTRIBUTE_SETTOKEN] = setToken;
            this[NAME_ATTRIBUTE_CHECKTOKEN] = checkToken;
            this[NAME_ATTRIBUTE_UPDATETOKEN] = updateToken;
        }

        /// <summary>
        /// name ̒l擾܂B
        /// </summary>
        /// <value>
        /// name ̒lB
        /// </value>
        [ConfigurationProperty(NAME_ATTRIBUTE_NAME, IsRequired = true, IsKey = true)]
        public string Name
        {
            get
            {
                return (string)this[NAME_ATTRIBUTE_NAME];
            }
        }

        /// <summary>
        /// path ̒l擾܂B
        /// </summary>
        /// <value>
        /// path ̒lB
        /// </value>
        [ConfigurationProperty(NAME_ATTRIBUTE_PATH, IsRequired = true, IsKey = true)]
        public string Path
        {
            get
            {
                return (string)this[NAME_ATTRIBUTE_PATH];
            }
        }

        /// <summary>
        /// preventDoubleSubmit ̒l擾܂B
        /// </summary>
        /// <value>
        /// preventDoubleSubmit ̒lB
        /// </value>
        [ConfigurationProperty(NAME_ATTRIBUTE_PDS, DefaultValue = "on")]
        public string Pds
        {
            get
            {
                return (string)this[NAME_ATTRIBUTE_PDS];
            }
        }

        /// <summary>
        /// setToken ̒l擾܂B
        /// </summary>
        /// <value>
        /// setToken ̒lB
        /// </value>
        [ConfigurationProperty(NAME_ATTRIBUTE_SETTOKEN, DefaultValue = "on")]
        public string SetToken
        {
            get
            {
                return (string)this[NAME_ATTRIBUTE_SETTOKEN];
            }
        }

        /// <summary>
        /// checkToken ̒l擾܂B
        /// </summary>
        /// <value>
        /// checkToken ̒lB
        /// </value>
        [ConfigurationProperty(NAME_ATTRIBUTE_CHECKTOKEN, DefaultValue = "on")]
        public string CheckToken
        {
            get
            {
                return (string)this[NAME_ATTRIBUTE_CHECKTOKEN];
            }
        }

        /// <summary>
        /// updateToken ̒l擾܂B
        /// </summary>
        /// <value>
        /// updateToken ̒lB
        /// </value>
        [ConfigurationProperty(NAME_ATTRIBUTE_UPDATETOKEN, IsRequired = false)]
        public string UpdateToken
        {
            get
            {
                return (string)this[NAME_ATTRIBUTE_UPDATETOKEN];
            }
        }

    }
}
