﻿// <著作権>
// Copyright (c) 2007, NTT DATA Corporation.
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common.Validation.Validators;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using System.Reflection;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.CommonUT.Validation.Validators
{
    /// <summary>
    /// TypeRangeValidator&lt;T&gt; のテストクラスです。
    /// </summary>
    /// <remarks>
    /// TypeRangeValidator&lt;T&gt;の実装クラスTypeRangeValidatorWrapper&lt;T&gt;をスタブクラスとして利用します。
    /// </remarks>
    [TestClass()]
    public class TypeRangeValidatorTest
    {
        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        //ログの初期化
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateがnullで、インスタンスの型パラメータがSystem.DateTimeの場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest01()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008,8,10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008,8,30),
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        false);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0
 
            // 準備
            MethodInfo method = 
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
               /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator , new object[]{null,"オブジェクト","キー",results});

            // 確認
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが空文字でインスタンスの型パラメータがSystem.DateTimeの場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest02()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        false);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator, new object[] { "", "オブジェクト", "キー", results });

            // 確認
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型に変換可能な文字列(範囲内)でインスタンスの型パラメータがSystem.DateTimeの場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
         [TestMethod]
        public void DoValidateTest03()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        false);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator, new object[] { "2008/8/15", "オブジェクト", "キー", results });

            // 確認
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型に変換可能な文字列(範囲外)でインスタンスの型パラメータがSystem.DateTimeの場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest04()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        false);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator, new object[] { "2001/1/1", "オブジェクト", "キー", results });

            // 確認
            Assert.IsFalse(results.IsValid);

            ValidationResultList resultList = new ValidationResultList(results);
            
            Assert.AreEqual<int>(1, resultList.Count , "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage("The value must fall within the range \"2008/08/10 0:00:00\" (Exclusive) - \"2008/08/30 0:00:00\" (Inclusive).");
            Assert.IsNotNull(r,"メッセージが不正です.");
            Assert.AreEqual<string>(r.Key, "キー", "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.AreEqual(r.Target, "オブジェクト", "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型に変換不可能な文字列でインスタンスの型パラメータがSystem.DateTimeの場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest05()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        false);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator, new object[] { "あああああ", "オブジェクト", "キー", results });

            // 確認
            Assert.IsFalse(results.IsValid);

            ValidationResultList resultList = new ValidationResultList(results);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage("The value must fall within the range \"2008/08/10 0:00:00\" (Exclusive) - \"2008/08/30 0:00:00\" (Inclusive).");
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.AreEqual<string>(r.Key, "キー", "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.AreEqual(r.Target, "オブジェクト", "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型のオブジェクト(範囲内)でインスタンスの型パラメータがSystem.DateTimeの場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest06()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        false);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator, new object[] { new DateTime(2008,8,20), "オブジェクト", "キー", results });

            // 確認
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型のオブジェクト(範囲外)でインスタンスの型パラメータがSystem.DateTimeの場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest07()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        false);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator, new object[] { new DateTime(2008,9,1), "オブジェクト", "キー", results });

            // 確認
            Assert.IsFalse(results.IsValid);

            ValidationResultList resultList = new ValidationResultList(results);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage("The value must fall within the range \"2008/08/10 0:00:00\" (Exclusive) - \"2008/08/30 0:00:00\" (Inclusive).");
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.AreEqual<string>(r.Key, "キー", "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.AreEqual(r.Target, "オブジェクト", "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型ではないオブジェクトでインスタンスの型パラメータがSystem.DateTimeの場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest08()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        false);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator, new object[] { 10, "オブジェクト", "キー", results });

            // 確認
            Assert.IsFalse(results.IsValid);

            ValidationResultList resultList = new ValidationResultList(results);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage("The value must fall within the range \"2008/08/10 0:00:00\" (Exclusive) - \"2008/08/30 0:00:00\" (Inclusive).");
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.AreEqual<string>(r.Key, "キー", "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.AreEqual(r.Target, "オブジェクト", "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型に変換可能な文字列(範囲外)であり、
        /// currentTargetがnullでインスタンスの型パラメータがSystem.DateTimeの場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest09()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        false);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator, new object[] { "2001/1/1", null, "キー", results });

            // 確認
            Assert.IsFalse(results.IsValid);

            ValidationResultList resultList = new ValidationResultList(results);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage("The value must fall within the range \"2008/08/10 0:00:00\" (Exclusive) - \"2008/08/30 0:00:00\" (Inclusive).");
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.AreEqual<string>(r.Key, "キー", "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target, "ターゲットが不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型に変換可能な文字列(範囲内)であり、
        /// currentTargetがnullでインスタンスの型パラメータがSystem.DateTimeの場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest10()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        false);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator, new object[] { "2008/8/15", null, "キー", results });

            // 確認
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型に変換可能な文字列(範囲外)であり、
        /// keyがnullでインスタンスの型パラメータがSystem.DateTimeの場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest11()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        false);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator, new object[] { "2001/1/1", "オブジェクト", null, results });

            // 確認
            Assert.IsFalse(results.IsValid);

            ValidationResultList resultList = new ValidationResultList(results);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage("The value must fall within the range \"2008/08/10 0:00:00\" (Exclusive) - \"2008/08/30 0:00:00\" (Inclusive).");
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.AreEqual(r.Target, "オブジェクト", "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型に変換可能な文字列(範囲内)であり、
        /// keyがnullでインスタンスの型パラメータがSystem.DateTimeの場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest12()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        false);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator, new object[] { "2008/8/15", "オブジェクト", null, results });

            // 確認
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型に変換可能な文字列(範囲外)であり、
        /// ValidationResultsがnullでインスタンスの型パラメータがSystem.DateTimeの場合、ArgumentNullExceptionがスローされることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest13()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        false);
            validator.Tag = "試験対象項目";


            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            try
            {
                method.Invoke(validator, new object[] { "2001/1/1", "オブジェクト", "キー", null });
                Assert.Fail();
            }
            catch (TargetInvocationException e)
            {
                Assert.IsInstanceOfType(e.InnerException, typeof(ArgumentNullException), "発生する例外が不正です");
            }
            catch (Exception)
            {
                Assert.Fail("発生する例外が不正です");
            }

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型に変換可能な文字列(範囲内)であり、
        /// ValidationResultsがnullでインスタンスの型パラメータがSystem.DateTimeの場合、ArgumentNullExceptionがスローされることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest14()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        false);
            validator.Tag = "試験対象項目";


            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            try
            {
                method.Invoke(validator, new object[] { "2008/8/15", "オブジェクト", "キー", null });
                Assert.Fail();
            }
            catch (TargetInvocationException e)
            {
                Assert.IsInstanceOfType(e.InnerException, typeof(ArgumentNullException), "発生する例外が不正です");
            }
            catch (Exception)
            {
                Assert.Fail("発生する例外が不正です");
            }

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型に変換可能な文字列(範囲外)であり、
        /// ValidationResultsの検証エラーが1つでインスタンスの型パラメータがSystem.DateTimeの場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest15()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        false);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0
            ValidationResult result1 = new ValidationResult("result01",null,null,null,null);
            results.AddResult(result1);

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator, new object[] { "2001/1/1", "オブジェクト", "キー", results });

            // 確認
            Assert.IsFalse(results.IsValid);

            ValidationResultList resultList = new ValidationResultList(results);

            Assert.AreEqual<int>(2, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage("The value must fall within the range \"2008/08/10 0:00:00\" (Exclusive) - \"2008/08/30 0:00:00\" (Inclusive).");
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.AreEqual<string>(r.Key, "キー", "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.AreEqual(r.Target, "オブジェクト", "Targetが不正です.");

            ValidationResult r1 = resultList.FindFromMessage("result01");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型に変換可能な文字列(範囲内)であり、
        /// ValidationResultsの検証エラーが1つでインスタンスの型パラメータがSystem.DateTimeの場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest16()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        false);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0
            ValidationResult result1 = new ValidationResult("result01", null, null, null, null);
            results.AddResult(result1);

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator, new object[] { "2008/8/15", "オブジェクト", "キー", results });

            // 確認
            Assert.IsFalse(results.IsValid);

            ValidationResultList resultList = new ValidationResultList(results);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r1 = resultList.FindFromMessage("result01");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型に変換可能な文字列(範囲外)であり、
        /// validationResultsの検証エラーが3つでインスタンスの型パラメータがSystem.DateTimeの場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest17()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        false);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0
            results.AddResult(new ValidationResult("result01", null, null, null,null));
            results.AddResult(new ValidationResult("result02", null, null, null,null));
            results.AddResult(new ValidationResult("result03", null, null, null,null));

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator, new object[] { "2001/1/1", "オブジェクト", "キー", results });

            // 確認
            Assert.IsFalse(results.IsValid);

            ValidationResultList resultList = new ValidationResultList(results);

            Assert.AreEqual<int>(4, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage("The value must fall within the range \"2008/08/10 0:00:00\" (Exclusive) - \"2008/08/30 0:00:00\" (Inclusive).");
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.AreEqual<string>(r.Key, "キー", "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.AreEqual(r.Target, "オブジェクト", "Targetが不正です.");

            ValidationResult r1 = resultList.FindFromMessage("result01");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            ValidationResult r2 = resultList.FindFromMessage("result02");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            ValidationResult r3 = resultList.FindFromMessage("result03");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型に変換可能な文字列(範囲内)であり、
        /// validationResultsの検証エラーが3つでインスタンスの型パラメータがSystem.DateTimeの場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest18()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        false);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0
            results.AddResult(new ValidationResult("result01", null, null, null, null));
            results.AddResult(new ValidationResult("result02", null, null, null, null));
            results.AddResult(new ValidationResult("result03", null, null, null, null));

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator, new object[] { "2008/8/15", "オブジェクト", "キー", results });

            // 確認
            Assert.IsFalse(results.IsValid);

            ValidationResultList resultList = new ValidationResultList(results);

            Assert.AreEqual<int>(3, resultList.Count, "エラー数が不正です.");
            
            ValidationResult r1 = resultList.FindFromMessage("result01");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            ValidationResult r2 = resultList.FindFromMessage("result02");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            ValidationResult r3 = resultList.FindFromMessage("result03");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型に変換可能な文字列(範囲外)であり、
        /// プロパティの型パラメータが参照型(string)の場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest19()
        {
            // 初期化
            TypeRangeValidatorWrapper<string> validator =
                new TypeRangeValidatorWrapper<string>("A",
                                                        RangeBoundaryType.Exclusive,
                                                        "D",
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        false);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<string>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator, new object[] { "Z", "オブジェクト", "キー", results });

            // 確認
            Assert.IsFalse(results.IsValid);

            ValidationResultList resultList = new ValidationResultList(results);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage("The value must fall within the range \"A\" (Exclusive) - \"D\" (Inclusive).");
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.AreEqual<string>(r.Key, "キー", "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.AreEqual(r.Target, "オブジェクト", "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型に変換可能な文字列(範囲内)であり、
        /// プロパティの型パラメータが参照型(string)の場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest20()
        {
            // 初期化
            TypeRangeValidatorWrapper<string> validator =
                new TypeRangeValidatorWrapper<string>("A",
                                                        RangeBoundaryType.Exclusive,
                                                        "D",
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        false);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<string>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator, new object[] { "C", "オブジェクト", "キー", results });

            // 確認
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }


        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型に変換可能な文字列(範囲外)であり、
        /// プロパティのNegatedがtrueでインスタンスの型パラメータがSystem.DateTimeの場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest30()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        true);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator, new object[] { "2001/1/1", "オブジェクト", "キー", results });

            // 確認
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型に変換可能な文字列(範囲内)であり、
        /// プロパティのNegatedがtrueでインスタンスの型パラメータがSystem.DateTimeの場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest31()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        true);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator, new object[] { "2008/8/15", "オブジェクト", "キー", results });

            // 確認
            Assert.IsFalse(results.IsValid);

            ValidationResultList resultList = new ValidationResultList(results);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage("The value must not fall within the range \"2008/08/10 0:00:00\" (Exclusive) - \"2008/08/30 0:00:00\" (Inclusive).");
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.AreEqual<string>(r.Key, "キー", "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.AreEqual(r.Target, "オブジェクト", "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型に変換可能な文字列(範囲外)であり、
        /// プロパティのMessageTemplateが空文字でインスタンスの型パラメータがSystem.DateTimeの場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest32()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        "",
                                                        false);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator, new object[] { "2001/1/1", "オブジェクト", "キー", results });

            // 確認
            Assert.IsFalse(results.IsValid);

            ValidationResultList resultList = new ValidationResultList(results);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage("");
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.AreEqual<string>(r.Key, "キー", "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.AreEqual(r.Target, "オブジェクト", "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型に変換可能な文字列(範囲外)であり、
        /// プロパティのMessageTemplateがプレースホルダ0～6でインスタンスの型パラメータがSystem.DateTimeの場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest33()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        "{0},{1},{2},{3},{4},{5},{6}",
                                                        false);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator, new object[] { "2001/1/1", "オブジェクト", "キー", results });

            // 確認
            Assert.IsFalse(results.IsValid);

            ValidationResultList resultList = new ValidationResultList(results);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage("2001/01/01 0:00:00,キー,試験対象項目,2008/08/10 0:00:00,Exclusive,2008/08/30 0:00:00,Inclusive");
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.AreEqual<string>(r.Key, "キー", "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.AreEqual(r.Target, "オブジェクト", "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型に変換可能な文字列(範囲外)であり、
        /// プロパティのMessageTemplateがプレースホルダ0～7でインスタンスの型パラメータがSystem.DateTimeの場合、
        /// FormatExceptionがスローされることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest34()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        "{0},{1},{2},{3},{4},{5},{6},{7}",
                                                        false);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            try
            {
                method.Invoke(validator, new object[] { "2001/1/1", "オブジェクト", "キー", results });
                Assert.Fail();
            }
            catch (TargetInvocationException e)
            {
                Assert.IsInstanceOfType(e.InnerException, typeof(FormatException),"例外の型が不正です");
            }
            catch (Exception)
            {
                Assert.Fail("例外の型が不正です");
            }

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型に変換可能な文字列(範囲外)であり、
        /// プロパティのTagがnullでインスタンスの型パラメータがSystem.DateTimeの場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest35()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        false);
            validator.Tag = null;

            ValidationResults results = new ValidationResults();//errors = 0

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator, new object[] { "2001/1/1", "オブジェクト", "キー", results });

            // 確認
            Assert.IsFalse(results.IsValid);

            ValidationResultList resultList = new ValidationResultList(results);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage("The value must fall within the range \"2008/08/10 0:00:00\" (Exclusive) - \"2008/08/30 0:00:00\" (Inclusive).");
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.AreEqual<string>(r.Key, "キー", "Keyが不正です.");
            Assert.IsNull(r.Tag,"Tagが不正です.");
            Assert.AreEqual(r.Target, "オブジェクト", "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateがnullであり、ValidationResultsがnullでインスタンスの型パラメータがSystem.DateTimeの場合、
        /// ArgumentNullExceptionがスローされることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest36()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        false);
            validator.Tag = "試験対象項目";


            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            try
            {
                method.Invoke(validator, new object[] { null, "オブジェクト", "キー", null });
                Assert.Fail();
            }
            catch (TargetInvocationException e)
            {
                Assert.IsInstanceOfType(e.InnerException, typeof(ArgumentNullException), "発生する例外が不正です");
            }
            catch (Exception)
            {
                Assert.Fail("発生する例外が不正です");
            }

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定型に変換不可能な文字列であり、
        /// プロパティのNegatedがtrueでインスタンスの型パラメータがSystem.DateTimeの場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void DoValidateTest37()
        {
            // 初期化
            TypeRangeValidatorWrapper<DateTime> validator =
                new TypeRangeValidatorWrapper<DateTime>(new DateTime(2008, 8, 10),
                                                        RangeBoundaryType.Exclusive,
                                                        new DateTime(2008, 8, 30),
                                                        RangeBoundaryType.Inclusive,
                                                        null,
                                                        true);
            validator.Tag = "試験対象項目";

            ValidationResults results = new ValidationResults();//errors = 0

            // 準備
            MethodInfo method =
                typeof(TypeRangeValidator<DateTime>).GetMethod("DoValidate"
                        , BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.DeclaredOnly);

            // 実施
            /* IComparable ,object,string,ValidationResults */
            method.Invoke(validator, new object[] { "ああああ", "オブジェクト", "キー", results });

            // 確認
            Assert.IsFalse(results.IsValid);

            ValidationResultList resultList = new ValidationResultList(results);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage("The value must not fall within the range \"2008/08/10 0:00:00\" (Exclusive) - \"2008/08/30 0:00:00\" (Inclusive).");
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.AreEqual<string>(r.Key, "キー", "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.AreEqual(r.Target, "オブジェクト", "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TypeRangeValidatorWrapper<DateTime>), LogLevel.INFO));      
        }
    }

    internal class TypeRangeValidatorWrapper<T> : TypeRangeValidator<T> where T : IComparable
    {
        public TypeRangeValidatorWrapper(T lowerBound, 
                                 RangeBoundaryType lowerBoundType,
                                 T upperBound, 
                                 RangeBoundaryType upperBoundType,
                                 string messageTemplate, 
                                 bool negated)
            :base(lowerBound,lowerBoundType,upperBound,upperBoundType,messageTemplate,negated)
        {
        }
    }
}
