﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.Validation.Configuration;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using TERASOLUNA.Fw.Common.Validation.Validators;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.CommonUT.Validation.Configuration
{
    /// <summary>
    ///TERASOLUNA.Fw.Common.Validation.Configuration.AlphaNumericStringValidatorData のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Common.Validation.Configuration.AlphaNumericStringValidatorData 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class AlphaNumericStringValidatorDataTest
    {
        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        //ログの初期化      
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// 引数のTypeがnullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest01()
        {
            // 定義
            AlphaNumericStringValidatorData target = new AlphaNumericStringValidatorData();
            Type targetType = null;
            target.MessageTemplate = "メッセージテンプレート";
            target.Negated = false;
            target.Tag = "検証対象項目";

            // 準備
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_AlphaNumericStringValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_AlphaNumericStringValidatorDataAccessor(target);

            // 実施
            Validator result = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsNotNull(result);
            Assert.IsInstanceOfType(result, typeof(AlphaNumericStringValidator), "型が不正です");
            AlphaNumericStringValidator hksv = result as AlphaNumericStringValidator;
            Assert.AreEqual<string>(hksv.MessageTemplate, "メッセージテンプレート");
            Assert.IsNotNull(hksv.Tag, "Tagが不正です");
            Assert.IsFalse(hksv.Negated, "Negatedが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(AlphaNumericStringValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// 引数のTypeが非nullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest02()
        {
            // 定義
            AlphaNumericStringValidatorData target = new AlphaNumericStringValidatorData();
            Type targetType = typeof(AlphaNumericStringValidator);
            target.MessageTemplate = "メッセージテンプレート";
            target.Negated = false;
            target.Tag = "検証対象項目";

            // 準備
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_AlphaNumericStringValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_AlphaNumericStringValidatorDataAccessor(target);

            // 実施
            Validator result = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsNotNull(result);
            Assert.IsInstanceOfType(result, typeof(AlphaNumericStringValidator), "型が不正です");
            AlphaNumericStringValidator hksv = result as AlphaNumericStringValidator;
            Assert.AreEqual<string>(hksv.MessageTemplate, "メッセージテンプレート");
            Assert.IsNotNull(hksv.Tag, "Tagが不正です");
            Assert.IsFalse(hksv.Negated, "Negatedが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(AlphaNumericStringValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// プロパティのMessageTemplateがnullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest03()
        {
            // 定義
            AlphaNumericStringValidatorData target = new AlphaNumericStringValidatorData();
            Type targetType = typeof(AlphaNumericStringValidator);
            target.MessageTemplate = null;
            target.Negated = false;
            target.Tag = "検証対象項目";

            // 準備
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_AlphaNumericStringValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_AlphaNumericStringValidatorDataAccessor(target);

            // 実施
            Validator result = accessor.DoCreateValidator(targetType);

            // 確認
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("ALPHANUMERIC_STRING_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.IsNotNull(result);
            Assert.IsInstanceOfType(result, typeof(AlphaNumericStringValidator), "型が不正です");
            AlphaNumericStringValidator hksv = result as AlphaNumericStringValidator;
            Assert.AreEqual<string>(expectedMessage, hksv.MessageTemplate);
            Assert.IsNotNull(hksv.Tag, "Tagが不正です");
            Assert.IsFalse(hksv.Negated, "Negatedが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(AlphaNumericStringValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// プロパティのNegatedがtrueの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest04()
        {
            // 定義
            AlphaNumericStringValidatorData target = new AlphaNumericStringValidatorData();
            Type targetType = typeof(AlphaNumericStringValidator);
            target.MessageTemplate = "メッセージテンプレート";
            target.Negated = true;
            target.Tag = "検証対象項目";

            // 準備
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_AlphaNumericStringValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_AlphaNumericStringValidatorDataAccessor(target);

            // 実施
            Validator result = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsNotNull(result);
            Assert.IsInstanceOfType(result, typeof(AlphaNumericStringValidator), "型が不正です");
            AlphaNumericStringValidator hksv = result as AlphaNumericStringValidator;
            Assert.AreEqual<string>(hksv.MessageTemplate, "メッセージテンプレート");
            Assert.IsNotNull(hksv.Tag, "Tagが不正です");
            Assert.IsTrue(hksv.Negated, "Negatedが不正です.");
     
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(AlphaNumericStringValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// プロパティのTagがnullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest05()
        {
            // 定義
            AlphaNumericStringValidatorData target = new AlphaNumericStringValidatorData();
            Type targetType = typeof(AlphaNumericStringValidator);
            target.MessageTemplate = "メッセージテンプレート";
            target.Negated = false;
            target.Tag = null;

            // 準備
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_AlphaNumericStringValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_AlphaNumericStringValidatorDataAccessor(target);

            // 実施
            Validator result = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsNotNull(result);
            Assert.IsInstanceOfType(result, typeof(AlphaNumericStringValidator), "型が不正です");
            AlphaNumericStringValidator hksv = result as AlphaNumericStringValidator;
            Assert.AreEqual<string>(hksv.MessageTemplate, "メッセージテンプレート");
            Assert.IsNull(hksv.Tag, "Tagが不正です");
            Assert.IsFalse(hksv.Negated, "Negatedが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(AlphaNumericStringValidatorData), LogLevel.INFO));
        }
    }
}
