﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using TERASOLUNA.Fw.Common.Validation;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.CommonUT.Validation
{
    /// <summary>
    /// CaseCheckUtilTest のテストクラスです。
    /// </summary>
    [TestClass]
    public class CaseCheckUtilTest
    {

        #region 追加テスト属性
        //
        // テストを作成しているときに、次の追加属性を使用することができます:
        //
        // クラス内の最初のテストを実行する前にコードを実行するには、ClassInitialize を使用します
        // [ClassInitialize()]
        // public static void MyClassInitialize(TestContext testContext) { }
        //
        // クラス内のすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用します
        // [ClassCleanup()]
        // public static void MyClassCleanup() { }
        //
        // 各テストを実行する前にコードを実行するには、TestInitialize を使用します 
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        // 各テストを実行した後にコードを実行するには、TestCleanup を使用します
        // [TestCleanup()]
        // public void MyTestCleanup() { }
        //
        #endregion

        #region IsAlphaNumericStringTest
        /// <summary>
        /// IsAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数がnullの場合、ArgumentNullExceptionがスローされることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsAlphaNumericStringTest01()
        {
            try
            {
                CaseCheckUtil.IsAlphaNumericString(null);
                Assert.Fail();
            }
            catch (ArgumentNullException e)
            {
                // 成功
                Assert.AreEqual("value", e.ParamName);
            }

            //ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(CaseCheckUtil), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "value"));
        }

        /// <summary>
        /// IsAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が空文字の場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsAlphaNumericStringTest02()
        {
            Assert.IsTrue(CaseCheckUtil.IsAlphaNumericString(""));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角大文字英字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsAlphaNumericStringTest03()
        {
            Assert.IsTrue(CaseCheckUtil.IsAlphaNumericString("AAAAA"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角小文字英字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsAlphaNumericStringTest04()
        {
            Assert.IsTrue(CaseCheckUtil.IsAlphaNumericString("aaaaa"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角数値文字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsAlphaNumericStringTest05()
        {
            Assert.IsTrue(CaseCheckUtil.IsAlphaNumericString("12334567"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角英大文字・小文字、半角数値文字混在の場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsAlphaNumericStringTest06()
        {
            Assert.IsTrue(CaseCheckUtil.IsAlphaNumericString("AaBbCcDd123"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角英数字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsAlphaNumericStringTest07()
        {
            Assert.IsFalse(CaseCheckUtil.IsAlphaNumericString("ＡＢ１"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角カナ文字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsAlphaNumericStringTest08()
        {
            Assert.IsFalse(CaseCheckUtil.IsAlphaNumericString("ア"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角カナ文字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsAlphaNumericStringTest09()
        {
            Assert.IsFalse(CaseCheckUtil.IsAlphaNumericString("ｱ"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角カナ記号のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsAlphaNumericStringTest10()
        {
            Assert.IsFalse(CaseCheckUtil.IsAlphaNumericString("ﾟ｡"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数がひらがなのみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsAlphaNumericStringTest11()
        {
            Assert.IsFalse(CaseCheckUtil.IsAlphaNumericString("あ"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角記号のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsAlphaNumericStringTest12()
        {
            Assert.IsFalse(CaseCheckUtil.IsAlphaNumericString("_"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角空白のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsAlphaNumericStringTest13()
        {
            Assert.IsFalse(CaseCheckUtil.IsAlphaNumericString(" "));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        #endregion

        #region IsHankakuKanaString
        /// <summary>
        /// IsHankakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数がnullの場合、ArgumentNullExceptionがスローされることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuKanaStringTest01()
        {
            try
            {
                CaseCheckUtil.IsHankakuKanaString(null);
                Assert.Fail();
            }
            catch (ArgumentNullException)
            {
                // 成功
            }

            //ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(CaseCheckUtil), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "value"));
        }

        /// <summary>
        /// IsHankakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が空文字の場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuKanaStringTest02()
        {
            Assert.IsTrue(CaseCheckUtil.IsHankakuKanaString(""));
            
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角大文字英字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuKanaStringTest03()
        {
            Assert.IsFalse(CaseCheckUtil.IsHankakuKanaString("AAAAA"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角小文字英字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuKanaStringTest04()
        {
            Assert.IsFalse(CaseCheckUtil.IsHankakuKanaString("aaa"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角数値文字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuKanaStringTest05()
        {
            Assert.IsFalse(CaseCheckUtil.IsHankakuKanaString("0123456567"));
           
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角英大文字・小文字、半角数値文字混在の場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuKanaStringTest06()
        {
            Assert.IsFalse(CaseCheckUtil.IsHankakuKanaString("AaBbCcｱｲｳｴｵｴ01"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角英数字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuKanaStringTest07()
        {
            Assert.IsFalse(CaseCheckUtil.IsHankakuKanaString("Ａ１"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角カナのみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuKanaStringTest08()
        {
            Assert.IsFalse(CaseCheckUtil.IsHankakuKanaString("ア"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角カナのみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuKanaStringTest09()
        {
            Assert.IsTrue(CaseCheckUtil.IsHankakuKanaString("ｱｲｳｴｵ"));
           
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角カナ記号のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuKanaStringTest10()
        {
            Assert.IsTrue(CaseCheckUtil.IsHankakuKanaString("｡ﾟ｢｣"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角・半角カナ混在の場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuKanaStringTest11()
        {
            Assert.IsFalse(CaseCheckUtil.IsHankakuKanaString("ｱｲｳｴｵアイウエオ"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数がひらがなのみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuKanaStringTest12()
        {
            Assert.IsFalse(CaseCheckUtil.IsHankakuKanaString("ああああああ"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角記号のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuKanaStringTest13()
        {
            Assert.IsFalse(CaseCheckUtil.IsHankakuKanaString("__[]"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角空白のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuKanaStringTest14()
        {
            Assert.IsFalse(CaseCheckUtil.IsHankakuKanaString(" "));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        #endregion

        #region IsHankakuStringTest
        /// <summary>
        /// IsHankakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数がnullの場合、ArgumentNullExceptionがスローされることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuStringTest01()
        {
            try
            {
                CaseCheckUtil.IsHankakuString(null);
                Assert.Fail();
            }
            catch (ArgumentNullException e)
            {
                // 成功
                Assert.AreEqual("value", e.ParamName);
            }

            //ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(CaseCheckUtil), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "value"));
        }

        /// <summary>
        /// IsHankakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が空文字の場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuStringTest02()
        {
            Assert.IsTrue(CaseCheckUtil.IsHankakuString(""));
        
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角大文字英字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuStringTest03()
        {
            Assert.IsTrue(CaseCheckUtil.IsHankakuString("AAAAA"));
            
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角小文字英字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuStringTest04()
        {
            Assert.IsTrue(CaseCheckUtil.IsHankakuString("aaa"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角数値文字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuStringTest05()
        {
            Assert.IsTrue(CaseCheckUtil.IsHankakuString("0123456567"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角英大文字・小文字、半角数値文字混在の場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuStringTest06()
        {
            Assert.IsTrue(CaseCheckUtil.IsHankakuString("AaBbCcｱｲｳｴｵｴ01"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角英数字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuStringTest07()
        {
            Assert.IsFalse(CaseCheckUtil.IsHankakuString("Ａ１"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角カナのみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuStringTest08()
        {
            Assert.IsFalse(CaseCheckUtil.IsHankakuString("ア"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角カナのみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuStringTest09()
        {
            Assert.IsTrue(CaseCheckUtil.IsHankakuString("ｱｲｳｴｵ"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角カナ記号のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuStringTest10()
        {
            Assert.IsTrue(CaseCheckUtil.IsHankakuString("｡ﾟ｢｣"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角・半角カナ混在の場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuStringTest11()
        {
            Assert.IsFalse(CaseCheckUtil.IsHankakuString("ｱｲｳｴｵアイウエオ"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数がひらがなのみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuStringTest12()
        {
            Assert.IsFalse(CaseCheckUtil.IsHankakuString("ああああああ"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角記号のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuStringTest13()
        {
            Assert.IsTrue(CaseCheckUtil.IsHankakuString("__[]"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角空白のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuStringTest14()
        {
            Assert.IsTrue(CaseCheckUtil.IsHankakuString(" "));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsHankakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角記号のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsHankakuStringTest15()
        {
            Assert.IsFalse(CaseCheckUtil.IsHankakuString("＼￠￡§¨￢°±´¶×÷"));

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }
        #endregion

        #region IsNumericStringTest
        /// <summary>
        /// IsNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数がnullの場合、ArgumentNullExceptionがスローされることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsNumericStringTest01()
        {
            try
            {
                CaseCheckUtil.IsNumericString(null);
                Assert.Fail();
            }
            catch (ArgumentNullException)
            {
                // 成功
            }
            //ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(CaseCheckUtil), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "value"));

        }

        /// <summary>
        /// IsNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が空文字の場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsNumericStringTest02()
        {
            Assert.IsTrue(CaseCheckUtil.IsNumericString(""));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角大文字英字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsNumericStringTest03()
        {
            Assert.IsFalse(CaseCheckUtil.IsNumericString("AAAAA"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角小文字英字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsNumericStringTest04()
        {
            Assert.IsFalse(CaseCheckUtil.IsNumericString("aaa"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角数値文字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsNumericStringTest05()
        {
            Assert.IsTrue(CaseCheckUtil.IsNumericString("0123456567"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角英大文字・小文字、半角数値文字混在の場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsNumericStringTest06()
        {
            Assert.IsFalse(CaseCheckUtil.IsNumericString("A01"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角英数字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsNumericStringTest07()
        {
            Assert.IsFalse(CaseCheckUtil.IsNumericString("Ａ１"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角カナのみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsNumericStringTest08()
        {
            Assert.IsFalse(CaseCheckUtil.IsNumericString("ア"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角カナのみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsNumericStringTest09()
        {
            Assert.IsFalse(CaseCheckUtil.IsNumericString("ｱｲｳｴｵ"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角カナ記号のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsNumericStringTest10()
        {
            Assert.IsFalse(CaseCheckUtil.IsNumericString("｡ﾟ｢｣"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角・半角(数字)混在の場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsNumericStringTest11()
        {
            Assert.IsFalse(CaseCheckUtil.IsNumericString("111ＡＡＡＡ"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数がひらがなのみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsNumericStringTest12()
        {
            Assert.IsFalse(CaseCheckUtil.IsNumericString("ああああああ"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角記号のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsNumericStringTest13()
        {
            Assert.IsFalse(CaseCheckUtil.IsNumericString("__[]"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角空白のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsNumericStringTest14()
        {

            Assert.IsFalse(CaseCheckUtil.IsNumericString(" "));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }
        #endregion

        #region IsUpperAlphaNumericStringTest
        /// <summary>
        /// IsUpperAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数がnullの場合、ArgumentNullExceptionがスローされることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsUpperAlphaNumericStringTest01()
        {
            try
            {
                CaseCheckUtil.IsUpperAlphaNumericString(null);
                Assert.Fail();
            }
            catch (ArgumentNullException e)
            {
                // 成功
                Assert.AreEqual("value", e.ParamName);
            }
            //ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(CaseCheckUtil), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "value"));

        }

        /// <summary>
        /// IsUpperAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が空文字の場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsUpperAlphaNumericStringTest02()
        {
            Assert.IsTrue(CaseCheckUtil.IsUpperAlphaNumericString(""));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsUpperAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角大文字英字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsUpperAlphaNumericStringTest03()
        {
            Assert.IsTrue(CaseCheckUtil.IsUpperAlphaNumericString("AAAAA"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsUpperAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角小文字英字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsUpperAlphaNumericStringTest04()
        {
            Assert.IsFalse(CaseCheckUtil.IsUpperAlphaNumericString("aaa"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsUpperAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角数値文字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsUpperAlphaNumericStringTest05()
        {
            Assert.IsTrue(CaseCheckUtil.IsUpperAlphaNumericString("0123456567"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsUpperAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角英大文字・小文字、半角数値文字混在の場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsUpperAlphaNumericStringTest06()
        {
            Assert.IsTrue(CaseCheckUtil.IsUpperAlphaNumericString("A01"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsUpperAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角英数字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsUpperAlphaNumericStringTest07()
        {
            Assert.IsFalse(CaseCheckUtil.IsUpperAlphaNumericString("Ａ１"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsUpperAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角カナのみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsUpperAlphaNumericStringTest08()
        {
            Assert.IsFalse(CaseCheckUtil.IsUpperAlphaNumericString("ア"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsUpperAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角カナのみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsUpperAlphaNumericStringTest09()
        {
            Assert.IsFalse(CaseCheckUtil.IsUpperAlphaNumericString("ｱｲｳｴｵ"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsUpperAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角カナ記号のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsUpperAlphaNumericStringTest10()
        {
            Assert.IsFalse(CaseCheckUtil.IsUpperAlphaNumericString("｡ﾟ｢｣"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsUpperAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角・半角英字混在の場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsUpperAlphaNumericStringTest11()
        {
            Assert.IsFalse(CaseCheckUtil.IsUpperAlphaNumericString("AAAA11111ＡＢ"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsUpperAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数がひらがなのみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsUpperAlphaNumericStringTest12()
        {
            Assert.IsFalse(CaseCheckUtil.IsUpperAlphaNumericString("ああああああ"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsUpperAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角記号のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsUpperAlphaNumericStringTest13()
        {
            Assert.IsFalse(CaseCheckUtil.IsUpperAlphaNumericString("__[]"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsUpperAlphaNumericString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角空白のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsUpperAlphaNumericStringTest14()
        {
            Assert.IsFalse(CaseCheckUtil.IsUpperAlphaNumericString(" "));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }
        #endregion

        #region IsZenkakuStringTest
        /// <summary>
        /// IsZenkakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数がnullの場合、ArgumentNullExceptionがスローされることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuStringTest01()
        {
            try
            {
                CaseCheckUtil.IsZenkakuString(null);
                Assert.Fail();
            }
            catch (ArgumentNullException)
            {
                // 成功
            }
            //ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(CaseCheckUtil), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "value"));
        }

        /// <summary>
        /// IsZenkakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が空文字の場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuStringTest02()
        {
            Assert.IsTrue(CaseCheckUtil.IsZenkakuString(""));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角大文字英字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuStringTest03()
        {
            Assert.IsFalse(CaseCheckUtil.IsZenkakuString("AAAAA"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角小文字英字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuStringTest04()
        {
            Assert.IsFalse(CaseCheckUtil.IsZenkakuString("aaa"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角数値文字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuStringTest05()
        {
            Assert.IsFalse(CaseCheckUtil.IsZenkakuString("0123456567"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角英大文字・小文字、半角数値文字混在の場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuStringTest06()
        {
            Assert.IsFalse(CaseCheckUtil.IsZenkakuString("A01"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角英数字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuStringTest07()
        {
            Assert.IsTrue(CaseCheckUtil.IsZenkakuString("Ａ１"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角カナのみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuStringTest08()
        {
            Assert.IsTrue(CaseCheckUtil.IsZenkakuString("ア"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角カナのみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuStringTest09()
        {
            Assert.IsFalse(CaseCheckUtil.IsZenkakuString("ｱｲｳｴｵ"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角カナ記号のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuStringTest10()
        {
            Assert.IsFalse(CaseCheckUtil.IsZenkakuString("｡ﾟ｢｣"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角・半角カナ混在の場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuStringTest11()
        {
            Assert.IsFalse(CaseCheckUtil.IsZenkakuString("アアアアアｱｲｳｴｵ"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数がひらがなのみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuStringTest12()
        {
            Assert.IsTrue(CaseCheckUtil.IsZenkakuString("ああああああ"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角記号のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuStringTest13()
        {
            Assert.IsFalse(CaseCheckUtil.IsZenkakuString("__[]"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角空白のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuStringTest14()
        {
            Assert.IsFalse(CaseCheckUtil.IsZenkakuString(" "));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角記号のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuStringTest15()
        {
            Assert.IsTrue(CaseCheckUtil.IsZenkakuString("＼￠￡§¨￢°±´¶×÷　"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角英カナ混在の場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuStringTest16()
        {
            Assert.IsTrue(CaseCheckUtil.IsZenkakuString("アあＡ"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }
        #endregion

        #region IsZenkakuKanaStringTest
        /// <summary>
        /// IsZenkakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数がnullの場合、ArgumentNullExceptionがスローされることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuKanaStringTest01()
        {
            try
            {
                CaseCheckUtil.IsZenkakuKanaString(null);
                Assert.Fail();
            }
            catch (ArgumentNullException e)
            {
                // 成功
                Assert.AreEqual("value", e.ParamName);
            }

            //ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(CaseCheckUtil), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "value"));
        }

        /// <summary>
        /// IsZenkakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が空文字の場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuKanaStringTest02()
        {
            Assert.IsTrue(CaseCheckUtil.IsZenkakuKanaString(""));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角大文字英字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuKanaStringTest03()
        {
            Assert.IsFalse(CaseCheckUtil.IsZenkakuKanaString("AAAAA"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角小文字英字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuKanaStringTest04()
        {
            Assert.IsFalse(CaseCheckUtil.IsZenkakuKanaString("aaa"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角数値文字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuKanaStringTest05()
        {
            Assert.IsFalse(CaseCheckUtil.IsZenkakuKanaString("0123456567"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角英大文字・小文字、半角数値文字混在の場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuKanaStringTest06()
        {
            Assert.IsFalse(CaseCheckUtil.IsZenkakuKanaString("A01"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角英数字のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuKanaStringTest07()
        {
            Assert.IsFalse(CaseCheckUtil.IsZenkakuKanaString("Ａ１"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角カナのみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuKanaStringTest08()
        {
            Assert.IsTrue(CaseCheckUtil.IsZenkakuKanaString("ア"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角カナのみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuKanaStringTest09()
        {
            Assert.IsFalse(CaseCheckUtil.IsZenkakuKanaString("ｱｲｳｴｵ"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角カナ記号のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuKanaStringTest10()
        {
            Assert.IsFalse(CaseCheckUtil.IsZenkakuKanaString("｡ﾟ｢｣"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角・半角カナ混在の場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuKanaStringTest11()
        {
            Assert.IsFalse(CaseCheckUtil.IsZenkakuKanaString("アアアアアｱｲｳｴｵ"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数がひらがなのみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuKanaStringTest12()
        {
            Assert.IsFalse(CaseCheckUtil.IsZenkakuKanaString("ああああああ"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角記号のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuKanaStringTest13()
        {
            Assert.IsFalse(CaseCheckUtil.IsZenkakuKanaString("__[]"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が半角空白のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuKanaStringTest14()
        {
            Assert.IsFalse(CaseCheckUtil.IsZenkakuKanaString(" "));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }

        /// <summary>
        /// IsZenkakuKanaString (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数が全角記号のみの場合、返却される値が想定値であることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void IsZenkakuKanaStringTest15()
        {
            Assert.IsFalse(CaseCheckUtil.IsZenkakuKanaString("＼￠￡§¨￢°±´¶×÷　"));
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CaseCheckUtil), LogLevel.INFO));
        }
        #endregion
    }
}

