﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common.Configuration.BLogic;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.CommonUT.Configuration.BLogic
{
    /// <summary>
    ///TERASOLUNA.Fw.Common.Configuration.BLogic.BLogicDbInfoElement のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Common.Configuration.BLogic.BLogicDbInfoElement 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class BLogicDbInfoElementTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        ///BLogicDbInfoElement () のテスト
        ///</summary>
        /// <TestTarget>Constructor()</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>インスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor01()
        {
            BLogicDbInfoElement target = new BLogicDbInfoElement();
            Assert.IsNotNull(target);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoElement), LogLevel.INFO));
        }

        /// <summary>
        ///BLogicDbInfoElement (string) のテスト
        ///</summary>
        /// <TestTarget>Constructor(string)</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor02()
        {
            string name = "HotelSample_Data";

            BLogicDbInfoElement target = new BLogicDbInfoElement(name);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoElement), LogLevel.INFO));
        }

        /// <summary>
        ///BLogicDbInfoElement (string) のテスト
        ///</summary>
        /// <TestTarget>Constructor(string)</TestTarget>
        /// <TestCondition>引数nameを空文字に設定すること</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor03()
        {
            string name = "";

            BLogicDbInfoElement target = new BLogicDbInfoElement(name);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoElement), LogLevel.INFO));
        }

        /// <summary>
        ///BLogicDbInfoElement (string) のテスト
        ///</summary>
        /// <TestTarget>Constructor(string)</TestTarget>
        /// <TestCondition>引数nameをnullに設定すること</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor04()
        {
            string name = null;

            BLogicDbInfoElement target = new BLogicDbInfoElement(name);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoElement), LogLevel.INFO));
        }

        /// <summary>
        ///Name のテスト
        ///</summary>
        /// <TestTarget>Name</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>nameの値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestName01()
        {
            string name = "HotelSample_Data";

            BLogicDbInfoElement target = new BLogicDbInfoElement(name);

            Assert.AreEqual(name, target.Name);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoElement), LogLevel.INFO));
        }

    }
}
