// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using Microsoft.Practices.EnterpriseLibrary.Common.Configuration;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Common.Validation.Configuration;

namespace TERASOLUNA.Fw.Common.Validation.Validators
{
    /// <summary>
    /// ؃["K{̓`FbN"ɑΉK{`FbNs
    /// <see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> pNXłB
    /// </summary>
    /// <remarks>
    /// <para>
    /// ؑΏۂ̒l null ł邩A܂́A̕\̃zCgXy[X(p󔒁ASp󔒁AsA^u)
    /// 񒷂 0 łꍇA؎sƂȂ܂B
    /// ʏA TERASOLUNA Œ񋟂Ă錟؃[ł́A null ܂͋󕶎ɑ΂Č؃G[ƂȂ̂"K{̓`FbN"݂̂łB
    /// </para>
    /// <para>
    /// `FbNύXɂ́AhNX쐬A <seealso cref="RequiredValidator.IsBlankData"/> \bhI[o[Ch܂B
    /// </para>
    /// <para>
    /// {NXpē͒l؂{ɂ́A͒lؐݒt@CɋLq 
    /// validator vf̑ƂāAȉ̐ݒs܂B
    /// ͒lؐݒt@Ĉ̋L@ɂẮA 
    /// Validation Application Block ̃hLgQƂĂB 
    /// </para>
    /// <para>
    /// <list type="bullet">
    /// <item>
    /// <description>negated</description>
    /// <para>؃[𔽓]tOłB true ݒ肵ꍇA؃[]܂BftHgĺA false łB</para>
    /// </item>
    /// <item>
    /// <description>messageTemplate</description>
    /// <para>؃G[bZ[W̃ev[gƂĎgp镶B
    /// ݒ̏ꍇ́A <seealso cref="RequiredValidator.DefaultNonNegatedMessageTemplate"/> A <seealso cref="RequiredValidator.DefaultNegatedMessageTemplate"/>  
    /// ꂩgp܂B
    /// </para>
    /// </item>
    /// <item>
    /// <description>messageTemplateResourceName</description>
    /// <para>bZ[Wev[g\[Xǂݍލۂ̖OB</para>
    /// </item>
    /// <item>
    /// <description>messageTemplateResourceType</description>
    /// <para>bZ[Wev[g\[Xǂݍލۂ̃\[X̌^B</para>
    /// </item>
    /// <item>
    /// <description>tag</description>
    /// <para>bZ[Wev[g̃v[Xz_{2}ɓn镶B
    /// ؑΏۍڂ̘_w肵܂B</para>
    /// </item>
    /// <item>
    /// <description>type</description>
    /// <para>gp <see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> NX̌^SC^Ŏw肵܂B</para>
    /// </item>
    /// <item>
    /// <description>name</description>
    /// <para>gp <see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> ̖OłBt[[Nł͗p܂B
    /// ɕ <see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> 𗘗p؂sꍇAdOgp
    /// Ƃ͂ł܂B͕̑K{ڂłB</para>
    /// </item>
    /// </list>
    /// </para>
    /// <example>
    /// <code>
    /// &lt;validator negated="false"  
    /// messageTemplate="" messageTemplateResourceName=""
    /// messageTemplateResourceType="" tag="ؑΏۍږ" name="required validator"  
    /// type="TERASOLUNA.Fw.Common.Validation.Validators.RequiredValidator,TERASOLUNA.Fw.Common"/&gt;
    /// </code>
    /// </example>
    /// </remarks>
    [ConfigurationElementType(typeof(RequiredValidatorData))]
    public class RequiredValidator : ValueValidator
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(RequiredValidator));

        /// <summary>
        /// V <see cref="RequiredValidator"/> ̃CX^X܂B
        /// </summary>
        /// <param name="tag">ؑΏۂ̍ږB؎s̍ہAbZ[Wɗp܂B</param>
        /// <param name="messageTemplate">؎s̍ہAbZ[W𐶐邽߂ɗpev[gB
        /// ؂ɗpp[^v[Xz_ɓn܂B
        /// p[^Ƃ̃v[Xz_ԍ͈ȉ̒ʂłB
        /// <list type="table">
        /// <listheader>
        /// <term>v[Xz_</term>
        /// <description>e</description>
        /// </listheader>
        /// <item>
        /// <term>{0}</term>
        /// <description>ؑΏە</description>
        /// </item>
        /// <item>
        /// <term>{1}</term>
        /// <description>key(vpeBE\bh)</description>
        /// </item>
        /// <item>
        /// <term>{2}</term>
        /// <description>Tag</description>
        /// </item>
        /// </list>
        /// </param>
        /// <param name="negated">؏̔]tOB
        /// ]Ō؂{ꍇɂ true w肵܂B</param>
        public RequiredValidator(string messageTemplate, string tag, bool negated)
            : base(messageTemplate, tag, negated)
        {
        }

        /// <summary>
        /// <seealso cref="ValueValidator.Negated"/>  true łꍇɎgpftHg̃bZ[Wev[g擾܂B
        /// </summary>
        /// <value>؃[]̃ftHgbZ[Wev[gB</value>
        protected override string DefaultNegatedMessageTemplate
        {
            get { return Properties.Resources.REQUIRED_VALIDATOR_NEGATED_MESSAGETEMPLATE; }
        }

        /// <summary>
        /// <seealso cref="ValueValidator.Negated"/>  false łꍇɎgpftHg̃bZ[Wev[g擾܂B
        /// </summary>
        /// <value>ftHgbZ[Wev[gB</value>
        protected override string DefaultNonNegatedMessageTemplate
        {
            get { return Properties.Resources.REQUIRED_VALIDATOR_NONNEGATED_MESSAGETEMPLATE; }
        }

        /// <summary>
        /// K{`FbNs\bhłBnꂽ <paramref name="objectToValidate"/>  null A܂
        /// ̕\̃zCgXy[X(p󔒁ASp󔒁AsA^u)񒷂 0 ̏ꍇA؎sƂ܂B
        /// </summary>
        /// <remarks>
        /// </remarks>
        /// <param name="objectToValidate">ؑΏۂ̒lB</param>
        /// <param name="currentTarget">ؑΏۂ̃IuWFNgB</param>
        /// <param name="key">ؑΏۂ̃vpeB܂̓\bhB</param>
        /// <param name="validationResults">،ʂi[ <see cref="ValidationResults"/> B</param>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="validationResults"/>  null QƂłB
        /// </exception> 
        public override void DoValidate(object objectToValidate,
                                           object currentTarget,
                                           string key,
                                           ValidationResults validationResults)
        {
            if (validationResults == null)
            {
                ArgumentNullException exception = new ArgumentNullException("validationResults");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "validationResults"), exception);
                }
                throw exception;
            }

            if (IsBlankData(objectToValidate) != Negated)
            {
                LogValidationResult(validationResults,
                                    GetMessage(objectToValidate, key),
                                    currentTarget,
                                    key);
            }
        }

        /// <summary>
        /// <paramref name="data"/> ł邩̃`FbNs܂B
        /// </summary>
        /// <remarks>
        /// Ƃ́A<paramref name="data"/>  null A܂͂̕\
        /// zCgXy[X(p󔒁ASp󔒁AsA^u)񒷂 0 łꍇ܂B
        /// </remarks>
        /// <param name="data">ΏەB</param>
        /// <returns><paramref name="data"/>  null A܂͂̕\̃zCgXy[X񒷂 0 ̏ꍇA true Ԃ܂B</returns>
        protected virtual bool IsBlankData(object data)
        {
            return data == null || (data.ToString()).Trim().Length == 0;

        }
    }
}
