// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Text.RegularExpressions;
using Microsoft.Practices.EnterpriseLibrary.Common.Configuration;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Common.Validation.Configuration;


namespace TERASOLUNA.Fw.Common.Validation.Validators
{
    /// <summary>
    /// ؃["K\`FbN"ɑΉp^[v`FbNs <see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> pNXłB
    /// </summary>
    /// <remarks>
    /// <para>
    /// ؑΏۂ̒l\ł鎞Aw肳ꂽK\p^[Ƀ}b`邩`FbN@\񋟂܂B
    ///  null ܂͋󕶎ɑ΂Ă͌؂͍sȂ߁A <seealso cref="ValueValidator.Negated"/> ̏ԂɊւ炸AKؐƂȂ܂B 
    /// </para>
    /// <para>
    /// {NXpē͒l؂{ɂ́A͒lؐݒt@CɋLq
    ///  validator vf̑ƂāAȉ̐ݒs܂B
    /// ͒lؐݒt@Ĉ̋L@ɂẮA
    ///  Validation Application Block ̃hLgQƂĂB 
    /// </para>
    /// <para>
    /// <list type="bullet">
    /// <item>
    /// <description>negated</description>
    /// <para>؃[𔽓]tOłB true ݒ肵ꍇA؃[]܂BftHgĺA false łB</para>
    /// </item>
    /// <item>
    /// <description>pattern</description>
    /// <para>`FbNsK\p^[w肵܂B</para>
    /// </item>
    /// <item>
    /// <description>options</description>
    /// <para>K\IvV񋓑̂̒lB<code>None, IgnoreCase, Multiline, ExplicitCapture, Compiled, Singleline, IgnorePatternWhiteSpace, RighttoLeft</code>̒l̈܂͕̑gݍ킹Lq܂B̒lw肷ꍇɂ́A<code>C</code>ŋ؂Ďw肵ĂB
    /// </para>
    /// </item>
    /// <item>
    /// <description>patternResourceName</description>
    /// <para>K\p^[\[X擾ۂɗpL[w肵܂B</para>
    /// </item>
    /// <item>
    /// <description>patternResourceType</description>
    /// <para>K\p^[\[X擾ۂɗp郊\[X^AZuCŎw肵܂B</para>
    /// </item>   
    /// <item>
    /// <description>messageTemplate</description>
    /// <para>؃G[bZ[W̃ev[gƂĎgp镶B
    /// ݒ̏ꍇ́A <seealso cref="NumericStringValidator.DefaultNonNegatedMessageTemplate"/> A <seealso cref="NumericStringValidator.DefaultNegatedMessageTemplate"/>  
    /// ꂩgp܂B
    /// </para>
    /// </item>
    /// <item>
    /// <description>messageTemplateResourceName</description>
    /// <para>bZ[Wev[g\[Xǂݍލۂ̖OB</para>
    /// </item>
    /// <item>
    /// <description>messageTemplateResourceType</description>
    /// <para>bZ[Wev[g\[Xǂݍލۂ̃\[X̌^B</para>
    /// </item>
    /// <item>
    /// <description>tag</description>
    /// <para>bZ[Wev[g̃v[Xz_{2}ɓn镶B
    /// ؑΏۍڂ̘_w肵܂B</para>
    /// </item>
    /// <item>
    /// <description>type</description>
    /// <para>gp <see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> NX̌^SC^Ŏw肵܂B</para>
    /// </item>
    /// <item>
    /// <description>name</description>
    /// <para>gp <see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> ɖO܂BɗpȂlłB 
    /// Cӂ̖O邱Ƃł܂ǍؑΏۂ̏ꍇA̖O邱Ƃ͋܂B
    /// ܂A󕶎܂BK{łB</para>
    /// </item>
    /// </list>
    /// </para>
    /// <example>
    /// <code>
    /// &lt;validator negated="false"  pattern="[0-9a-zA-Z]+.@sample.co.jp" options="None" patternResourceName=""
    /// patternResourceType="" messageTemplate="" messageTemplateResourceName=""
    /// messageTemplateResourceType="" tag="ؑΏۍږ" name="numeric validator"  
    /// type="TERASOLUNA.Fw.Common.Validation.Validators.RegexStringValidator,TERASOLUNA.Fw.Common"/&gt;
    /// </code>
    /// </example>
    /// </remarks>
    [ConfigurationElementType(typeof(RegexValidatorExData))]
    public class RegexValidatorEx : RegexValidator
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(RegexValidatorEx));

        /// <summary>
        /// V <see cref="RegexValidatorEx"/> ̃CX^X܂B
        /// </summary>
        /// <param name="pattern">K\p^[B</param>
        /// <param name="patternResourceName">K\p^[\[X擾ۂɗpL[B</param>
        /// <param name="patternResourceType">K\p^[\[X擾ۂɗp郊\[X^B</param>
        /// <param name="options">K\IvVB</param>
        /// <param name="messageTemplate">؎s̍ہAbZ[W𐶐邽߂ɗpev[gB
        /// ؂ɗpp[^v[Xz_ɓn܂B
        /// p[^Ƃ̃v[Xz_ԍ͈ȉ̒ʂłB
        /// <list type="table">
        /// <listheader>
        /// <term>v[Xz_</term>
        /// <description>e</description>
        /// </listheader>
        /// <item>
        /// <term>{0}</term>
        /// <description>ؑΏە</description>
        /// </item>
        /// <item>
        /// <term>{1}</term>
        /// <description>key(vpeBE\bh)</description>
        /// </item>
        /// <item>
        /// <term>{2}</term>
        /// <description>Tag</description>
        /// </item>
        /// <item>
        /// <term>{3}</term>
        /// <description>K\p^[</description>
        /// </item>
        /// <item>
        /// <term>{4}</term>
        /// <description>K\IvV</description>
        /// </item>
        /// </list>
        /// </param>
        /// <param name="negated">؏̔]tOB</param>
        public RegexValidatorEx(string pattern, string patternResourceName, Type patternResourceType, RegexOptions options, string messageTemplate, bool negated)
            : base(pattern, patternResourceName, patternResourceType, options, messageTemplate, negated)
        {
        }

        /// <summary>
        /// <seealso cref="ValueValidator.Negated"/>  <code>true</code> łꍇɎgpftHg̃bZ[Wev[g擾܂B
        /// </summary>
        /// <value>؃[]̃ftHgbZ[Wev[gB</value>
        protected override string DefaultNegatedMessageTemplate
        {
            get
            {
                return Properties.Resources.REGEX_VALIDATOR_MESSAGETEMPLATE;
            }
        }

        /// <summary>
        /// <seealso cref="ValueValidator.Negated"/>  <code>false</code> łꍇɎgpftHg̃bZ[Wev[g擾܂B
        /// </summary>
        /// <value>ftHgbZ[Wev[gB</value>
        protected override string DefaultNonNegatedMessageTemplate
        {
            get
            {
                return Properties.Resources.REGEX_VALIDATOR_MESSAGETEMPLATE;
            }
        }

        /// <summary>
        /// K\`FbNs\bhłBeNX̏bvAؑΏےl null ܂͋󕶎ꍇɂ
        /// ؐƂ܂B
        /// </summary>
        /// <param name="objectToValidate">ؑΏۂ̒lB</param>
        /// <param name="currentTarget">ؑΏۂ̃IuWFNgB</param>
        /// <param name="key">ؑΏۂ̃vpeB܂̓\bhB</param>
        /// <param name="validationResults">،ʂi[ <see cref="ValidationResults"/> B</param>
        protected override void DoValidate(string objectToValidate, object currentTarget, string key, ValidationResults validationResults)
        {
            if (validationResults == null)
            {
                ArgumentNullException exception = new ArgumentNullException("validationResults");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "validationResults"), exception);
                }
                throw exception;
            }

            if (string.IsNullOrEmpty(objectToValidate))
            {
                return;
            }

            base.DoValidate(objectToValidate, currentTarget, key, validationResults);
        }
    }
}
