// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using Microsoft.Practices.EnterpriseLibrary.Common.Configuration;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using TERASOLUNA.Fw.Common.Validation.Configuration;

namespace TERASOLUNA.Fw.Common.Validation.Validators
{

    /// <summary>
    /// ؃["t^͈̓`FbN"ɑΉ DateTime ^͈̓`FbNs <see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> pNXłB
    /// </summary>
    /// <remarks>
    /// <para>
    /// ؑΏۂ̒l DateTime ^A܂ DateTime ^ɕϊ\ȕłA
    /// w肳ꂽ͈͂Ɋ܂܂邱Ƃ`FbN錟؋@\񋟂܂BB
    ///  null ܂͋󕶎ɑ΂Ă͌؂͍sȂ߁A<seealso cref="ValueValidator.Negated"/> ̏ԂɊւ炸AKؐƂȂ܂B 
    /// </para>
    /// <para>
    /// {NXpē͒l؂{ɂ́A͒lؐݒt@CɋLq
    ///  validator vf̑ƂāAȉ̐ݒs܂B
    /// ͒lؐݒt@Ĉ̋L@ɂẮA
    ///  Validation Application Block ̃hLgQƂĂB 
    /// </para>
    /// <para>
    /// <list type="bullet">
    /// <item>
    /// <description>negated</description>
    /// <para>؃[𔽓]tOłB true ݒ肵ꍇA؃[]܂BftHgĺA false łB</para>
    /// </item>
    /// <item>
    /// <description>messageTemplate</description>
    /// <para>؃G[bZ[W̃ev[gƂĎgp镶B
    /// ݒ̏ꍇ́A<seealso cref="DateTimeRangeValidatorEx.DefaultNonNegatedMessageTemplate"/> A <seealso cref="DateTimeRangeValidatorEx.DefaultNegatedMessageTemplate"/>  
    /// ꂩgp܂B
    /// </para>
    /// </item>
    /// <item>
    /// <description>messageTemplateResourceName</description>
    /// <para>bZ[Wev[g\[Xǂݍލۂ̖OB</para>
    /// </item>
    /// <item>
    /// <description>messageTemplateResourceType</description>
    /// <para>bZ[Wev[g\[Xǂݍލۂ̃\[X̌^B</para>
    /// </item>
    /// <item>
    /// <description>tag</description>
    /// <para>ؑΏۍڂ̖Ow肵܂B</para>
    /// </item>
    /// <item>
    /// <description>type</description>
    /// <para>gp <see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> NX̌^SC^Ŏw肵܂B</para>
    /// </item>
    /// <item>
    /// <description>name</description>
    /// <para>gp <see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> ̖OłBt[[Nł͗p܂B
    /// ɕ <see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> 𗘗p؂sꍇAdOgp
    /// Ƃ͂ł܂B͕̑K{ڂłB</para>
    /// </item>
    /// <item>
    /// <description>lowerBound</description>
    /// <para>ŏl\܂BftHgl 0 łB</para>
    /// </item>
    /// <item>
    /// <description>lowerBoundType</description>
    /// <para>ŏlŎw肳ꂽl̈w肷<see cref="RangeBoundaryType"/>񋓑̂̒lłB
    ///  <seealso cref="RangeBoundaryType.Inclusive"/> , <seealso cref="RangeBoundaryType.Exclusive"/> , <seealso cref="RangeBoundaryType.Ignore"/> ̂ꂩw肵܂BftHgl <seealso cref="RangeBoundaryType.Ignore"/> ()łB</para>
    /// </item>
    /// <item>
    /// <description>upperBound</description>
    /// <para>ől\܂BftHgl 0 ( 1 / 1 / 1 )łB</para>
    /// </item>
    /// <item>
    /// <description>upperBoundType</description>
    /// <para>őlŎw肳ꂽl̈w肷 <see cref="RangeBoundaryType"/> 񋓑̂̒lłB
    ///  <seealso cref="RangeBoundaryType.Inclusive"/> , <seealso cref="RangeBoundaryType.Exclusive"/> , <seealso cref="RangeBoundaryType.Ignore"/> ̂ꂩw肵܂BftHgl <seealso cref="RangeBoundaryType.Inclusive"/> (܂)łB</para>
    /// </item>
    /// </list>
    /// </para>
    /// <example>
    /// <code>
    /// &lt;validator negated="false" lowerBound="7/1/1999" lowerBoundType="Exclusive" upperBound="7/30/1999" 
    /// upperBoundType="Inclusive" messageTemplate="" messageTemplateResourceName=""
    /// messageTemplateResourceType="" tag="ؑΏۍږ" name="date range validator"  
    /// type="TERASOLUNA.Fw.Common.Validation.Validators.DateTimeRangeValidatorEx,TERASOLUNA.Fw.Common"/&gt;
    /// </code>
    /// </example>
    /// </remarks>
    [ConfigurationElementType(typeof(DateTimeRangeValidatorExData))]
    public class DateTimeRangeValidatorEx : TypeRangeValidator<DateTime>
    {
        /// <summary>
        /// p^[𕪐͂邽߂̃tH[}bgB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "{0}_{1}" łB
        /// </remarks>
        private static readonly string PATTERN_FORMAT = "{0}_{1}";

        /// <summary>
        /// RXgN^łBV <see cref="DateTimeRangeValidatorEx"/> ̃CX^X܂B
        /// </summary>
        /// <param name="lowerBound">ŏlB</param>
        /// <param name="lowerBoundType">͈͂ɂŏl̈ <see cref="RangeBoundaryType"/> 񋓂̒lB
        /// w肵ȂꍇA<seealso cref="RangeBoundaryType.Ignore"/>gp܂B</param>
        /// <param name="upperBound">őlB</param>
        /// <param name="upperBoundType">͈͂ɂől̈ <see cref="RangeBoundaryType"/> 񋓂̒lB
        /// w肵ȂꍇA<seealso cref="RangeBoundaryType.Inclusive"/>p܂B</param>
        /// <param name="messageTemplate">؎s̍ہAbZ[W𐶐邽߂ɗpev[gB
        /// ؂ɗpp[^v[Xz_ɓn܂B
        /// p[^Ƃ̃v[Xz_ԍ͈ȉ̒ʂłB
        /// <list type="table">
        /// <listheader>
        /// <term>v[Xz_</term>
        /// <description>e</description>
        /// </listheader>
        /// <item>
        /// <term>{0}</term>
        /// <description>ؑΏە</description>
        /// </item>
        /// <item>
        /// <term>{1}</term>
        /// <description>key(vpeBE\bh)</description>
        /// </item>
        /// <item>
        /// <term>{2}</term>
        /// <description>Tag</description>
        /// </item>
        /// <item>
        /// <term>{3}</term>
        /// <description>LowerBound</description>
        /// </item>
        /// <item>
        /// <term>{4}</term>
        /// <description>LowerBoundType</description>
        /// </item>
        /// <item>
        /// <term>{5}</term>
        /// <description>UpperBound</description>
        /// </item>
        /// <item>
        /// <term>{6}</term>
        /// <description>UpperBoundType</description>
        /// </item>
        /// </list>
        /// </param>
        /// <param name="negated">؏̔]tOB
        /// ]Ō؂{ꍇɂ true w肵܂B</param>
        /// <exception cref="ArgumentException">
        /// <list type="bullet">
        /// <item>
        /// <paramref name="lowerBound"/>  <paramref name="upperBound"/> 傫łB
        /// </item>
        /// <item>
        /// <paramref name="lowerBoundType"/>  <paramref name="upperBoundType"/> 
        /// <seealso cref="RangeBoundaryType.Ignore"/> łB
        /// </item>
        /// <item>
        /// <paramref name="lowerBound"/> A<paramref name="upperBound"/> ̂ꂩA
        /// <see cref="RangeBoundaryType.Ignore"/> ȊOɎw肳ĂA null łB
        /// </item>
        /// </list>
        /// </exception> 
        public DateTimeRangeValidatorEx(DateTime lowerBound,
                                 RangeBoundaryType lowerBoundType,
                                 DateTime upperBound,
                                 RangeBoundaryType upperBoundType,
                                 string messageTemplate,
                                 bool negated)
            : base(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated)
        { }

        /// <summary>
        /// t^Ɍ^w肳ꂽ͈̓`FbN <see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> ŗpA
        /// <seealso cref="ValueValidator.Negated"/>  true łꍇɎgpftHg̃bZ[Wev[g擾܂B
        /// </summary>
        /// <value>؃[]̃ftHgbZ[Wev[gB</value>
        protected override string DefaultNegatedMessageTemplate
        {
            get
            {
                string pattern = string.Format(PATTERN_FORMAT, LowerBoundType.ToString(), UpperBoundType.ToString());
                string result = null;
                switch (pattern)
                {
                    case IGNORE_INCLUSIVE:
                        result = Properties.Resources.DATETIME_RANGE_VALIDATOR_NEGATED_IG_IN_MESSAGETEMPLATE;
                        break;
                    case IGNORE_EXCLUSIVE:
                        result = Properties.Resources.DATETIME_RANGE_VALIDATOR_NEGATED_IG_EX_MESSAGETEMPLATE;
                        break;
                    case INCLUSIVE_IGNORE:
                        result = Properties.Resources.DATETIME_RANGE_VALIDATOR_NEGATED_IN_IG_MESSAGETEMPLATE;
                        break;
                    case INCLUSIVE_INCLUSIVE:
                        result = Properties.Resources.DATETIME_RANGE_VALIDATOR_NEGATED_IN_IN_MESSAGETEMPLATE;
                        break;
                    case INCLUSIVE_EXCLUSIVE:
                        result = Properties.Resources.DATETIME_RANGE_VALIDATOR_NEGATED_IN_EX_MESSAGETEMPLATE;
                        break;
                    case EXCLUSIVE_IGNORE:
                        result = Properties.Resources.DATETIME_RANGE_VALIDATOR_NEGATED_EX_IG_MESSAGETEMPLATE;
                        break;
                    case EXCLUSIVE_INCLUSIVE:
                        result = Properties.Resources.DATETIME_RANGE_VALIDATOR_NEGATED_EX_IN_MESSAGETEMPLATE;
                        break;
                    case EXCLUSIVE_EXCLUSIVE:
                        result = Properties.Resources.DATETIME_RANGE_VALIDATOR_NEGATED_EX_EX_MESSAGETEMPLATE;
                        break;
                    default:
                        result = base.DefaultNegatedMessageTemplate;
                        break;
                }
                return result;
            }

        }

        /// <summary>
        /// t^Ɍ^w肳ꂽ͈̓`FbN s<see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> ŗpA
        /// <seealso cref="ValueValidator.Negated"/>  false łꍇɎgpftHg̃bZ[Wev[g擾܂B
        /// </summary>
        /// <value>ftHgbZ[Wev[gB</value>
        protected override string DefaultNonNegatedMessageTemplate
        {
            get
            {
                string pattern = string.Format(PATTERN_FORMAT, LowerBoundType.ToString(), UpperBoundType.ToString());
                string result = null;
                switch (pattern)
                {
                    case IGNORE_INCLUSIVE:
                        result = Properties.Resources.DATETIME_RANGE_VALIDATOR_NONNEGATED_IG_IN_MESSAGETEMPLATE;
                        break;
                    case IGNORE_EXCLUSIVE:
                        result = Properties.Resources.DATETIME_RANGE_VALIDATOR_NONNEGATED_IG_EX_MESSAGETEMPLATE;
                        break;
                    case INCLUSIVE_IGNORE:
                        result = Properties.Resources.DATETIME_RANGE_VALIDATOR_NONNEGATED_IN_IG_MESSAGETEMPLATE;
                        break;
                    case INCLUSIVE_INCLUSIVE:
                        result = Properties.Resources.DATETIME_RANGE_VALIDATOR_NONNEGATED_IN_IN_MESSAGETEMPLATE;
                        break;
                    case INCLUSIVE_EXCLUSIVE:
                        result = Properties.Resources.DATETIME_RANGE_VALIDATOR_NONNEGATED_IN_EX_MESSAGETEMPLATE;
                        break;
                    case EXCLUSIVE_IGNORE:
                        result = Properties.Resources.DATETIME_RANGE_VALIDATOR_NONNEGATED_EX_IG_MESSAGETEMPLATE;
                        break;
                    case EXCLUSIVE_INCLUSIVE:
                        result = Properties.Resources.DATETIME_RANGE_VALIDATOR_NONNEGATED_EX_IN_MESSAGETEMPLATE;
                        break;
                    case EXCLUSIVE_EXCLUSIVE:
                        result = Properties.Resources.DATETIME_RANGE_VALIDATOR_NONNEGATED_EX_EX_MESSAGETEMPLATE;
                        break;
                    default:
                        result = base.DefaultNonNegatedMessageTemplate;
                        break;
                }
                return result;
            }
        }
    }
}
