// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Data;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Common.BLogic
{
    /// <summary>
    /// rWlXWbN̎sʂi[邽߂̃NXłB
    /// </summary>
    /// <remarks>
    /// <para>
    /// <seealso cref="IBLogic.Execute"/> ͂̃NX̃CX^Xԋp܂B
    /// </para>
    /// </remarks>
    public class BLogicResult
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(BLogicResult));

        /// <summary>
        /// rWlXWbNŐɏIA<see cref="BLogicResult"/> ɓnʕłB
        /// </summary>
        /// <remarks>
        /// <para>
        /// ̒萔̒l "success" łB
        /// </para>
        /// </remarks>
        public static readonly string SUCCESS = "success";

        /// <summary>
        /// rWlXWbN̎sʂ\ʕłB
        /// </summary>
        /// <remarks>
        /// ftHg̒ĺA null łB
        /// </remarks>
        private string _resultString = null;

        /// <summary>
        /// rWlXWbN̎sʂi[ <see cref="DataSet"/> łB
        /// </summary>
        /// <remarks>
        /// ftHg̒ĺA null łB
        /// </remarks>
        private DataSet _resultData = null;

        /// <summary>
        /// G[bZ[Wێ郊XgłB
        /// </summary>
        /// <remarks>
        /// ftHg̒ĺA <see cref="List{MessageInfo}"/> łB
        /// </remarks>
        private IList<MessageInfo> _errors = new List<MessageInfo>();

        /// <summary>
        /// rWlXWbN̎sʏi[ <see cref="Dictionary{String,Object}"/> łB
        /// </summary>
        /// <remarks>
        /// ftHg̒ĺA <see cref="Dictionary{String,Object}"/> łB
        /// </remarks>
        private IDictionary<string, object> _items = new Dictionary<string, object>();

        /// <summary>
        /// <see cref="BLogicResult"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>ftHgRXgN^łB</remarks>
        public BLogicResult()
        {
        }

        /// <summary>
        /// <see cref="BLogicResult"/> NX̐VCX^X܂B
        /// </summary>
        /// <param name="resultString">rWlXWbŇʕB</param>
        public BLogicResult(string resultString) : this(resultString, null)
        {
        }

        /// <summary>
        /// <see cref="BLogicResult"/> NX̐VCX^X܂B
        /// </summary>
        /// <param name="resultString">rWlXWbŇʕB</param>
        /// <param name="resultData">rWlXWbNo <see cref="DataSet"/></param>
        public BLogicResult(string resultString, DataSet resultData)
        {
            _resultString = resultString;
            _resultData = resultData;
        }

        /// <summary>
        /// rWlXWbN̎sʂ\ʕ擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// rWlXWbŇʕB
        /// </value>
        /// <remarks>
        /// ftHg̒ĺA null łB
        /// </remarks>
        public string ResultString
        {
            get
            {
                return _resultString;
            }
            set
            {
                _resultString = value;
            }
        }

        /// <summary>
        /// rWlXWbNo <see cref="DataSet"/> 擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// rWlXWbNo <see cref="DataSet"/> B
        /// </value>
        /// <remarks>
        /// ftHg̒ĺA null łB
        /// </remarks>
        public DataSet ResultData
        {
            get
            {
                return _resultData;
            }
            set
            {
                _resultData = value;
            }
        }

        /// <summary>
        /// sʂ̃G[bZ[WXg擾܂B
        /// </summary>
        /// <value>
        /// sʂ̃G[bZ[WXgB
        /// </value>
        /// <remarks>
        /// ftHg̒ĺA <see cref="List{MessageInfo}"/> CX^XłB
        /// </remarks>
        public IList<MessageInfo> Errors
        {
            get
            {
                return _errors;
            }
        }

        /// <summary>
        /// rWlXWbN̎sʏi[ <see cref="IDictionary{String,Object}"/> 
        /// 擾܂B
        /// </summary>
        public IDictionary<string, object> Items
        {
            get { return _items; }
        }

        /// <summary>
        /// sʂ̃G[bZ[WꊇĒǉ܂B
        /// </summary>
        /// <remarks>
        /// sʂ̃G[bZ[W <paramref name="Errors"/> ɒǉ܂B
        /// </remarks>
        /// <param name="messages">ǉG[bZ[WXgB</param>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="messages"/>  null QƂłB
        /// </exception>
        public virtual void AddErrors(IList<MessageInfo> messages)
        {
            if (messages == null)
            {
                ArgumentNullException exception = new ArgumentNullException("messages");
                if(_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "messages"), exception);
                }
                throw exception;
            } 
            
            foreach (MessageInfo message in messages)
            {
                _errors.Add(message);
            }
        }
    }
}
