/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.terasoluna.fw.web.rich.springmvc.exception.UnknownRequestNameException;

import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

/**
 * sȃNGXgNGXgĂꍇɎs郊NGXgRg[B
 * 
 * <p>
 * KUnkownRequestNameExceptionX[B
 * 
 * BeanNameUrlHandlerMappingExŃNGXgɑΉ郊NGXgRg[
 * ݂ȂꍇɎs邱Ƃz肵ĂB
 * 
 * X[ÓASimpleMappingExceptionResolverEx
 * K؂ɃnhO邱Ƃz肵ĂB
 * </p>
 * 
 * <p>
 * Bean`t@CɈȉ̐ݒ邱ƁB
 * </p>
 * 
 * <p>
 *  y<code>Bean`t@C</code>̐ݒz<br>
 *  <code><pre>
 *  &lt;bean id="unkownRequestNameController"
 *      class="jp.terasoluna.fw.web.rich.springmvc.controller.UnkownRequestNameController"/&gt;
 * </pre></code>
 * </p>
 * 
 * <p>
 * ܂Anh}bsOBean`̍ہAvpeBdefaultHandlerɏLBeanݒ肷邱ƁB
 * ڍׂ́ABeanNameUrlHandlerMappingExQƂ̂ƁB
 * </p>
 * 
 * <p>
 * ɁAhandlerExceptionResolverBean`̍ۂ
 * UnknownRequestNameExceptionX[ꂽꍇ̏`邱ƁB
 * ڍׂ́ASimpleMappingExceptionResolverExQƂ̂ƁB
 * </p>
 * 
 * @see jp.terasoluna.fw.web.rich.springmvc.servlet.handler.BeanNameUrlHandlerMappingEx
 * @see jp.terasoluna.fw.web.rich.springmvc.servlet.handler.SimpleMappingExceptionResolverEx
 * 
 */
public class UnkownRequestNameController implements Controller {

    /**
     * NGXgsB
     * KUnknownRequestNameExceptionX[B
     * 
     * @param request HTTPNGXgB
     * @param response HTTPX|XB
     * @return X|X_O邽߂ModelAndViewB
     * @throws Exception OB
     */
    public ModelAndView handleRequest(
            HttpServletRequest request, 
            HttpServletResponse response) throws Exception {
        throw new UnknownRequestNameException();
    }
}
