/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.thin;

import jp.terasoluna.utlib.MockFilterConfig;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.thin.AuthenticationControlFilter} 
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * OIς݂ǂ̃`FbNsB<br>
 * OIKvȃpXւ̃ANZXꍇ́A 
 * [UOIς݂ǂ𔻕ʂA
 * OIς݂ł͂ȂꍇA{@link UnauthenticatedException}X[B
 * <p>
 * 
 * @see jp.terasoluna.fw.web.thin.AuthenticationControlFilter
 */
public class AuthenticationControlFilterTest extends TestCase {



    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(AuthenticationControlFilterTest.class);
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖O
     */
    public AuthenticationControlFilterTest(String name) {
        super(name);
    }
    
    /**
     * sB
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        // statictB[h̏sB
        UTUtil.setPrivateField(AuthenticationControlFilter.class, 
                               "controller", 
                               null);   
    }

    /**
     * nsB
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        UTUtil.setPrivateField(AuthenticationControlFilter.class, 
                               "controller",
                               null);   
    }
    
    /**
     * testInit01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:not null<br>
     *         () config:not null<br>
     *         () getController():AuthenticationControlFilter_AuthenticationControllerStub01CX^X<br>
     *         () controller:AuthenticationControlFilter_AuthenticationControllerStub01CX^X<br>
     *         
     * <br>
     * ҒlF(ԕω) config:ŗ^FilterConfigƓ̃CX^X<br>
     *         (ԕω) getController():ĂяoȂ<br>
     *         (ԕω) controller:OƓ̃CX^X<br>
     *         
     * <br>
     * controllernullŖꍇAconrollŗ^configݒ肳AgetControllerĂяoȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit01() throws Exception {
        // O
        
        // ɐݒ肵ĂRtBO
        MockFilterConfig existingConfig = new MockFilterConfig();
        // ɐݒ肵ĂRg[
        AuthenticationController existingController
            = new AuthenticationControlFilter_AuthenticationControllerStub01();
        UTUtil.setPrivateField(AuthenticationControlFilter.class,
                               "controller",
                               existingController);
        // tB^̗p
        AuthenticationControlFilter_AuthenticationControlFilterStub01 filter
            = new AuthenticationControlFilter_AuthenticationControlFilterStub01();
        filter.setConfig(existingConfig);

        // Vݒ肳RtBO
        MockFilterConfig newConfig = new MockFilterConfig();                              
        // Vݒ肳Rg[
        AuthenticationControlFilter_AuthenticationControllerStub01 newController
            = new AuthenticationControlFilter_AuthenticationControllerStub01();
        filter.newController = newController;

        // eXg{
        filter.init(newConfig);

        // 
        assertSame(newConfig, UTUtil.getPrivateField(filter, "config"));
        assertFalse(filter.isCalled);
        assertSame(existingController, 
                   UTUtil.getPrivateField(AuthenticationControlFilter.class,
                                          "controller"));
    }

    /**
     * testInit02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:not null<br>
     *         () config:null<br>
     *         () getController():AuthenticationControlFilter_AuthenticationControllerStub01CX^X<br>
     *         () controller:null<br>
     *         
     * <br>
     * ҒlF(߂l) String:ŗ^FilterConfigƓ̃CX^X<br>
     *         (ԕω) getController():Ăяo<br>
     *         (ԕω) controller:getController()瓾CX^XƓ̃CX^X<br>
     *         
     * <br>
     * controllernull̏ꍇAŗ^configݒ肳A
     * getControllerĂяoAtB[hɐݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit02() throws Exception {
        // O

        // Vݒ肳RtBO
        MockFilterConfig newConfig = new MockFilterConfig();
        
        // tB^̗p
        AuthenticationControlFilter_AuthenticationControlFilterStub01 filter
            = new AuthenticationControlFilter_AuthenticationControlFilterStub01();
                               
        // Vݒ肳Rg[
        AuthenticationController newController
            = new AuthenticationControlFilter_AuthenticationControllerStub01();
        filter.newController = newController;

        // eXg{
        filter.init(newConfig);

        // 
        assertSame(newConfig, UTUtil.getPrivateField(filter, "config"));
        assertTrue(filter.isCalled);
        assertSame(newController, 
                   UTUtil.getPrivateField(AuthenticationControlFilter.class,
                                          "controller"));
        
    }

    /**
     * testGetAuthenticationController01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() controller:AuthenticationControlFilter_AuthenticationControllerStub01CX^X<br>
     *         
     * <br>
     * ҒlF(߂l) AuthenticationController:OŐݒ肵CX^XƓ̃CX^X<br>
     *         
     * <br>
     * n1̂݃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetAuthenticationController01() throws Exception {
        // O
        AuthenticationController existingController
            = new AuthenticationControlFilter_AuthenticationControllerStub01();
        UTUtil.setPrivateField(AuthenticationControlFilter.class, 
                               "controller", 
                               existingController);

        // eXg{
        AuthenticationController actual
            = AuthenticationControlFilter.getAuthenticationController();

        // 
        assertSame(existingController, actual);
    }

    /**
     * testDoFilter01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () AUTHENTICATION_THRU_KEY:"aaaaa"<br>
     *         () authenticationController:AuthenticationControlFilter_AuthenticationControllerStub01<br>
     *         
     * <br>
     * ҒlF(ԕω) AUTHENTICATION_THRU_KEY:OƓl<br>
     *         (ԕω) chain.doFilter:s<br>
     *         
     * <br>
     * request̑lłAUTHENTICATION_THRU_KEYnullłȂꍇA
     * ʋƖւ̑Jڃ`FbNs킸ɏI邱ƁB<br>
     * FilterChain#doFilter()\bhs邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter01() throws Exception {
        // O
        AuthenticationControlFilter filter = new AuthenticationControlFilter();

        // eXgf[^̐ݒ
        AuthenticationController controller
            = new AuthenticationControlFilter_AuthenticationControllerStub01();
        UTUtil.setPrivateField(AuthenticationControlFilter.class,
                               "controller",
                               controller);
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setAttribute("AUTHENTICATION_THRU_KEY", "aaaaa");
        MockHttpServletResponse res = new MockHttpServletResponse();
        AuthenticationControlFilter_FilterChainStub01 chain
            = new AuthenticationControlFilter_FilterChainStub01();

        // eXgs
        filter.doFilter(req, res, chain);

        //         
        assertEquals("aaaaa", req.getAttribute("AUTHENTICATION_THRU_KEY"));
        assertTrue(chain.isCalled);
    }

    /**
     * testDoFilter02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () AUTHENTICATION_THRU_KEY:null<br>
     *         () authenticationController:AuthenticationControlFilter_AuthenticationControllerStub01<br>
     *         () .isCheckRequired():false<br>
     *         
     * <br>
     * ҒlF(ԕω) AUTHENTICATION_THRU_KEY:"true"<br>
     *         (ԕω) chain.doFilter:s<br>
     *         
     * <br>
     * ʋƖւ̑Jڃ`FbNfalsȅꍇAȍ~̃`FbNs킸A
     * request̑lAUTHENTICATION_THRU_KEYtrueݒ肵ďI邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter02() throws Exception {
        // O
        AuthenticationControlFilter filter = new AuthenticationControlFilter();

        // eXgf[^̐ݒ
        AuthenticationControlFilter_AuthenticationControllerStub01 controller
            = new AuthenticationControlFilter_AuthenticationControllerStub01();
        UTUtil.setPrivateField(AuthenticationControlFilter.class,
                               "controller",
                               controller);
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        AuthenticationControlFilter_FilterChainStub01 chain
            = new AuthenticationControlFilter_FilterChainStub01();

        // eXgs
        filter.doFilter(req, res, chain);

        //         
        assertEquals("true", req.getAttribute("AUTHENTICATION_THRU_KEY"));
        assertTrue(chain.isCalled);
    }

    /**
     * testDoFilter03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () AUTHENTICATION_THRU_KEY:null<br>
     *         () authenticationController:AuthenticationControlFilter_AuthenticationControllerStub02<br>
     *         () .isCheckRequired():true<br>
     *         () .isAuthenticated():false<br>
     *         
     * <br>
     * ҒlF(ԕω) AUTHENTICATION_THRU_KEY:"true"<br>
     *         (ԕω) chain.doFilter:sȂ<br>
     *         (ԕω) O:UnauthenticatedExceptionF<br>
     *         
     * <br>
     * ʋƖւ̑Jڃ`FbNtureŁAOIς݃`FbNfalsȅꍇA
     * request̑lAUTHENTICATION_THRU_KEYݒ肵
     * UnauthenticatedException邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter03() throws Exception {
        // O
        AuthenticationControlFilter filter = new AuthenticationControlFilter();

        // eXgf[^̐ݒ
        AuthenticationControlFilter_AuthenticationControllerStub02 controller
            = new AuthenticationControlFilter_AuthenticationControllerStub02();
        UTUtil.setPrivateField(AuthenticationControlFilter.class,
                               "controller",
                               controller);
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setRequestURI("/test/logon.do");
        req.setContextPath("/test");
        MockHttpServletResponse res = new MockHttpServletResponse();
        AuthenticationControlFilter_FilterChainStub01 chain
            = new AuthenticationControlFilter_FilterChainStub01();

        // eXgs
        try {
            filter.doFilter(req, res, chain);
            fail();
        } catch (UnauthenticatedException e) {
            // 
            assertEquals("true", req.getAttribute("AUTHENTICATION_THRU_KEY"));
            assertFalse(chain.isCalled);
        }
    }

    /**
     * testDoFilter04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () AUTHENTICATION_THRU_KEY:null<br>
     *         () authenticationController:AuthenticationControlFilter_AuthenticationControllerStub03<br>
     *         () .isCheckRequired():true<br>
     *         () .isAuthenticated():true<br>
     *         
     * <br>
     * ҒlF(ԕω) AUTHENTICATION_THRU_KEY:"true"<br>
     *         (ԕω) chain.doFilter:s<br>
     *         
     * <br>
     * ʋƖւ̑Jڃ`FbNAOIς݃`FbNtruȅꍇA
     * request̑lAUTHENTICATION_THRU_KEYݒ肵ďI邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter04() throws Exception {
        // O
        AuthenticationControlFilter filter = new AuthenticationControlFilter();

        // eXgf[^̐ݒ
        AuthenticationControlFilter_AuthenticationControllerStub03 controller
            = new AuthenticationControlFilter_AuthenticationControllerStub03();
        UTUtil.setPrivateField(AuthenticationControlFilter.class,
                               "controller",
                               controller);
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setRequestURI("/test/logon.do");
        req.setContextPath("/test");
        MockHttpServletResponse res = new MockHttpServletResponse();
        AuthenticationControlFilter_FilterChainStub01 chain
            = new AuthenticationControlFilter_FilterChainStub01();

        // eXgs
        filter.doFilter(req, res, chain);
        
        // 
        assertEquals("true", req.getAttribute("AUTHENTICATION_THRU_KEY"));
        assertTrue(chain.isCalled);
    }

    /**
     * testDoFilter05()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () AUTHENTICATION_THRU_KEY:null<br>
     *         () authenticationController:null<br>
     *         
     * <br>
     * ҒlF(ԕω) chain.doFilter:sȂ<br>
     *         (ԕω) O:NullPointerExceptionF<br>
     *         
     * <br>
     * authenticationControllernull̏ꍇA
     * NullPointerException邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter05() throws Exception {
        // O
        AuthenticationControlFilter filter = new AuthenticationControlFilter();

        // eXgf[^̐ݒ       
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setRequestURI("/test/logon.do");
        req.setContextPath("/test");
        MockHttpServletResponse res = new MockHttpServletResponse();
        AuthenticationControlFilter_FilterChainStub01 chain
            = new AuthenticationControlFilter_FilterChainStub01();

        // eXgs
        try {
            filter.doFilter(req, res, chain);
            fail();
        } catch (NullPointerException e) {
            // 
            assertEquals("true", req.getAttribute("AUTHENTICATION_THRU_KEY"));
            assertFalse(chain.isCalled);
        }
    }

    /**
     * testGetControllerClass01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() AUTHENTICATION_CONTROLLER_CLASS:AuthenticationController.class<br>
     *                static final<br>
     *         
     * <br>
     * ҒlF(߂l) Class:OŐݒ肵CX^XƓ̃CX^X<br>
     *         
     * <br>
     * n1̂݃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetControllerClass01() throws Exception {
        // O
        AuthenticationControlFilter filter = new AuthenticationControlFilter();

        // eXg{
        Class actual = filter.getControllerClass();

        // 
        assertEquals(AuthenticationController.class, actual);
    }

    /**
     * testGetErrorCode01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() AUTHENTICATION_CONTROLLER_ERROR:"errors.authentication.controller"<br>
     *                static final<br>
     *         
     * <br>
     * ҒlF(߂l) String:"errors.authentication.controller"<br>
     *         
     * <br>
     * n1̂݃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetErrorCode01() throws Exception {
        // O
        AuthenticationControlFilter filter = new AuthenticationControlFilter();

        // eXg{
        String actual = filter.getErrorCode();

        // 
        assertEquals("errors.authentication.controller", actual);
    }

    /**
     * testGetDefaultControllerBeanId01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() DEFAULT_AUTHENTICATION_BEAN_ID:"authenticationController"<br>
     *                static final<br>
     *         
     * <br>
     * ҒlF(߂l) String:"authenticationController"<br>
     *         
     * <br>
     * n1̂݃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetDefaultControllerBeanId01() throws Exception {
        // O
        AuthenticationControlFilter filter = new AuthenticationControlFilter();

        // eXg{
        String actual = filter.getDefaultControllerBeanId();

        // 
        assertEquals("authenticationController", actual);
    }



}
